///////////////////////////////////////////////////////////////////////////////
// $Id: document.h,v 1.2 2004/04/04 15:29:07 krake Exp $
//
// Package:   MOAGG Edit - Level Editor for MOAGG
// Copyright: Kevin Krammer, 2003
//
///////////////////////////////////////////////////////////////////////////////
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
///////////////////////////////////////////////////////////////////////////////

/*! \file    document.h
    \author  Kevin Krammer, kevin.krammer@gmx.at
    \brief   Declaration of the document base class
*/

#ifndef DOCUMENT_H
#define DOCUMENT_H

// forward declarations
class QIODevice;
class QString;

class Document
{
public:
	virtual ~Document() {};

	virtual bool openFile(const QString& filename) = 0;
	virtual bool saveFile() = 0;
	virtual bool saveFileAs(const QString& filename) = 0;

	virtual QString fileName() const = 0;
	virtual QString fileFilter() const = 0;
	virtual bool isModified() const = 0;

	virtual bool readFromDevice(QIODevice* device) = 0;
	virtual bool writeToDevice(QIODevice* device) const = 0;
};

#endif

// End of file
