      SUBROUTINE MN_HEX(IDA,TPART,NPART,RBUF,NDIM,NWPPT,NPNT
     + ,EDENT,EDLO,EDHI,IDBIN,ADLO,ADHI,NBPPT,TITLE,ACONT,IERR)
C
C     ROUTINE TO EXTRACT PART OR ALL OF AN HBOOK HISTOGRAM
C
CICB      INTEGER MPNTMX
CICB      PARAMETER (MPNTMX=20000)
CICB+CDE,MNSCR.
CICB      REAL BUFDAT(MPNTMX),BUFERR(MPNTMX)
CICB      EQUIVALENCE(SCRATCH(1),BUFDAT(1))
CICB      EQUIVALENCE(SCRATCH(MPNTMX+1),BUFERR(1))
C
      REAL RBUF(*)
      CHARACTER*4 TPART
      INTEGER IDA,NPART,NDIM,NWPPT,NPNT,NBPPT,IERR,IDBIN(*)
      REAL EDENT,EDLO,EDHI,ADLO(*),ADHI(*)
      REAL ACONT(*)
C
      CHARACTER*80 TITLE
      LOGICAL QERRL,QERRH
C
      IDBIN(1) = 0
      IDBIN(2) = 0
C
C     GET THE HISTOGRAM DIMENSIONS
C
      TITLE = ' '
      CALL HGIVE(IDA,TITLE,NBINX,XLO,XHI,NBINY,YLO,YHI,NWT,IAD)
C
C     CHECK THAT WHAT I WANT IS REASONABLE
C     AND SET THE DIMENSIONS
C
      IF(TPART.EQ.' ' .OR. TPART.EQ.'HIST') THEN
CICB          IF(NBINX*MAX0(1,NBINY).GT.MPNTMX) THEN
CICB              WRITE(TXTERR,'(''Histogram'',I8
CICB     +         ,'' is too big for my internal storage'')') IDA
CICB              CALL MN_ERR('MN_HEX',TXTERR)
CICB              IERR = 3
CICB              GOTO 9000
CICB          ENDIF
      ELSEIF(TPART.EQ.'FUN') THEN
          IF(NBINY.GT.0) THEN
              CALL MN_ERR('MN_HEX','Functions are not associated' //
     1         ' with scatter plots')
              IERR = 2
              GOTO 9000
          ENDIF
      ELSEIF(NDIM.LT.-1) THEN
          CALL MN_ERR('MN_HEX','Called for an Ntuple.' //
     +     ' This should not happen!')
          IERR = 3
          GOTO 9000
      ELSE
          IF(NBINY.LE.0) THEN
              CALL MN_ERR('MN_HEX','It is only possible to make' //
     1         ' projections of scatter plots')
              IERR = 3
              GOTO 9000
          ENDIF
      ENDIF
C
      DX = (XHI-XLO) / FLOAT(NBINX)
      IF(NBINY.GT.0) DY = (YHI-YLO) / FLOAT(NBINY)
C
      CALL AMNOFF(NDIM,NWPPT,NOFF,NOFFL,NOFFH,QERRL,QERRH)
      EDENT = 0.0
      EDLO = 1.0E+30
      EDHI = -1.0E+30
      NHPT = 0
      DEE  = 0.0
      CALL VZERO_r(ACONT,3**IABS(NDIM))
C
C     Put the data after the errors, so that when copying to the
C     Mn_Fit order of data, error, data, error no overwriting occurs.
C     However I don't think this really matters!
C     For variable bin width the order is x,y,dx,dy!
C
      NPTRD1 = (NWPPT+0)*NBINX*MAX0(1,NBINY) + 1
      NPTRE1 = (NWPPT-1)*NBINX*MAX0(1,NBINY) + 1
C
      IF((TPART.EQ.' ' .OR. TPART.EQ.'HIST') .AND.
     1   IABS(NDIM).EQ.1) THEN
          IF(NDIM.GT.0 .OR. (NDIM.EQ.-1 .AND.NWPPT.GT.1)) THEN
              NB1 = 0
              NB2 = NBINX + 1
          ELSE
              NB1 = 1
              NB2 = NBINX
          ENDIF
          CALL HUNPAK(IDA,RBUF(NPTRD1),TPART,NPART)
          IF(QERRL) CALL HUNPKE(IDA,RBUF(NPTRE1),TPART,NPART)
          DO 3600 I=NB1,NB2
              IF(I.GE.1 .AND. I.LE.NBINX) THEN
                  EE  = RBUF(NPTRD1+I-1)
                  IF(QERRL) DEE = RBUF(NPTRE1+I-1)
              ELSE
                  EE = HI(IDA,I)
                  DEE = 0.0
              ENDIF
CICB              IF(QERRL) THEN
CICB                  IF(I.GE.1 .AND. I.LE.NBINX) THEN
CICB                      DEE = HIE(IDA,I)
CICB                  ELSE
CICB                      DEE = 0.0
CICB                  ENDIF
CICB              ENDIF
              IF(I.GE.1 .AND. I.LE.NBINX) THEN
                  NHPT = NHPT + 1
                  NPTR = NWPPT*(NHPT-1)
C
C                 Variable bin width histograms
C
                  IF(NDIM.EQ.-1) THEN
                      if(i.eq.1) call hix(ida,i,x1)
                      if(i.lt.nbinx) then
                          CALL HIX(IDA,I+1,X2)
                      else
                          x2 = xhi
                      endif
                      XX  = 0.5*(x1+x2)
                      DXX = 0.5*(x2-x1)
                      X1  = X2
C
                      RBUF(NPTR+1) = XX
                      RBUF(NPTR+2) = EE
                      IF(QERRL) THEN
                          RBUF(NPTR+3) = DXX
                          RBUF(NPTR+4) = DEE
                      ENDIF
                  ELSE
                      RBUF(NPTR+1) = EE
                      IF(QERRL) THEN
                          RBUF(NPTR+2) = DEE
                      ENDIF
                  ENDIF
                  EDENT = EDENT + EE
                  EDLO = AMIN1(EDLO,EE-DEE)
                  EDHI = AMAX1(EDHI,EE+DEE)
              ENDIF
C
              IF(I.EQ.0) THEN
                  NUOF = 1
              ELSEIF(I.LE.NBINX) THEN
                  NUOF = 2
              ELSE
                  NUOF = 3
              ENDIF
              ACONT(NUOF) = ACONT(NUOF) + EE
 3600     CONTINUE
      ELSEIF((TPART.EQ.' ' .OR. TPART.EQ.'HIST') .AND.
     1 NDIM.EQ.2) THEN
          NBX1 = 0
          NBX2 = NBINX + 1
          NBY1 = 0
          NBY2 = NBINY + 1
          CALL HUNPAK(IDA,RBUF(NPTRD1),TPART,NPART)
          IF(QERRL) CALL HUNPKE(IDA,RBUF(NPTRE1),TPART,NPART)
          DO 3700 J=NBY1,NBY2
              Y = YLO + FLOAT(J-1)*DY + 0.5*DY
C
              IF(J.EQ.0) THEN
                  NUOFY = 1
              ELSEIF(J.LE.NBINY) THEN
                  NUOFY = 2
              ELSE
                  NUOFY = 3
              ENDIF
C
              DO 3650 I=NBX1,NBX2
                  X = XLO + FLOAT(I-1)*DX + 0.5*DX
                  IF(I.GE.1 .AND. I.LE.NBINX .AND.
     +               J.GE.1 .AND. J.LE.NBINY) THEN
                      NHPT = NHPT + 1
                      EE  = RBUF(NPTRD1+NHPT-1)
                      IF(QERRL) DEE = RBUF(NPTRE1+NHPT-1)
                  ELSE
                      EE = HIJ(IDA,I,J)
                      DEE = 0.0
                  ENDIF
                  IF(I.GE.1 .AND. I.LE.NBINX .AND.
     +               J.GE.1 .AND. J.LE.NBINY) THEN
                      NPTR = NWPPT*(NHPT-1)
                      RBUF(NPTR+1) = EE
                      IF(QERRL) THEN
                          RBUF(NPTR+2) = DEE
                      ENDIF
                      EDENT = EDENT + EE
                      EDLO = AMIN1(EDLO,EE-DEE)
                      EDHI = AMAX1(EDHI,EE+DEE)
                  ENDIF
C
                  IF(I.EQ.0) THEN
                      NUOFX = 1
                  ELSEIF(I.LE.NBINX) THEN
                      NUOFX = 2
                  ELSE
                      NUOFX = 3
                  ENDIF
                  NUOF = 3*(NUOFY-1) + NUOFX
                  ACONT(NUOF) = ACONT(NUOF) + EE
 3650         CONTINUE
 3700     CONTINUE
C
C     Associated functions
C
      ELSEIF(TPART.EQ.'FUN ') THEN
          DO 3800 I=1,NBINX
              NHPT = NHPT + 1
              NPTR = NWPPT*(NHPT-1)
              CALL HIX(IDA,I,X)
              EE = HIF(IDA,I)
              IF(NDIM.EQ.-1) THEN
                  RBUF(NPTR+1) = X + 0.5*DX
                  RBUF(NPTR+2) = EE
                  IF(QERRL) THEN
                      RBUF(NPTR+3) = 0.5*DX
                      RBUF(NPTR+4) = DEE
                  ENDIF
              ELSE
                  RBUF(NPTR+1) = EE
                  IF(QERRL) THEN
                      RBUF(NPTR+2) = DEE
                  ENDIF
              ENDIF
              EDENT = EDENT + EE
              EDLO = AMIN1(EDLO,EE-DEE)
              EDHI = AMAX1(EDHI,EE+DEE)
 3800     CONTINUE
          IF(EDENT.LE.0) THEN
              CALL M_EMSG('MN_HEX',' The associated function has' //
     1         ' no entries.')
          ENDIF
C
C     Projections, slices, bands etc.
C
      ELSE
          CALL HUNPAK(IDA,RBUF(NPTRD1),TPART,NPART)
          IF(QERRL) CALL HUNPKE(IDA,RBUF(NPTRE1),TPART,NPART)
          IF(TPART(4:4).EQ.'Y') THEN
              NBINX = NBINY
              XLO = YLO
              XHI = YHI
              DX  = DY
          ENDIF
C
          DO 3900 II=1,NBINX
              NHPT = NHPT + 1
              NPTR = NWPPT*(NHPT-1)
              X = XLO + FLOAT(II-1)*DX + 0.5*DX
              EE = RBUF(NPTRD1+II-1)
C             IF(QERRL) DEE = SQRT(ABS(EE))
              IF(QERRL) DEE = RBUF(NPTRE1+II-1)
              IF(NDIM.EQ.-1) THEN
                  RBUF(NPTR+1) = X
                  RBUF(NPTR+2) = EE
                  IF(QERRL) THEN
                      RBUF(NPTR+3) = 0.5*DX
                      RBUF(NPTR+4) = DEE
                  ENDIF
              ELSE
                  RBUF(NPTR+1) = EE
                  IF(QERRL) THEN
                      RBUF(NPTR+2) = DEE
                  ENDIF
              ENDIF
              EDENT = EDENT + EE
              EDLO = AMIN1(EDLO,EE-DEE)
              EDHI = AMAX1(EDHI,EE+DEE)
 3900     CONTINUE
          IF(EDENT.LE.0) THEN
              CALL M_EMSG('MN_HEX','The projection has no entries.')
          ENDIF
      ENDIF
C
      IDBIN(1) = NBINX
      ADLO(1)  = XLO
      ADHI(1)  = XHI
      IF(IABS(NDIM).GT.1) THEN
          IDBIN(2) = NBINY
          ADLO(2)  = YLO
          ADHI(2)  = YHI
      ENDIF
C
 9000 CONTINUE
      RETURN
      END
