      subroutine m_pfil(nmode,tfile,ierr)
*
*-----------------------------------------------------------------------
*     Fixes up the working directory.
*     Fixes up environment variables and ~
*
*     nmode = 0 means first try path. If that fails add wd
*           = 1 means try path
*           = 2 means output file. Add wd
*-----------------------------------------------------------------------
*
      implicit none
*
#include "mndir.inc"
#include "mnflg.inc"
*
      character tfile*(*)
      integer nmode,ierr
*
      character*20  tnam
      character*255 txt1,txt2,conct0
      character*80  tvar
*
      integer lent,lend,lenv,lenp,lnblnk,n1,istat,kpass,kpath
     + ,ind1,ind2,ind3,ind4,ind5,ind6,ind7,ind8,indl,indf
      logical qexist,accessf
      external conct0
*
      ierr  = 0
      kpass = 0
      kpath = 0
*
*     First check if the filename already starts with a directory
*
      txt1 = tfile
      lent = lnblnk(txt1)
*
*     For nmode = 0, do 2 passes. 1st look for an existing file and if that
*     fails then try adding the wd if it exists
*
 1000 continue
      kpass = kpass + 1
 2000 continue
      txt1 = tfile
      lent = lnblnk(txt1)
C
C     If a working directory is set, see if the directory name is given.
C     If it is not given prepend it
C
      IF((nmode.eq.2 .or.
     +   (nmode.eq.0 .and. kpass.eq.2)) .and.
     +   DIR_WD.NE.' ') THEN
#if ( defined(VMS) )
          IF(INDEX(TXT1,']').EQ.0 .AND. INDEX(TXT1,':').EQ.0) THEN
              TXT2 = CONCT0(DIR_WD,TXT1)
              TXT1 = TXT2
          ENDIF
#endif
#if ( defined(UNIX) )
          IF(TXT1(1:2).EQ.'./') THEN
              TXT2 = TXT1(3:)
              TXT1 = TXT2
              LENT = LENT - 2
              IF(LENT.LE.0) THEN
                  IERR = 1
                  GOTO 9000
              ENDIF
          ELSEIF(TXT1(1:1).NE.'~' .AND. TXT1(1:1).NE.'$' .AND.
     +       INDEX(TXT1,'/').EQ.0) THEN
              LEND = LNBLNK(DIR_WD)
              IF(DIR_WD(LEND:LEND).NE.'/') THEN
                  TXT2   = CONCT0(DIR_WD,'/')
                  DIR_WD = TXT2
              ENDIF
              TXT2 = CONCT0(DIR_WD,TXT1)
              TXT1 = TXT2
              LENT = LNBLNK(TXT1)
          ENDIF
#endif

*
*     Loop over the paths
*
      elseif((nmode.eq.1 .or.
     +        (nmode.eq.0 .and. kpass.eq.1)) .and.
     +       kpath.gt.0) then
          lenp = lnblnk(tpath(kpath))
*
*         Check for / at end of path and beginning of file
*
          if(tpath(kpath)(lent:lent).eq.'/' .and. txt1(1:1).eq.'/') then
              txt2 = conct0(tpath(kpath),txt1(2:))
          else
              txt2 = conct0(tpath(kpath),txt1)
          endif
          txt1 = txt2
          lent = lnblnk(txt1)
      endif
C
C     See if ~ is the start of the filename
C     ~/ means home directory
C     ~text means someone elses directory - translate to /user/text for now
C     until I find something better
C
#if ( defined(UNIX) )
      IF(TXT1(1:1).EQ.'~') THEN
          IF(TXT1(2:2).EQ.'/') THEN
              TXT2 = TMNHOM(1:LMNHOM) // TXT1(3:)
              LENT = LENT + LMNHOM - 2
          ELSE
              TXT2 = '/user/' // TXT1(2:)
              LENT = LENT + 6 - 1
          ENDIF
          TXT1 = TXT2
      ENDIF
#endif

C
C     See if the filename contains a $ which flags an environment variable.
C     The variable is terminated by a / . : - ; <spc> or tab
C     On the Vax, a $ terminated by a : probably means that the $ is
C     part of a logical, so do not try to translate it.
C     On VAX do not try to do translation at all for now.
C
#if ( defined(UNIX) )
      N1 = 1
 2300 CONTINUE
      INDF = INDEX(TXT1(N1:LENT),'$')
      IF(INDF.GT.0 .AND. INDF.LT.LENT) THEN
          IND1 = LENT - INDF + 1
          IND2 = INDEX(TXT1(N1+INDF:LENT),'/')
          IND3 = INDEX(TXT1(N1+INDF:LENT),'.')
          IND4 = INDEX(TXT1(N1+INDF:LENT),'-')
          IND5 = INDEX(TXT1(N1+INDF:LENT),';')
          IND6 = INDEX(TXT1(N1+INDF:LENT),':')
          IND7 = INDEX(TXT1(N1+INDF:LENT),'[')
          IND8 = INDEX(TXT1(N1+INDF:LENT),']')
          IF(IND2.LE.0) IND2 = 999
          IF(IND3.LE.0) IND3 = 999
          IF(IND4.LE.0) IND4 = 999
          IF(IND5.LE.0) IND5 = 999
          IF(IND6.LE.0) IND6 = 999
          INDL = INDF + MIN(IND1,IND2,IND3,IND4,IND5) - 1
          TNAM = TXT1(INDF+N1:INDL+N1-1)
          IF(INDL.GT.INDF) THEN
              CALL M_TLOGI(TNAM,LENV,ISTAT,TVAR)
          ELSE
              ISTAT = 0
          ENDIF
          IF(ISTAT.NE.0) THEN
              IF(INDF+N1-1.GT.1 .AND. INDL+N1-1.LT.LENT) THEN
                  TXT2 = TXT1(1:INDF-1) // TVAR(1:LENV) //
     +             TXT1(INDL+1:LENT)
              ELSEIF(INDF+N1-1.GT.1) THEN
                  TXT2 = TXT1(1:INDF-1) // TVAR(1:LENV)
              ELSEIF(INDL+N1-1.LT.LENT) THEN
                  TXT2 = TVAR(1:LENV) // TXT1(INDL+1:LENT)
              ELSE
                  TXT2 = TVAR(1:LENV)
              ENDIF
              TXT1 = TXT2
              LENT = LENT - (INDL-INDF+1) + LENV
              N1   = N1   + LENV
          ELSE
              N1 = N1 + 1
          ENDIF
          IF(N1.LT.LENT) GOTO 2300
      ENDIF
#endif

*
*     For mode 0 and 1 the loop is over all paths, until the file exists
*
      if(nmode.eq.0 .or. nmode.eq.1) then
#if ( defined(UNIX) )
          qexist = accessf(txt1,0)
#endif
#if ( defined(VMS) )
          inquire(file=txt1,exist=qexist)
#endif

          if(qexist) goto 8000
*
*         If the filename starts with ./ do not loop over paths
*
          if(tfile(1:2).ne.'./' .and. kpass.eq.1) then
              kpath = kpath + 1
              if(kpath.le.npath) goto 2000
          endif
      endif
*
*     If the path failed, try the working directory
*
      if(nmode.eq.0 .and. kpass.eq.1) goto 1000
*
*     If everything failed set the filename back to its original value
*
      if(nmode.eq.1) then
          txt1 = tfile
      endif
*
 8000 continue
      tfile = txt1
*
 9000 continue
      end
