      DOUBLE PRECISION FUNCTION
     + XMNPP2(ZAM12,ZERES,ZEDAU,ZAMPI,WBIN,LMODEL,ZPAR)
C
C     FUNCTION TO EVALUATE THE DIPION INVARIANT MASS SPECTRUM
C     FOR VARIOUS MODELS
C
      implicit none
C
#include "mnpar.inc"
#include "mnlun.inc"
C
      DOUBLE PRECISION ZAM12,ZERES,ZEDAU,ZAMPI,WBIN
      INTEGER LMODEL
      DOUBLE PRECISION ZPAR(MFNPAR)
C
      LOGICAL QSTART1,QSTART2,QSTART3,QSTART4,QSTART5
     1 ,QSTART6,QSTART7,QSTART8,QSTART9
C
      DOUBLE PRECISION XMNGPI
      DOUBLE PRECISION XMNPHS,XMNYAN,XMNZAK,XMNNOV,XMNYN2,XMNVOL
     1 ,XMNBW,XMNMOX
      DOUBLE PRECISION ZMAX,Z,ZAMPI2,ZAM122
     1 ,ZAMLO,ZAMHI,ZXPAR
      DOUBLE PRECISION ZMG,ZWG
      INTEGER IOERR,NDUMPE
C
      DATA QSTART1/.TRUE./,QSTART2/.TRUE./,QSTART3/.TRUE./
     1 ,QSTART4/.TRUE./,QSTART5/.TRUE./,QSTART6/.TRUE./
     2 ,QSTART7/.TRUE./,QSTART8/.TRUE./,QSTART9/.TRUE./
      DATA NDUMPE/0/
C
      XMNPP2 = 0.0D0
C
      ZXPAR  = ZPAR(2)
      ZAMLO  = 2.0D0*ZAMPI
      ZAMHI  = ZERES - ZEDAU
      ZAM122 = ZAM12 * ZAM12
      ZAMPI2 = ZAMPI * ZAMPI
C
      IF(ZAM12.LT.ZAMLO .OR. ZAM12.GT.ZAMHI) THEN
          NDUMPE = NDUMPE + 1
          IF(NDUMPE.LE.10) WRITE(LUNTTO
     1     ,'('' Input Dipion Invariant Mass is''
     1     ,'' Out of Range'',F8.4,''  Low Limit'',F8.4
     2     ,'' High Limit'',F8.4)',IOSTAT=IOERR)
     +     ZAM12,ZAMLO,ZAMHI
          RETURN
      ENDIF
C
C     PHASE SPACE
C
      IF(LMODEL.EQ.1) THEN
          IF(QSTART1) THEN
              QSTART1 = .FALSE.
              WRITE(LUNTTO,20000)
20000         FORMAT(/,' Using Phase Space for Dipion Effective'
     1         ,' Mass Spectrum.')
          ENDIF
          Z = XMNPHS(ZAM122,ZERES,ZEDAU,ZAMPI2,ZXPAR)
          XMNPP2 = Z
C
C     YAN MODEL
C
      ELSEIF(LMODEL.EQ.2) THEN
          IF(QSTART2) THEN
              QSTART2 = .FALSE.
              WRITE(LUNTTO,21000) ZXPAR
21000         FORMAT(/,' Using Yan Model for Dipion Effective'
     1         ,' Mass Spectrum.'
     1         ,/,' Parameter Value',G13.5)
          ENDIF
          Z = XMNPHS(ZAM122,ZERES,ZEDAU,ZAMPI2,ZXPAR) *
     1        XMNYAN(ZAM122,ZERES,ZEDAU,ZAMPI2,ZXPAR)
          XMNPP2 = Z
C
C     VOLOSHIN-ZAKHAROV MODEL
C
      ELSEIF(LMODEL.EQ.3) THEN
          IF(QSTART3) THEN
              QSTART3 = .FALSE.
              WRITE(LUNTTO,22000) ZXPAR
22000         FORMAT(/,' Using Voloshin-Zakharov Model'
     1         ,' for Dipion Effective Mass Spectrum.'
     1         ,/,' Parameter Value',G13.5)
          ENDIF
          Z = XMNPHS(ZAM122,ZERES,ZEDAU,ZAMPI2,ZXPAR) *
     1        XMNZAK(ZAM122,ZERES,ZEDAU,ZAMPI2,ZXPAR)
          XMNPP2 = Z
C
C     NOVIKOV-SHIFMAN MODEL
C
      ELSEIF(LMODEL.EQ.4) THEN
          IF(QSTART4) THEN
              QSTART4 = .FALSE.
              WRITE(LUNTTO,23000) ZXPAR
23000         FORMAT(/,' Using Novikov-Shifman Model'
     1         ,' for Dipion Effective Mass Spectrum.'
     1         ,/,' Parameter Value',G13.5)
          ENDIF
          Z = XMNPHS(ZAM122,ZERES,ZEDAU,ZAMPI2,ZXPAR) *
     1        XMNNOV(ZAM122,ZERES,ZEDAU,ZAMPI2,ZXPAR)
          XMNPP2 = Z
C
C     YAN MODEL WITH FULL FORMULA
C
      ELSEIF(LMODEL.EQ.5) THEN
          IF(QSTART5) THEN
              QSTART5 = .FALSE.
              WRITE(LUNTTO,24000) ZXPAR
24000         FORMAT(/,' Using Full Yan Model for Dipion Effective'
     1         ,' Mass Spectrum.'
     1         ,/,' Parameter Value',G13.5)
          ENDIF
          Z = XMNPHS(ZAM122,ZERES,ZEDAU,ZAMPI2,ZXPAR) *
     1       (XMNYAN(ZAM122,ZERES,ZEDAU,ZAMPI2,ZXPAR) +
     2        XMNYN2(ZAM122,ZERES,ZEDAU,ZAMPI2,ZXPAR))
          XMNPP2 = Z
C
C     PESKIN MODEL
C
      ELSEIF(LMODEL.EQ.6) THEN
          ZMG = ZPAR(3)
          ZWG = ZPAR(4)
          IF(QSTART6) THEN
              QSTART6 = .FALSE.
              WRITE(LUNTTO,25000) ZXPAR,ZMG,ZWG
25000         FORMAT(/,' Using Peskin Model for Dipion Effective'
     1         ,' Mass Spectrum. Corrected Formula'
     1         ,/,' Parameter Value',G13.5
     1         ,'  Gluonium Mass and Width',2G13.5)
          ENDIF
          Z = XMNGPI(ZAM12,ZXPAR,ZMG,ZWG,ZAMPI,ZERES,ZEDAU)
          XMNPP2 = Z
C
C     VOLOSHIN ISOVECTOR RESONANCE MODEL
C
      ELSEIF(LMODEL.EQ.7) THEN
          ZMG = ZPAR(3)
          ZWG = ZPAR(4)
          IF(QSTART7) THEN
              QSTART7 = .FALSE.
              WRITE(LUNTTO,27000) ZXPAR,ZMG,ZWG
27000         FORMAT(/,' Using Voloshin 4 Quark Model for'
     1         ,' Dipion Effective Mass Spectrum.'
     1         ,/,' Parameter Value',G13.5
     1         ,'  Gluonium Mass and Width',2G13.5)
          ENDIF
          Z = XMNGPI(ZAM12,ZXPAR,ZMG,ZWG,ZAMPI,ZERES,ZEDAU)
          XMNPP2 = Z
C
C     PHASE SPACE MULTIPLIED BY A BREIT-WIGNER
C
      ELSEIF(LMODEL.EQ.8) THEN
          ZMG = ZPAR(2)
          ZWG = ZPAR(3)
          IF(QSTART8) THEN
              QSTART8 = .FALSE.
              WRITE(LUNTTO,28000) ZMG,ZWG
28000         FORMAT(/,' Using Breit-Wigner * Phase Space'
     1         ,' for Dipion Effective Mass Spectrum.'
     1         ,/,' Resonance mass',G13.5,'  Width',G13.5)
          ENDIF
          Z = XMNPHS(ZAM122,ZERES,ZEDAU,ZAMPI2,ZXPAR) *
     1        XMNBW(ZAM12,ZMG,ZWG)
          XMNPP2 = Z
C
C     MOXHAY RESONANCE FORM
C
      ELSEIF(LMODEL.EQ.9) THEN
          ZMG = ZPAR(2)
          ZWG = ZPAR(3)
          IF(QSTART9) THEN
              QSTART9 = .FALSE.
              WRITE(LUNTTO,29000) ZMG,ZWG
29000         FORMAT(/,' Using Moxhay Resonance Form'
     1         ,' for Dipion Effective Mass Spectrum.'
     1         ,/,' Resonance mass',G13.5,'  Kappa',G13.5)
          ENDIF
          Z = XMNMOX(ZAM12,ZAM122,ZERES,ZEDAU
     1     ,ZAMPI,ZAMPI2,ZMG,ZWG)
          XMNPP2 = Z
      ENDIF
C
      XMNPP2 = ZPAR(1) * XMNPP2 * WBIN
C
      RETURN
      END
