{
//*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
//*-*
//*-*  This program creates :
//*-*    - one-dimensional histograms of each type
//*-*    - two-dimensional histogram of each type
//*-*    - a profile histogram
//*-*    - a memory-resident ntuple
//*-*
//*-*  These objects are filled with some random numbers and saved on a file.
//*-*
//*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*

gROOT->Reset();

// Create a new canvas.
c01 = new TCanvas("c01","1-D Histograms",250,60,700,500);
c01->Divide(3,2);
c02 = new TCanvas("c02","2-D Histograms",300,110,700,500);
c02->Divide(3,2);
c03 = new TCanvas("c03","Other Histograms",300,110,700,500);
c03->Divide(3,2);

c1 = new TCanvas("c1","Dynamic Filling Example",200,10,700,500);
c1->SetFillColor(42);
c1->GetFrame()->SetFillColor(21);
c1->GetFrame()->SetBorderSize(6);
c1->GetFrame()->SetBorderMode(-1);
c1->cd(1);

// Create a new ROOT binary machine independent file.
// Note that this file may contain any kind of ROOT objects, histograms,
// pictures, graphics objects, detector geometries, tracks, events, etc..
// This file is now becoming the current directory.

TFile *hfile = (TFile*)gROOT->FindObject("example.root");
if (hfile) hfile->Close();

hfile = new TFile("example.root","RECREATE","Demo ROOT file with histograms");

// Create some histograms, a profile histogram and an ntuple
hpx1   = new TH1F("hpx","Px distribution",100,-4,4);
hpx2   = new TH1F("h101","Py distribution",100,-3,3);
hpxpy   = new TH2F("hpxpy","py vs px",40,-4,4,30,-3,3);
hpxpypz = new TH3F("hpxpypz","Flat vs Py vs Px",
		   10,-2,2,20,-2.5,2.5,9,-0.9,0.9);
//
Double_t xbins[] = {-4, -3.0, -2.0, -1.5, -1.0, 0.0, 0.5, 1.0, 1.5, 2.0, 3.0};
Double_t ybins[] = {-3, -2.0, -1.5, -1.0, -0.4, 0.0, 0.4, 0.8, 1.2, 1.5, 2.0};
hpxv1   = new TH1F("hpxv1","Px with variable bins",10,xbins);
hpxpyv1 = new TH2F("hpxpyv1","Py vs Px with variable bins",10,xbins,10,ybins);
//
hprof1  = new TProfile("hprof1","Profile of pz versus px",100,-4,4,0,20);
hprof2  = new TProfile2D("hprof2","Profile of pz versus px and py",
		       40,-4,4,30,-3,3,0,20);
//
ntuple = new TNtuple("ntuple","Demo ntuple","px:py:pz:random:i");

// Put same histograms of different types in a subdirectory
hfile->mkdir("h1dir");
hfile->mkdir("h2dir");
hfile->mkdir("h3dir");

// Create a histogram of each type
hfile->cd("h1dir");
h1c = new TH1C("h1c","Byte per channel",60,-3,3);
h1d = new TH1D("h1d","Double per channel",60,-3,3);
h1f = new TH1F("h1f","Float per channel",60,-3,3);
h1i = new TH1I("h1i","Integer per channel",60,-3,3);
h1s = new TH1S("h1s","Short Integer per channel",60,-3,3);

hfile->cd("h2dir");
h2c = new TH2C("h2c","Byte per channel",30,-3,3,20,-2,2);
h2d = new TH2D("h2d","Double per channel",30,-3,3,20,-2,2);
h2f = new TH2F("h2f","Float per channel",30,-3,3,20,-2,2);
h2i = new TH2I("h2i","Integer per channel",30,-3,3,20,-2,2);
h2s = new TH2S("h2s","Short Integer per channel",30,-3,3,20,-2,2);

hfile->cd("h3dir");
h3c = new TH3C("h3c","Byte per channel",12,-3,3,10,-2,2,10,-1,1);
h3d = new TH3D("h3d","Double per channel",12,-3,3,10,-2,2,10,-1,1);
h3f = new TH3F("h3f","Float per channel",12,-3,3,10,-2,2,10,-1,1);
h3i = new TH3I("h3i","Integer per channel",12,-3,3,10,-2,2,10,-1,1);
h3s = new TH3S("h3s","Short Integer per channel",30,-3,3,10,-2,2,10,-1,1);

//  Set canvas/frame attributes (save old attributes)
  hpx1->SetFillColor(48);
  hpx2->SetFillColor(48);

  gBenchmark->Start("hsimple");

// Fill histograms randomly
  gRandom->SetSeed();
  Float_t px, py, pz;
  const Int_t kUPDATE = 1000;
  for (Int_t i = 0; i < 25000; i++) {
     gRandom->Rannor(px,py);
     pz = px*px + py*py;
     Float_t random = gRandom->Rndm(1);
     hpx1->Fill(px);
     hpx2->Fill(py);
     hpxv1->Fill(px);
     hpxpy->Fill(px,py);
     hpxpyv1->Fill(px,py);
     hpxpypz->Fill(px,py,2*(random-0.5));
     //
     hprof1->Fill(px,pz);
     hprof2->Fill(px,py,pz);
     //
     ntuple->Fill(px,py,pz,random,i);

     h1c->Fill(px);
     h1d->Fill(px+0.2);
     h1f->Fill(px-0.2);
     h1i->Fill(px+0.4);
     h1s->Fill(px-0.4);

     h2c->Fill(px,py);
     h2d->Fill(px+0.2,py+0.2);
     h2f->Fill(px+0.4,py-0.2);
     h2i->Fill(px-0.2,py+0.4);
     h2s->Fill(px-0.4,py-0.4);

     h3c->Fill(px,py,2*(random-0.5));
     h3d->Fill(px+0.2,py+0.2,2*(random-0.5));
     h3f->Fill(px+0.4,py-0.2,2*(random-0.5));
     h3i->Fill(px-0.2,py+0.4,2*(random-0.5));
     h3s->Fill(px-0.4,py-0.4,2*(random-0.5));

     if (i && (i%kUPDATE) == 0) {
        if (i == kUPDATE) hpx1->Draw();
        c1->Modified();
        c1->Update();
        if (gSystem->ProcessEvents())
           break;
     }
  }
  gBenchmark->Show("hsimple");

// Save all objects in this file
  hpx1->SetFillColor(0);
  hfile->Write();
  hpx1->SetFillColor(48);
  c1->Modified();

// Show the 1-D and 2-D histograms
c01->cd(1);
h1c->Draw();
c01->cd(2);
h1d->Draw();
c01->cd(3);
h1f->Draw();
c01->cd(4);
h1i->Draw();
c01->cd(5);
h1s->Draw();

c02->cd(1);
h2c->Draw("BOX");
c02->cd(2);
h2d->Draw("COL");
c02->cd(3);
h2f->Draw("LEGO");
c02->cd(4);
h2i->Draw("SURF");
c02->cd(5);
h2s->Draw("COLZ");

c03->cd(1);
hpxv1->Draw();
c03->cd(2);
hpxpyv1->Draw("BOX");
c03->cd(4);
hprof1->Draw();
c03->cd(5);
hprof2->Draw("BOX");
c03->cd(6);
hpxpypz->Draw();
  
// Note that the file is automatically close when application terminates
// or when the file destructor is called.
}
