      PROGRAM IGTEXT_EXAM
C
C-----------------------------------------------------------------------
C
C     Makes the standard picture of IGTEXT characters
C
C-----------------------------------------------------------------------
C
      COMMON/PAWC/H(20000)
      CHARACTER*80 FILENAME
      CHARACTER*10 TQUAL
*
      integer nloop,lenf,lnblnk
*.___________________________________________
*
      CALL MZPAW(20000,'M')
      CALL IGINIT(0)
*      KWTYPE = 10002
      KWTYPE = 0
#if ( defined(X11) )
      KWTYPE = 1
#endif

      IF(KWTYPE.EQ.0) CALL IGWKTY(KWTYPE)
*
      KWPOST = -113
      TQUAL  = 'eps'
      LQUAL = LENOCC(TQUAL)
      CALL CUTOL(TQUAL)
      IF(LQUAL.EQ.0) THEN
          TQUAL = 'eps'
          LQUAL = LENOCC(TQUAL)
      ENDIF
*
      CALL IGSSE(6,KWTYPE)
*
      nloop = 0
 1000 CONTINUE
      NLOOP = NLOOP + 1
#if ( defined(UNIX) )
      write(filename,'(''igtext'',i1,''.'',a)')
     + nloop,tqual(:lqual)
      lenf = lnblnk(filename)
      write(6,'('' Opening '',A)') filename(:lenf)
      OPEN(UNIT=10,FILE=filename(:lenf),FORM='FORMATTED'
     +  ,STATUS='UNKNOWN')
#endif
#if ( defined(VMS) )
      write(filename,'(''igtext'',i1,''.'',a)')
     + nloop,tqual(:lqual)
      lenf = lnblnk(filename)
      write(6,'('' Opening '',A)') filename(:lenf)
      OPEN(UNIT=10,FILE=filename(:lenf),FORM='FORMATTED'
     + ,SHARED,CARRIAGECONTROL='LIST',STATUS='UNKNOWN')
#endif

      NCONID = 10

      CALL IOPWK(2,NCONID,KWPOST)
      CALL IACWK(2)
*
*     I want the picture to be 16x18cm. Set up the normalization transformation
*     accordingly.
*
      ITNR = 2
      difx = 16.0
      dify = 18.0
CICB      CALL ISWKWN(1,0.0,DIFX/DIFY,0.0,1.0)
CICB      CALL ISWKWN(2,0.0,DIFX/DIFY,0.0,1.0)
C
      x1 = 0.0
      x2 = 0.01*difx
      y1 = 0.0
      y2 = 0.01*dify
CICB      CALL ISWKVP(1,X1,X2,Y1,Y2)
CICB      CALL ISWKVP(2,X1,X2,Y1,Y2)
C
CICB      CALL ISWN(ITNR,0.0,DIFX,0.0,DIFY)
CICB      CALL ISVP(ITNR,0.0,DIFX/DIFY,0.0,1.0)
C
      call igrng(difx,dify)
C
CICB      CALL ISELNT(ITNR)
*
      CALL ICLRWK(0,0)
*
      IF(NLOOP.EQ.1) THEN
          CALL HIEX2(0,2,difx,dify)
      ELSE
          CALL HIEX2(-4,1,difx,dify)
      ENDIF
*
      call iuwk(0,1)
*
*      write(6,'('' Hit <CR> to continue: '',$)')
*      read(5,*)
*
      CALL IACWK(2)
      CALL ICLWK(2)
      CLOSE(UNIT=10)
      if(nloop.lt.2) goto 1000
*
  20  CALL IGEND
      STOP
      END
*
      SUBROUTINE HIEX2(NFONT,NPREC,difx,dify)
*.==========>
*.           Example to plot the table of HIGZ software characters
*..=========> ( R.Brun )
*
      implicit none
*
      INTEGER NFONT,NPREC
      real difx,dify
*
      character*60 title
      CHARACTER*8 KD1,KD2
      CHARACTER*45 KDG
      CHARACTER*3 KTEXT
      CHARACTER*1 CHOPT
      CHARACTER*5 TESC(8)
      real XPOS(8),X(5),Y(5)
*
      real xlong,ytop,ybot,xmarg,angle,xw,size,ylong,y1,y2,yp
     + ,tsize,xmid,ytit
      integer i,j,lent,lnblnk
      integer ncol,nhead,nchar
*
      DATA KD1/' < < < <'/
      DATA KD2/'  [[""~~'/
      DATA KDG/'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.,+-*/=()'/
      DATA TESC/'ABC','abc','[ABC]','[abc]','"ABC#','"abc#'
     + ,'~ABC#','~abc#'/
C
      DATA XLONG,YTOP,YBOT,xmarg/12.,18.,0.5,0.5/
      DATA ANGLE/0./
C
c     CALL IGRNG(20.,24.)
      CALL ICLRWK(0,0)
*
      xlong = difx
      ytop  = dify
C
      x(1) =  0.0
      y(1) =  0.0
      x(2) =  0.0
      y(2) = ytop
      x(3) = 16.0
      y(3) = ytop
      x(4) = 16.0
      y(4) =  0.0
      x(5) =  0.0
      y(5) =  0.0
*      call ipl(5,x,y)
*
      if(nfont.eq.0 .and. nprec.eq.2) then
          title = 'Font 2000, i.e. IGTEXT'
          ncol = 6
      else
          title = 'Font -1004, i.e. Postscript - Helvetica'
          ncol = 8
      endif
      tsize = 0.4
      xmid = 0.5*xlong
      ytit = ytop - 1.5*tsize
      CALL ISTXFP(NFONT,NPREC)
      CALL ISTXAL(2,0)
      CALL ISCHH(TSIZE)
      lent = lnblnk(title)
      call itx(xmid,ytit,title(:lent))
*
      ytop = ytop - 2.0*tsize
      nhead = 5
      nchar = 45
*
      XW     = (XLONG-2.0*xmarg)/(2.0*float(ncol))
      DO 10 I = 1,ncol
         XPOS(I) = (2*I-1)*XW + xmarg
  10  CONTINUE
C
C             DRAW THE FRAME
C
      SIZE   = (YTOP-YBOT) / ((nhead+nchar)*1.5)
      YLONG  = nchar*1.5*SIZE + nhead*1.5*SIZE
      X(1)   = XPOS(1) - XW
      X(2)   = XPOS(ncol) + XW
      X(3)   = X(2)
      X(4)   = X(1)
      X(5)   = X(1)
      Y(1)   = YTOP
      Y(2)   = Y(1)
      Y(3)   = Y(1) - YLONG
      Y(4)   = Y(3)
      Y(5)   = Y(1)
      CALL IPL(5,X,Y)
      DO 20 I = 1,ncol-1
         X(1)   = XPOS(I) + XW
         X(2)   = X(1)
         Y(1)   = YTOP
         Y(2)   = Y(1) - YLONG
         CALL IPL(2,X,Y)
  20  CONTINUE
      X(1)   = XPOS(1) - XW
      X(2)   = XPOS(ncol) + XW
      Y(1)   = YTOP - float(nhead)*SIZE
      Y(2)   = Y(1)
      CALL IPL(2,X,Y)
C
C     DRAW BOX TITLES
C
      Y1     = YTOP - 2.*SIZE
      Y2     = Y1 - 2.*SIZE
      CHOPT='C'
      CALL ISTXFP(NFONT,NPREC)
      CALL ISTXAL(2,0)
      CALL ISCHH(SIZE)
C
      CALL ITX(XPOS(1),Y1,'Upper')
      CALL ITX(XPOS(1),Y2,'Roman')
      CALL ITX(XPOS(2),Y1,'Lower')
      CALL ITX(XPOS(2),Y2,'Roman')
      CALL ITX(XPOS(3),Y1,'Upper')
      CALL ITX(XPOS(3),Y2,'Greek')
      CALL ITX(XPOS(4),Y1,'L<OWER')
      CALL ITX(XPOS(4),Y2,'G<REEK')
      CALL ITX(XPOS(5),Y1,'U<PPER')
      CALL ITX(XPOS(5),Y2,'Special')
      CALL ITX(XPOS(6),Y1,'Lower')
      CALL ITX(XPOS(6),Y2,'Special')
C
      if(ncol.gt.6) then
          CALL ITX(XPOS(7),Y1,'U<PPER')
          CALL ITX(XPOS(7),Y2,'Zapf')
          CALL ITX(XPOS(8),Y1,'Lower')
          CALL ITX(XPOS(8),Y2,'Zapf')
      endif
C
CICB      Y3     = Y1 - 4.*SIZE
CICB      DO 25 I = 1,6
CICB          CALL ITX(XPOS(I),Y3,TESC(I))
CICB25    CONTINUE
C
      YP     = YTOP - float(nhead)*SIZE
      DO 40 I = 1,45
         YP     = YP - 1.5*SIZE
         DO 30 J = 1,ncol
            KTEXT=KD1(J:J)//KD2(J:J)//KDG(I:I)
            CALL ITX(XPOS(J),YP,KTEXT)
  30     CONTINUE
  40  CONTINUE
C
CICB      YP = YBOT - 1.5*SIZE
CICB      CALL ISTXFP(1,0)
CICB      CALL ISTXAL(1,4)
CICB      CALL ISCHH(SIZE)
CICB      CALL ITX(XPOS(1)-XW,YP,'Superscript: ^  abc!')
CICB      CALL ITX(XPOS(3)-XW,YP,'Backspace:  &')
CICB      YP = YP - 1.5*SIZE
CICB      CALL ITX(XPOS(1)-XW,YP,'Subscript:   ?abc!')
C
      END
