# -------------------------------------------------------------------------
#     This file is part of mMass - the spectrum analysis tool for MS.
#     Copyright (C) 2005-07 Martin Strohalm <mmass@biographics.cz>

#     This program is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 2 of the License, or
#     (at your option) any later version.

#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.

#     Complete text of GNU GPL can be found in the file LICENSE in the
#     main directory of the program
# -------------------------------------------------------------------------

# Function: Application defaults.


# defaults for main config
config = {
        'common':{
                'appheight':650,
                'appwidth':1000,
                'contact':'',
                'charge':'1+',
                'debugmode':0,
                'digits':2,
                'errortype':'Da',
                'errtoconsole':0,
                'exportfilter':0.5,
                'institution':'',
                'instrument':'',
                'lastspecdir':'./examples',
                'lastseqdir':'./examples',
                'masstype':'mmass',
                'maximize': 0,
                'nomatchalert':1,
                'operator':'',
                'printfilter':3,
                'showmatchinfo':1,
                'tolerance':0.5,
                'updatedescr':0,
                },
        'colours':{
                'grayed':'200,200,200',
                'matched':'0,204,255',
                'mdiffaa':'0,204,255',
                'mdiffdip':'203,234,255',
                'mdiffmod':'104,255,120',
                'mdiffval':'255,139,140',
                'mdiffzero':'240,240,240',
                'modified':'104,255,120',
                'spectrum0':'0,0,255',
                'spectrum1':'48,146,0',
                'spectrum2':'247,148,28',
                'spectrum3':'150,31,118',
                'spectrum4':'166,124,81',
                'spectrum5':'53,88,124',
                'spectrum6':'153,204,0',
                'spectrum7':'0,204,255',
                'spectrum8':'255,204,0',
                'spectrum9':'255,0,255',
                },
        'mpeak':{
                'copymass':1,
                'copyintens':1,
                'copyannot':0,
                'delimiter':'tab',
                'showpeaklist':1,
                'splitting':'v',
                'thdirection':'below',
                'treshold':1000,
                },
        'mspec':{
                'cursorimage':1,
                'gelviewheight':13,
                'importpeaklist':1,
                'labelangle':90,
                'mousefce':'distance',
                'movex':0.1,
                'peakheight':80,
                'scalex':0.1,
                'scaley':0.1,
                'scrollx':0.1,
                'showticks':1,
                'showlabels':1,
                'showannots':0,
                'showtracker':1,
                'showposition':1,
                'showdistance':1,
                'showgrid':1,
                'showlegend':1,
                'showposbar':1,
                'showgelview':0,
                },
        'mcut':{
                'enzyme':'Trypsin',
                'highlightmods':1,
                'charge':'1+',
                'maxmass':4000,
                'maxpartials':50,
                'minmass':500,
                'notcleavemodif':0,
                'optmodif':0,
                'partials':3,
                'sortby':3,
                'sortdesc':0,
                'uselimits':1,
                },
        'mfrag':{
                'annotfiltered':1,
                'matchfiltered':0,
                'maxsequence':100,
                'pres-default':'im;a0;a1;a2;b0;b1;b2;y0;y1;y2;int0;int1;int2;int3;',
                'pres-esi-quad-tof':'b0;b1;b2;b3;b4;b5;y0;y1;y2;y3;y4;y5;',
                'pres-esi-quad':'b0;b1;b2;b3;b4;b5;y0;y1;y2;y3;y4;y5;',
                'pres-esi-trap':'b0;b1;b2;b3;b4;b5;y0;y1;y2;y3;y4;y5;',
                'pres-esi-4sector':'im;a0;a3;b0;b1;b2;b3;b4;b5;y0;y3;z0;z1;',
                'pres-esi-fticr':'b0;b1;b2;b3;b4;b5;y0;y1;y2;y3;y4;y5;',
                'pres-ftms-ecd':'c0;c1;y0;y3;z0;z1;',
                'pres-maldi-tof-psd':'im;a0;a1;a2;b0;b1;b2;y0;',
                'pres-maldi-tof-tof':'im;a0;a1;a2;b0;b1;b2;y0;y1;y2;',
                'pres-maldi-quad-tof':'im;b0;b1;b2;b3;b4;b5;y0;y1;y2;y3;y4;y5;',
                'pres-maldi-qit-tof':'im;a0;a1;a2;a3;a4;a5;b0;b1;b2;b3;b4;b5;y0;y1;y2;y3;y4;y5;',
                'pres-custom1':'',
                'pres-custom2':'',
                'pres-custom3':'',
                },
        'mdiff':{
                'checkaa':1,
                'checkdiff':0,
                'checkdip':1,
                'checkmod':1,
                'maxdiff':500,
                'modgroups':'ptm;chemical;glyco;artefact;other;',
                'usemaxdiff':1,
                },
        'mascot':{
                'database':'SwissProt',
                'email':'',
                'enzyme':'Trypsin',
                'fixedmod':'',
                'icat':0,
                'instrument':'MALDI-TOF-PSD',
                'msmscharge':'1+',
                'msmstol':0.8,
                'msmstolunits':'Da',
                'masstype':'Monoisotopic',
                'overview':1,
                'partials':1,
                'pepcharge':'1+',
                'peptol':0.5,
                'peptolunits':'Da',
                'showhits':20,
                'taxonomy':'All entries',
                'urlparams':'http://www.matrixscience.com/cgi/get_params.pl',
                'urlsearch':'http://www.matrixscience.com/cgi/nph-mascot.exe?1',
                'username':'',
                'variablemod':'',
                },
        'links':{
                'blast':'http://www.ebi.ac.uk/blastall/',
                'clustalw':'http://www.ebi.ac.uk/clustalw/',
                'deltamass':'http://www.abrf.org/index.cfm/dm.home',
                'emblebi':'http://www.ebi.ac.uk/services/',
                'expasy':'http://www.expasy.org/',
                'fasta':'http://www.ebi.ac.uk/fasta33/',
                'matrixscience':'http://www.matrixscience.com/',
                'mmass':'http://mmass.biographics.cz/',
                'mmassupdate':'http://mmass.biographics.cz/update.php',
                'muscle':'http://phylogenomics.berkeley.edu/cgi-bin/muscle/input_muscle.py',
                'ncbi':'http://www.ncbi.nlm.nih.gov/Entrez/',
                'pdb':'http://www.rcsb.org/pdb/',
                'pir':'http://pir.georgetown.edu/',
                'prospector':'http://prospector.ucsf.edu/',
                'searchxlinks':'http://www.searchxlinks.de/',
                'unimod':'http://www.unimod.org/',
                'uniprot':'http://www.expasy.uniprot.org/',
                },
        'history':{
                'f0':'',
                'f1':'',
                'f2':'',
                'f3':'',
                'f4':'',
                'f5':'',
                'f6':'',
                'f7':'',
                'f8':'',
                'f9':'',
                },
}

# default elements
elements = {
            'H':{'mmass':1.0078250321, 'amass':1.00794},
            'He':{'mmass':4.0026032497, 'amass':4.002602},
            'Li':{'mmass':7.016004, 'amass':6.941},
            'Be':{'mmass':9.0121821, 'amass':9.012182},
            'B':{'mmass':11.0093055, 'amass':10.811},
            'C':{'mmass':12.0, 'amass':12.0107},
            'N':{'mmass':14.0030740052, 'amass':14.00674},
            'O':{'mmass':15.9949146221, 'amass':15.9994},
            'F':{'mmass':18.9984032, 'amass':18.9984032},
            'Ne':{'mmass':19.9924401759, 'amass':20.1797},
            'Na':{'mmass':22.98976967, 'amass':22.98977},
            'Mg':{'mmass':23.9850419, 'amass':24.305},
            'Al':{'mmass':26.98153844, 'amass':26.981538},
            'Si':{'mmass':27.9769265327, 'amass':28.0855},
            'P':{'mmass':30.97376151, 'amass':30.973761},
            'S':{'mmass':31.97207069, 'amass':32.066},
            'Cl':{'mmass':34.96885271, 'amass':35.4527},
            'Ar':{'mmass':39.962383123, 'amass':39.948},
            'K':{'mmass':38.9637069, 'amass':39.0983},
            'Ca':{'mmass':39.9625912, 'amass':40.078},
            'Sc':{'mmass':44.95591, 'amass':44.95591},
            'Ti':{'mmass':47.947947, 'amass':47.867},
            'V':{'mmass':50.9439637, 'amass':50.9415},
            'Cr':{'mmass':51.9405119, 'amass':51.9961},
            'Mn':{'mmass':54.9380496, 'amass':54.9380496},
            'Fe':{'mmass':55.9349421, 'amass':55.845},
            'Co':{'mmass':58.9332002, 'amass':58.9332002},
            'Ni':{'mmass':57.9353479, 'amass':58.6934},
            'Cu':{'mmass':62.9296011, 'amass':63.546},
            'Zn':{'mmass':63.9291466, 'amass':65.39},
            'Ga':{'mmass':68.925581, 'amass':69.723},
            'Ge':{'mmass':73.9211782, 'amass':72.61},
            'As':{'mmass':74.9215964, 'amass':74.9215964},
            'Se':{'mmass':79.9165218, 'amass':78.96},
            'Br':{'mmass':78.9183376, 'amass':79.904},
            'Kr':{'mmass':83.911507, 'amass':83.8},
            'Rb':{'mmass':84.9117893, 'amass':85.4678},
            'Sr':{'mmass':87.9056143, 'amass':87.62},
            'Y':{'mmass':88.9058479, 'amass':88.90585},
            'Zr':{'mmass':89.9047037, 'amass':91.224},
            'Nb':{'mmass':92.9063775, 'amass':92.90638},
            'Mo':{'mmass':97.9054078, 'amass':95.94},
            'Tc':{'mmass':98.0, 'amass':98.0},
            'Ru':{'mmass':101.9043495, 'amass':101.07},
            'Rh':{'mmass':102.905504, 'amass':102.9055},
            'Pd':{'mmass':105.903483, 'amass':106.42},
            'Ag':{'mmass':106.905093, 'amass':107.8682},
            'Cd':{'mmass':113.9033581, 'amass':112.411},
            'In':{'mmass':114.903878, 'amass':114.818},
            'Sn':{'mmass':119.9021966, 'amass':118.71},
            'Sb':{'mmass':120.903818, 'amass':121.76},
            'Te':{'mmass':129.9062228, 'amass':127.6},
            'I':{'mmass':126.904477, 'amass':126.904477},
            'Xe':{'mmass':131.9041545, 'amass':131.29},
            'Cs':{'mmass':132.905447, 'amass':132.90545},
            'Ba':{'mmass':137.905241, 'amass':137.327},
            'La':{'mmass':138.906348, 'amass':138.9055},
            'Ce':{'mmass':139.905434, 'amass':140.116},
            'Pr':{'mmass':140.907648, 'amass':140.90765},
            'Nd':{'mmass':141.907719, 'amass':144.24},
            'Pm':{'mmass':145.0, 'amass':145.0},
            'Sm':{'mmass':151.919728, 'amass':150.36},
            'Eu':{'mmass':152.921226, 'amass':151.964},
            'Gd':{'mmass':157.924101, 'amass':157.25},
            'Tb':{'mmass':158.925343, 'amass':158.92534},
            'Dy':{'mmass':163.929171, 'amass':162.5},
            'Ho':{'mmass':164.930319, 'amass':164.93032},
            'Er':{'mmass':165.93029, 'amass':167.26},
            'Tm':{'mmass':168.934211, 'amass':168.93421},
            'Yb':{'mmass':173.9388581, 'amass':173.04},
            'Lu':{'mmass':174.9407679, 'amass':174.967},
            'Hf':{'mmass':179.9465488, 'amass':178.49},
            'Ta':{'mmass':180.947996, 'amass':180.9479},
            'W':{'mmass':183.9509326, 'amass':183.84},
            'Re':{'mmass':186.9557508, 'amass':186.207},
            'Os':{'mmass':191.961479, 'amass':190.23},
            'Ir':{'mmass':192.962924, 'amass':192.217},
            'Pt':{'mmass':194.964774, 'amass':195.078},
            'Au':{'mmass':196.966552, 'amass':196.96655},
            'Hg':{'mmass':201.970626, 'amass':200.59},
            'Tl':{'mmass':204.974412, 'amass':204.3833},
            'Pb':{'mmass':207.976636, 'amass':207.2},
            'Bi':{'mmass':208.980383, 'amass':208.98038},
            'Po':{'mmass':209.0, 'amass':209.0},
            'At':{'mmass':210.0, 'amass':210.0},
            'Rn':{'mmass':222.0, 'amass':222.0},
            'Fr':{'mmass':223.0, 'amass':223.0},
            'Ra':{'mmass':226.0, 'amass':226.0},
            'Ac':{'mmass':227.0, 'amass':227.0},
            'Th':{'mmass':232.0380504, 'amass':232.0381},
            'Pa':{'mmass':231.0358789, 'amass':231.03588},
            'U':{'mmass':238.0507826, 'amass':238.0289},
            'Np':{'mmass':237.0, 'amass':237.0},
            'Pu':{'mmass':244.0, 'amass':244.0},
            'Am':{'mmass':243.0, 'amass':243.0},
            'Cm':{'mmass':247.0, 'amass':247.0},
            'Bk':{'mmass':247.0, 'amass':247.0},
            'Cf':{'mmass':251.0, 'amass':251.0},
            'Es':{'mmass':252.0, 'amass':252.0},
            'Fm':{'mmass':257.0, 'amass':257.0},
            'Md':{'mmass':258.0, 'amass':258.0},
            'No':{'mmass':259.0, 'amass':259.0},
            'Lr':{'mmass':262.0, 'amass':262.0},
            'Rf':{'mmass':261.0, 'amass':261.0},
            'Db':{'mmass':262.0, 'amass':262.0},
            'Sg':{'mmass':263.0, 'amass':263.0},
            'Bh':{'mmass':264.0, 'amass':264.0},
            'Hs':{'mmass':265.0, 'amass':265.0},
            'Mt':{'mmass':268.0, 'amass':268.0},
            'D':{'mmass':2.014102, 'amass':2.014102},
            'T':{'mmass':3.016049, 'amass':3.016049},
            'C*':{'mmass':13.003355, 'amass':13.003355},
            'N*':{'mmass':15.000109, 'amass':15.000109},
            'O*':{'mmass':17.99916, 'amass':17.99916},
            'S*':{'mmass':35.967081, 'amass':35.967081}
}


# default amino acids
aminoacids = {
            'A':{'abbr':'Ala', 'formula':'C3H5NO', 'name':'Alanine'},
            'R':{'abbr':'Arg', 'formula':'C6H12N4O', 'name':'Arginine'},
            'N':{'abbr':'Asn', 'formula':'C4H6O2N2', 'name':'Asparagine'},
            'D':{'abbr':'Asp', 'formula':'C4H5NO3', 'name':'Aspartic Acid'},
            'C':{'abbr':'Cys', 'formula':'C3H5NOS', 'name':'Cysteine'},
            'E':{'abbr':'Glu', 'formula':'C5H7NO3', 'name':'Glutamic Acid'},
            'Q':{'abbr':'Gln', 'formula':'C5H8N2O2', 'name':'Glutamine'},
            'G':{'abbr':'Gly', 'formula':'C2H3NO', 'name':'Glycine'},
            'H':{'abbr':'His', 'formula':'C6H7N3O', 'name':'Histidine'},
            'I':{'abbr':'Ile', 'formula':'C6H11NO', 'name':'Isoleucine'},
            'L':{'abbr':'Leu', 'formula':'C6H11NO', 'name':'Leucine'},
            'K':{'abbr':'Lys', 'formula':'C6H12N2O', 'name':'Lysine'},
            'M':{'abbr':'Met', 'formula':'C5H9NSO', 'name':'Methionine'},
            'F':{'abbr':'Phe', 'formula':'C9H9NO', 'name':'Phenylalanine'},
            'P':{'abbr':'Pro', 'formula':'C5H7NO', 'name':'Proline'},
            'S':{'abbr':'Ser', 'formula':'C3H5NO2', 'name':'Serine'},
            'T':{'abbr':'Thr', 'formula':'C4H7NO2', 'name':'Threonine'},
            'W':{'abbr':'Trp', 'formula':'C11H10N2O', 'name':'Tryptophan'},
            'Y':{'abbr':'Tyr', 'formula':'C9H9NO2', 'name':'Tyrosine'},
            'V':{'abbr':'Val', 'formula':'C5H9NO', 'name':'Valine'},
            'Ca':{'abbr':'CysA', 'formula':'C6H10N2O2S', 'name':'Cystein Acrylamide Adduct'},
            'Cc':{'abbr':'CysC', 'formula':'C5H8N2O2S', 'name':'Cystein Carbamidomethylated'},
            'Co':{'abbr':'CysO', 'formula':'C5H7NO3S', 'name':'Cystein Carboxymethylated'},
            'Mo':{'abbr':'MetO', 'formula':'C5H9NSO2', 'name':'Methionine Oxidized'}
}

# default digest enzymes
enzymes = {
        'Arg-C':{'expr':'[R][A-Z]', 'n-term':'H', 'c-term':'OH'},
        'Asp-N':{'expr':'[A-Z][D]', 'n-term':'H', 'c-term':'OH'},
        'Bromelain':{'expr':'[KAY][A-Z]', 'n-term':'H', 'c-term':'OH'},
        'Cathepsin B':{'expr':'[R][A-Z]', 'n-term':'H', 'c-term':'OH'},
        'Cathepsin D':{'expr':'[LF][^VAG]', 'n-term':'H', 'c-term':'OH'},
        'Cathepsin G':{'expr':'[YWF][A-Z]', 'n-term':'H', 'c-term':'OH'},
        'Chymotrypsin':{'expr':'[YWFL][^P]', 'n-term':'H', 'c-term':'OH'},
        'Clostripain':{'expr':'[R][^P]', 'n-term':'H', 'c-term':'OH'},
        'CNBr_HSer':{'expr':'[M][A-Z]', 'n-term':'H', 'c-term':'H2O2-SCH3'},
        'CNBr_HSerLac':{'expr':'[M][A-Z]', 'n-term':'H', 'c-term':'O-SCH3'},
        'Elastase':{'expr':'[AVLIGS][A-Z]', 'n-term':'H', 'c-term':'OH'},
        'Glu-C_Bic':{'expr':'[E][A-Z]', 'n-term':'H', 'c-term':'OH'},
        'Glu-C_Phos':{'expr':'[ED][A-Z]', 'n-term':'H', 'c-term':'OH'},
        'Hydroxylamine':{'expr':'[N][G]', 'n-term':'H', 'c-term':'OH'},
        'Lys-C':{'expr':'[K][A-Z]', 'n-term':'H', 'c-term':'OH'},
        'Lys-N':{'expr':'[A-Z][K]', 'n-term':'H', 'c-term':'OH'},
        'Papain':{'expr':'[RK][A-Z]', 'n-term':'H', 'c-term':'OH'},
        'Pepsin':{'expr':'[LF][^VAG]', 'n-term':'H', 'c-term':'OH'},
        'Proteinase K':{'expr':'[YWF][A-Z]', 'n-term':'H', 'c-term':'OH'},
        'Subtilisin':{'expr':'[^RHK][A-Z]', 'n-term':'H', 'c-term':'OH'},
        'Thermolysin':{'expr':'[LFIVMA][^P]', 'n-term':'H', 'c-term':'OH'},
        'Trypsin':{'expr':'[KR][^P]', 'n-term':'H', 'c-term':'OH'},
        'TrypChymo':{'expr':'[FYWLKR][^P]', 'n-term':'H', 'c-term':'OH'}
}

# default modifications
modifications = {
                '2-sulfobenzoate':{'formula':'C7H5O4S-H', 'specifity':'K', 'n-term':1, 'c-term':0, 'group':'chemical;', 'descr':'2-sulfobenzoate'},
                'Acetyl':{'formula':'C2H3O-H', 'specifity':'KCS', 'n-term':1, 'c-term':0, 'group':'ptm;chemical;', 'descr':'acetylation'},
                'Amide':{'formula':'NH2-OH', 'specifity':'', 'n-term':0, 'c-term':1, 'group':'ptm;', 'descr':'amidation'},
                'Amino-Tyr':{'formula':'HN', 'specifity':'Y', 'n-term':0, 'c-term':0, 'group':'chemical;', 'descr':'tyrosine oxidation to 2-aminotyrosine'},
                'Aminoadipic_acid':{'formula':'O2-H3N1', 'specifity':'K', 'n-term':0, 'c-term':0, 'group':'ptm;', 'descr':'alpha-amino adipic acid'},
                'Biotin':{'formula':'H14C10N2O2S', 'specifity':'K', 'n-term':1, 'c-term':0, 'group':'ptm;chemical;', 'descr':'biotinylation'},
                'Boc':{'formula':'C5H9O2-H', 'specifity':'K', 'n-term':1, 'c-term':0, 'group':'chemical;', 'descr':'Boc protecting group'},
                'C-Imide':{'formula':'-H2O1', 'specifity':'', 'n-term':0, 'c-term':1, 'group':'ptm;', 'descr':'C-term blocking imide'},
                'CAF':{'formula':'H4C3O4S', 'specifity':'', 'n-term':1, 'c-term':0, 'group':'chemical;', 'descr':'sulfonation of N-terminus'},
                'Carbamidomethyl':{'formula':'CH2CONH2-H', 'specifity':'CKHDE', 'n-term':1, 'c-term':0, 'group':'chemical;artefact;', 'descr':'iodoacetamide derivative'},
                'Carbamyl':{'formula':'HCNO', 'specifity':'KRC', 'n-term':1, 'c-term':0, 'group':'artefact;ptm;', 'descr':'carbamylation'},
                'Carboxyethyl':{'formula':'H4C3O2', 'specifity':'K', 'n-term':0, 'c-term':0, 'group':'ptm;', 'descr':'carboxyethyl'},
                'Carboxyl':{'formula':'H4C3O2', 'specifity':'WKD', 'n-term':0, 'c-term':0, 'group':'chemical;artefact;ptm;', 'descr':'carboxylation'},
                'Carboxymethyl':{'formula':'CH2COOH-H', 'specifity':'C', 'n-term':0, 'c-term':0, 'group':'chemical;', 'descr':'iodoacetic acid derivative'},
                'Cyano':{'formula':'CN-H', 'specifity':'C', 'n-term':0, 'c-term':0, 'group':'ptm;', 'descr':'cyano'},
                'CysCoA':{'formula':'H34C21N7O16P3S', 'specifity':'C', 'n-term':0, 'c-term':0, 'group':'ptm;', 'descr':'cysteine modified by Coenzyme A'},
                'Cysteic_acid':{'formula':'O3', 'specifity':'C', 'n-term':0, 'c-term':0, 'group':'chemical;', 'descr':'cysteine oxidation to cysteic acid'},
                'Cystine':{'formula':'-H', 'specifity':'C', 'n-term':0, 'c-term':0, 'group':'ptm;chemical;', 'descr':'half of a disulfide bridge'},
                'Dansyl':{'formula':'H11C12NO2S', 'specifity':'K', 'n-term':1, 'c-term':0, 'group':'chemical;', 'descr':'5-dimethylaminonaphthalene-1-sulfonyl'},
                'Deamidation':{'formula':'O-HN', 'specifity':'NQ', 'n-term':0, 'c-term':0, 'group':'artefact;', 'descr':'Deamidation'},
                'Dehydration':{'formula':'-H2O', 'specifity':'ST', 'n-term':0, 'c-term':0, 'group':'ptm;', 'descr':'dehydration'},
                'DehydroAlaC':{'formula':'-H2S', 'specifity':'C', 'n-term':0, 'c-term':0, 'group':'chemical;', 'descr':'dehydroalanine (from Cysteine)'},
                'DehydroAlaY':{'formula':'-H6C6O', 'specifity':'Y', 'n-term':0, 'c-term':0, 'group':'ptm;', 'descr':'dehydroalanine (from Tyrosine)'},
                'Deoxyhexose':{'formula':'C6H12O5-H2O', 'specifity':'ST', 'n-term':0, 'c-term':0, 'group':'glyco;', 'descr':'deoxyhexose'},
                'Diacylglycerol':{'formula':'H68C37O4', 'specifity':'C', 'n-term':0, 'c-term':0, 'group':'ptm;', 'descr':'diacylglycerol'},
                'Didehydrog':{'formula':'-H2', 'specifity':'YS', 'n-term':0, 'c-term':0, 'group':'ptm;', 'descr':'didehydrogenation'},
                'Dihydroxy':{'formula':'O2H2-H2', 'specifity':'PRK', 'n-term':0, 'c-term':0, 'group':'ptm;', 'descr':'dihydroxy'},
                'DihydroxyPhe':{'formula':'O2', 'specifity':'F', 'n-term':0, 'c-term':0, 'group':'chemical;', 'descr':'phenylalanine oxidation to dihydroxyphenylalanine'},
                'Dioxidation':{'formula':'O2', 'specifity':'W', 'n-term':0, 'c-term':0, 'group':'artefact;', 'descr':'double oxidation'},
                'EDT':{'formula':'H4C2S2-O', 'specifity':'ST', 'n-term':0, 'c-term':0, 'group':'chemical;', 'descr':'EDT'},
                'EtOH':{'formula':'H4C2O', 'specifity':'C', 'n-term':0, 'c-term':0, 'group':'chemical;', 'descr':'ethanolation of Cys'},
                'Ethyl':{'formula':'H4C2', 'specifity':'C', 'n-term':1, 'c-term':0, 'group':'ptm;chemical;artefact;', 'descr':'ethylation'},
                'FAD':{'formula':'H31C27N9O15P2', 'specifity':'CHY', 'n-term':0, 'c-term':0, 'group':'ptm;', 'descr':'flavin adenine dinucleotide'},
                'FMN':{'formula':'H19C17N4O9P', 'specifity':'CH', 'n-term':0, 'c-term':0, 'group':'ptm;', 'descr':'flavin mononucleotide'},
                'Fluorescein':{'formula':'H14C22NO6', 'specifity':'C', 'n-term':0, 'c-term':0, 'group':'chemical;', 'descr':'5-iodoacetamidofluorescein'},
                'Fmoc':{'formula':'C15H11O2-H', 'specifity':'K', 'n-term':1, 'c-term':0, 'group':'chemical;', 'descr':'Fmoc protecting group'},
                'Formyl':{'formula':'CHO-H', 'specifity':'KST', 'n-term':1, 'c-term':0, 'group':'artefact;', 'descr':'formylation'},
                'Gamma_carboxyl':{'formula':'CO2', 'specifity':'DE', 'n-term':0, 'c-term':0, 'group':'ptm;', 'descr':'gamma-carboxylation'},
                'Guanidin':{'formula':'H2CN2', 'specifity':'K', 'n-term':0, 'c-term':0, 'group':'chemical;', 'descr':'guanidination'},
                'HSe':{'formula':'O-H2C1S', 'specifity':'M', 'n-term':0, 'c-term':0, 'group':'chemical;', 'descr':'homoserine'},
                'HSeLac':{'formula':'-H4C1S1', 'specifity':'M', 'n-term':0, 'c-term':0, 'group':'chemical;', 'descr':'homoserine lactone'},
                'Heme':{'formula':'H32C34N4O4Fe', 'specifity':'CH', 'n-term':0, 'c-term':0, 'group':'ptm;', 'descr':'heme'},
                'Heptose':{'formula':'C7H14O7-H2O', 'specifity':'STD', 'n-term':0, 'c-term':0, 'group':'glyco;', 'descr':'heptose'},
                'HexNAc':{'formula':'C8H15N1O6-H2O', 'specifity':'NST', 'n-term':0, 'c-term':0, 'group':'glyco;', 'descr':'N-acetylhexosamine'},
                'Hexosamine':{'formula':'C6H13N1O5-H2O', 'specifity':'STD', 'n-term':0, 'c-term':0, 'group':'glyco;', 'descr':'hexosamine'},
                'Hexose':{'formula':'C6H12O6-H2O', 'specifity':'KNTWCRY', 'n-term':1, 'c-term':0, 'group':'glyco;', 'descr':'hexose'},
                'Hg':{'formula':'Hg', 'specifity':'C', 'n-term':0, 'c-term':0, 'group':'chemical;', 'descr':'mercury mercaptan'},
                'His2Asn':{'formula':'O-HC2N', 'specifity':'H', 'n-term':0, 'c-term':0, 'group':'chemical;', 'descr':'histidine oxidation to aspargine'},
                'His2Asp':{'formula':'O2-H2C2N2', 'specifity':'H', 'n-term':0, 'c-term':0, 'group':'chemical;', 'descr':'histidine oxidation to aspartic acid'},
                'Homoarginine':{'formula':'CH3N2-H', 'specifity':'K', 'n-term':0, 'c-term':0, 'group':'chemical;', 'descr':'homoarginine from lysine'},
                'Hydroxylation':{'formula':'HO-H', 'specifity':'DKNPFYR', 'n-term':0, 'c-term':0, 'group':'ptm;artefact;', 'descr':'hydroxylation'},
                'Hydroxymethyl':{'formula':'H2CO', 'specifity':'N', 'n-term':0, 'c-term':0, 'group':'ptm;', 'descr':'hydroxymethyl'},
                'ICAT_heavy':{'formula':'H17CC*9N3O3', 'specifity':'C', 'n-term':0, 'c-term':0, 'group':'chemical;', 'descr':'AB cleavable ICAT heavy'},
                'ICAT_light':{'formula':'H17C10N3O3', 'specifity':'C', 'n-term':0, 'c-term':0, 'group':'chemical;', 'descr':'AB cleavable ICAT light'},
                'ICPL_heavy':{'formula':'H3C*6NO', 'specifity':'K', 'n-term':1, 'c-term':0, 'group':'chemical;', 'descr':'BD SERVA-ICPL quantification chemistry, heavy'},
                'ICPL_light':{'formula':'H3C6NO', 'specifity':'K', 'n-term':1, 'c-term':0, 'group':'chemical;', 'descr':'BD SERVA-ICPL quantification chemistry, light'},
                'Iodination':{'formula':'I-H', 'specifity':'YH', 'n-term':0, 'c-term':0, 'group':'chemical;', 'descr':'iodination'},
                'K':{'formula':'K-H', 'specifity':'DE', 'n-term':0, 'c-term':1, 'group':'artefact;', 'descr':'potassium adduct'},
                'Koshland':{'formula':'C7H6NO3-H', 'specifity':'W', 'n-term':0, 'c-term':0, 'group':'chemical;', 'descr':'2-hydroxy-5-nitrobenzyl bromide'},
                'Lipoyl':{'formula':'H12C8OS2', 'specifity':'K', 'n-term':0, 'c-term':0, 'group':'ptm;', 'descr':'lipoyl'},
                'Me-ester':{'formula':'H2C', 'specifity':'DEST', 'n-term':0, 'c-term':1, 'group':'ptm;', 'descr':'methyl ester'},
                'Methyl':{'formula':'CH3-H', 'specifity':'CHKNQRIL', 'n-term':1, 'c-term':0, 'group':'ptm;', 'descr':'methylation'},
                'Muramic_acid':{'formula':'C11H19N1O8-H2O', 'specifity':'STD', 'n-term':0, 'c-term':0, 'group':'glyco;', 'descr':'muramic acid'},
                'Myristoyl':{'formula':'C14H27O-H', 'specifity':'GKC', 'n-term':1, 'c-term':0, 'group':'ptm;', 'descr':'myristoylation'},
                'N-FormylMet':{'formula':'H10C6NO2S', 'specifity':'', 'n-term':1, 'c-term':0, 'group':'ptm;', 'descr':'addition of N-formyl met'},
                'N-carboxyl':{'formula':'CO2', 'specifity':'', 'n-term':1, 'c-term':0, 'group':'ptm;', 'descr':'N-carboxylation of Met'},
                'Na':{'formula':'Na-H', 'specifity':'DE', 'n-term':0, 'c-term':1, 'group':'artefact;', 'descr':'sodium adduct'},
                'Nitro':{'formula':'NO2-H', 'specifity':'WY', 'n-term':0, 'c-term':0, 'group':'chemical;', 'descr':'oxidation to nitro'},
                'O18':{'formula':'O*-O', 'specifity':'STY', 'n-term':0, 'c-term':1, 'group':'chemical;', 'descr':'O18 label'},
                'Oxidation':{'formula':'O', 'specifity':'MHW', 'n-term':0, 'c-term':0, 'group':'artefact;', 'descr':'oxidation'},
                'PIC':{'formula':'H5C7NO', 'specifity':'', 'n-term':1, 'c-term':0, 'group':'chemical;', 'descr':'phenyl isocyanate'},
                'Palmitoyl':{'formula':'C16H31O-H', 'specifity':'CKST', 'n-term':1, 'c-term':0, 'group':'ptm;', 'descr':'palmitoylation'},
                'Pentose':{'formula':'C5H10O5-H2O', 'specifity':'STD', 'n-term':0, 'c-term':0, 'group':'glyco;', 'descr':'pentose'},
                'Phospho':{'formula':'H2PO3-H', 'specifity':'STY', 'n-term':0, 'c-term':0, 'group':'ptm;', 'descr':'phosphorylation'},
                'Propionamide':{'formula':'C3H6ON-H', 'specifity':'C', 'n-term':0, 'c-term':0, 'group':'artefact;', 'descr':'acrylamide adduct'},
                'PyroGluE':{'formula':'-H2O', 'specifity':'E', 'n-term':0, 'c-term':0, 'group':'artefact;', 'descr':'pyro-glu from E'},
                'PyroGluQ':{'formula':'-H3N', 'specifity':'Q', 'n-term':0, 'c-term':0, 'group':'artefact;', 'descr':'pyro-glu from Q'},
                'Pyroglutamic':{'formula':'O-H2', 'specifity':'P', 'n-term':0, 'c-term':0, 'group':'chemical;', 'descr':'proline oxidation to pyroglutamic acid'},
                'Quinone':{'formula':'O2-H2', 'specifity':'YW', 'n-term':0, 'c-term':0, 'group':'ptm;', 'descr':'quinone'},
                'Retinal':{'formula':'H26C20', 'specifity':'K', 'n-term':0, 'c-term':0, 'group':'ptm;', 'descr':'retinal'},
                'SNO':{'formula':'NO-H', 'specifity':'C', 'n-term':0, 'c-term':0, 'group':'ptm;', 'descr':'S-nitrosylation'},
                'SPITC':{'formula':'H5C7NO3S2', 'specifity':'K', 'n-term':1, 'c-term':0, 'group':'chemical;', 'descr':'4-sulfophenyl isothiocyanate'},
                'Se-Cys':{'formula':'Se-S', 'specifity':'C', 'n-term':0, 'c-term':0, 'group':'other;', 'descr':'selenium replaces sulphur in cysteine'},
                'Se-Met':{'formula':'Se-S', 'specifity':'M', 'n-term':0, 'c-term':0, 'group':'other;', 'descr':'selenium replaces sulphur in methionine'},
                'Sialic_acid':{'formula':'C11H19N1O9-H2O', 'specifity':'STD', 'n-term':0, 'c-term':0, 'group':'glyco;', 'descr':'sialic acid'},
                'Sulfation':{'formula':'HSO3-H', 'specifity':'STY', 'n-term':0, 'c-term':0, 'group':'ptm;', 'descr':'O-sulfonation'},
                'Sulfenic_acid':{'formula':'O', 'specifity':'C', 'n-term':0, 'c-term':0, 'group':'ptm;', 'descr':'cysteine sulfenic acid'},
                'SulfonicAcid':{'formula':'O3H-H', 'specifity':'C', 'n-term':0, 'c-term':0, 'group':'ptm;', 'descr':'cysteine sulfonic acid'},
                'Sulphonylacetyl':{'formula':'C2H3O4S-H2', 'specifity':'K', 'n-term':1, 'c-term':0, 'group':'chemical;', 'descr':'sulphonylacetyl'},
                'iTRAQ':{'formula':'H12C4C*3NN*O', 'specifity':'KY', 'n-term':1, 'c-term':0, 'group':'chemical;', 'descr':'AB iTRAQ multiplexed quantitation chemistry'},
                'tButyl':{'formula':'C4H9-H', 'specifity':'CDEHSTY', 'n-term':0, 'c-term':0, 'group':'chemical;', 'descr':'tButyl protecting group'}
}

# calibration references
references = {
            'MALDI_matrices_positive':{
                'CCA_[M+H]+_mono':190.04987,
                'CCA_[2M+H]+_mono':379.09246,
                'SA_[M+H]+_mono':225.07633,
                'SA_[2M+H]+_mono':449.14483,
                'DHB_[M+H]+_mono':155.03444,
                'DHB_[2M+H]+_mono':309.06105,
                },
            'MALDI_matrices_negative':{
                'CCA_[M-H]-_mono':188.03532,
                'CCA_[2M-H]-_mono':377.07791,
                'SA_[M-H]-_mono':223.061777,
                'SA_[2M-H]-_mono':447.130277,
                'DHB_[M-H]-_mono':153.019887,
                'DHB_[2M-H]-_mono':307.046497,
                },
            'Bruker_pepmix_positive':{
                'Bradykinin(1-7)_[M+H]+_mono':757.39916,
                'Angiotensin_II_[M+H]+_mono':1046.5418,
                'Angiotensin_I_[M+H]+_mono':1296.6848,
                'Substance_P_[M+H]+_mono':1347.7354,
                'Bombesin_[M+H]+_mono':1619.8223,
                'Renin_Substrate_[M+H]+_mono':1758.93261,
                'ACTH_clip(1-17)_[M+H]+_mono':2093.0862,
                'ACTH_clip(18-39)_[M+H]+_mono':2465.1983,
                'Somatostatin(28)_[M+H]+_mono':3147.471,
                },
            'Bruker_pepmix_negative':{
                'Angiotensin_II_[M-H]-_mono':1044.527247,
                'Angiotensin_I_[M-H]-_mono':1294.670247,
                'Substance_P_[M-H]-_mono':1345.720847,
                'Bombesin_[M-H]-_mono':1617.807747,
                'ACTH_clip(1-17)_[M-H]-_mono':2091.071647,
                'ACTH_clip(18-39)_[M-H]-_mono':2463.183747,
                'Somatostatin(28)_[M-H]-_mono':3145.456447,
                },
            'Bruker_protmixI_positive':{
                'Insulin_[M+H]+_aver':5734.56,
                'Ubiquitin_I_[M+H]+_aver':8565.89,
                'Cytochrom_C_[M+H]+_aver':12361.09,
                'Myoglobin_[M+H]+_aver':16952.55,
                'Cytochrome_C_[M+2H]2+_aver':6181.05,
                'Myoglobin_[M+2H]2+_aver':8476.77,
                },
            'Bruker_protmixI_negative':{
                'Insulin_[M-H]-_aver':5732.545447,
                'Ubiquitin_I_[M-H]-_aver':8563.875447,
                'Cytochrom_C_[M-H]-_aver':12359.075447,
                'Myoglobin[M-H]-_aver':16950.535447,
                'Cytochrome_C_[M-2H]2-_aver':6179.035447,
                'Myoglobin_[M-2H]2-_aver':8474.755447,
                },
            'Bruker_protmixII_positive':{
                'Trypsinogen_[M+H]+_aver':23982.0,
                'Protein_A_[M+H]+_aver':44613.0,
                'Albumin-Bovin_[M+H]+_aver':66431.0,
                'Protein_A_[M+2H]2+_aver':22306.0,
                'Albumin-Bovin_[M+2H]2+_aver':33216.0,
                },
            'Bruker_protmixII_negative':{
                'Trypsinogen_[M-H]-_aver':23979.985447,
                'Protein_A_[M-H]-_aver':44610.985447,
                'Albumin-Bovin_[M-H]-_aver':66428.985447,
                'Protein_A_[M-2H]2-_aver':22303.985447,
                'Albumin-Bovin_[M-2H]2-_aver':33213.985447,
                },
            'Trypsin_Promega_porcine_positive':{
                'Trypsin_[108-115]_mono':842.5094,
                'Trypsin_[98-107]_mono':1045.5637,
                'Trypsin_[58-77]_mono':2211.104,
                'Trypsin_[78-97]_mono':2283.1802,
                'Trypsin_[58-72]_mono':1713.8084,
                'Trypsin_[62-77]_mono':1774.8975,
                'Trypsin_[58-76]_mono':2083.0096,
                },
            'Trypsin_Roche_bovine_positive':{
                'Trypsin_[112-119]_mono':805.4163,
                'Trypsin_[160-169]_mono':1020.503,
                'Trypsin_[229-237]_mono':1111.5605,
                'Trypsin_[207-220]_mono':1433.7206,
                'Trypsin_[70-89]_mono':2163.0564,
                'Trypsin_[90-109]_mono':2273.1595,
                },
            'Trypsin_Roche_porcine_positive':{
                'Trypsin_[108-115]_mono':842.5094,
                'Trypsin_[148-157]_mono':1006.4874,
                'Trypsin_[98-107]_mono':1045.5637,
                'Trypsin_[134-147]_mono':1469.7305,
                'Trypsin_[116-133]_mono':1768.7993,
                'Trypsin_[58-77]_mono':2211.104,
                'Trypsin_[58-74]_mono':1940.9354,
                },
            'Keratin_positive':{
                'Keratin_1/II_mono':1179.601,
                'Keratin_1/II_mono':1300.5302,
                'Keratin_1/II_mono':1716.8517,
                'Keratin_1/II_mono':1993.9767,
                'Keratin_10_mono':1165.5853,
                'Keratin_10_mono':2825.4056,
                },
}
