
# load libs
from wx.tools import img2py

# ----
def convertImages():
    """Convert an image to PNG format and embed it in a Python file. """

    # make starting text to import all needed libs
    buff = '#load libs\nfrom wx import ImageFromStream, BitmapFromImage\nfrom wx import EmptyIcon\nimport cStringIO\n\n'

    imageFile = file('images.py', 'w')
    imageFile.write(buff)
    imageFile.close()
    
    # make commandlines
    command_lines = [
        "-a -u -i -n Icon16 ../images/icon_win_16.png images.py",
        "-a -u -i -n Icon22 ../images/icon_win_22.png images.py",
        "-a -u -i -n Icon24 ../images/icon_win_24.png images.py",
        "-a -u -i -n Icon32 ../images/icon_win_32.png images.py",
        "-a -u -i -n Icon48 ../images/icon_win_48.png images.py",
        "-a -u -n Toolbar ../images/toolbar.png images.py",
        "-a -u -n Cursors ../images/cursors.png images.py",
        "-a -u -n Splash ../images/splash.png images.py",
        ]

    # convert images
    for line in command_lines:
        args = line.split()
        img2py.main(args)
# ----

if __name__ == "__main__":
    convertImages()
