# -------------------------------------------------------------------------
#     This file is part of mMass - the spectrum analysis tool for MS.
#     Copyright (C) 2005-07 Martin Strohalm <mmass@biographics.cz>

#     This program is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 2 of the License, or
#     (at your option) any later version.

#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.

#     Complete text of GNU GPL can be found in the file LICENSE in the
#     main directory of the program
# -------------------------------------------------------------------------

# Function: Export peaklist to ASCII XY file.


# ----
def formatData(data, config):
    """ Format peaklist data to XY ascii file. """

    # get delimiter
    if config['delimiter'] == 'tab':
        delimiter = '\t'
    else:
        delimiter = config['delimiter']

    # make format
    format = ''
    if config['copymass']:
        format += '%f'
    if config['copyintens']:
        format += delimiter + '%f'
    if config['copyannot']:
        format += delimiter + '%s'

    # format data
    buff = ''
    for point in data:
        items = []
        if config['copymass']:
            items.append(point[0])
        if config['copyintens']:
            items.append(point[1])
        if config['copyannot']:
            items.append(point[2])

        buff += format % tuple(items)
        buff += '\n'

    return buff
# ----
