# -------------------------------------------------------------------------
#     This file is part of mMass - the spectrum analysis tool for MS.
#     Copyright (C) 2005-07 Martin Strohalm <mmass@biographics.cz>

#     This program is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 2 of the License, or
#     (at your option) any later version.

#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.

#     Complete text of GNU GPL can be found in the file LICENSE in the
#     main directory of the program
# -------------------------------------------------------------------------

# Function: Basic sequence definition.


class sequence:
    """ Basic sequence definition. """

    # ----
    def __init__(self):
        self.title = '' # sequence title
        self.sequence = [] # one-letter sequence
        self.modifications = [] # list of modifications [[where, formula, name], [...]]
        self.parsedSequence = [] # sequence dic with calculated masses
    # ----


    # ----
    def setSequence(self, sequence=[]):
        """ Set new data to sequence. """

        # set new sequence
        if type(sequence) != list:
            self.sequence = list(sequence)
        else:
            self.sequence = sequence

        # delete parsed sequence and modifications
        self.parsedSequence = []
        self.modifications = []
    # ----


    # ----
    def setTitle(self, title=''):
        """ Set new sequence title. """
        self.title = title
    # ----


    # ----
    def setParsedSequence(self, sequence=[]):
        """ Set new data to parsed sequence. """
        self.parsedSequence = sequence
    # ----


    # ----
    def setModifications(self, modifications=[]):
        """ Set new data to sequence modifications. """
        self.modifications = modifications
    # ----


    # ----
    def getTitle(self):
        """ Get sequence title. """
        return self.title
    # ----


    # ----
    def getSequence(self, index1=None, index2=None):
        """ Get sequence slice or whole sequence. """

        # get single amino acid
        if index1 != None and index2 == None:
            return self.sequence[index1]

        # get sequence slice
        else:
            return self.sequence[index1:index2]
    # ----


    # ----
    def getSequenceString(self, index1=None, index2=None):
        """ Get sequence slice or whole sequence as string. """

        # get slice of sequence
        sequence = ''
        for amino in self.sequence[index1:index2]:
            sequence += amino

        return sequence
    # ----


    # ----
    def getParsedSequence(self, index1=None, index2=None):
        """ Get parsed sequence slice or whole parsed sequence. """

        if index1 != None and index2 == None:
            return self.parsedSequence[index1]

        # get sequence slice
        else:
            return self.parsedSequence[index1:index2]
    # ----


    # ----
    def getLength(self):
        """ Get number of amino acids in the sequence. """
        return len(self.sequence)
    # ----


    # ----
    def getModifications(self, index=None):
        """ Get modifications for selected amino acid or whole sequence. """

        # get whole list
        if index == None:
            return self.modifications[:]

        # get modification for selected amino acid
        else:
            return self.modifications[index]
    # ----


    # ----
    def getModificationsCount(self, index1=None, index2=None):
        """ Count modifications in sequence/selection. """

        # get parsed sequence
        sequence = self.parsedSequence[index1:index2]

        # count residue modifications
        count = 0
        for amino in sequence:
            count += len(amino[3:])

        return count
    # ----
