;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; int.scm
;;
;; Integers
;;
;; $Id: int.scm 2156 2008-01-25 13:25:12Z schimans $
;;
;; Markus Sauermann
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(exload "train/pos.scm")

(add-alg "int"
	 '("IZero" "int")
         '("Ipos" "pos=>int")
	 '("Ineg" "pos=>int"))

(av "z" (py "int"))
(av "ztob" (py "int=>boole"))
(add-pvar-name "Pint" (make-arity (py "int")))

(set-goal (pf "all z1,z2. z1=z2 -> z2=z1"))
(assume "z1" "z2" 1)
(simp 1)
(use "Truth-Axiom")
(save "intSymm")

(set-goal (pf "all z1,z2,z3. z1=z2 -> z2=z3 -> z1=z3"))
(strip)
(simp 1)
(use 2)
(save "intTrans")

;; SHIFTS

(add-program-constant "intSHLone" (py "int=>int") 1 'const 1)
(add-computation-rule (pt "intSHLone IZero") (pt "IZero"))
(add-computation-rule (pt "intSHLone (Ipos p)") (pt "Ipos (SZero p)"))
(add-computation-rule (pt "intSHLone (Ineg p)") (pt "Ineg (SZero p)"))

(set-goal (pf "all z1,z2. (intSHLone(z1)=intSHLone(z2)) = (z1=z2)"))
(cases)
(cases)
(auto)
(assume "p1")
(cases)
(auto)
(assume "p1")
(cases)
(auto)
(save "intSHLequality")


(set-goal (pf "all p. Ipos (SZero p) = intSHLone(Ipos p) &
                      Ineg (SZero p) = intSHLone(Ineg p)"))
(search)
(save "intSZeroShlBij")


;; ADDITION

(add-program-constant "intPlus" (py "int=>int=>int") 1 'const 2)

(add-token
 "/+"
 'add-op
 (lambda (x y)
   (mk-term-in-app-form
    (make-term-in-const-form (pconst-name-to-pconst "intPlus"))
    x y)))

(add-display
 (py "int")
 (lambda (x)
   (let ((op (term-in-app-form-to-final-op x))
	 (args (term-in-app-form-to-args x)))
     (if (and (term-in-const-form? op)
	      (string=? "intPlus"
			(const-to-name (term-in-const-form-to-const op)))
	      (= 2 (length args)))
	 (list 'add-op "/+"
	       (term-to-token-tree (car args))
	       (term-to-token-tree (cadr args)))
	 #f))))

(add-computation-rule (pt "z               /+ IZero")           (pt "z"))
(add-computation-rule (pt "IZero           /+ Ipos p")          (pt "Ipos p"))
(add-computation-rule (pt "IZero           /+ Ineg p")          (pt "Ineg p"))
(add-computation-rule (pt "Ipos p1         /+ Ipos p2")         (pt "Ipos (p1%+p2)"))
(add-computation-rule (pt "Ineg p1         /+ Ineg p2")         (pt "Ineg (p1%+p2)"))
(add-computation-rule (pt "Ipos One        /+ Ineg One")        (pt "IZero"))
(add-computation-rule (pt "Ipos One        /+ Ineg (SZero p)")  (pt "Ineg ((SZero p)%-One)"))
(add-computation-rule (pt "Ipos One        /+ Ineg (SOne p)")   (pt "Ineg (SZero p)"))
(add-computation-rule (pt "Ipos (SZero p1) /+ Ineg One")        (pt "Ipos (SZero p1%-One)"))
(add-computation-rule (pt "Ipos (SZero p1) /+ Ineg (SZero p2)") (pt "intSHLone(Ipos p1 /+ Ineg p2)"))
(add-computation-rule (pt "Ipos (SZero p1) /+ Ineg (SOne  p2)") (pt "intSHLone(Ipos p1 /+ Ineg p2)/+(Ineg One)"))
(add-computation-rule (pt "Ipos (SOne  p1) /+ Ineg One")        (pt "Ipos (SZero p1)"))
(add-computation-rule (pt "Ipos (SOne  p1) /+ Ineg (SZero p2)") (pt "intSHLone(Ipos p1 /+ Ineg p2)/+(Ipos One)"))
(add-computation-rule (pt "Ipos (SOne  p1) /+ Ineg (SOne  p2)") (pt "intSHLone(Ipos p1 /+ Ineg p2)"))
(add-computation-rule (pt "Ineg One        /+ Ipos One")        (pt "IZero"))
(add-computation-rule (pt "Ineg One        /+ Ipos (SZero p)")  (pt "Ipos ((SZero p)%-One)"))
(add-computation-rule (pt "Ineg One        /+ Ipos (SOne p)")   (pt "Ipos (SZero p)"))
(add-computation-rule (pt "Ineg (SZero p1) /+ Ipos One")        (pt "Ineg (SZero p1%-One)"))
(add-computation-rule (pt "Ineg (SZero p1) /+ Ipos (SZero p2)") (pt "intSHLone(Ineg p1 /+ Ipos p2)"))
(add-computation-rule (pt "Ineg (SZero p1) /+ Ipos (SOne  p2)") (pt "intSHLone(Ineg p1 /+ Ipos p2)/+(Ipos One)"))
(add-computation-rule (pt "Ineg (SOne  p1) /+ Ipos One")        (pt "Ineg (SZero p1)"))
(add-computation-rule (pt "Ineg (SOne  p1) /+ Ipos (SZero p2)") (pt "intSHLone(Ineg p1 /+ Ipos p2)/+(Ineg One)"))
(add-computation-rule (pt "Ineg (SOne  p1) /+ Ipos (SOne  p2)") (pt "intSHLone(Ineg p1 /+ Ipos p2)"))

;; (remove-computation-rules-for (pt "z1/+z2"))

(set-goal (pf "all z. IZero /+ z = z"))
(cases)
(use "Truth-Axiom")
(assume "p")
(use "Truth-Axiom")
(assume "p")
(use "Truth-Axiom")
(save "intHelper1")
(add-rewrite-rule (pt "IZero /+ z") (pt "z"))

(set-goal (pf "all z,z1,z2. z1=z2 -> z1/+z=z2/+z"))
(assume "z" "z1" "z2" 1)
(simp 1)
(use "Truth-Axiom")
(save "intIdSucc")

(set-goal (pf "all p1,p2. Ipos p1 /+ Ineg p2 = Ineg p2 /+ Ipos p1"))
(ind)
;; p1 = 1
(cases)
(use "Truth-Axiom")
(assume "p2")
(use "Truth-Axiom")
(assume "p2")
(use "Truth-Axiom")
;; p1 = 2x
(assume "p1" 1)
(cases)
(use "Truth-Axiom")
(assume "p2")
(ng)
(simp "intSHLequality")
(use 1)
(assume "p2")
(ng)
(use "intIdSucc")
(simp "intSHLequality")
(use 1)
;; p1 = 2x+1
(assume "p1" 1)
(cases)
(use "Truth-Axiom")
(assume "p2")
(ng)
(simp 1)
(use "Truth-Axiom")
(assume "p2")
(ng)
(simp 1)
(use "Truth-Axiom")
(save "intPlusCommPre")

(set-goal (pf "all z1,z2. z1/+z2 = z2/+z1"))
(cases)
(assume "z2")
(use "Truth-Axiom")
;; z1 = Pos
(assume "p1")
(cases)
(use "Truth-Axiom")
(assume "p2")
(use "posPlusComm")
(assume "p2")
(use "intPlusCommPre")
(assume "p1")
(cases)
(use "Truth-Axiom")
(assume "p2")
(simp "intPlusCommPre")
(use "Truth-Axiom")
(assume "p2")
(use "posPlusComm")
(save "intPlusComm")

(set-goal (pf "all p. Ipos p /+ Ineg p = IZero"))
(ind)
(use "Truth-Axiom")
(assume "p" 1)
(ng)
(simp 1)
(use "Truth-Axiom")
(assume "p" 1)
(ng)
(simp 1)
(use "Truth-Axiom")
(save "intPosNegZero")
(add-rewrite-rule (pt "Ipos p /+ Ineg p") (pt "IZero"))

(set-goal (pf "all p. Ineg p /+ Ipos p = IZero"))
(assume "p")
(simp "intPlusComm")
(use "Truth-Axiom")
(save "intNegPosZero")
(add-rewrite-rule (pt "Ineg p /+ Ipos p") (pt "IZero"))

(set-goal (pf "all z. z /+ Ineg One /+ Ipos One = z"))
(cases)
(use "Truth-Axiom")
(cases)
(auto)
(cases)
(auto)
(use "posHelper16")
(save "intMinusPlusOne")

(set-goal (pf "all z. z /+ Ipos One /+ Ineg One = z"))
(cases)
(use "Truth-Axiom")
(cases)
(auto)
(cases)
(auto)
(use "posHelper16")
(cases)
(auto)
(save "intPlusMinusOne")




;; SUBTRACTION

(add-program-constant "intMinus" (py "int=>int=>int") 1 'const 2)

(add-token
 "/-"
 'add-op
 (lambda (x y)
   (mk-term-in-app-form
    (make-term-in-const-form (pconst-name-to-pconst "intMinus"))
    x y)))

(add-display
 (py "int")
 (lambda (x)
   (let ((op (term-in-app-form-to-final-op x))
	 (args (term-in-app-form-to-args x)))
     (if (and (term-in-const-form? op)
	      (string=? "intMinus"
			(const-to-name (term-in-const-form-to-const op)))
	      (= 2 (length args)))
	 (list 'add-op "/-"
	       (term-to-token-tree (car args))
	       (term-to-token-tree (cadr args)))
	 #f))))

(add-computation-rule (pt "z /- IZero") (pt "z"))
(add-computation-rule (pt "IZero /- Ipos p") (pt "Ineg p"))
(add-computation-rule (pt "IZero /- Ineg p") (pt "Ipos p"))
(add-computation-rule (pt "Ipos p1 /- Ineg p2") (pt "Ipos (p1%+p2)"))
(add-computation-rule (pt "Ineg p1 /- Ipos p2") (pt "Ineg (p1%+p2)"))
(add-computation-rule (pt "Ipos p1 /- Ipos p2") (pt "Ipos p1 /+ Ineg p2"))
(add-computation-rule (pt "Ineg p1 /- Ineg p2") (pt "Ineg p1 /+ Ipos p2"))




;; LEMMATA

(set-goal (pf "all z1,z2. intSHLone(z1/+z2) = intSHLone z1 /+ intSHLone z2"))
(cases)
(auto)
(assume "p1")
(cases)
(auto)
(assume "p1")
(cases)
(auto)
(save "intShlPlusBij")

(set-goal (pf "all p1,z. z /- Ipos p1 = z /+ Ineg p1 &
                         z /- Ineg p1 = z /+ Ipos p1"))
(assume "p1")
(cases)
(search)
(search)
(search)
(save "intHelper2")

(set-goal (pf "all z. z/-z = IZero"))
(cases)
(use "Truth-Axiom")
(assume "p")
(use "Truth-Axiom")
(assume "p")
(use "Truth-Axiom")
(save "intHelper7")
(add-rewrite-rule (pt "z/-z") (pt "IZero"))



;; LESS AND LESS OR EQUAL

(add-program-constant "intLess" (py "int=>int=>boole") 1 'const 2)

(add-computation-rule (pt "intLess IZero     IZero")     (pt "False"))
(add-computation-rule (pt "intLess IZero     (Ipos p)")  (pt "True"))
(add-computation-rule (pt "intLess IZero     (Ineg p)")  (pt "False"))
(add-computation-rule (pt "intLess (Ipos p)  IZero")     (pt "False"))
(add-computation-rule (pt "intLess (Ineg p)  IZero")     (pt "True"))
(add-computation-rule (pt "intLess (Ineg p1) (Ipos p2)") (pt "True"))
(add-computation-rule (pt "intLess (Ipos p1) (Ineg p2)") (pt "False"))
(add-computation-rule (pt "intLess (Ipos p1) (Ipos p2)") (pt "posLess p1 p2"))
(add-computation-rule (pt "intLess (Ineg p1) (Ineg p2)") (pt "posLess p2 p1"))

(add-program-constant "intLeq"  (py "int=>int=>boole") 1 'const 2)

(add-computation-rule (pt "intLeq IZero IZero")         (pt "True"))
(add-computation-rule (pt "intLeq IZero (Ipos p)")      (pt "True"))
(add-computation-rule (pt "intLeq IZero (Ineg p)")      (pt "False"))
(add-computation-rule (pt "intLeq (Ipos p) IZero")      (pt "False"))
(add-computation-rule (pt "intLeq (Ipos p1) (Ipos p2)") (pt "posLeq p1 p2"))
(add-computation-rule (pt "intLeq (Ipos p1) (Ineg p2)") (pt "False"))
(add-computation-rule (pt "intLeq (Ineg p) IZero")      (pt "True"))
(add-computation-rule (pt "intLeq (Ineg p1) (Ipos p2)") (pt "True"))
(add-computation-rule (pt "intLeq (Ineg p1) (Ineg p2)") (pt "posLeq p2 p1"))


(set-goal (pf "all z. intLess z z -> F & intLeq z z"))
(cases)
(assume 1)
(use-with "Efq" 1)
(assume "p" 1)
(use-with "Efq" 1)
(assume "p" 1)
(use-with "Efq" 1)
(save "intLessNeverSelf")
(add-rewrite-rule (pt "intLess z z") (pt "False"))
(add-rewrite-rule (pt "intLeq z z") (pt "True"))


;; ABSOLUT VALUE

(add-program-constant "intAbs" (py "int=>int") 1 'const 1)

(add-computation-rule (pt "intAbs IZero") (pt "IZero"))
(add-computation-rule (pt "intAbs (Ipos p)") (pt "Ipos p"))
(add-computation-rule (pt "intAbs (Ineg p)") (pt "Ipos p"))

;; MULTIPLICATION

(add-program-constant "intTimes" (py "int=>int=>int") 1 'const 2)

(add-token
 "/*"
 'mul-op
 (lambda (x y)
   (mk-term-in-app-form
    (make-term-in-const-form (pconst-name-to-pconst "intTimes"))
    x y)))

(add-display
 (py "int")
 (lambda (x)
   (let ((op (term-in-app-form-to-final-op x))
	 (args (term-in-app-form-to-args x)))
     (if (and (term-in-const-form? op)
	      (string=? "intTimes"
			(const-to-name (term-in-const-form-to-const op)))
	      (= 2 (length args)))
	 (list 'mul-op "/*"
	       (term-to-token-tree (car args))
	       (term-to-token-tree (cadr args)))
	 #f))))

(add-computation-rule (pt "z /* IZero") (pt "IZero"))
(add-computation-rule (pt "IZero /* (Ipos p)") (pt "IZero"))
(add-computation-rule (pt "IZero /* (Ineg p)") (pt "IZero"))
(add-computation-rule (pt "(Ipos p1) /* (Ipos p2)") (pt "Ipos (posTimes p1 p2)"))
(add-computation-rule (pt "(Ipos p1) /* (Ineg p2)") (pt "Ineg (posTimes p1 p2)"))
(add-computation-rule (pt "(Ineg p1) /* (Ipos p2)") (pt "Ineg (posTimes p1 p2)"))
(add-computation-rule (pt "(Ineg p1) /* (Ineg p2)") (pt "Ipos (posTimes p1 p2)"))



(set-goal (pf "all p1,p2. posLess p1 p2 -> Ipos p2 /- Ipos p1 = Ipos (p2%-p1)"))
(ind)
(ng)
(cases)
(assume 1)
(use 1)
(assume "p2" 1)
(use "Truth-Axiom")
(assume "p2" 1)
(use "Truth-Axiom")
(assume "p1" 1)
(cases)
(assume 2)
(use 2)
(assume "p2" 2)
(ng)
(simp (pf "Ipos(SZero(p2%-p1))=intSHLone(Ipos(p2%-p1))"))
(simp "intSHLequality")
(use 1)
(use 2)
(use "Truth-Axiom")
(assume "p2" 2)
(cases (pt "p1=p2"))
(assume 3)
(simp 3)
(use "Truth-Axiom")
(assume 3)
(simp "posSOneSZeroDiff")
(ng)
(simp (pf "Ipos(SOne(p2%-p1))=Ipos(SZero(p2%-p1))/+(Ipos One)"))
(use "intIdSucc")
(simp (pf "Ipos(SZero(p2%-p1))=intSHLone(Ipos(p2%-p1))"))
(simp "intSHLequality")
(use 1)
(use "posLeqNotEqual")
(use 2)
(use 3)
(use "Truth-Axiom")
(use "Truth-Axiom")
(use "posLeqNotEqual")
(use 2)
(use 3)
(assume "p1" 1)
(cases)
(assume 2)
(use 2)
(assume "p2" 2)
(ng)
(simp 1)
(use "Truth-Axiom")
(use 2)
(assume "p2" 2)
(ng)
(simp 1)
(use "Truth-Axiom")
(use 2)
(save "intDiffPos")

(set-goal (pf "all p1,p2. posLess p1 p2 -> Ipos p1 /- Ipos p2 = Ineg (p2%-p1)"))
(ind)
(cases)
(assume 1)
(use 1)
(assume "p2" 1)
(use "Truth-Axiom")
(assume "p2" 1)
(use "Truth-Axiom")
(assume "p1" 1)
(cases)
(assume 2)
(use 2)
(assume "p2" 2)
(ng)
(use (pf "intSHLone(Ipos p1/+Ineg p2)=intSHLone(Ineg(p2%-p1))"))
(simp "intSHLequality")
(use 1)
(use 2)
(assume "p2" 2)
(cases (pt "p1=p2"))
(assume 3)
(simp 3)
(use "Truth-Axiom")
(assume 3)
(assert (pf "posLess p1 p2"))
(use "posLeqNotEqual")
(use 2)
(use 3)
(assume 3)
(simp "posSOneSZeroDiff")
(ng)
(simp "posHelper18")
(simp (pf "Ineg(SZero(p2%-p1)%+One)=Ineg(SZero(p2%-p1))/+Ineg One"))
(use "intIdSucc")
(use (pf "intSHLone(Ipos p1/+Ineg p2)=intSHLone(Ineg(p2%-p1))"))
(simp "intSHLequality")
(use 1)
(use 4)
(use "Truth-Axiom")
(use 4)
(assume "p1" 1)
(cases)
(assume 2)
(use 2)
(assume "p2" 2)
(ng)
(simp (pf "Ineg(SZero(p2%-p1)%-One) = Ineg(SZero(p2%-p1)) /+ Ipos One"))
(use "intIdSucc")
(use (pf "intSHLone(Ipos p1/+Ineg p2)=intSHLone(Ineg(p2%-p1))"))
(simp "intSHLequality")
(use 1)
(use 2)
(use "Truth-Axiom")
(assume "p2" 2)
(ng)
(use (pf "intSHLone(Ipos p1/+Ineg p2)=intSHLone(Ineg(p2%-p1))"))
(simp "intSHLequality")
(use 1)
(use 2)
(save "intDiffNeg")


;; PROOF OF THE FORMULA all z1,z2,z3. z1/+z2/-z3=z1/-z3/+z2

;; Part 1: z1 = 0

(set-goal (pf "all z2,z3. IZero/+z2/-z3 = IZero/-z3/+z2"))
(cases)
(assume "z3")
(use "Truth-Axiom")
(assume "p2")
(cases)
(use "Truth-Axiom")
(assume "p3")
(use "intPlusComm")
(assume "p3")
(use "posPlusComm")
(assume "p2")
(cases)
(use "Truth-Axiom")
(assume "p3")
(use "posPlusComm")
(assume "p3")
(use "intPlusComm")
(save "intPlusMinusExchangePre1")

;; Part 2: z1 > 0


(set-goal (pf "all p1,z2,z3. (Ipos p1)/+z2/-z3 = (Ipos p1)/-z3/+z2"))
(assume "p1")
(cases)
(assume "z3")
(use "Truth-Axiom")
(assume "p2")
(cases)
(use "Truth-Axiom")
(assume "p3")
(ng)
(cases (pt "posLess p3 p1"))
(assume 1)
(simp "intDiffPos")
(simp "intDiffPos")
(ng)
(use "posPlusMinusExchange")
(use 1)
(use 1)
(use "posLessTrans" (pt "p1"))
(use 1)
(use "Truth-Axiom")
(assume 1)
(assert (pf "posLeq p1 p3"))
(use "posNotLeImpRevLe")
(use 1)
(assume 2)
(cases (pt "p3=p1"))
(assume 3)
(simp 3)
(ng)
(simp "intDiffPos")
(simp "posPlusComm")
(simp "posPlusMinus")
(use "Truth-Axiom")
(use "Truth-Axiom")
(assume 3)
(assert (pf "posLess p1 p3"))
(use "posLeqNotEqual")
(use 2)
(assume 4)
(use 3)
(simp 4)
(use "Truth-Axiom")
(assume 4)
(simp-with "intDiffNeg" (pt "p1") (pt "p3") 4)
(cases (pt "posLess p3 (p1%+p2)"))
(assume 5)
(simp "intDiffPos")
(assert (pf "posLess (p3%-p1) p2"))
(simp "<-" "posIdLessLeqPred" (pt "p1"))
(simp "posMinusPlus")
(simp "posPlusComm")
(use 5)
(use 4)
(assume 6)
(simp "intPlusComm")
(simp "intDiffPos")
(use "posDoubleMinus")
(use 4)
(use 6)
(use 6)
(use 5)
(assume 5)
(cases (pt "p1%+p2=p3"))
(assume 6)
(simp 6)
(ng)
(simp "<-" 6)
(simp "posPlusComm")
(simp "posPlusMinus")
(use "Truth-Axiom")
(assume 6)
(assert (pf "posLess (p1%+p2)p3"))
(use "posLeqNotEqual")
(use "posNotLeImpRevLe")
(use 5)
(use 6)
(assume 7)
(simp "intDiffNeg")
(assert (pf "posLess p2 (p3%-p1)"))
(simp "<-" "posIdLessLeqPred" (pt "p1"))
(simp "posMinusPlus")
(simp "posPlusComm")
(use 7)
(use 4)
(assume 8)
(simp "intPlusComm")
(simp "intDiffNeg")
(use "posTwoMinus")
(use 7)
(use 8)
(use 7)
(assume "p3")
(ng)
(simp "posPlusComm")
(simp "posPlusAssoc")
(use "posIdSucc")
(use "posPlusComm")
(assume "p2")
(cases)
(use "Truth-Axiom")
(assume "p3")
(cases (pt "posLess p2 p1"))
(assume 1)
(ng)
(simp "intDiffPos")
(cases (pt "posLess p3(p1%-p2)"))
(assume 2)
(simp "intDiffPos")
(simp "intDiffPos")
(simp "intDiffPos")
(assert (pf "posLess (p2%+p3)p1"))
(simp (pf "p1=p1%-p2%+p2"))
(simp "posPlusComm")
(simp "posIdLessLeqPred")
(use 2)
(simp "posMinusPlus")
(use "Truth-Axiom")
(use 1)
(assume 3)
(simp "<-" "posTwoMinus")
(simp "posPlusComm")
(use "posTwoMinus")
(simp "posPlusComm")
(use 3)
(use 3)
(simp "<-" "posIdLessLeqPred" (pt "p3"))
(simp "posMinusPlus")
(simp-with "<-" "posMinusPlus" (pt "p2") (pt "p1") 1)
(simp "posPlusComm")
(simp "posIdLessLeqPred")
(use 2)
(use "posLessTrans" (pt "p1%-p2"))
(use 2)
(simp "<-" "posIdLessLeqPred" (pt "p2"))
(simp "posMinusPlus")
(use "Truth-Axiom")
(use 1)
(use "posLessTrans" (pt "p1%-p2"))
(use 2)
(simp "<-" "posIdLessLeqPred" (pt "p2"))
(simp "posMinusPlus")
(use "Truth-Axiom")
(use 1)
(use 2)
(assume 2)
(assert (pf "posLeq (p1%-p2)p3"))
(use "posNotLeImpRevLe")
(use 2)
(assume 3)
(cases (pt "p1%-p2=p3"))
(assume 4)
(simp "<-" 4)
(ng)
(simp "intDiffPos")
(ng)
(simp "<-" "posDoubleMinus")
(simp "posPlusMinus")
(use "Truth-Axiom")
(simp "<-" "posIdLessLeqPred" (pt "p2"))
(simp "posMinusPlus")
(use "Truth-Axiom")
(use 1)
(use 1)
(simp "<-" "posIdLessLeqPred" (pt "p2"))
(simp "posMinusPlus")
(use "Truth-Axiom")
(use 1)
(assume 4)
(assert (pf "posLess (p1%-p2) p3"))
(use "posLeqNotEqual")
(use 3)
(use 4)
(assume 5)
(simp "intDiffNeg")
(cases (pt "posLess p3 p1"))
(assume 6)
(simp "intDiffPos")
(assert (pf "posLess (p1%-p3)p2"))
(simp "<-" "posIdLessLeqPred" (pt "p3"))
(simp "posMinusPlus")
(simp "posPlusComm")
(simp (pf "p1=p1%-p2%+p2"))
(simp "posIdLessLeqPred")
(use 5)
(simp "posMinusPlus")
(use "Truth-Axiom")
(use 1)
(use 6)
(assume 7)
(simp "intDiffNeg")
(ng)
(simp "<-" "posDoubleMinus")
(simp "<-" "posDoubleMinus")
(simp "posPlusComm")
(use "Truth-Axiom")
(use 7)
(use 6)
(use 5)
(use 1)
(use 7)
(use 6)
(assume 6)
(assert (pf "posLeq p1 p3"))
(use "posNotLeImpRevLe")
(use 6)
(assume 7)
(cases (pt "p3=p1"))
(assume 8)
(simp 8)
(simp "<-" "posDoubleMinus")
(simp "posPlusMinus")
(use "Truth-Axiom")
(simp "<-" "posIdLessLeqPred" (pt "p2"))
(simp "posMinusPlus")
(use "Truth-Axiom")
(use 1)
(use 1)
(assume 8)
(assert (pf "posLess p1 p3"))
(use "posLeqNotEqual")
(use 7)
(assume 9)
(use 8)
(simp 9)
(use "Truth-Axiom")
(assume 9)
(simp "intDiffNeg")
(ng)
(simp "<-" "posDoubleMinus")
(simp "posPlusComm")
(use "posPlusMinusExchange")
(use 9)
(use 5)
(use 1)
(use 9)
(use 5)
(use 1)
(assume 1)
(cases (pt "p1=p2"))
(assume 2)
(simp 2)
(cases (pt "posLess p3 p2"))
(assume 3)
(simp "intDiffPos")
(assert (pf "posLess (p2%-p3)p2"))
(simp "<-" "posIdLessLeqPred" (pt "p3"))
(simp "posMinusPlus")
(use "Truth-Axiom")
(use 3)
(assume 4)
(simp "intDiffNeg")
(ng)
(simp "<-" "posDoubleMinus")
(simp "posPlusMinus")
(use "Truth-Axiom")
(use 4)
(use 3)
(use 4)
(use 3)
(assume 3)
(cases (pt "p2=p3"))
(assume 4)
(simp 4)
(use "Truth-Axiom")
(assume 4)
(assert (pf "posLess p2 p3"))
(use "posLeqNotEqual")
(use "posNotLeImpRevLe")
(use 3)
(use 4)
(assume 5)
(simp "intDiffNeg")
(ng)
(simp "posMinusPlus")
(use "Truth-Axiom")
(use 5)
(use 5)
(assume 2)
(assert (pf "posLess p1 p2"))
(use "posLeqNotEqual")
(use "posNotLeImpRevLe")
(use 1)
(use 2)
(assume 3)
(ng)
(simp "intDiffNeg")
(ng)
(cases (pt "posLess p3 p1"))
(assume 4)
(simp "intDiffPos")
(simp "intDiffNeg")
(simp "<-" "posDoubleMinus")
(use "posSymm")
(simp "posPlusComm")
(use "posPlusMinusExchange")
(use 3)
(simp "<-" "posIdLessLeqPred" (pt "p3"))
(simp "posMinusPlus")
(use "posLessTrans" (pt "p2"))
(use 3)
(use "Truth-Axiom")
(use 4)
(use 4)
(simp "<-" "posIdLessLeqPred" (pt "p3"))
(simp "posMinusPlus")
(use "posLessTrans" (pt "p2"))
(use 3)
(use "Truth-Axiom")
(use 4)
(use 4)
(assume 4)
(cases (pt "p3=p1"))
(assume 5)
(simp 5)
(simp "posMinusPlus")
(use "Truth-Axiom")
(use 3)
(assume 5)
(assert (pf "posLess p1 p3"))
(use "posLeqNotEqual")
(use "posNotLeImpRevLe")
(use 4)
(assume 6)
(use 5)
(use "posSymm")
(use 6)
(assume 6)
(simp "intDiffNeg")
(ng)
(simp "<-" "posPlusMinusExchange")
(simp "<-" "posPlusMinusExchange")
(simp "posPlusComm")
(use "Truth-Axiom")
(use 6)
(use 3)
(use 6)
(use 3)
(assume "p3")
(cases (pt "posLess p2 p1"))
(assume 1)
(simp "intDiffPos")
(ng)
(simp "intDiffPos")
(simp "<-" "posPlusMinusExchange")
(use "Truth-Axiom")
(use 1)
(use "posLessTrans" (pt "p1"))
(use 1)
(use "Truth-Axiom")
(use 1)
(assume 1)
(cases (pt "p1=p2"))
(assume 2)
(simp 2)
(ng)
(simp "intDiffPos")
(simp "posPlusComm")
(simp "posPlusMinus")
(use "Truth-Axiom")
(use "Truth-Axiom")
(assume 2)
(assert (pf "posLess p1 p2"))
(use "posLeqNotEqual")
(use "posNotLeImpRevLe")
(use 1)
(use 2)
(assume 3)
(simp "intDiffNeg")
(ng)
(simp "intPlusComm")
(cases (pt "posLess (p2%-p1) p3"))
(assume 4)
(simp "intDiffPos")
(simp "intDiffPos")
(simp "<-" "posDoubleMinus")
(use "Truth-Axiom")
(use 4)
(use 3)
(simp "posPlusComm")
(simp-with "<-" "posMinusPlus" (pt "p1") (pt "p2") 3)
(simp "posIdLessLeqPred")
(use 4)
(use 4)
(assume 4)
(cases (pt "p2%-p1=p3"))
(assume 5)
(simp 5)
(ng)
(simp "<-" 5)
(simp "posPlusComm")
(simp "posMinusPlus")
(use "Truth-Axiom")
(use 3)
(assume 5)
(assert (pf "posLess p3 (p2%-p1)"))
(use "posLeqNotEqual")
(use "posNotLeImpRevLe")
(use 4)
(assume 6)
(use 5)
(simp 6)
(use "Truth-Axiom")
(assume 6)
(simp "intDiffNeg")
(simp "intDiffNeg")
(simp "posTwoMinus")
(use "Truth-Axiom")
(simp "posPlusComm")
(simp-with "<-" "posMinusPlus" (pt "p1") (pt "p2") 3)
(simp "posIdLessLeqPred")
(use 6)
(simp "posPlusComm")
(simp-with "<-" "posMinusPlus" (pt "p1") (pt "p2") 3)
(simp "posIdLessLeqPred")
(use 6)
(use 6)
(use 3)
(save "intPlusMinusExchangePre2")

;; Part 3: z1 < 0

(set-goal (pf "all p1,z2,z3. (Ineg p1)/+z2/-z3 = (Ineg p1)/-z3/+z2"))
(assume "p1")
(cases)
(assume "z3")
(use "Truth-Axiom")
(assume "p2")
(cases)
(use "Truth-Axiom")
(assume "p3")
(simp "intPlusComm")
(cases (pt "posLess p1 p2"))
(assume 1)
(simp "intDiffPos")
(ng)
(cases (pt "posLess p3 (p2%-p1)"))
(assume 2)
(simp "intDiffPos")
(simp "intPlusComm")
(simp "intDiffPos")
(use "posSymm")
(use "posTwoMinus")
(simp "posPlusComm")
(simp-with "<-" "posMinusPlus" (pt "p1") (pt "p2") 1)
(simp "posIdLessLeqPred")
(use 2)
(simp "posPlusComm")
(simp-with "<-" "posMinusPlus" (pt "p1") (pt "p2") 1)
(simp "posIdLessLeqPred")
(use 2)
(use 2)
(assume 2)
(cases (pt "p3=(p2%-p1)"))
(assume 3)
(simp "<-" 3)
(ng)
(simp 3)
(simp "posPlusComm")
(simp "posMinusPlus")
(use "Truth-Axiom")
(use 1)
(assume 3)
(assert (pf "posLess (p2%-p1) p3"))
(use "posLeqNotEqual")
(use "posNotLeImpRevLe")
(use 2)
(assume 4)
(use 3)
(simp 4)
(use "Truth-Axiom")
(assume 4)
(simp "intDiffNeg")
(simp "intPlusComm")
(simp "intDiffNeg")
(simp "posDoubleMinus")
(use "Truth-Axiom")
(use 4)
(use 1)
(simp "posPlusComm")
(simp-with "<-" "posMinusPlus" (pt "p1") (pt "p2") 1)
(simp "posIdLessLeqPred")
(use 4)
(use 4)
(use 1)
(assume 1)
(cases (pt "p1=p2"))
(assume 2)
(simp 2)
(ng)
(simp "intPlusComm")
(simp "intDiffNeg")
(simp "posPlusComm")
(simp "posPlusMinus")
(use "Truth-Axiom")
(use "Truth-Axiom")
(assume 2)
(assert (pf "posLess p2 p1"))
(use "posLeqNotEqual")
(use "posNotLeImpRevLe")
(use 1)
(assume 3)
(use 2)
(simp 3)
(use "Truth-Axiom")
(assume 3)
(simp "intDiffNeg")
(ng)
(simp "intPlusComm")
(simp "intDiffNeg")
(simp "posPlusMinusExchange")
(use "Truth-Axiom")
(use 3)
(use "posLessTrans" (pt "p1"))
(use 3)
(use "Truth-Axiom")
(use 3)
(assume "p3")
(simp "intPlusComm")
(cases (pt "posLess p1 p2"))
(assume 1)
(simp "intDiffPos")
(ng)
(simp-with "intPlusComm" (pt "Ineg p1") (pt "Ipos p3"))
(cases (pt "posLess p1 p3"))
(assume 2)
(simp "intDiffPos")
(ng)
(simp "<-" "posPlusMinusExchange")
(simp "<-" "posPlusMinusExchange")
(simp "posPlusComm")
(use "Truth-Axiom")
(use 2)
(use 1)
(use 2)
(assume 2)
(cases (pt "p3=p1"))
(assume 3)
(simp 3)
(simp "posMinusPlus")
(use "Truth-Axiom")
(use 1)
(assume 3)
(assert (pf "posLess p3 p1"))
(use "posLeqNotEqual")
(use "posNotLeImpRevLe")
(use 2)
(use 3)
(assume 4)
(simp "intDiffNeg")
(simp "intPlusComm")
(simp "intDiffPos")
(simp "<-" "posDoubleMinus")
(simp "<-" "posPlusMinusExchange")
(simp "posPlusComm")
(use "Truth-Axiom")
(use 1)
(use "posLessTrans" (pt "p1"))
(simp "<-" "posIdLessLeqPred" (pt "p3"))
(simp "posMinusPlus")
(use "Truth-Axiom")
(use 4)
(use 1)
(use 4)
(simp "<-" "posIdLessLeqPred" (pt "p3"))
(simp "posMinusPlus")
(use "posLessTrans" (pt "p2"))
(use 1)
(use "Truth-Axiom")
(use 4)
(use 4)
(use 1)
(assume 1)
(cases (pt "p2=p1"))
(assume 2)
(simp 2)
(ng)
(simp-with "intPlusComm" (pt "Ineg p1") (pt "Ipos p3"))
(cases (pt "posLess p1 p3"))
(assume 3)
(simp "intDiffPos")
(ng)
(simp "posMinusPlus")
(use "Truth-Axiom")
(use 3)
(use 3)
(assume 3)
(cases (pt "p3=p1"))
(assume 4)
(simp 4)
(use "Truth-Axiom")
(assume 4)
(assert (pf "posLess p3 p1"))
(use "posLeqNotEqual")
(use "posNotLeImpRevLe")
(use 3)
(use 4)
(assume 5)
(simp "intDiffNeg")
(simp "intPlusComm")
(simp "intDiffPos")
(simp "<-" "posDoubleMinus")
(simp "posPlusMinus")
(use "Truth-Axiom")
(simp "<-" "posIdLessLeqPred" (pt "p3"))
(simp "posMinusPlus")
(use "Truth-Axiom")
(use 5)
(use 5)
(simp "<-" "posIdLessLeqPred" (pt "p3"))
(simp "posMinusPlus")
(use "Truth-Axiom")
(use 5)
(use 5)
(assume 2)
(assert (pf "posLess p2 p1"))
(use "posLeqNotEqual")
(use "posNotLeImpRevLe")
(use 1)
(use 2)
(assume 3)
(simp "intDiffNeg")
(cases (pt "posLess p3 (p1%-p2)"))
(assume 4)
(ng)
(simp "intPlusComm")
(simp "intDiffNeg")
(simp-with "intPlusComm" (pt "Ineg p1") (pt "Ipos p3"))
(simp "intDiffNeg")
(simp "intPlusComm")
(simp "intDiffNeg")
(simp "<-" "posTwoMinus")
(simp "<-" "posTwoMinus")
(simp "posPlusComm")
(use "Truth-Axiom")
(simp (pf "p1=p1%-p2%+p2"))
(simp "posIdLessLeqPred")
(use 4)
(simp "posMinusPlus")
(use "Truth-Axiom")
(use 3)
(simp "<-" (pf "p1%-p2%+p2=p1"))
(simp "posPlusComm")
(simp "posIdLessLeqPred")
(use 4)
(use "posMinusPlus")
(use 3)
(simp "<-" "posIdLessLeqPred" (pt "p3"))
(simp "posPlusComm")
(simp "posMinusPlus")
(simp "<-" (pf "p1%-p2%+p2=p1"))
(simp "posIdLessLeqPred")
(use 4)
(use "posMinusPlus")
(use 3)
(use "posLessTrans" (pt "p1%-p2"))
(use 4)
(simp "<-" "posIdLessLeqPred" (pt "p2"))
(simp "posMinusPlus")
(use "Truth-Axiom")
(use 3)
(use "posLessTrans" (pt "p1%-p2"))
(use 4)
(simp "<-" "posIdLessLeqPred" (pt "p2"))
(simp "posMinusPlus")
(use "Truth-Axiom")
(use 3)
(use 4)
(assume 4)
(cases (pt "p3=(p1%-p2)"))
(assume 5)
(simp "<-" 5)
(ng)
(simp-with "intPlusComm" (pt "Ineg p1") (pt "Ipos p3"))
(simp 5)
(simp "intDiffNeg")
(simp "<-" "posDoubleMinus")
(simp "posPlusMinus")
(use "Truth-Axiom")
(simp "<-" "posIdLessLeqPred" (pt "p2"))
(simp "posMinusPlus")
(use "Truth-Axiom")
(use 3)
(use 3)
(simp "<-" "posIdLessLeqPred" (pt "p2"))
(simp "posMinusPlus")
(use "Truth-Axiom")
(use 3)
(assume 5)
(assert (pf "posLess (p1%-p2)p3"))
(use "posLeqNotEqual")
(use "posNotLeImpRevLe")
(use 4)
(assume 6)
(use 5)
(simp 6)
(use "Truth-Axiom")
(assume 6)
(ng)
(simp "intPlusComm")
(simp "intDiffPos")
(simp-with "intPlusComm" (pt "Ineg p1") (pt "Ipos p3"))
(cases (pt "posLess p1 p3"))
(assume 7)
(simp "intDiffPos")
(ng)
(simp "<-" "posDoubleMinus")
(simp "posPlusComm")
(use "posPlusMinusExchange")
(use 7)
(use 6)
(use 3)
(use 7)
(assume 7)
(cases (pt "p3=p1"))
(assume 8)
(simp 8)
(simp "<-" "posDoubleMinus")
(simp "posPlusMinus")
(use "Truth-Axiom")
(simp "<-" "posIdLessLeqPred" (pt "p2"))
(simp "posMinusPlus")
(use "Truth-Axiom")
(use 3)
(use 3)
(assume 8)
(assert (pf "posLess p3 p1"))
(use "posLeqNotEqual")
(use "posNotLeImpRevLe")
(use 7)
(use 8)
(assume 9)
(simp "intDiffNeg")
(simp "intPlusComm")
(assert (pf "posLess (p1%-p3) p2"))
(simp "<-" "posIdLessLeqPred" (pt "p3"))
(simp "posMinusPlus")
(simp "posPlusComm")
(simp "<-" (pf "p1%-p2%+p2=p1"))
(simp "posIdLessLeqPred")
(use 6)
(use "posMinusPlus")
(use 3)
(use 9)
(assume 10)
(simp "intDiffPos")
(simp "<-" "posDoubleMinus")
(simp "<-" "posDoubleMinus")
(simp "posPlusComm")
(use "Truth-Axiom")
(use 10)
(use 9)
(use 6)
(use 3)
(use 10)
(use 9)
(use 6)
(use 3)
(assume "p2")
(cases)
(use "Truth-Axiom")
(assume "p3")
(ng)
(simp "<-" "posPlusAssoc")
(simp-with "posPlusComm" (pt "p2") (pt "p3"))
(use "posPlusAssoc")
(assume "p3")
(ng)
(cases (pt "posLess p3 p1"))
(assume 1)
(simp "intPlusComm")
(simp "intDiffNeg")
(simp-with "intPlusComm" (pt "Ineg p1") (pt "Ipos p3"))
(simp "intDiffNeg")
(ng)
(use "posPlusMinusExchange")
(use 1)
(use 1)
(use "posLessTrans" (pt "p1"))
(use 1)
(use "Truth-Axiom")
(assume 1)
(cases (pt "p3=p1"))
(assume 2)
(simp 2)
(ng)
(simp "intPlusComm")
(simp "intDiffNeg")
(simp "posPlusComm")
(simp "posPlusMinus")
(use "Truth-Axiom")
(use "Truth-Axiom")
(assume 2)
(assert (pf "posLess p1 p3"))
(use "posLeqNotEqual")
(use "posNotLeImpRevLe")
(use 1)
(assume 3)
(use 2)
(simp 3)
(use "Truth-Axiom")
(assume 3)
(simp-with "intPlusComm" (pt "Ineg p1") (pt "Ipos p3"))
(simp "intDiffPos")
(simp "intPlusComm")
(cases (pt "posLess (p1%+p2) p3"))
(assume 4)
(simp "intDiffPos")
(assert (pf "posLess p2 (p3%-p1)"))
(simp "<-" "posIdLessLeqPred" (pt "p1"))
(simp "posMinusPlus")
(simp "posPlusComm")
(use 4)
(use 3)
(assume 5)
(simp "intDiffPos")
(simp "posTwoMinus")
(use "Truth-Axiom")
(use 4)
(use 5)
(use 4)
(assume 4)
(cases (pt "(p1%+p2)=p3"))
(assume 5)
(simp 5)
(ng)
(simp "<-" 5)
(simp "posPlusComm")
(simp "posPlusMinus")
(use "Truth-Axiom")
(assume 5)
(assert (pf "posLess p3 (p1%+p2)"))
(use "posLeqNotEqual")
(use "posNotLeImpRevLe")
(use 4)
(assume 6)
(use 5)
(simp 6)
(use "Truth-Axiom")
(assume 6)
(simp "intDiffNeg")
(assert (pf "posLess (p3%-p1) p2"))
(simp "<-" "posIdLessLeqPred" (pt "p1"))
(simp "posMinusPlus")
(simp "posPlusComm")
(use 6)
(use 3)
(assume 7)
(simp "intDiffNeg")
(simp "posDoubleMinus")
(use "Truth-Axiom")
(use 7)
(use 3)
(use 7)
(use 6)
(use 3)
(save "intPlusMinusExchangePre3")

(set-goal (pf "all z1,z2,z3. z1/+z2/-z3 = z1/-z3/+z2"))
(cases)
(use "intPlusMinusExchangePre1")
(use "intPlusMinusExchangePre2")
(use "intPlusMinusExchangePre3")
(save "intPlusMinusExchange")

(set-goal (pf "all p1,z. z /+ Ineg p1 = z /- Ipos p1 &
                         z /- Ineg p1 = z /+ Ipos p1"))
(assume "p1")
(cases)
(search)
(assume "p")
(search)
(assume "p")
(search)
(save "intNegation")

(set-goal (pf "all z1,z2,z3. z1/+z2/+z3 = z1/+z3/+z2"))
(assume "z1")
(assume "z2")
(cases)
(use "Truth-Axiom")
(assume "p3")
(simp "<-"  "intNegation")
(simp "<-"  "intNegation")
(use "intPlusMinusExchange")
(assume "p3")
(simp "intNegation")
(simp "intNegation")
(use "intPlusMinusExchange")
(save "intPlusPlusExchange")

(set-goal (pf "all z1,z2,z3. z1/+(z2/+z3) = z1/+z2/+z3"))
(assume "z1" "z2" "z3")
(simp "intPlusComm")
(simp "intPlusPlusExchange")
(use "intIdSucc")
(use "intPlusComm")
(save "intPlusAssoc")

(set-goal (pf "all z1,z2. z1/+z2/-z2 = z1"))
(assume "z1")
(cases)
(use "Truth-Axiom")
(assume "p2")
(simp "intHelper2")
(simp "<-" "intPlusAssoc")
(use "Truth-Axiom")
(assume "p2")
(simp "intHelper2")
(simp "<-" "intPlusAssoc")
(use "Truth-Axiom")
(save "intPlusMinus")

(set-goal (pf "all z1,z2. z1/-z2/+z2 = z1"))
(assume "z1")
(cases)
(use "Truth-Axiom")
(assume "p2")
(simp "<-" "intNegation")
(simp "<-" "intNegation")
(use "intPlusMinus")
(assume "p2")
(simp "intNegation")
(simp "intNegation")
(use "intPlusMinus")
(save "intMinusPlus")

(set-goal (pf "all z1,z2. z1/-z2 = (IZero/-z2)/+z1"))
(assume "z1")
(cases)
(use "Truth-Axiom")
(assume "p2")
(ng)
(simp "<-" "intNegation")
(use "intPlusComm")
(assume "p2")
(simp "intNegation")
(ng)
(use "intPlusComm")
(save "intMinusComm")

(set-goal (pf "all z1,z2,z3. (z1=z2/-z3 -> z1/+z3=z2) &
                             (z1/+z3=z2 -> z1=z2/-z3) &
                             (z1=z2/+z3 -> z1/-z3=z2) &
                             (z1/-z3=z2 -> z1=z2/+z3)"))
(assume "z1" "z2" "z3")
(split)
(split)
(split)
(assume 1)
(simp 1)
(use "intMinusPlus")
(assume 1)
(simp "<-" 1)
(simp "intPlusMinus")
(use "Truth-Axiom")
(assume 1)
(simp 1)
(use "intPlusMinus")
(assume 1)
(simp "<-" 1)
(simp "intMinusPlus")
(use "Truth-Axiom")
(save "intMPshifts")

(set-goal (pf "all p. Ipos p = IZero /- Ineg p &
                      Ineg p = IZero /- Ipos p"))
(assume "p")
(search)
(save "intNeg")

(set-goal (pf "all z,z1,z2. z1/+z=z2/+z -> z1=z2"))
(assume "z" "z1" "z2" 1)
(simp-with "<-" "intPlusMinus" (pt "z1") (pt "z"))
(simp-with "<-" "intPlusMinus" (pt "z2") (pt "z"))
(simp "intMinusComm")
(use "intSymm")
(simp "intMinusComm")
(simp "intPlusComm")
(use "intSymm")
(simp "intPlusComm")
(use "intIdSucc")
(use 1)
(save "intIdPred")


(set-goal (pf "all z1,z2. z1 /* z2 = z2 /* z1"))
(cases)
(cases)
(use "Truth-Axiom")
(assume "p2")
(use "Truth-Axiom")
(assume "p2")
(use "Truth-Axiom")
(assume "p1")
(cases)
(use "Truth-Axiom")
(assume "p2")
(use "posTimesComm")
(assume "p2")
(use "posTimesComm")
(assume "p1")
(cases)
(use "Truth-Axiom")
(assume "p2")
(use "posTimesComm")
(assume "p2")
(use "posTimesComm")
(save "intTimesComm")

(set-goal (pf "all z. IZero/*z=IZero"))
(assume "z")
(simp "intTimesComm")
(use "Truth-Axiom")
(save "intHelper12")
(add-rewrite-rule (pt "IZero/*z") (pt "IZero"))

(set-goal (pf "all z1,z2,z3. z1/*(z2/*z3) = z1/*z2/*z3"))
(cases)
(assume "z2" "z3")
(use "Truth-Axiom")
(assume "p1")
(cases)
(assume "z3")
(use "Truth-Axiom")
(assume "p2")
(cases)
(use "Truth-Axiom")
(assume "p3")
(use "posTimesAssoc")
(assume "p3")
(use "posTimesAssoc")
(assume "p2")
(cases)
(use "Truth-Axiom")
(assume "p3")
(use "posTimesAssoc")
(assume "p3")
(use "posTimesAssoc")
(assume "p1")
(cases)
(assume "z3")
(use "Truth-Axiom")
(assume "p2")
(cases)
(use "Truth-Axiom")
(assume "p3")
(use "posTimesAssoc")
(assume "p3")
(use "posTimesAssoc")
(assume "p2")
(cases)
(use "Truth-Axiom")
(assume "p3")
(use "posTimesAssoc")
(assume "p3")
(use "posTimesAssoc")
(save "intTimesAssoc")

(set-goal (pf "all z,z1,z2. (z1/+z2)/*z = z1/*z /+ z2/*z"))
(cases)
(assume "z1" "z2")
(use "Truth-Axiom")
(assume "p")
(cases)
(assume "z2")
(use "Truth-Axiom")
(assume "p1")
(cases)
(use "Truth-Axiom")
(assume "p2")
(use "posRightDistrib")
(assume "p2")
(cases (pt "posLess p2 p1"))
(assume 1)
(ng)
(simp "intDiffPos")
(simp "intDiffPos")
(ng)
(use "posRightDistribMinus")
(use 1)
(use 1)
(use 1)
(assume 1)
(cases (pt "p2=p1"))
(assume 2)
(simp 2)
(use "Truth-Axiom")
(assume 2)
(assert (pf "posLess p1 p2"))
(use "posLeqNotEqual")
(use "posNotLeImpRevLe")
(use 1)
(assume 3)
(use 2)
(simp 3)
(use "Truth-Axiom")
(assume 3)
(simp "intDiffNeg")
(ng)
(simp "intDiffNeg")
(use "posRightDistribMinus")
(use 3)
(use 3)
(use 3)
(assume "p1")
(cases)
(use "Truth-Axiom")
(assume "p2")
(ng)
(cases (pt "posLess p2 p1"))
(assume 1)
(simp "intPlusComm")
(simp "intDiffNeg")
(simp "intPlusComm")
(simp "intDiffNeg")
(ng)
(use "posRightDistribMinus")
(use 1)
(use 1)
(use 1)
(assume 1)
(cases (pt "p1=p2"))
(assume 2)
(simp 2)
(use "Truth-Axiom")
(assume 2)
(assert (pf "posLess p1 p2"))
(use "posLeqNotEqual")
(use "posNotLeImpRevLe")
(use 1)
(use 2)
(assume 3)
(simp "intPlusComm")
(simp "intDiffPos")
(simp "intPlusComm")
(simp "intDiffPos")
(use "posRightDistribMinus")
(use 3)
(use 3)
(use 3)
(assume "p2")
(use "posRightDistrib")
(assume "p")
(cases)
(assume "z2")
(use "Truth-Axiom")
(assume "p1")
(cases)
(use "Truth-Axiom")
(assume "p2")
(use "posRightDistrib")
(assume "p2")
(cases (pt "posLess p2 p1"))
(assume 1)
(simp "intDiffPos")
(ng)
(simp "intPlusComm")
(simp "intDiffNeg")
(use "posRightDistribMinus")
(use 1)
(use 1)
(use 1)
(assume 1)
(cases (pt "p1=p2"))
(assume 2)
(simp 2)
(use "Truth-Axiom")
(assume 2)
(assert (pf "posLess p1 p2"))
(use "posLeqNotEqual")
(use "posNotLeImpRevLe")
(use 1)
(use 2)
(assume 3)
(simp "intDiffNeg")
(ng)
(simp "intPlusComm")
(simp "intDiffPos")
(use "posRightDistribMinus")
(use 3)
(use 3)
(use 3)
(assume "p1")
(cases)
(use "Truth-Axiom")
(assume "p2")
(cases (pt "posLess p2 p1"))
(assume 1)
(simp "intPlusComm")
(simp "intDiffNeg")
(ng)
(simp "intDiffPos")
(use "posRightDistribMinus")
(use 1)
(use 1)
(use 1)
(assume 1)
(cases (pt "p1=p2"))
(assume 2)
(simp 2)
(use "Truth-Axiom")
(assume 2)
(assert (pf "posLess p1 p2"))
(use "posLeqNotEqual")
(use "posNotLeImpRevLe")
(use 1)
(use 2)
(assume 3)
(simp "intPlusComm")
(simp "intDiffPos")
(ng)
(simp "intDiffNeg")
(use "posRightDistribMinus")
(use 3)
(use 3)
(use 3)
(assume "p2")
(use "posRightDistrib")
(save "intRightDistrib")

(set-goal (pf "all z,z1,z2. z/*(z1/+z2) = z/*z1 /+ z/*z2"))
(assume "z" "z1" "z2")
(simp "intTimesComm")
(simp-with "intTimesComm" (pt "z") (pt "z1"))
(simp-with "intTimesComm" (pt "z") (pt "z2"))
(use "intRightDistrib")
(save "intLeftDistrib")

(set-goal (pf "all z. intSHLone z = z /+ z"))
(cases)
(use "Truth-Axiom")
(assume "p")
(ng)
(simp "posConstructors")
(use "Truth-Axiom")
(assume "p")
(ng)
(simp "posConstructors")
(use "Truth-Axiom")
(save "intHelper13")

(set-goal (pf "all z1,z2. intLess z1 z2 -> intLeq z1 z2"))
(cases)
(cases)
(assume 1)
(use "Truth-Axiom")
(assume "p2" 1)
(use "Truth-Axiom")
(assume "p2" 1)
(use 1)
(assume "p1")
(cases)
(assume 1)
(use 1)
(assume "p2" 1)
(use "posLessImpLeq")
(use 1)
(assume "p2" 1)
(use 1)
(assume "p1")
(cases)
(assume 1)
(use "Truth-Axiom")
(assume "p2" 1)
(use "Truth-Axiom")
(assume "p2" 1)
(use "posLessImpLeq")
(use 1)
(save "intLessImpLeq")

(set-goal (pf "all z1,z2. intLess z1 z2 -> ex p. z2 /- z1 = Ipos p"))
(cases)
(cases)
(assume 1)
(use-with "Efq" 1)
(assume "p" 1)
(ex-intro (pt "p"))
(use "Truth-Axiom")
(assume "p" 1)
(use-with "Efq" 1)
(assume "p1")
(cases)
(assume 1)
(use-with "Efq" 1)
(assume "p2" 1)
(ex-intro (pt "p2%-p1"))
(use "intDiffPos")
(use 1)
(assume "p2" 1)
(use "Efq")
(use 1)
(assume "p1")
(cases)
(assume 1)
(ex-intro (pt "p1"))
(use "Truth-Axiom")
(assume "p2" 1)
(ex-intro (pt "p2%+p1"))
(use "Truth-Axiom")
(assume "p2" 1)
(ex-intro (pt "p1%-p2"))
(ng)
(simp "intPlusComm")
(use "intDiffPos")
(use 1)
(save "intExPosDiff")
;(pp(nt (proof-to-extracted-term (current-proof))))

(set-goal (pf "all z1,z2. intLeq z1 z2 -> (z1=z2 -> F) -> intLess z1 z2"))
(cases)
(cases)
(assume 1 2)
(use-with 2 "Truth-Axiom")
(assume "p2" 1 2)
(use "Truth-Axiom")
(assume "p2" 1 2)
(use-with "Efq" 1)
(assume "p1")
(cases)
(assume 1 2)
(use 1)
(assume "p2" 1 2)
(use "posLeqNotEqual")
(use 1)
(use 2)
(assume "p2" 1 2)
(use 1)
(assume "p1")
(cases)
(assume 1 2)
(use "Truth-Axiom")
(assume "p2" 1 2)
(use "Truth-Axiom")
(assume "p2" 1 2)
(use "posLeqNotEqual")
(use 1)
(assume 3)
(use 2)
(simp 3)
(use "Truth-Axiom")
(save "intLeqNotEqual")

(set-goal (pf "all z1,z2,z3. ((intLess z1 z2) -> (intLess z2 z3) -> (intLess z1 z3)) &
                             ((intLeq  z1 z2) -> (intLeq  z2 z3) -> (intLeq  z1 z3)) &
                             ((intLeq  z1 z2) -> (intLess z2 z3) -> (intLess z1 z3)) &
                             ((intLess z1 z2) -> (intLeq  z2 z3) -> (intLess z1 z3))"))
(cases)
(cases)
(cases)
(auto)
(assume "p2")
(cases)
(auto)
(assume "p2")
(cases)
(auto)
(assume "p1")
(cases)
(cases)
(search)
;; ?_24
(assume "p3")
(split)
(split)
(split)
(assume 1 2)
(use-with "Efq" 1)
(assume 1 2)
(use-with "Efq" 1)
(assume 1 2)
(use-with "Efq" 1)
(assume 1 2)
(use-with "Efq" 1)
;; ?_24 end
(search)
(assume "p2")
(cases)
(search)
;; ?_39
(assume "p3")
(use "posHelper25")
(search)
(assume "p2")
(cases)
(search)
;; ?_46
(assume "p3")
(split)
(split)
(split)
(assume 1 2)
(use-with "Efq" 1)
(assume 1 2)
(use-with "Efq" 1)
(assume 1 2)
(use-with "Efq" 1)
(assume 1 2)
(use-with "Efq" 1)
(search)
(assume "p1")
(cases)
(cases)
(auto)
(assume "p3")
(split)
(split)
(split)
(assume 1 2)
(use-with "Efq" 2)
(assume 1 2)
(use-with "Efq" 2)
(assume 1 2)
(use-with "Efq" 2)
(assume 1 2)
(use-with "Efq" 2)
(assume "p2")
(cases)
(auto)
(assume "p3")
(split)
(split)
(split)
(assume 1 2)
(use-with "Efq" 2)
(assume 1 2)
(use-with "Efq" 2)
(assume 1 2)
(use-with "Efq" 2)
(assume 1 2)
(use-with "Efq" 2)
(assume "p2")
(cases)
(auto)
(assume "p3")
(split)
(split)
(split)
(assume 1 2)
(use-with "posHelper25" (pt "p3") (pt "p2") (pt "p1") 'left 'left 'left 2 1)
(assume 1 2)
(use-with "posHelper25" (pt "p3") (pt "p2") (pt "p1") 'left 'left 'right 2 1)
(assume 1 2)
(use-with "posHelper25" (pt "p3") (pt "p2") (pt "p1") 'right 2 1)
(assume 1 2)
(use-with "posHelper25" (pt "p3") (pt "p2") (pt "p1") 'left 'right 2 1)
(save "intHelper14")

(set-goal (pf "all z1,z2,z3. (intLeq z1 z2) -> (intLess z2 z3) -> (intLess z1 z3)"))
(assume "z1" "z2" "z3")
(use "intHelper14")
(save "intLeqLessTrans")

(set-goal (pf "all z1,z2,z3. (intLess z1 z2) -> (intLeq z2 z3) -> (intLess z1 z3)"))
(assume "z1" "z2" "z3")
(use "intHelper14")
(save "intLessLeqTrans")

(set-goal (pf "all z1,z2,z3. (intLess z1 z2) -> (intLess z2 z3) -> (intLess z1 z3)"))
(assume "z1" "z2" "z3")
(use "intHelper14")
(save "intLessTrans")

(set-goal (pf "all z1,z2,z3. (intLeq z1 z2) -> (intLeq z2 z3) -> (intLeq z1 z3)"))
(assume "z1" "z2" "z3")
(use "intHelper14")
(save "intLeqTrans")

(set-goal (pf "all z1,p2. (intLess z1 (z1/+(Ipos p2))) & (intLeq z1 (z1/+(Ipos p2)))"))
(cases)
(assume "p2")
(search)
(assume "p1" "p2")
(search)
(assume "p1" "p2")
(cases (pt "p1=p2"))
(assume 1)
(simp 1)
(search)
(assume 1)
(cases (pt "posLess p1 p2"))
(assume 2)
(simp (pf "Ineg p1/+Ipos p2 = Ipos p2/-Ipos p1"))
(simp "intDiffPos")
(search)
(use 2)
(use "intPlusComm")
(assume 2)
(simp (pf "Ineg p1/+Ipos p2 = Ipos p2/-Ipos p1"))
(assert (pf "posLess p2 p1"))
(use "posLeqNotEqual")
(use "posNotLeImpRevLe")
(use 2)
(assume 3)
(use 1)
(simp 3)
(use "Truth-Axiom")
(assume 3)
(simp "intDiffNeg")
(ng)
(simp "<-" "posIdLessLeqPred" (pt "p2"))
(simp "posMinusPlus")
(split)
(use "Truth-Axiom")
(simp "<-" "posIdLessLeqPred" (pt "p2"))
(simp "posMinusPlus")
(use "Truth-Axiom")
(use 3)
(use 3)
(use 3)
(use "intPlusComm")
(save "intPlusLessLeq")



(set-goal (pf "all z1,p2. (intLess z1 (z1/+(Ineg p2)) = F) & (intLeq z1 (z1/+(Ineg p2)) = F)"))
(cases)
(assume "p2")
(search)
(assume "p1" "p2")
(cases (pt "p1=p2"))
(assume 1)
(simp 1)
(search)
(assume 1)
(cases (pt "posLess p1 p2"))
(assume 2)
(simp (pf "Ipos p1/+Ineg p2 = Ipos p1/-Ipos p2"))
(simp "intDiffNeg")
(search)
(use 2)
(use "Truth-Axiom")
(assume 2)
(assert (pf "posLess p2 p1"))
(use "posLeqNotEqual")
(use "posNotLeImpRevLe")
(use 2)
(assume 3)
(use 1)
(simp 3)
(use "Truth-Axiom")
(assume 3)
(simp (pf "(Ipos p1/+Ineg p2) = (Ipos p1/-Ipos p2)"))
(simp "intDiffPos")
(ng)
(simp "<-" "posIdLessLeqPred" (pt "p2"))
(simp "posMinusPlus")
(split)
(use "Truth-Axiom")
(simp "<-" "posIdLessLeqPred" (pt "p2"))
(simp "posMinusPlus")
(use "Truth-Axiom")
(use 3)
(use 3)
(use 3)
(use "Truth-Axiom")
(assume "p1" "p2")
(search)
(save "intMinusLessLeq")


(set-goal (pf "all z1,z2. ((intLeq  z1 z2 -> F) -> intLess z2 z1) &
                          ((intLess z1 z2 -> F) -> intLeq  z2 z1) &
                          (intLess z2 z1 -> (intLeq  z1 z2 -> F)) &
                          (intLeq  z2 z1 -> (intLess  z1 z2 -> F))"))
(cases)
(cases)
(auto)
(assume "p1")
(cases)
(auto)
(assume "p2")
(use "posNotLeImpRevLe")
(assume "p2")
(auto)
(assume "p1")
(cases)
(auto)
(assume "p2")
(use "posNotLeImpRevLe")
(save "intNotLeImpRevLe")

(set-goal (pf "all z1,p2. (intLess (z1/+(Ipos p2)) z1 = False) & (intLeq (z1/+(Ipos p2)) z1 = False)"))
(assume "z1" "p2")
(split)
(simp (pf "intLess(z1/+Ipos p2)z1 -> F"))
(use "Truth-Axiom")
(use "intNotLeImpRevLe")
(use "intPlusLessLeq")
(simp (pf "intLeq(z1/+Ipos p2)z1 -> F"))
(use "Truth-Axiom")
(use "intNotLeImpRevLe")
(use "intPlusLessLeq")
(save "intNotPlusLessLeq")

(set-goal (pf "all z1,p2. (intLess (z1/+(Ineg p2)) z1) & (intLeq (z1/+(Ineg p2)) z1)"))
(assume "z1" "p2")
(split)
(simp (pf "intLess(z1/+Ineg p2)z1"))
(use "Truth-Axiom")
(use "intNotLeImpRevLe")
(simp "intMinusLessLeq")
(search)
(simp (pf "intLeq(z1/+Ineg p2)z1"))
(use "Truth-Axiom")
(use "intNotLeImpRevLe")
(simp "intMinusLessLeq")
(search)
(save "intNotMinusLessLeq")






(set-goal (pf "all p,z1,z2. (intLess (z1/+(Ipos p))(z2/+(Ipos p)) -> intLess z1 z2) &
                            (intLeq  (z1/+(Ipos p))(z2/+(Ipos p)) -> intLeq  z1 z2) &
                            (intLess z1 z2 -> intLess (z1/+(Ipos p))(z2/+(Ipos p))) &
                            (intLeq  z1 z2 -> intLeq  (z1/+(Ipos p))(z2/+(Ipos p)))"))
(assume "p")
(cases)
(cases)
(search)
(search)
(assume "p2")
(use "posTriple" (pt "p2") (pt "p"))
(assume 1)
(simp 1)
(search)
(assume 1)
(ng)
(simp "intPlusComm")
(simp (pf "Ipos p/+Ineg p2 = Ipos p /- Ipos p2"))
(simp "intDiffPos")
(ng)
(split)
(split)
(split)
(use "posNotLeImpRevLe")
(use "posMinusLeq")
(use "posNotLeImpRevLe")
(use "posLeqNotEqual")
(use "posMinusLeq")
(assume 2)
(use (pf "posLeq (p%+p2) p"))
(simp (pf "p%+p2=(p%-p2)%+p2"))
(simp "posMinusPlus")
(use "Truth-Axiom")
(use 1)
(simp 2)
(use "Truth-Axiom")
(assume 2)
(use-with "Efq" 2)
(assume 2)
(use-with "Efq" 2)
(use 1)
(use "Truth-Axiom")
(assume 1)
(ng)
(simp "intPlusComm")
(simp (pf "Ipos p/+Ineg p2 = Ipos p /- Ipos p2"))
(simp "intDiffNeg")
(ng)
(search)
(use 1)
(use "Truth-Axiom")
(assume "p1")
(cases)
(search)
(assume "p2")
(ng)
(simp "posIdLessLeqPred")
(simp "posIdLessLeqPred")
(search)
(assume "p2")
(ng)
(use "posTriple" (pt "p2") (pt "p"))
(assume 1)
(simp 1)
(search)
(assume 1)
(simp "intPlusComm")
(simp (pf "Ipos p/+Ineg p2 = Ipos p /- Ipos p2"))
(simp "intDiffPos")
(ng)
(split)
(split)
(split)
(use "posNotLeImpRevLe")
(simp "posPlusComm")
(use "posLeqTrans" (pt "p"))
(use "posMinusLeq")
(use "Truth-Axiom")
(use "posNotLeImpRevLe")
(simp "posPlusComm")
(use "posLeqLessTrans" (pt "p"))
(use "posMinusLeq")
(use "Truth-Axiom")
(assume 2)
(use-with "Efq" 2)
(assume 2)
(use-with "Efq" 2)
(use 1)
(use "Truth-Axiom")
(assume 1)
(simp "intPlusComm")
(simp (pf "Ipos p/+Ineg p2 = Ipos p /- Ipos p2"))
(simp "intDiffNeg")
(search)
(use 1)
(use "Truth-Axiom")
(assume "p1")
(cases)
(ng)
(use "posTriple" (pt "p1") (pt "p"))
(assume 1)
(simp 1)
(search)
(assume 1)
(simp "intPlusComm")
(simp (pf "Ipos p/+Ineg p1 = Ipos p /- Ipos p1"))
(simp "intDiffPos")
(split)
(split)
(search)
(assume 2)
(ng)
(simp "<-" "posIdLessLeqPred" (pt "p1"))
(simp "posMinusPlus")
(use "Truth-Axiom")
(use 1)
(assume 2)
(use "posMinusLeq")
(use 1)
(use "Truth-Axiom")
(assume 1)
(simp "intPlusComm")
(simp (pf "Ipos p/+Ineg p1 = Ipos p /- Ipos p1"))
(simp "intDiffNeg")
(search)
(use 1)
(use "Truth-Axiom")
(assume "p2")
(ng)
(use "posTriple" (pt "p1") (pt "p"))
(assume 1)
(simp 1)
(search)
(assume 1)
(simp "intPlusComm")
(simp (pf "Ipos p/+Ineg p1 = Ipos p /- Ipos p1"))
(simp "intDiffPos")
(ng)
(split)
(split)
(search)
(assume 2)
(simp "posPlusComm")
(simp "<-" "posIdLessLeqPred" (pt "p1"))
(simp "posMinusPlus")
(simp "<-" "posPlusAssoc")
(use "Truth-Axiom")
(use 1)
(assume 2)
(simp "posPlusComm")
(simp "<-" "posIdLessLeqPred" (pt "p1"))
(simp "posMinusPlus")
(simp "<-" "posPlusAssoc")
(use "Truth-Axiom")
(use 1)
(use 1)
(use "Truth-Axiom")
(assume 1)
(simp "intPlusComm")
(simp (pf "Ipos p/+Ineg p1 = Ipos p /- Ipos p1"))
(simp "intDiffNeg")
(ng)
(search)
(use 1)
(use "Truth-Axiom")
(assume "p2")
(use "posTriple" (pt "p1") (pt "p"))
(assume 1)
(simp 1)
(ng)
(use "posTriple" (pt "p2") (pt "p"))
(assume 2)
(simp 2)
(search)
(assume 2)
(simp "intPlusComm")
(simp (pf "Ipos p/+Ineg p2 = Ipos p /- Ipos p2"))
(simp "intDiffPos")
(split)
(split)
(split)
(assume 3)
(use 2)
(assume 3)
(use "posLessImpLeq")
(use 2)
(assume 3)
(use "Truth-Axiom")
(assume 3)
(use "Truth-Axiom")
(use 2)
(use "Truth-Axiom")
(assume 2)
(simp "intPlusComm")
(simp (pf "Ipos p/+Ineg p2 = Ipos p /- Ipos p2"))
(simp "intDiffNeg")
(ng)
(split)
(split)
(split)
(assume 3)
(use-with "Efq" 3)
(assume 3)
(use-with "Efq" 3)
(assume 3)
(use-with "posHelper27" (pt "p") (pt "p2") 2 3)
(assume 3)
(use-with "posHelper28" (pt "p2") (pt "p") 3 2)
(use 2)
(use "Truth-Axiom")
(assume 1)
(simp "intPlusComm")
(simp (pf "Ipos p/+Ineg p1 = Ipos p /- Ipos p1"))
(simp "intDiffPos")
(ng)
(use "posTriple" (pt "p2") (pt "p"))
(assume 2)
(simp 2)
(ng)
(split)
(split)
(split)
(assume 3)
(use-with "Efq" 3)
(assume 3)
(use-with "Efq" 3)
(assume 3)
(use-with "posHelper27" (pt "p") (pt "p1") 3 1)
(assume 3)
(use-with "posHelper28" (pt "p") (pt "p1") 3 1)
(assume 2)
(simp "intPlusComm")
(simp (pf "Ipos p/+Ineg p2 = Ipos p /- Ipos p2"))
(simp "intDiffPos")
(ng)
;; 238
(simp "<-" "posIdLessLeqPred" (pt "(p1%+p2)"))
(simp "<-" "posIdLessLeqPred" (pt "(p1%+p2)") 'right)
(simp "posPlusAssoc")
(simp "posMinusPlus")
(simp-with "posPlusComm" (pt "p1") (pt "p2"))
(simp "posPlusAssoc")
(simp "posMinusPlus")
(simp "posPlusComm")
(simp-with "posPlusComm" (pt "p") (pt "p1"))
(simp "posIdLessLeqPred")
(simp "posIdLessLeqPred")
(search)
(use 2)
(use 1)
(use 2)
(use "Truth-Axiom")
(assume 2)
(simp "intPlusComm")
(simp (pf "Ipos p/+Ineg p2 = Ipos p /- Ipos p2"))
(simp "intDiffNeg")
(ng)
(split)
(split)
(split)
(assume 3)
(use-with "Efq" 3)
(assume 3)
(use-with "Efq" 3)
(use-with "posHelper27" (pt "p1") (pt "p2") "?")
(use-with "posLessTrans" (pt "p1") (pt "p") (pt "p2") 1 2)
(assume 3)
(use-with "posHelper27" (pt "p") (pt "p2") 2 "?")
(use "posLeqLessTrans" (pt "p1"))
(use 3)
(use 1)
(use 2)
(use "Truth-Axiom")
(use 1)
(use "Truth-Axiom")
(assume 1)
(simp "intPlusComm")
(simp (pf "Ipos p/+Ineg p1 = Ipos p /- Ipos p1"))
(simp "intDiffNeg")
(ng)
(use "posTriple" (pt "p2") (pt "p"))
(assume 2)
(simp 2)
(ng)
(split)
(split)
(split)
(assume 3)
(use 1)
(assume 3)
(use "posLessImpLeq")
(use 1)
(assume 3)
(use "Truth-Axiom")
(assume 3)
(use "Truth-Axiom")
(assume 2)
(simp "intPlusComm")
(simp (pf "Ipos p/+Ineg p2 = Ipos p /- Ipos p2"))
(simp "intDiffPos")
(ng)
(split)
(split)
(split)
(assume 3)
(use "posLessTrans" (pt "p"))
(use 2)
(use 1)
(assume 3)
(use "posLessImpLeq")
(use "posLessTrans" (pt "p"))
(use 2)
(use 1)
(assume 3)
(use "Truth-Axiom")
(assume 3)
(use "Truth-Axiom")
(use 2)
(use "Truth-Axiom")
(assume 2)
(simp "intPlusComm")
(simp (pf "Ipos p/+Ineg p2 = Ipos p /- Ipos p2"))
(simp "intDiffNeg")
(ng)
(simp "<-" "posIdLessLeqPred" (pt "p"))
(simp "<-" "posIdLessLeqPred" (pt "p") 'right)
(simp "posMinusPlus")
(simp "posMinusPlus")
(search)
(use 1)
(use 2)
(use 2)
(use "Truth-Axiom")
(use 1)
(use "Truth-Axiom")
(save "intIdLessLeqPredPre1")


(set-goal (pf "all p,z1,z2. (intLess (z1/+(Ipos p))(z2/+(Ipos p)) = intLess z1 z2) &
                            (intLeq  (z1/+(Ipos p))(z2/+(Ipos p)) = intLeq  z1 z2)"))
(assume "p" "z1" "z2")
(split)
(cases (pt "intLess(z1/+Ipos p)(z2/+Ipos p)"))
(assume 1)
(simp (pf "intLess z1 z2"))
(use "Truth-Axiom")
(use "intIdLessLeqPredPre1" (pt "p"))
(use 1)
(assume 1)
(simp (pf "intLess z1 z2 -> F"))
(use "Truth-Axiom")
(assume 2)
(use 1)
(use "intIdLessLeqPredPre1" 'left 'right)
(use 2)
(cases (pt "intLeq(z1/+Ipos p)(z2/+Ipos p)"))
(assume 1)
(simp (pf "intLeq z1 z2"))
(use "Truth-Axiom")
(use "intIdLessLeqPredPre1" (pt "p"))
(use 1)
(assume 1)
(simp (pf "intLeq z1 z2 -> F"))
(use "Truth-Axiom")
(assume 2)
(use 1)
(use "intIdLessLeqPredPre1" 'right)
(use 2)
(save "intIdLessLeqPredPre2")



(set-goal (pf "all p,z1,z2. (intLess (z1/+(Ineg p))(z2/+(Ineg p)) = intLess z1 z2) &
                            (intLeq  (z1/+(Ineg p))(z2/+(Ineg p)) = intLeq  z1 z2)"))
(assume "p" "z1" "z2")
(simp (pf "intLess z1 z2 = (intLess (z1/+(Ineg p)/+Ipos p)(z2/+(Ineg p)/+Ipos p))"))
(simp (pf "intLeq  z1 z2 = (intLeq  (z1/+(Ineg p)/+Ipos p)(z2/+(Ineg p)/+Ipos p))"))
(simp "intIdLessLeqPredPre2")
(ng)
(simp "intIdLessLeqPredPre2")
(ng)
(search)
(simp "<-" "intHelper2")
(simp "<-" "intHelper2")
(simp "intMinusPlus")
(simp "intMinusPlus")
(use "Truth-Axiom")
(simp "<-" "intHelper2")
(simp "<-" "intHelper2")
(simp "intMinusPlus")
(simp "intMinusPlus")
(use "Truth-Axiom")
(save "intIdLessLeqPredPre3")

(set-goal (pf "all z,z1,z2. (intLess (z1/+z)(z2/+z) = intLess z1 z2) &
                            (intLeq  (z1/+z)(z2/+z) = intLeq  z1 z2)"))
(cases)
(search)
(assume "p")
(use "intIdLessLeqPredPre2")
(use "intIdLessLeqPredPre3")
(save "intIdLessLeqPred")


(set-goal (pf "all z1,z2,z3. z1/-(z2/+z3) = z1/-z2/-z3"))
(assume "z1" "z2" "z3")
(simp "intMinusComm")
(simp-with "intMinusComm" (pt "z1") (pt "z2"))
(simp-with "intMinusComm" (pt "IZero/-z2/+z1") (pt "z3"))
(simp "intPlusAssoc")
(use "intIdSucc")
(use "intSymm")
(simp "<-" "intMinusComm")
(simp "<-" "intIdPred" (pt "z3"))
(use "Truth-Axiom")
(simp "intMinusPlus")
(simp "<-" "intIdPred" (pt "z2"))
(use "Truth-Axiom")
(simp "intMinusPlus")
(simp "<-" "intPlusAssoc")
(simp-with "intPlusComm" (pt "z2") (pt "z3"))
(simp "intMinusPlus")
(use "Truth-Axiom")
(save "intDoubleMinus")


