/*======================================================================*\
|*		Editor mined						*|
|*		keyboard mappings to commands and characters		*|
\*======================================================================*/

#include "mined.h"
#include "io.h"


/*======================================================================*\
|*			Key and function key -> command mapping		*|
\*======================================================================*/

/* The mapping between input codes and functions */

#ifdef unix
#define NULLcmd FUNKEY
#define BSPcmd MLF
#endif
#ifdef msdos
#define NULLcmd FUNKEY	/* since FUNcmd is 0 */
#define BSPcmd DPC
#endif
#ifdef vms
#define NULLcmd FUNKEY
#define BSPcmd MLF
#endif

#define Sch (voidfunc) S

voidfunc key_map [256] =
{	/* characters to functions map */
  /* ^@-^G */	NULLcmd, MPW, DCC, PD, MRT, MUP, MNW, GOTO,
  /* ^H-^O */	/*BSPcmd*/ DPC, Sch, SNL, DLN, HOP, SNL, RS, LIB,
  /* ^P-^W */	PASTEstay, HOP, PU, MLF, DNW, CUT, CTRLINS, SU,
  /* ^X-^_ */	MDN, COPY, SD, ESCAPE, CANCEL, MARK, DPW, (voidfunc) BADch,
  /* 040-057 */	Sch, Sch, Sdoublequote, Sch, Sch, Sch, Sch, Ssinglequote,
		 Sch, Sch, Sch, Sch, Sch, Sdash, Sch, Sch,
  /* 060-077 */	Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch,
  /* 100-117 */	Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch,
  /* 120-137 */	Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch,
  /* 140-157 */	Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch,
  /* 160-177 */	Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, /*DPC*/ DCC,
  /* 200-217 */	Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch,
  /* 220-237 */	Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch,
  /* 240-257 */	Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch,
  /* 260-277 */	Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch,
  /* 300-317 */	Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch,
  /* 320-337 */	Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch,
  /* 340-357 */	Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch,
  /* 360-377 */	Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch,
};

voidfunc ws_key_map [32] =
{	/* characters to functions map */
  /* ^@-^G */	NULLcmd, MPW, JUS, PD, MRT, MUP, MNW, DCC,
  /* ^H-^O */	MLF, Sch, Sch, ctrlK, RS, SNL, LIB, ctrlO,
  /* ^P-^W */	CTRLINS, ctrlQ, PU, MLF, DNW, (voidfunc) BADch, TOGINS, SU,
  /* ^X-^_ */	MDN, DLINE, SD, ESCAPE, CANCEL, (voidfunc) BADch, (voidfunc) BADch, (voidfunc) BADch,
};

voidfunc emacs_key_map [32] =
{	/* characters to functions map */
  /* ^@-^G */	NULLcmd, BLINE, MLF, I, DCC, ELINE, MRT, CANCEL,
  /* ^H-^O */	HELP, Sch, Sch, DLN, RD, SNL, MDN, LIB,
  /* ^P-^W */	MUP, CTRLINS, SRV, SFW, I, (voidfunc) REPT, PD, CUT,
  /* ^X-^_ */	EMAX, PASTE, SUSP, META, toggleKEYMAP, I, HOP, UNDO,
};

/*
function keys deliver NUL and the following codes:
Block1: RGISOQHKPM
Block2: GHIKMOPQRS	Pos1 Up PgUp Left Center Right End Down PdDn Ins
Cntrl:	st <-/->
Cntrl:	wu Pos1/End
	v PgUp / PgDn	<- for MSDOS: first char is  (a-with-")
F1-F10: ;<=>?@ABCD
shift:	TUVWXYZ[\]
cntrl:	^_`abcdefg
alt:	hijklmnopq
*/

void
HELPF ()
{
  status_msg ("       F2 write  F3 edit  F5 \371  F6 \357  F8 search     F9 next       F10 hop");
}

void
HELPS ()
{
  status_msg ("shift- F2 write!          F5 ~  F6 `  F8 search rev F9 next       F10 hop");
}

void
HELPC ()
{
  status_msg ("cntrl- F2 exit   F3 view  F5 \370  F6 ^  F8 search nxt F9 cycle lns  F10 hop");
}

void
HELPA ()
{
  status_msg ("alt-   F2 write buffer                F8 search rev F9 switch lns F10 hop");
}


/* mapping function key codes -> functions */
voidfunc pc_fkey_map [256] =
{
   /* 00-0F */ NULLcmd, I, I, I, I, I, I, I, I, I, I, I, I, I, I, I,
   /* 10 alt-Q */ I,
   /* 11 alt-W */ I,
   /* 12 alt-E */ EDITMENU,
   /* 13 alt-R */ I,
   /* 14 alt-T */ I,
   /* 15 alt-Y */ I,
   /* 16 alt-U */ I,
   /* 17 alt-I */ I,
   /* 18 alt-O */ I,
   /* 19 alt-P */ PARAMENU,
   /* 1A-1D */ I, I, I, I,
   /* 1E alt-A */ I,
   /* 1F alt-S */ SEARCHMENU,
   /* 20 alt-D */ I,
   /* 21 alt-F */ FILEMENU,
   /* 22 alt-G */ I,
   /* 23 alt-H */ HTML,
   /* 24 alt-J */ I,
   /* 25 alt-K */ I,
   /* 26 alt-L */ I,
   /* 27-2B */ I, I, I, I, I,
   /* 2C alt-Z */ I,
   /* 2D alt-X */ EXTRAMENU,
   /* 2E alt-C */ I,
   /* 2F alt-V */ I,
   /* 30 alt-B */ I,
   /* 31 alt-N */ I,
   /* 32 alt-M */ I,
   /* 33-36 */ I, I, I, I,
   /* 37 alt-* */ I,
   /* 38 */ I,
   /* 39 alt-control-blank */ QUICKMENU,
   /* 3A */ I,
   /* 3B F1 */ HELP,	/* HELPF ? */
   /* 3C F2 */ WT,
   /* 3D F3 */ EDIT,
   /* 3E F4 */ I,
   /* 3F F5 */ insert_diaeresis,
   /* 40 F6 */ insert_acute,
   /* 41 F7 */ I, 
   /* 42 F8 */ SFW,
   /* 43 F9 */ RS,
   /* 44 F10 */ GOTO,
   /* 45-46 */ I, I,
   /* 47 pos1 */ MARK,
   /* 48 up */ MUP,
   /* 49 pgup */ PU,
   /* 4A alt-- */ I,
   /* 4B lf */ MLF,
   /* 4C 5 */ HOP,
   /* 4D rt */ MRT,
   /* 4E alt-+ */ I,
   /* 4F end */ COPY,
   /* 50 dn */ MDN,
   /* 51 pgdn */ PD,
   /* 52 ins */ PASTE,
   /* 53 del */ DCC,
   /* 54 shift-F1 */ HELP,	/* HELPS ? */
   /* 55 shift-F2 */ WTU,
   /* 56 shift-F3 */ I,
   /* 57 shift-F4 */ I,
   /* 58 shift-F5 */ insert_tilde,
   /* 59 shift-F6 */ insert_grave,
   /* 5A shift-F7 */ I,
   /* 5B shift-F8 */ SRV,
   /* 5C shift-F9 */ RS,
   /* 5D shift-F10 */ GOTO,
   /* 5E ctrl-F1 */ HELP,	/* HELPC ? */
   /* 5F ctrl-F2 */ EXED,
   /* 60 ctrl-F3 */ VIEW,
   /* 61 ctrl-F4 */ I,
   /* 62 ctrl-F5 */ insert_angstrom,
   /* 63 ctrl-F6 */ insert_circumflex,
   /* 64 ctrl-F7 */ I,
   /* 65 ctrl-F8 */ RS,
   /* 66 ctrl-F9 */ LNCI,
   /* 67 ctrl-F10 */ GOTO,
   /* 68 alt-F1 */ HELP,	/* HELPA ? */
   /* 69 alt-F2 */ WB,
   /* 6A alt-F3 */ I,
   /* 6B alt-F4 */ I,
   /* 6C alt-F5 */ I,
   /* 6D alt-F6 */ I,
   /* 6E alt-F7 */ I,
   /* 6F alt-F8 */ SRV,
   /* 70 alt-F9 */ LNSW,
   /* 71 alt-F10 */ GOTO,
   /* 72 */ I,
   /* 73 ctrl-lf */ MPW,
   /* 74 ctrl-rt */ MNW,
   /* 75 ctrl-end */ CUT,
   /* 76 ctrl-pgdn */ SD,
   /* 77 ctrl-pos1 */ HOP,
   /* 78 alt-1 */ I,
   /* 79 alt-2 */ I,
   /* 7A alt-3 */ I,
   /* 7B alt-4 */ I,
   /* 7C alt-5 */ I,
   /* 7D alt-6 */ I,
   /* 7E alt-7 */ I,
   /* 7F alt-8 */ I,
   /* 80 alt-9 */ I,
   /* 81 alt-0 */ I,
   /* 82-83 */ I, I,
   /* 84 ctrl-pgup */ SU,
   /* 85 F11 */ LOWCAP,
   /* 86 F12 */ I,
   /* 87 shift-F11 */ I,
   /* 88 shift-F12 */ I,
   /* 89 ctrl-F11 */ I,
   /* 8A ctrl-F12 */ I,
   /* 8B alt-F11 */ I,
   /* 8C alt-F12 */ I,
   /* 8D ctrl-up */ MUP,
   /* 8E ctrl-- */ I,
   /* 8F ctrl-5 */ HOP,
   /* 90 ctrl-+ */ I,
   /* 91 ctrl-dn */ MDN,
   /* 92 ctrl-ins */ I,
   /* 93 ctrl-del */ I,
   /* 94 */ I,
   /* 95 ctrl-/ */ I,
   /* 96 ctrl-* */ I,
   /* 97 alt-pos1 */ I,
   /* 98 alt-up */ I,
   /* 99 alt-pgup */ I,
   /* 9A */ I,
   /* 9B alt-lf */ I,
   /* 9C */ I,
   /* 9D alt-rt */ I,
   /* 9E */ I,
   /* 9F alt-end */ I,
   /* A0 alt-dn */ I,
   /* A1 alt-pgdn */ I,
   /* A2 alt-ins */ I,
   /* A3 alt-del */ I,
   /* A4 alt-/ */ I,
   /* A5-AF */ I, I, I, I, I, I, I, I, I, I, I,
   /* B0-BF */ I, I, I, I, I, I, I, I, I, I, I, I, I, I, I, I,
   /* C0-CF */ I, I, I, I, I, I, I, I, I, I, I, I, I, I, I, I,
   /* D0-DF */ I, I, I, I, I, I, I, I, I, I, I, I, I, I, I, I,
   /* E0-EF */ I, I, I, I, I, I, I, I, I, I, I, I, I, I, I, I,
   /* F0-FF */ I, I, I, I, I, I, I, I, I, I, I, I, I, I, I, I,
};


#ifndef msdos

/* mapping table: function key escape sequences -> mined functions */
struct fkeyentry {
	char * fk;
	voidfunc fp;
} fkeymap [] =
{
	/* Alt-Letter sequences for manual menu activation */
/*
	{"\033f",	FILEMENU},
	{"\033e",	EDITMENU},
	{"\033s",	SEARCHMENU},
	{"\033x",	EXTRAMENU},
	{"\033p",	PARAMENU},
*/

	/* Alt-Letter sequences for keyboard switching functions 
	   to be recognised on prompt line */
	{"\033k",	toggleKEYMAP},
	{"\033K",	setupKEYMAP},

	/* VT100 and Sun */
	{"\033[A",	MUP},	/* move cursor up	*/
	{"\033[B",	MDN},	/* more cursor down	*/
	{"\033[C",	MRT},	/* more cursor right	*/
	{"\033[D",	MLF},	/* more cursor left	*/

	/* Sun raw function key codes */
	{"\033[215z",	MUP},	/* move cursor up	*/
	{"\033[221z",	MDN},	/* more cursor down	*/
	{"\033[219z",	MRT},	/* more cursor right	*/
	{"\033[217z",	MLF},	/* more cursor left	*/

	/* SuSe Linux console */
	{"\033[1~",	HOMEkey},	/* Pos1	*/
	{"\033[4~",	ENDkey},	/* End	*/

	/* RedHat Linux console */
	{"\033[[A",	HELP},	/* F1	*/
	{"\033[[B",	WT},	/* F2	*/
	{"\033[[C",	EDIT},	/* F3	*/
	{"\033[[D",	INSFILE},	/* F4	*/
	{"\033[[E",	insert_diaeresis},	/* F5	*/
	{"\033[G",	HOP},	/* 5	*/
	{"\033[1G",	HOP},	/* shift-5? (or some other terminal)	*/

	/* Linux X / xterm */
	{"\033OP",	HELP},	/* F1	*/
	{"\033OQ",	WT},	/* F2	*/
	{"\033OR",	EDIT},	/* F3	*/
	{"\033OS",	INSFILE},	/* F4	*/
	{"\033OH",	HOMEkey},	/* Pos1	*/
	{"\033OF",	ENDkey},	/* End	*/
	{"\033OE",	HOP},	/* 5	*/
	{"\033Ol",	DELkey},	/* Del	*/
	/* non-application mode xterm */
	{"\033[H",	smallHOMEkey},	/* Pos1, esp on left keypad	*/
	{"\033[F",	smallENDkey},	/* End, esp on left keypad	*/
	{"\033[E",	HOP},	/* 5	*/

	/* xterm generic keypad keys */
	{"\033[1H",	HOMEkey},	/* Pos1	*/
	{"\033[1F",	ENDkey},	/* End	*/
	{"\033[1E",	HOP},	/* 5	*/
	{"\033[1A",	MUP},	/* Up	*/
	{"\033[1D",	MLF},	/* Left	*/
	{"\033[1B",	MDN},	/* Down	*/
	{"\033[1C",	MRT},	/* Right	*/

	/* SiC! keypad redefinitions */
	{"\033[57~",	SNL},	/* KP_Enter	*/
	{"\033[58~",	COPY},	/* control-Ins	*/

	/* mined keyboard add-ons: shifted digits etc*/
	{"\033[00~",	shift_0},
	{"\033[01~",	shift_1},
	{"\033[02~",	shift_2},
	{"\033[03~",	shift_3},
	{"\033[04~",	shift_4},
	{"\033[05~",	shift_5},
	{"\033[06~",	shift_6},
	{"\033[07~",	shift_7},
	{"\033[08~",	shift_8},
	{"\033[09~",	shift_9},
	{"\033[~",	DPC},	/* ctrl-BackSpace */

	/* various modified keypad keys (non-application mode) */
	{"\033\r",	Popmark},	/* alt-Enter	*/
	{"\033\n",	Popmark},	/* alt-Enter	*/
	{"\033[2H",	MARK},	/* shift-Pos1	*/
	{"\033[2F",	COPY},	/* shift-Ende	*/
	{"\033[5H",	BLINE},	/* ctrl-Pos1	*/
	{"\033[5F",	ELINE},	/* ctrl-Ende	*/
	{"\0332A",	HIGH},	/* shift-Up	*/
	{"\0332D",	MPW},	/* shift-Left	*/
	{"\0332B",	LOW},	/* shift-Down	*/
	{"\0332C",	MNW},	/* shift-Right	*/
	{"\0335A",	MUP},	/* control-Up	*/
	{"\0335D",	ctrl_MLF},	/* control-Left	*/
	{"\0335B",	MDN},	/* control-Down	*/
	{"\0335C",	ctrl_MRT},	/* control-Right	*/
	{"\0336A",	HIGH},	/* control-shift-Up	*/
	{"\0336D",	BLINE},	/* control-shift-Left	*/
	{"\0336B",	LOW},	/* control-shift-Down	*/
	{"\0336C",	ELINE},	/* control-shift-Right	*/

	/* vim mouse wheel mappings for xterm */
	{"\033[64~",	PU},	/* shift-wheel-up */
	{"\033[65~",	PD},	/* shift-wheel-down */
	{"\033[62~",	SU},	/* wheel-up */
	{"\033[63~",	SD},	/* wheel-down */

	/* hanterm */
	{"\033O ",	HOP},	/* middle keypad key ("5")	*/

	/* various VT100-style Fn function keys */
	{"\033[11~",	HELP},	/* F1	*/
	{"\033[12~",	WT},	/* F2	*/
	{"\033[13~",	EDIT},	/* F3	*/
	{"\033[14~",	INSFILE},	/* F4	*/
	{"\033[15~",	insert_diaeresis},	/* F5	*/
	{"\033[17~",	insert_acute}, /* F6	*/
	{"\033[18~",	SFW},	/* F7	*/
	{"\033[19~",	SFW},	/* F8	*/
	{"\033[20~",	RS},	/* F9	*/
	{"\033[21~",	FILEMENU},	/* F10	*/

	{"\033[23~",	LOWCAP},	/* shift F1 / F11	*/
	{"\033[24~",	SAVPOS},	/* shift F2 / F12	*/
	{"\033[25~",	I},	/* shift F3 / F13 (VT100)	*/
	{"\033[26~",	WB},	/* shift F4 / F14 (VT100)	*/
	{"\033[28~",	insert_tilde},	/* shift F5	*/
	{"\033[29~",	insert_grave},	/* shift F6	*/
	{"\033[31~",	I},	/* shift F7 / F17 (VT100)	*/
	{"\033[32~",	GR},	/* shift F8 / F18 (VT100)	*/
	{"\033[33~",	I},	/* shift F9 / F19 (VT100)	*/
	{"\033[34~",	QUICKMENU},	/* shift F10 / F20 (VT100)	*/

	/* VT100 - some have been disabled by linux sequences */
	/* F1...F10 see above, F11...F20 see fkeymap_vt100 below */
	{"\033[6~",	PD},	/* Next Screen, xterm PgDn	*/
	{"\033[5~",	PU},	/* Prev Screen, xterm PgUp	*/
	{"\033[3~",	DELkey},	/* Remove, xterm Del	*/
	{"\033[2~",	PASTE},	/* Insert Here, xterm Ins	*/
/*	{"\033OP",	HOP},	*//* PF1	*/
/*	{"\033OQ",	SU},	*//* PF2	*/
/*	{"\033OR",	SD},	*//* PF3	*/
/*	{"\033OS",	SU},	*//* PF4	*/
	{"\033[@",	HOMEkey},	/* Pos1, PC-xterm	*/
	{"\033[e",	ENDkey},	/* End, PC-xterm	*/
	/* application cursor keys */
	{"\033OA",	MUP},	/* up	*/
	{"\033OB",	MDN},	/* dn	*/
	{"\033OC",	MRT},	/* rt	*/
	{"\033OD",	MLF},	/* lf	*/
	{"\033O@",	HOMEkey},	/* Pos1, PC-xterm	*/
	{"\033Oe",	ENDkey},	/* End, PC-xterm	*/
	/* application keypad */
	{"\033Oo",	I},	/* PF1, keypad /	*/
	{"\033Oj",	I},	/* PF2, keypad *	*/
	{"\033Om",	SU},	/* PF3, keypad - 	*/
	{"\033Ok",	SD},	/* PF4, keypad +	*/
	{"\033OM",	SNL},	/* Enter */
	{"\033Ow",	HOMEkey},	/* Pos1	*/
	{"\033Ox",	MUP},	/* up	*/
	{"\033Oy",	PU},	/* PgUp	*/
	{"\033Ot",	MLF},	/* lf	*/
	{"\033Ou",	HOP},	/* mid	*/
	{"\033Ov",	MRT},	/* rt	*/
	{"\033Oq",	ENDkey},	/* End	*/
	{"\033Or",	MDN},	/* dn	*/
	{"\033Os",	PD},	/* PgDn	*/
	{"\033Op",	PASTE},	/* Ins	*/
	{"\033On",	DELkey},	/* Del	*/

	/* Sun */
	{"\033[208z",	insert_grave},	/* R1 */
	{"\033[209z",	insert_circumflex},	/* R2 */
	{"\033[210z",	insert_acute},	/* R3 */
	{"\033[211z",	insert_diaeresis},	/* R4 */
	{"\033[212z",	insert_tilde},	/* R5 */
	{"\033[213z",	insert_angstrom},	/* R6 */
	{"\033[214z",	SU},	/* R7	*/
	{"\033[216z",	PU},	/* R9	*/
	{"\033[218z",	HOP},	/* R11	*/
	{"\033[220z",	SD},	/* R13	*/
	{"\033[222z",	PD},	/* R15	*/
	{"\033[254z",	GOMA},	/* - */
	{"\033[253z",	MARK},	/* + */
	{"\033[250z",	COPY},	/* Enter */
	{"\033[249z",	DELkey},	/* Del */
	{"\033[247z",	PASTEstay},	/* Ins */
	{"\033[1z",	HOMEkey},	/* Home/Pos1, non-appl */
	{"\033[4z",	ENDkey},	/* End, non-appl */
	{"\033[2z",	PASTE},	/* Ins on VT100 block */
	{"\033[3z",	DELkey},	/* Del (xterm/Sun) */
	{"\033[5z",	PU},	/* PgUp on VT100 block */
	{"\033[6z",	PD},	/* PgDn on VT100 block */
	{"\033[192z",	MARK},	/* Stop */
	{"\033[193z",	RS},	/* Again */
	{"\033[194z",	FS},	/* Props */
	{"\033[195z",	I},	/* Undo */
	{"\033[197z",	COPY},	/* Copy */
	{"\033[199z",	PASTE},	/* Paste */
	{"\033[200z",	SFW},	/* Find */
	{"\033[201z",	CUT},	/* Cut */
	{"\033[196z",	HELP},	/* Help */

	{"\033[225z",	WT},	/* F2 */
	{"\033[226z",	EDIT},	/* F3 */
	{"\033[227z",	INSFILE},	/* F4 */
	{"\033[228z",	insert_diaeresis},	/* F5 */
	{"\033[229z",	PU},	/* F6 */
	{"\033[230z",	PD},	/* F7 */
	{"\033[231z",	SFW},	/* F8 */
	{"\033[232z",	RS},	/* F9 */
	{"\033[233z",	FILEMENU},	/* F10 */
	{"\033[234z",	LOWCAP},	/* F11 */
	{"\033[235z",	I},	/* F12 */
	{"\033[224z",	HELP},	/* F1, xterm */
/*	{"\033[192z",	I},	*//* F11, xterm; Sun "Stop" -> MARK */
/*	{"\033[193z",	I},	*//* F12, xterm; Sun "Again" */

	/* Iris */
	{"\033[209q",	HOMEkey},	/* Print Screen */
	{"\033[213q",	ENDkey},	/* Scroll Lock */
/*	{"\033[217q",	I},	*//* Pause */
	{"\033[139q",	PASTE},	/* Insert, Ins */
	{"\033[P",	DELkey},	/* Del */
/*	{"\033[H",	smallHOMEkey},	*//* Home */
	{"\033[150q",	PU},	/* PgUp */
	{"\033[146q",	smallENDkey},	/* End */
	{"\033[154q",	PD},	/* PgDn */
	{"\033[000q",	HOP},	/* 5 */
	{"\033[001q",	HELP},	/* F1 */
	{"\033[002q",	WT},	/* F2 */
	{"\033[005q",	insert_diaeresis},	/* F5 */
	{"\033[006q",	insert_acute},	/* F6 */
	{"\033[007q",	I},	/* F7 */
	{"\033[008q",	SFW},	/* F8 */
	{"\033[009q",	RS},	/* F9 */
	{"\033[022q",	insert_grave},	/* Shift-F10 */
	{"\033[023q",	insert_circumflex},	/* Shift-F11 */
	{"\033[024q",	insert_acute},	/* Shift-F12 */
	{"\033[010q",	insert_diaeresis},	/* F10 */
	{"\033[011q",	insert_tilde},	/* F11 */
	{"\033[012q",	insert_angstrom},	/* F12 */

	/* HP workstation keyboard without NumLock */
	{"\033OU",	MARK},	/* Pos1	*/
	{"\033OW",	MUP},	/* up	*/
	{"\033OZ",	PU},	/* PgUp	*/
	{"\033OV",	MLF},	/* lf	*/
	{"\033OX",	MRT},	/* rt	*/
	{"\033OY",	MDN},	/* dn	*/
	{"\033O?",	PD},	/* PgDn, End, Ins, Del	*/

	/* rxvt */
	{"\033[7~",	smallHOMEkey},	/* 	*/
	{"\033[8~",	smallENDkey},	/* 	*/
	{"\033[Z",	MPW},		/* shift-TAB */

	{NIL_PTR}
};

struct fkeyentry fkeymap_xterm [] = {
	/* xterm */
	{"\033[M",	DIRECTxterm},	/* direct cursor address */
	{"\033[t",	TRACKxterm},	/* cursor hilite tracking */
	{"\033[T",	TRACKxtermT},	/* cursor hilite tracking */

	{NIL_PTR}
};

struct fkeyentry fkeymap_vt100 [] = {
	/* VT100 */
	{"\033[1~",	SFW},	/* Find	*/
	{"\033[4~",	MARK},	/* Select	*/
	{"\033[29~",	COPY},	/* Do		*/
	{"\033[28~",	HELP},	/* Help		*/

	{NIL_PTR}
};

struct fkeyentry fkeymap_hp [] = {
	/* crttool */
	{"\033m",	DIRECTcrttool},	/* direct cursor address */

	/* HP, overrides some of Siemens and VT100 PC-emulator */
	{"\033h",	HOMEkey},	/* Pos1 */
	{"\033A",	MUP},	/* up	*/
	{"\033T",	PU},	/* PgUp	*/
	{"\033D",	MLF},	/* lf	*/
	{"\033C",	MRT},	/* rt	*/
	{"\033F",	ENDkey},	/* End	*/
	{"\033B",	MDN},	/* dn	*/
	{"\033S",	PD},	/* PgDn	*/
	{"\033Q",	PASTE},	/* Ins	*/
	{"\033P",	DELkey},	/* Del	*/
	{"\033p",	HELP},	/* F1 */
	{"\033q",	WT},	/* F2 */
	{"\033r",	EDIT},	/* F3 */
	{"\033s",	INSFILE},	/* F4 */
	{"\033t",	insert_diaeresis},	/* F5 */
	{"\033u",	PU},	/* F6 */
	{"\033v",	PD},	/* F7 */
	{"\033w",	SFW},	/* F8 */
	{"\0332p",	I},	/* shift-F1 */
	{"\0332q",	WTU},	/* shift-F2 */
	{"\0332r",	I},	/* shift-F3 */
	{"\0332s",	I},	/* shift-F4 */
	{"\0332t",	insert_tilde},	/* shift-F5 */
	{"\0332u",	insert_grave},	/* shift-F6 */
	{"\0332v",	I},	/* shift-F7 */
	{"\0332w",	GR},	/* shift-F8 */
	{"\033V",	PU},
	{"\033U",	PD},

	{"\033&",	SNL},	/* keypad Enter */

	{NIL_PTR}
};

struct fkeyentry fkeymap_siemens [] = {
	/* Siemens 97801/97808 */
	{"\033N",	insert_diaeresis},	/* F14 */
	{"\033P",	RS},			/* F16 */
	{"\0332",	insert_grave},		/* shift-F18 */
	{"\0333",	insert_circumflex},	/* shift-F19 */
	{"\033U",	insert_acute},		/* shift-F20 */
	{"\033T",	insert_diaeresis},	/* F20 */
	{"\033d",	insert_tilde},		/* F19 */
	{"\033_",	insert_angstrom},	/* F18 */
	{"\0330",	(voidfunc) UML},			/* F17 */
	{"\033[Z",	MPW},		/* |<- */
	{"\0339",	MPW},		/* <~- */
	{"\033:",	MNW},		/* -~> */
	{"\0336",	HOP},		/* neben END, ber Cursorblock */
	{"\033[@",	PASTE},		/* Insert */
/*
?
INSERT: o
DELETE: p [M
*/
	{"\033[S",	PU},
	{"\033[T",	PD},
	{"\033^",	HOP},

	{"\033@",	HELP},	/* F1 */
	{"\033A",	WT},	/* F2 */
	{"\033B",	EDIT},	/* F3 */
	{"\033C",	INSFILE},	/* F4 */
	{"\033D",	PD},	/* F5 , Pg Dn ? */
	{"\033F",	insert_acute},	/* F6 */
	{"\033G",	SFW},	/* F7 */
	{"\033H",	SFW},	/* F8 */
	{"\033I",	RS},	/* F9 */
	{"\033J",	FILEMENU},	/* F10 */
	{"\033K",	LOWCAP},	/* F11 */
	{"\033L",	SAVPOS},	/* F12 */
	{"\033 ",	I},	/* shift-F1 */
	{"\033;",	WTU},	/* shift-F2 */
	{"\033\"",	I},	/* shift-F3 */
	{"\033#",	WB},	/* shift-F4 */
	{"\033$",	insert_tilde},	/* shift-F5 */
	{"\033%",	insert_grave},	/* shift-F6 */
	{"\033&",	I},	/* shift-F7 */
	{"\033'",	GR},	/* shift-F8 */
	{"\033<",	I},	/* shift-F9 */
	{"\033=",	QUICKMENU},	/* shift-F10 */
	{"\033*",	I},	/* shift-F11 */
	{"\033+",	I},	/* shift-F12 */

	{NIL_PTR}
};

#define MAXCODELEN 7 /* max. length of function key sequence to be detected, 
			depending on the fkeymap table => used in keyboard.c */

#endif


/*======================================================================*\
|*				End					*|
\*======================================================================*/
