;; -*-emacs-lisp-*-
;;
;; Emacs startup file for the Debian GNU/Linux MH-E package

(cond
 ((not (file-exists-p "/usr/share/emacs/site-lisp/mh-e"))
  (message "Package mh-e removed but not purged.  Skipping setup."))
 ((eq debian-emacs-flavor 'emacs20)
  (message "Skipping MH-E package setup for emacs20: not supported."))
 ((eq debian-emacs-flavor 'emacs-snapshot)
  (message "Skipping MH-E package setup for emacs-snapshot"))
 (t
  ;; Replace all occurrences of nil in load-path by "." since nil breaks
  ;; debian-pkg-add-load-path-item
  (if (memq nil load-path)
      (setq load-path (substitute "." nil load-path)))
  
  ;; The MH-E package follows the Debian/GNU Linux 'emacsen' policy and
  ;; byte-compiles its elisp files for each 'emacs flavor' (emacs19,
  ;; xemacs19, emacs20, xemacs20...).  The compiled code is then
  ;; installed in a subdirectory of the respective site-lisp directory.
  ;; We have to add this to the load-path:
  (debian-pkg-add-load-path-item
   (concat "/usr/share/" (symbol-name debian-emacs-flavor) "/site-lisp/mh-e"))

  ;; Starting from MH-E 7.85, icon images are no longer collocated with elisp.
  (if (boundp 'image-load-path)
      (add-to-list 'image-load-path
                   "/usr/share/emacs/site-lisp/etc/images/mh-e")
    (debian-pkg-add-load-path-item
     "/usr/share/emacs/site-lisp/etc/images/mh-e"))

  ;; Usual entry commands into MH-E
  (require 'mh-autoloads)

  ;; contrib autoloads
  (autoload 'mh-frame "mh-frame" "" t)))
