/*
 * medussa - a distributed cracking system
 * Copyright (C) 1999 Kostas Evangelinos <kos@bastard.net>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */
/*
 * $Id: bruteforce.h,v 1.2 2003/02/05 04:38:37 kos Exp $
 *
 */

#ifndef _BRUTEFORCE_H
#define _BRUTEFORCE_H

#include "keyspace.h"
#include "generator.h"

#define BF_MINLEN 1
#define BF_MAXLEN 6
#define BF_POSS "eairtonslcumdphgbyfwvkzxqSMCBAjZYXWVUTRQPONLKJIHGFED9876543210"
#define BF_LINELEN 1024

typedef struct bruteforce_t {
  char poss[BF_LINELEN];
  key_index_t posslen;
  int len;
  int minlen;
  int maxlen;  
  key_index_t index;
  key_index_t minindex;
  key_index_t maxindex;
  key_index_t cur_min;
  key_index_t cur_max;
  key_index_t kindex;
  key_index_t kmult;
} bruteforce_t;

bruteforce_t *bruteforce_init(char *params);
int bruteforce_set(bruteforce_t *, key_index_t index);
int bruteforce_fetch(bruteforce_t *, kchar *buf, int len, int *rlen);
int bruteforce_done(bruteforce_t *);
int bruteforce_destroy(bruteforce_t *);
key_index_t *bruteforce_minindex(bruteforce_t *);
key_index_t *bruteforce_maxindex(bruteforce_t *);
key_index_t *bruteforce_curindex(bruteforce_t *);
int bruteforce_minlen(bruteforce_t *);
int bruteforce_maxlen(bruteforce_t *);

#endif /* _BRUTEFORCE_H */
