/*
 * medussa - a distributed cracking system
 * Copyright (C) 1999 Kostas Evangelinos <kos@bastard.net>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

/*
 * $Id: keyspace.h,v 1.10 2000/11/14 04:04:32 kos Exp $
 *
 */

#ifndef _KEYSPACE_H
#define _KEYSPACE_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <gmp.h>
#include "array.h"
#include "common.h"

#define KEYSPACE_BASE 10
#define KSP_LINELEN 1024

typedef mpz_t key_index_t;

int keyspace_init(key_index_t i);
int keyspace_destroy(key_index_t i);
char *keyspace_ntoa(key_index_t i);
int keyspace_shr(key_index_t r, key_index_t i, unsigned int j);
int keyspace_inc(key_index_t r);

#define keyspace_add(a,b,c) mpz_add(a,b,c)
#define keyspace_sub(a,b,c) mpz_sub(a,b,c)
#define keyspace_mul(a,b,c) mpz_mul(a,b,c)
#define keyspace_div(a,b,c) mpz_div(a,b,c)
#define keyspace_fromstr(a,b) mpz_set_str(a,b,KEYSPACE_BASE)
#define keyspace_tostr(a,b,c) mpz_get_str(a,KEYSPACE_BASE,c)
#define keyspace_cmp(a,b) mpz_cmp(a,b)
#define keyspace_pow(a,b,c) mpz_pow_ui(a,c,b)
#define keyspace_toint(a) mpz_get_ui(a)
#define keyspace_todouble(a) mpz_get_d(a)
#define keyspace_fromdouble(a,b) mpz_set_d(b,a)
#define keyspace_fromint(a,b) mpz_set_ui(b,a)
#define keyspace_set(a,b) mpz_set(a,b)
#define keyspace_mod(a,b,c) mpz_mod(a,b,c)

#endif /* _KEYSPACE_H */

