/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.plugin;

import com.fluendo.jst.Buffer;
import com.fluendo.jst.Caps;
import com.fluendo.jst.Sink;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageProducer;

public class VideoSink
extends Sink {
    private Component component;
    private boolean keepAspect = true;
    private boolean scale = true;
    private Frame frame;
    private int width;
    private int height;
    private int aspectX;
    private int aspectY;

    protected boolean setCapsFunc(Caps caps) {
        String string = caps.getMime();
        if (!string.equals("video/raw")) {
            return false;
        }
        this.width = caps.getFieldInt("width", -1);
        this.height = caps.getFieldInt("height", -1);
        if (this.width == -1 || this.height == -1) {
            return false;
        }
        this.aspectX = caps.getFieldInt("aspect_x", 1);
        this.aspectY = caps.getFieldInt("aspect_y", 1);
        this.component.setVisible(true);
        return true;
    }

    protected int preroll(Buffer buffer) {
        return this.render(buffer);
    }

    protected int render(Buffer buffer) {
        int n;
        int n2;
        int n3;
        int n4;
        Image image;
        if (buffer.object instanceof ImageProducer) {
            image = this.component.createImage((ImageProducer)buffer.object);
        } else if (buffer.object instanceof Image) {
            image = (Image)buffer.object;
        } else {
            System.out.println(this + ": unknown buffer received " + buffer);
            return -5;
        }
        if (!this.component.isVisible()) {
            return -4;
        }
        Dimension dimension = this.component.getSize();
        Graphics graphics = this.component.getGraphics();
        if (this.keepAspect) {
            double d = (double)this.width / (double)this.height;
            double d2 = (double)dimension.width / (double)dimension.height;
            if (d > d2) {
                n4 = dimension.width;
                n3 = (int)((double)dimension.width / d);
                n2 = 0;
                n = (dimension.height - n3) / 2;
            } else if (d < d2) {
                n4 = (int)((double)dimension.height * d);
                n3 = dimension.height;
                n2 = (dimension.width - n4) / 2;
                n = 0;
            } else {
                n2 = 0;
                n = 0;
                n4 = dimension.width;
                n3 = dimension.height;
            }
        } else if (!this.scale) {
            n4 = Math.min(this.width, dimension.width);
            n3 = Math.min(this.height, dimension.height);
            n2 = (dimension.width - n4) / 2;
            n = (dimension.height - n3) / 2;
        } else {
            n4 = dimension.width;
            n3 = dimension.height;
            n2 = 0;
            n = 0;
        }
        graphics.drawImage(image, n2, n, n4, n3, null);
        return 0;
    }

    public String getFactoryName() {
        return "videosink";
    }

    public boolean setProperty(String string, Object object) {
        if (string.equals("component")) {
            this.component = (Component)object;
        } else if (string.equals("keep-aspect")) {
            this.keepAspect = String.valueOf(object).equals("true");
        } else if (string.equals("scale")) {
            this.scale = String.valueOf(object).equals("true");
        } else {
            return false;
        }
        return true;
    }

    public Object getProperty(String string) {
        if (string.equals("component")) {
            return this.component;
        }
        if (string.equals("keep-aspect")) {
            return this.keepAspect ? "true" : "false";
        }
        return null;
    }

    protected int changeState(int n) {
        if (this.currentState == 1 && this.pendingState == 2 && this.component == null) {
            this.frame = new Frame();
            this.component = this.frame;
        }
        return super.changeState(n);
    }
}

