/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mediathek.io.starter;

import mediathek.filme.DatenFilm;

public class Starts {

    public int status = STATUS_INIT;
    public int art = 0;
    public int quelle;
    public int startcounter = 0;
    public boolean restart = false; //Download im Fehlerfall wieder Starten
    public DatenFilm film;
    public String prog = ""; //Programmstring zum Ausführen
    public Process process = null; //Prozess des Download
    public boolean stoppen = false;
//    public boolean autoDelete = false; // am Ende selbst wieder löschen
    // Quelle - start über einen Button - Abo - Podcast
    public static final int QUELLE_ALLE = -1;
    public static final int QUELLE_BUTTON = 1;
    public static final int QUELLE_ABO = 2;
    public static final int QUELLE_PODCAST = 3;
    public static final int ART_DOWNLOAD = 1;
    public static final int ART_PROGRAMM = 2;
//    public static final int ART_ZDF_DIREKT = 3;
    // Art - laden mit einem Programm - direkter Dateidownload
    public static final int ART_PROG = 1;
    public static final int ART_DIREKT = 2;
    // Stati
    public static final int STATUS_INIT = 1;
    public static final int STATUS_RUN = 2;
    public static final int STATUS_FERTIG = 3;
    public static final int STATUS_ERR = 4;
    //Download wird so oft gestartet, falls er beim ersten Mal nicht anspringt
    public static final int STARTCOUNTER_MAX = 3;

    /**
     * Initialisiert einen neuen Download
     * @param ddatenFilm 
     * @param aart
     * @param pprog
     * @param rrestart
     */
    public Starts(int qquelle, DatenFilm ddatenFilm, int aart, String pprog, boolean rrestart) {
        quelle = qquelle;
        film = ddatenFilm;
        art = aart;
        prog = pprog;
        restart = rrestart;
    }
}
