/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

package mediathek.gui.dialoge;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JOptionPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import mediathek.HinweisKeineAuswahl;
import mediathek.beobachter.BeobachterTableSelect;
import mediathek.daten.Daten;
import mediathek.Konstanten;
import mediathek.TModel;
import mediathek.daten.DatenPod;
import mediathek.daten.DatenPodster;

public class DialogPodster extends javax.swing.JDialog {

    private Daten daten;
    private TModel tModel;
    private BeobachterTableSelect beobachterTableSelect;
    private boolean stopBeob = false;
    public boolean podGeaendert = false;

    public DialogPodster(java.awt.Frame parent, boolean modal, Daten d) {
        super(parent, modal);
        initComponents();
        daten = d;
        init();
        this.setTitle("Podcast von Podster suchen");
        beobachterTableSelect = new BeobachterTableSelect(daten, jTable1) {

            @Override
            public void fill() {
            }

        };
        jTable1.getSelectionModel().addListSelectionListener(beobachterTableSelect);
        jButtonHinzufuegen.addActionListener(new BeobHinzufuegen());
        jButtonLaden.addActionListener(new BeobListeLaden());
        jButtonBeenden.addActionListener(new BeobBeenden());
        jButtonFilterLoeschen.addActionListener(new BeobachterFilterLoeschen());
        jTextFieldFilter.getDocument().addDocumentListener(new BeobachterFilter());
        jComboBoxFilterThema.setModel(new javax.swing.DefaultComboBoxModel(daten.listePodster.getModelOfField(Konstanten.PODSTER_THEMA_NR)));
        jComboBoxFilterThema.addActionListener(new BeobFilterThema());
    }

    void init() {
        fillTable();
    }

    private void fillTable() {
        tModel = new TModel(daten.listePodster.getObjectData(), Konstanten.PODSTER_COLUMN_NAMES);
        jTable1.setModel(tModel);
        spaltenbreiteSetzen();
        zeilenZahl();
    }

    private void zeilenZahl() {
        String text = "";
        if (tModel != null) {
            text = tModel.getRowCount() + " Podcasts";
        } else {
            text = "0 Podcasts";
        }
        jScrollPane1.setBorder(javax.swing.BorderFactory.createTitledBorder(null, text,
                                                                            javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION,
                                                                            javax.swing.border.TitledBorder.ABOVE_BOTTOM));
    }

    private void spaltenbreiteSetzen() {
        //Spalten ausblenden
        for (int i = 0; i < jTable1.getColumnCount(); ++i) {
            if (i == Konstanten.PODSTER_NR_NR) {
                jTable1.getColumnModel().getColumn(i).setMinWidth(50);
                jTable1.getColumnModel().getColumn(i).setPreferredWidth(50);
                jTable1.getColumnModel().getColumn(i).setMaxWidth(3000);
            } else if (i == Konstanten.PODSTER_THEMA_NR) {
                jTable1.getColumnModel().getColumn(i).setMinWidth(150);
                jTable1.getColumnModel().getColumn(i).setPreferredWidth(150);
                jTable1.getColumnModel().getColumn(i).setMaxWidth(3000);
            }
        }
    }

    private void listeLaden() {
        this.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
        daten.feedReaderPodster.starten();
        this.setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
        fillTable();
        stopBeob = true;
        jComboBoxFilterThema.setModel(new javax.swing.DefaultComboBoxModel(daten.listePodster.getModelOfField(Konstanten.PODSTER_THEMA_NR)));
        stopBeob = false;
    }

    private void podHinzuguegen() {
        String exist = null;
        int selectedTableRow = jTable1.getSelectedRow();
        if (selectedTableRow >= 0) {
            int selectedModelRow = jTable1.convertRowIndexToModel(selectedTableRow);
            DatenPodster podster = daten.listePodster.getPodNr(
                Integer.parseInt( tModel.getValueAt(selectedModelRow, Konstanten.PODSTER_NR_NR).toString()));
            DatenPod datenPod = new DatenPod(podster.arr[Konstanten.PODSTER_TITEL_NR], podster.arr[Konstanten.PODSTER_URL_NR],
                                             podster.arr[Konstanten.PODSTER_TITEL_NR]);
            if ((exist = daten.listePod.urlExists(podster.arr[Konstanten.PODSTER_URL_NR])) != null) {
                JOptionPane.showMessageDialog(null, "Podcast existiert bereits!"
                    + "\n" + "Name: " + exist, "Podcast anlegen", JOptionPane.INFORMATION_MESSAGE);
            } else {
                DialogPod dialogPod = new DialogPod(null, true, daten, datenPod);
                dialogPod.setVisible(true);
                daten.listePod.addPod(datenPod);
                podGeaendert = true;
            }
        } else {
            new HinweisKeineAuswahl();
        }
    }

    private void filterLoeschen() {
        stopBeob = true;
        jTextFieldFilter.setText("");
        jComboBoxFilterThema.setModel(new javax.swing.DefaultComboBoxModel(daten.listePodster.getModelOfField(Konstanten.PODSTER_THEMA_NR)));
        stopBeob = false;
        filter();
    }

    private void filter() {
        stopBeob = true;
        //neu laden
        fillTable();
        //filtern
        if (tModel != null) {
            if (tModel.getRowCount() > 0) {
                tModel.filterModel(jTextFieldFilter.getText(), Konstanten.PODSTER_TITEL_NR, false);
                tModel.filterModel( jComboBoxFilterThema.getSelectedItem().toString(), Konstanten.PODSTER_THEMA_NR, true);
            }
        }
        zeilenZahl();
        stopBeob = false;
    }

    private void beenden() {
        this.dispose();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        jTable1 = new javax.swing.JTable();
        jPanel1 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jTextFieldFilter = new javax.swing.JTextField();
        jButtonFilterLoeschen = new javax.swing.JButton();
        jLabel2 = new javax.swing.JLabel();
        jComboBoxFilterThema = new javax.swing.JComboBox();
        jButtonBeenden = new javax.swing.JButton();
        jButtonLaden = new javax.swing.JButton();
        jButtonHinzufuegen = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);

        jTable1.setAutoCreateRowSorter(true);
        jTable1.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {

            }
        ));
        jScrollPane1.setViewportView(jTable1);

        jPanel1.setBorder(javax.swing.BorderFactory.createEtchedBorder());

        jLabel1.setText("Titel:");

        jButtonFilterLoeschen.setText("X");

        jLabel2.setText("Thema:");

        jComboBoxFilterThema.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel2)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jComboBoxFilterThema, javax.swing.GroupLayout.PREFERRED_SIZE, 138, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jTextFieldFilter, javax.swing.GroupLayout.DEFAULT_SIZE, 290, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jButtonFilterLoeschen)
                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTextFieldFilter, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jButtonFilterLoeschen)
                    .addComponent(jComboBoxFilterThema, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel2)
                    .addComponent(jLabel1))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanel1Layout.linkSize(javax.swing.SwingConstants.VERTICAL, new java.awt.Component[] {jButtonFilterLoeschen, jTextFieldFilter});

        jButtonBeenden.setText("Ok");
        jButtonBeenden.setToolTipText("diesen Dialog schließen");

        jButtonLaden.setText("Liste neu laden");

        jButtonHinzufuegen.setText("Podcast hinzufügen");
        jButtonHinzufuegen.setToolTipText("eine Auswahl an Programmen hinzufügen");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 628, Short.MAX_VALUE)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addComponent(jButtonHinzufuegen)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonLaden)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonBeenden)))
                .addContainerGap())
        );

        layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {jButtonBeenden, jButtonHinzufuegen, jButtonLaden});

        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 282, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(jButtonLaden)
                        .addComponent(jButtonHinzufuegen))
                    .addComponent(jButtonBeenden))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonBeenden;
    private javax.swing.JButton jButtonFilterLoeschen;
    private javax.swing.JButton jButtonHinzufuegen;
    private javax.swing.JButton jButtonLaden;
    private javax.swing.JComboBox jComboBoxFilterThema;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTable jTable1;
    private javax.swing.JTextField jTextFieldFilter;
    // End of variables declaration//GEN-END:variables

    private class BeobHinzufuegen implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            podHinzuguegen();
        }

    }

    private class BeobListeLaden implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            listeLaden();
        }

    }

    private class BeobBeenden implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            beenden();
        }

    }

    private class BeobachterFilterLoeschen implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            filterLoeschen();
        }

    }

    private class BeobachterFilter implements DocumentListener {

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            filtern();
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            filtern();
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            filtern();
        }

        private void filtern() {
            if (!stopBeob) {
                filter();
            }
        }

    }

    private class BeobFilterThema implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!stopBeob) {
                filter();
            }
        }

    }

}
