/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mediathek;

import java.util.LinkedList;
import javax.swing.table.DefaultTableModel;
import mediathek.daten.Daten;
import mediathek.daten.Datum;
import mediathek.io.History;

public class TModel extends DefaultTableModel {

    /** Creates a new instance of TModel */
    public TModel() {
    }
    public Object[][] object;
    Object[] columns;

    public TModel(Object[][] data, Object[] columnNames) {
        super(data, columnNames);
        object = data;
        columns = columnNames;
    }

//    public TModel copy() {
//        return new TModel(object, columns);
//    }
    @Override
    public boolean isCellEditable(int i, int j) {
        return false;
    }

    public void filterModel(String str, int feld, boolean exact) {
        if (str != null) {
            if (!str.equals("")) {
                for (int i = 0; i < this.getRowCount(); ++i) {
                    String tmp;
                    tmp = this.getValueAt(i, feld).toString();
                    if (exact && tmp.length() != str.length()) {
                        this.removeRow(i);
                        --i;
                        continue;
                    }
                    if (!tmp.toLowerCase().contains(str.toLowerCase())) {
                        this.removeRow(i);
                        --i;
                    }
                }
            }
        }
    }

    public void verkuerzen(int feld1, int feld2, int anz) {
        //nur eine Zeile mit gleichem Inhalt aus fleld
        int start = 0;
        int count = 1;
        while (start < this.getRowCount()) {
            String str1 = this.getValueAt(start, feld1).toString();
            String str2 = this.getValueAt(start, feld2).toString();
            for (int i = start + 1; i < this.getRowCount(); ++i) {
                String tmp1 = this.getValueAt(i, feld1).toString();
                String tmp2 = this.getValueAt(i, feld2).toString();
                if (tmp1.equals(str1) && tmp2.equals(str2)) {
                    if (count < anz) {
                        ++count;
                    } else {
                        this.removeRow(i);
                        --i;
                    }
                }
            }
            count = 1;
            ++start;
        }
    }

    public void nurAbo() {
        // alle Zeilen in denen kein Abo eingetragen ist löschen
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (this.getValueAt(i, Konstanten.FILM_ABO_NR).equals("")) {
                this.removeRow(i);
                --i;
            }
        }
    }

    public void keineGesehenen(Daten daten) {
        // alle Zeilen mit gesehenen fillmen löschen
        History history = daten.history;
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (history.contains(this.getValueAt(i, Konstanten.FILM_URL_NR).toString())) {
                this.removeRow(i);
                --i;
            }
        }
    }

    public String[] getModelOfField(Daten daten, int feld, boolean leer) {
        /* erstellt ein StringArray mit den Daten des Feldes
        lee: immer ein leeres Feld am Anfang */
        LinkedList<String> list = new LinkedList<String>();
        String[] ret;
        String str = new String();
        for (int i = 0; i < this.getRowCount(); ++i) {
            str = this.getValueAt(i, feld).toString();
            if (str.equals("")) {
                leer = true;
            } else if (!list.contains(str)) {
                list.add(str);
            }
        }
        if (leer) {
            ret = new String[list.size() + 1];
            ret[0] = "";
            for (int i = 0; i < list.size(); ++i) {
                ret[i + 1] = list.get(i);
            }
        } else {
            ret = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                ret[i] = list.get(i);
            }
        }
        return ret;
    }
}
