!*  This file is part of MED.
!*
!*  COPYRIGHT (C) 1999 - 2011  EDF R&D, CEA/DEN
!*  MED is free software: you can redistribute it and/or modify
!*  it under the terms of the GNU Lesser General Public License as published by
!*  the Free Software Foundation, either version 3 of the License, or
!*  (at your option) any later version.
!*
!*  MED is distributed in the hope that it will be useful,
!*  but WITHOUT ANY WARRANTY; without even the implied warranty of
!*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!*  GNU Lesser General Public License for more details.
!*
!*  You should have received a copy of the GNU Lesser General Public License
!*  along with MED.  If not, see <http://www.gnu.org/licenses/>.
!*

!*
!*  Use case 5 : read a 2D structured mesh
!*

program UsesCase_MEDmesh_5

    implicit none
  include 'med.hf'

  integer cret
  integer fid, nmesh, it, naxis
  character(64)  :: mname = "2D unstructured mesh"
  character(200) :: desc
  character(16)  :: dtunit
  integer nstep, mdim, sdim, stype, mtype, atype
  character(16), dimension(:), allocatable :: aname
  character(16), dimension (:), allocatable :: aunit
  integer gtype

  ! open file             **
  call mfiope(fid,'UsesCase_MEDmesh_4.med',MED_ACC_RDONLY, cret)
  print *,cret
  print *,fid
  if (cret .ne. 0 ) then
     print *,'ERROR : open file'
     call efexit(-1)
  endif

  ! ... we know that the MED file has only one mesh, 
  ! a real code working would check ... 

  ! read computation space dimension **
  call mmhnan(fid,mname,naxis,cret)
  print *,cret
  if (cret .ne. 0 ) then
     print *,'Read number of axis in the mesh'
     call efexit(-1)
  endif
  print *,'Number of axis in the mesh  = ',naxis
     
  allocate ( aname(naxis), aunit(naxis) ,STAT=cret )
  if (cret > 0) then
     print *,'Memory allocation'
     call efexit(-1)
  endif
  ! read mesh informations **
  call  mmhmin(fid, mname, sdim, mdim, mtype, desc, dtunit, stype, nstep, atype, aname, aunit, cret)
  print *,cret
  if (cret .ne. 0 ) then
     print *,'Read mesh informations'
     call efexit(-1)
  endif
  print *,"mesh name =", mname
  print *,"space dim =", sdim
  print *,"mesh dim =", mdim
  print *,"mesh type =", mtype
  print *,"mesh description =", desc
  print *,"dt unit = ", dtunit
  print *,"sorting type =", stype
  print *,"number of computing step =", nstep
  print *,"coordinates axis type =", atype
  print *,"coordinates axis name =", aname
  print *,"coordinates axis units =", aunit
  deallocate(aname, aunit)

  ! read grid type
  call mmhgtr(fid,mname,gtype,cret)
  print *,cret
  if (cret .ne. 0 ) then
     print *,'Read grid type'
     call efexit(-1)
  endif
  print *,"grid type =", gtype

  ! close file **
  call mficlo(fid,cret)
  print *,cret
  if (cret .ne. 0 ) then
     print *,'ERROR :  close file'
     call efexit(-1)
  endif

end program UsesCase_MEDmesh_5


