""" An editor in the workarea. """


# Major package imports.
import logging
import wx

# Enthought library imports.
from enthought.traits.api import Property, Str

# Local imports.
from workarea_window import WorkareaWindow


# Setup a logger for this module.
logger=logging.getLogger(__name__)


####
#### FIXME - This is in the wrong place.  Needs to move to the resource plugin.
####

class Editor(WorkareaWindow):
    """ An editor in the workarea. """

    #### 'Editor' interface ###################################################

    # The resource that the editor is creating/editing.
    resource = Property

    # The name where the resource is bound in the namespace.
    resource_name = Str

    ###########################################################################
    # 'Window' interface.
    ###########################################################################

    def open(self):
        """ Opens the window. """

        super(Editor, self).open()

        # Use the image that represents the resource being edited as the icon
        # in the editor frame.
        #
        # fixme: This is MDI specific!
        if self.resource is not None:
            application = self.workbench_window.plugin.application
            resource_manager = application.get_service(
                'enthought.envisage.resource.IResourceManager',
            )

            resource_type = resource_manager.get_type_of(self.resource)
            if resource_type is not None:
                bmp = resource_type.node_type.image.create_bitmap()

                icon = wx.EmptyIcon()
                icon.CopyFromBitmap(bmp)

                self.control.SetIcon(icon)

        # Give the focus to the first control in the actual editor.
        #
        # fixme: There should be a cleaner way to do this!
        children = self.control.GetChildren()
        if len(children) > 0:
            children[0].SetFocus()

        return

    ###########################################################################
    # Editor interface.
    ###########################################################################

    #### Properties ###########################################################

    def _get_resource(self):
        """ Get the resource property. """

        return self._get_resource_real()

    def _set_resource(self, resource):
        """ Set the resource property. """

        self._set_resource_real(resource)


    #### Methods ##############################################################

    def get_auxillary_views(self):
        """ Get additional views that should be displayed with the editor. """

        return []

    def _get_resource_real(self):
        # TODO : For historical reasons, we permit editors to not actually
        #        create a resource.
        logger.warn('Editor failed to provide resource.')
        logger.warn('Override _get_resource or use WorkareaWindow.')

        return None


    def _set_resource_real(self, resource):
        """ Called when someone tries to set a resource on this editor. """
        logger.warn('Override _get_resource_real and _set_resource_real ' + \
            'if you want to set resources on your editor.')


#### EOF ######################################################################
