""" The resource type for Python objects. """


# Standard library imports.
import cPickle

# Enthought library imports.
from enthought.traits.api import Any

# Local imports.
from object_node_type import ObjectNodeType
from resource_type import ResourceType


class ObjectResourceType(ResourceType):
    """ The resource type for Python objects. """

    #### 'ResourceType' interface #############################################

    # A trait that describes the kind of domain object that the resource type
    # represents.
    type = Any

    ###########################################################################
    # 'ResourceType' interface.
    ###########################################################################

    #### Initializers #########################################################

    def _node_type_default(self):
        """ Initializes the node type. """

        return ObjectNodeType(resource_type=self)

    #### Methods ##############################################################
    
    def clone(self, obj):
        """ Returns a clone of an object. """

        # fixme: Should we have a default implementation here?  It seems kinda
        # dangerous since people will not have to think about cloning their
        # objects and pickle will 'appear' to work.  It is extremely useful
        # for primitive Python types etc.
        return cPickle.loads(cPickle.dumps(obj))

    def copy(self, context, name, obj):
        """ Copies a resource into the specified context. """

        context.bind(name, obj)

        return
    
#### EOF ######################################################################
