""" The initial context factory for workspace contexts. """


# Enthought library imports.
from enthought.envisage.resource import ResourceManager
from enthought.naming.api import Context, InitialContextFactory, NamingError 
from enthought.naming.api import ObjectSerializer, PyFSContext, PyFSContextFactory
from enthought.naming.api import PyFSObjectFactory, PyFSStateFactory

# Local imports.
from workspace import Workspace


class WorkspaceInitialContextFactory(InitialContextFactory):
    """ The initial context factory for workspace contexts. """

    ###########################################################################
    # 'InitialContextFactory' interface.
    ###########################################################################

    def get_initial_context(self, environment):
        """ Creates an initial context for beginning name resolution. """

        # The environment MUST have the root set.
        root = environment.get('root', None)
        if root is None:
            raise NamingError("no 'root' set in environment")
        
        # The default object factories.
        object_factories = [
            PyFSObjectFactory(), PyFSContextFactory()
        ]

        environment[Context.OBJECT_FACTORIES] = object_factories

        # The default state factory.
        state_factories = [
            PyFSStateFactory()
        ]
        
        environment[Context.STATE_FACTORIES] = state_factories

        # fixme: Bootstrap problem... SHould we put the plugin or application
        # into the environment?
        application = environment['application']
        
        # Tyep manager.
        type_manager = application.service_registry.get_service(
            'enthought.envisage.core.ITypeManager'
        )
        environment[Context.TYPE_MANAGER] = type_manager
        
        # Object serializers.
        resource_manager = application.service_registry.get_service(
            'enthought.envisage.resource.IResourceManager'
        )
        
        object_serializers = []
        for resource_type in resource_manager.resource_types:
            if resource_type.serializer is not None:
                object_serializers.append(resource_type.serializer)

        # fixme: Should we have to explicitly add this?!?
        object_serializers.append(ObjectSerializer())

        environment[PyFSContext.OBJECT_SERIALIZERS] = object_serializers

        # Filters.
        environment[PyFSContext.FILTERS] = [
            PyFSContext.ATTRIBUTES_FILE, '.svn'
        ]

        return Workspace(path=root, environment=environment)

#### EOF ######################################################################
