""" Tests a simple use of the application registry. """


# Standard library imports.
import os, sys, unittest

# Enthought library imports.
from enthought.envisage import Application

# Use of import application at this point results in application being None even after
# setUp runs. 
#from enthought.envisage import application

# Local imports.


class SimpleRegistryTestCase(unittest.TestCase):
    """ Tests a simple use of the application registry. """

    ###########################################################################
    # 'TestCase' interface. 
    ###########################################################################

    def setUp(self):
        """ Prepares the test fixture before each test method is called. """

        self.application = Application(
            argv               = sys.argv,
            requires_gui       = False
        )

        self.application.start()

        return 

    def tearDown(self):
        """ Called immediately after each test method has been called. """

        self.application.stop()

        return
    
    ###########################################################################
    # Tests.
    ###########################################################################

    def test_start(self):
        """ start the simple test plugin """

        from enthought.envisage import application, get_application
        # Make sure the simple plugin was created and started.
        self.assert_(application is not None)
        self.assert_(application.service_registry is not None)
        self.assert_(get_application() is not None)
        self.assert_(get_application().service_registry is not None)

        return
    
    def test_reset_application(self):
        from enthought.envisage import application, get_application
        app = get_application()
        self.assert_(get_application() is not None)

        self.setUp()
        new_app = get_application()
        self.assert_(get_application() is not None)
        self.assertNotEqual( app, new_app)
        
        # expected odd python behavior; that's why we use get_application
        self.assertEqual( app, application )
        return

        
### EOF #######################################################################        
