/* This file is part of the KDE project

   Copyright (C) 2006-2007 KovoKs <info@kovoks.nl>
   Copyright (C) 2007 Frode M. Døving <frode@lnix.net>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/


#ifndef GLOBAL_H
#define GLOBAL_H

#include <qobject.h>
#include <kabc/stdaddressbook.h>

namespace Mailody {

using namespace KABC;

/**
 * @class Global
 * This class consists of a few commonly used routines and values.
 * @author Tom Albers <tomalbers@kde.nl>
 */
class Global : public QObject
{
    Q_OBJECT
    public:
        /** Default constructor. */
        Global( QObject *parent = 0, const char *name = 0 );

        /** Default destructor. */
        ~Global();

        /**
         * Returns an instance of RSIGlobals. Never create your own instance
         * of RSIGlobals, but use this method instead to get the one and only
         * instance.
         */
        static Global *instance();

        /**
         * Will return the identites cached and not updated
         * during lifetime unless @p force is true
         * @param force refresh
         */
        static QStringList identities( bool refresh=false );
        static bool myEmail( const QString& email, bool refresh=false );
        static QString getIdentityForEmail( const QString& email );
        static void convertOldSmtpToIdentities();
        /**
         * will return true when it is possible to use SSL or TLS
         */
        static bool cryptoConnectionSupported();

        /**
         * Will print the ms between @p tv1 and @p tv2 with the
         * comment @p text. Use it like:
         *   #include <sys/time.h>
         *
         *   struct timeval tv1, tv2;
         *   gettimeofday(&tv1, 0);
         *   .. expensive stuff ...
         *   gettimeofday(&tv2, 0);
         *   Global::timing("expensive stuff", tv1, tv2);
         */
        static void timing(const QString& text, struct timeval tv1,
                           struct timeval tv2);

        /**
         * this will color each paragraph with a color depending on the
         * quotatation level.
         */
        static QString highlightText(const QString& text);

        /** this will color the text with a color depending on the quotation
         * level
         */
        static QString highlightParagraph( const QString& text);

    private:
        static Global* m_instance;
};

}

#endif
