/* Generated by GOB (v2.0.15)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 15

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "mn-gmime-stream-vfs.h"

#include "mn-gmime-stream-vfs-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 25 "src/mn-gmime-stream-vfs.gob"

#include <glib/gi18n.h>
#include "mn-vfs.h"

#define VFS_CALL(stream, expr, fail_format, fail_retval)		\
  {									\
    GnomeVFSResult result;						\
									\
    result = expr;							\
    if (result != GNOME_VFS_OK)						\
      {									\
	(stream)->_priv->eof = TRUE;					\
	if (result != GNOME_VFS_ERROR_EOF)				\
	  {								\
	    g_warning((fail_format),					\
		      (stream)->_priv->uri,				\
		      gnome_vfs_result_to_string(result));		\
	    return (fail_retval);					\
	  }								\
      }									\
  }

#define VFS_READ(stream, buffer, bytes, bytes_read, fail_retval) \
  VFS_CALL((stream), gnome_vfs_read((stream)->_priv->handle, (buffer), (bytes), (bytes_read)), _("unable to read %s: %s"), (fail_retval))
#define VFS_WRITE(stream, buffer, bytes, bytes_written, fail_retval) \
  VFS_CALL((stream), gnome_vfs_write((stream)->_priv->handle, (buffer), (bytes), (bytes_written)), _("unable to write to %s: %s"), (fail_retval))
#define VFS_SEEK(stream, whence, offset, fail_retval) \
  VFS_CALL((stream), gnome_vfs_seek((stream)->_priv->handle, (whence), (offset)), _("unable to seek in %s: %s"), (fail_retval))
#define VFS_TELL(stream, offset_return, fail_retval) \
  VFS_CALL((stream), gnome_vfs_tell((stream)->_priv->handle, (offset_return)), _("unable to tell position of %s: %s"), (fail_retval))
#define VFS_CLOSE(stream, fail_retval) \
  VFS_CALL((stream), gnome_vfs_close((stream)->_priv->handle), _("unable to close %s: %s"), (fail_retval))

#line 60 "mn-gmime-stream-vfs.c"
/* self casting macros */
#define SELF(x) MN_GMIME_STREAM_VFS(x)
#define SELF_CONST(x) MN_GMIME_STREAM_VFS_CONST(x)
#define IS_SELF(x) MN_IS_GMIME_STREAM_VFS(x)
#define TYPE_SELF MN_TYPE_GMIME_STREAM_VFS
#define SELF_CLASS(x) MN_GMIME_STREAM_VFS_CLASS(x)

#define SELF_GET_CLASS(x) MN_GMIME_STREAM_VFS_GET_CLASS(x)

/* self typedefs */
typedef MNGMimeStreamVFS Self;
typedef MNGMimeStreamVFSClass SelfClass;

/* here are local prototypes */
#line 0 "src/mn-gmime-stream-vfs.gob"
static void mn_gmime_stream_vfs_init (MNGMimeStreamVFS * o);
#line 77 "mn-gmime-stream-vfs.c"
#line 0 "src/mn-gmime-stream-vfs.gob"
static void mn_gmime_stream_vfs_class_init (MNGMimeStreamVFSClass * c);
#line 80 "mn-gmime-stream-vfs.c"
#line 67 "src/mn-gmime-stream-vfs.gob"
static void mn_gmime_stream_vfs_finalize (MNGMimeStreamVFS * self);
#line 83 "mn-gmime-stream-vfs.c"
#line 73 "src/mn-gmime-stream-vfs.gob"
static ssize_t ___2_mn_gmime_stream_vfs_read (GMimeStream * stream, char * buf, size_t len);
#line 86 "mn-gmime-stream-vfs.c"
#line 93 "src/mn-gmime-stream-vfs.gob"
static ssize_t ___3_mn_gmime_stream_vfs_write (GMimeStream * stream, const char * buf, size_t len);
#line 89 "mn-gmime-stream-vfs.c"
#line 113 "src/mn-gmime-stream-vfs.gob"
static int ___4_mn_gmime_stream_vfs_flush (GMimeStream * stream);
#line 92 "mn-gmime-stream-vfs.c"
#line 120 "src/mn-gmime-stream-vfs.gob"
static int ___5_mn_gmime_stream_vfs_close (GMimeStream * stream);
#line 95 "mn-gmime-stream-vfs.c"
#line 130 "src/mn-gmime-stream-vfs.gob"
static gboolean ___6_mn_gmime_stream_vfs_eos (GMimeStream * stream);
#line 98 "mn-gmime-stream-vfs.c"
#line 141 "src/mn-gmime-stream-vfs.gob"
static int ___7_mn_gmime_stream_vfs_reset (GMimeStream * stream);
#line 101 "mn-gmime-stream-vfs.c"
#line 155 "src/mn-gmime-stream-vfs.gob"
static off_t ___8_mn_gmime_stream_vfs_seek (GMimeStream * stream, off_t offset, GMimeSeekWhence whence);
#line 104 "mn-gmime-stream-vfs.c"
#line 200 "src/mn-gmime-stream-vfs.gob"
static off_t ___9_mn_gmime_stream_vfs_tell (GMimeStream * stream);
#line 107 "mn-gmime-stream-vfs.c"
#line 206 "src/mn-gmime-stream-vfs.gob"
static ssize_t ___a_mn_gmime_stream_vfs_length (GMimeStream * stream);
#line 110 "mn-gmime-stream-vfs.c"
#line 225 "src/mn-gmime-stream-vfs.gob"
static GMimeStream * ___b_mn_gmime_stream_vfs_substream (GMimeStream * stream, off_t start, off_t end);
#line 113 "mn-gmime-stream-vfs.c"

/* pointer to the class of our parent */
static GMimeStreamClass *parent_class = NULL;

/* Short form macros */
#define self_new mn_gmime_stream_vfs_new
GType
mn_gmime_stream_vfs_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNGMimeStreamVFSClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_gmime_stream_vfs_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNGMimeStreamVFS),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_gmime_stream_vfs_init,
			NULL
		};

		type = g_type_register_static (GMIME_TYPE_STREAM, "MNGMimeStreamVFS", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNGMimeStreamVFS *)g_object_new(mn_gmime_stream_vfs_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNGMimeStreamVFS * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNGMimeStreamVFS *
GET_NEW_VARG (const char *first, ...)
{
	MNGMimeStreamVFS *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNGMimeStreamVFS *)g_object_new_valist (mn_gmime_stream_vfs_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:GMime:Stream:VFS::finalize"
	MNGMimeStreamVFS *self G_GNUC_UNUSED = MN_GMIME_STREAM_VFS (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
#line 67 "src/mn-gmime-stream-vfs.gob"
	mn_gmime_stream_vfs_finalize (self);
#line 171 "mn-gmime-stream-vfs.c"
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#line 64 "src/mn-gmime-stream-vfs.gob"
	if(self->_priv->uri) { g_free ((gpointer) self->_priv->uri); self->_priv->uri = NULL; }
#line 176 "mn-gmime-stream-vfs.c"
}
#undef __GOB_FUNCTION__

static void 
mn_gmime_stream_vfs_init (MNGMimeStreamVFS * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:GMime:Stream:VFS::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,MN_TYPE_GMIME_STREAM_VFS,MNGMimeStreamVFSPrivate);
}
#undef __GOB_FUNCTION__
static void 
mn_gmime_stream_vfs_class_init (MNGMimeStreamVFSClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:GMime:Stream:VFS::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;
	GMimeStreamClass *gmime_stream_class = (GMimeStreamClass *)c;

	g_type_class_add_private(c,sizeof(MNGMimeStreamVFSPrivate));

	parent_class = g_type_class_ref (GMIME_TYPE_STREAM);

#line 73 "src/mn-gmime-stream-vfs.gob"
	gmime_stream_class->read = ___2_mn_gmime_stream_vfs_read;
#line 93 "src/mn-gmime-stream-vfs.gob"
	gmime_stream_class->write = ___3_mn_gmime_stream_vfs_write;
#line 113 "src/mn-gmime-stream-vfs.gob"
	gmime_stream_class->flush = ___4_mn_gmime_stream_vfs_flush;
#line 120 "src/mn-gmime-stream-vfs.gob"
	gmime_stream_class->close = ___5_mn_gmime_stream_vfs_close;
#line 130 "src/mn-gmime-stream-vfs.gob"
	gmime_stream_class->eos = ___6_mn_gmime_stream_vfs_eos;
#line 141 "src/mn-gmime-stream-vfs.gob"
	gmime_stream_class->reset = ___7_mn_gmime_stream_vfs_reset;
#line 155 "src/mn-gmime-stream-vfs.gob"
	gmime_stream_class->seek = ___8_mn_gmime_stream_vfs_seek;
#line 200 "src/mn-gmime-stream-vfs.gob"
	gmime_stream_class->tell = ___9_mn_gmime_stream_vfs_tell;
#line 206 "src/mn-gmime-stream-vfs.gob"
	gmime_stream_class->length = ___a_mn_gmime_stream_vfs_length;
#line 225 "src/mn-gmime-stream-vfs.gob"
	gmime_stream_class->substream = ___b_mn_gmime_stream_vfs_substream;
#line 218 "mn-gmime-stream-vfs.c"
	g_object_class->finalize = ___finalize;
}
#undef __GOB_FUNCTION__



#line 67 "src/mn-gmime-stream-vfs.gob"
static void 
mn_gmime_stream_vfs_finalize (MNGMimeStreamVFS * self)
{
#line 229 "mn-gmime-stream-vfs.c"
#define __GOB_FUNCTION__ "MN:GMime:Stream:VFS::finalize"
{
#line 68 "src/mn-gmime-stream-vfs.gob"
	
    if (selfp->handle_owned)
      g_mime_stream_close(GMIME_STREAM(self));
  }}
#line 237 "mn-gmime-stream-vfs.c"
#undef __GOB_FUNCTION__

#line 73 "src/mn-gmime-stream-vfs.gob"
static ssize_t 
___2_mn_gmime_stream_vfs_read (GMimeStream * stream G_GNUC_UNUSED, char * buf, size_t len)
#line 243 "mn-gmime-stream-vfs.c"
#define PARENT_HANDLER(___stream,___buf,___len) \
	((GMIME_STREAM_CLASS(parent_class)->read)? \
		(* GMIME_STREAM_CLASS(parent_class)->read)(___stream,___buf,___len): \
		((ssize_t )0))
{
#define __GOB_FUNCTION__ "MN:GMime:Stream:VFS::read"
{
#line 75 "src/mn-gmime-stream-vfs.gob"
	
    Self *self = SELF(stream);
    GnomeVFSFileSize bytes_read;

    if (stream->bound_end != -1 && stream->position >= stream->bound_end)
      return -1;
    if (stream->bound_end != -1)
      len = MIN(stream->bound_end - stream->position, (off_t) len);

    /* make sure we are at the right position */
    VFS_SEEK(self, GNOME_VFS_SEEK_START, stream->position, -1);

    VFS_READ(self, buf, len, &bytes_read, -1);
    stream->position += bytes_read;

    return bytes_read;
  }}
#line 269 "mn-gmime-stream-vfs.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 93 "src/mn-gmime-stream-vfs.gob"
static ssize_t 
___3_mn_gmime_stream_vfs_write (GMimeStream * stream G_GNUC_UNUSED, const char * buf, size_t len)
#line 276 "mn-gmime-stream-vfs.c"
#define PARENT_HANDLER(___stream,___buf,___len) \
	((GMIME_STREAM_CLASS(parent_class)->write)? \
		(* GMIME_STREAM_CLASS(parent_class)->write)(___stream,___buf,___len): \
		((ssize_t )0))
{
#define __GOB_FUNCTION__ "MN:GMime:Stream:VFS::write"
{
#line 95 "src/mn-gmime-stream-vfs.gob"
	
    Self *self = SELF(stream);
    GnomeVFSFileSize bytes_written;

    if (stream->bound_end != -1 && stream->position >= stream->bound_end)
      return -1;
    if (stream->bound_end != -1)
      len = MIN(stream->bound_end - stream->position, (off_t) len);

    /* make sure we are at the right position */
    VFS_SEEK(self, GNOME_VFS_SEEK_START, stream->position, -1);

    VFS_WRITE(self, buf, len, &bytes_written, -1);
    stream->position += bytes_written;

    return bytes_written;
  }}
#line 302 "mn-gmime-stream-vfs.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 113 "src/mn-gmime-stream-vfs.gob"
static int 
___4_mn_gmime_stream_vfs_flush (GMimeStream * stream G_GNUC_UNUSED)
#line 309 "mn-gmime-stream-vfs.c"
#define PARENT_HANDLER(___stream) \
	((GMIME_STREAM_CLASS(parent_class)->flush)? \
		(* GMIME_STREAM_CLASS(parent_class)->flush)(___stream): \
		((int )0))
{
#define __GOB_FUNCTION__ "MN:GMime:Stream:VFS::flush"
{
#line 115 "src/mn-gmime-stream-vfs.gob"
	
    /* nop */
    return 0;			/* success */
  }}
#line 322 "mn-gmime-stream-vfs.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 120 "src/mn-gmime-stream-vfs.gob"
static int 
___5_mn_gmime_stream_vfs_close (GMimeStream * stream G_GNUC_UNUSED)
#line 329 "mn-gmime-stream-vfs.c"
#define PARENT_HANDLER(___stream) \
	((GMIME_STREAM_CLASS(parent_class)->close)? \
		(* GMIME_STREAM_CLASS(parent_class)->close)(___stream): \
		((int )0))
{
#define __GOB_FUNCTION__ "MN:GMime:Stream:VFS::close"
{
#line 122 "src/mn-gmime-stream-vfs.gob"
	
    Self *self = SELF(stream);

    VFS_CLOSE(self, -1);

    return 0;			/* success */
  }}
#line 345 "mn-gmime-stream-vfs.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 130 "src/mn-gmime-stream-vfs.gob"
static gboolean 
___6_mn_gmime_stream_vfs_eos (GMimeStream * stream G_GNUC_UNUSED)
#line 352 "mn-gmime-stream-vfs.c"
#define PARENT_HANDLER(___stream) \
	((GMIME_STREAM_CLASS(parent_class)->eos)? \
		(* GMIME_STREAM_CLASS(parent_class)->eos)(___stream): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "MN:GMime:Stream:VFS::eos"
{
#line 132 "src/mn-gmime-stream-vfs.gob"
	
    Self *self = SELF(stream);

    if (stream->bound_end == -1)
      return selfp->eof;
    else
      return stream->position >= stream->bound_end;
  }}
#line 369 "mn-gmime-stream-vfs.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 141 "src/mn-gmime-stream-vfs.gob"
static int 
___7_mn_gmime_stream_vfs_reset (GMimeStream * stream G_GNUC_UNUSED)
#line 376 "mn-gmime-stream-vfs.c"
#define PARENT_HANDLER(___stream) \
	((GMIME_STREAM_CLASS(parent_class)->reset)? \
		(* GMIME_STREAM_CLASS(parent_class)->reset)(___stream): \
		((int )0))
{
#define __GOB_FUNCTION__ "MN:GMime:Stream:VFS::reset"
{
#line 143 "src/mn-gmime-stream-vfs.gob"
	
    Self *self = SELF(stream);

    if (stream->position == stream->bound_start)
      return 0;

    VFS_SEEK(self, GNOME_VFS_SEEK_START, stream->bound_start, -1);
    stream->position = stream->bound_start;

    return 0;
  }}
#line 396 "mn-gmime-stream-vfs.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 155 "src/mn-gmime-stream-vfs.gob"
static off_t 
___8_mn_gmime_stream_vfs_seek (GMimeStream * stream G_GNUC_UNUSED, off_t offset, GMimeSeekWhence whence)
#line 403 "mn-gmime-stream-vfs.c"
#define PARENT_HANDLER(___stream,___offset,___whence) \
	((GMIME_STREAM_CLASS(parent_class)->seek)? \
		(* GMIME_STREAM_CLASS(parent_class)->seek)(___stream,___offset,___whence): \
		((off_t )0))
{
#define __GOB_FUNCTION__ "MN:GMime:Stream:VFS::seek"
{
#line 157 "src/mn-gmime-stream-vfs.gob"
	
    Self *self = SELF(stream);
    off_t real = stream->position;

    switch (whence)
      {
      case GMIME_STREAM_SEEK_SET:
	real = offset;
	break;

      case GMIME_STREAM_SEEK_CUR:
	real = stream->position + offset;
	break;

      case GMIME_STREAM_SEEK_END:
	if (stream->bound_end == -1)
	  {
	    GnomeVFSFileSize current_position;

	    VFS_SEEK(self, GNOME_VFS_SEEK_END, offset, -1);
	    VFS_TELL(self, &current_position, -1);

	    real = current_position;
	    if (real < stream->bound_start)
	      real = stream->bound_start;
	    stream->position = real;

	    return real;
	  }
	real = stream->bound_end + offset;
	break;
      }

    if (stream->bound_end != -1)
      real = MIN(real, stream->bound_end);
    real = MAX(real, stream->bound_start);

    VFS_SEEK(self, GNOME_VFS_SEEK_START, real, -1);
    stream->position = real;

    return real;
  }}
#line 454 "mn-gmime-stream-vfs.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 200 "src/mn-gmime-stream-vfs.gob"
static off_t 
___9_mn_gmime_stream_vfs_tell (GMimeStream * stream G_GNUC_UNUSED)
#line 461 "mn-gmime-stream-vfs.c"
#define PARENT_HANDLER(___stream) \
	((GMIME_STREAM_CLASS(parent_class)->tell)? \
		(* GMIME_STREAM_CLASS(parent_class)->tell)(___stream): \
		((off_t )0))
{
#define __GOB_FUNCTION__ "MN:GMime:Stream:VFS::tell"
{
#line 202 "src/mn-gmime-stream-vfs.gob"
	
    return stream->position;
  }}
#line 473 "mn-gmime-stream-vfs.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 206 "src/mn-gmime-stream-vfs.gob"
static ssize_t 
___a_mn_gmime_stream_vfs_length (GMimeStream * stream G_GNUC_UNUSED)
#line 480 "mn-gmime-stream-vfs.c"
#define PARENT_HANDLER(___stream) \
	((GMIME_STREAM_CLASS(parent_class)->length)? \
		(* GMIME_STREAM_CLASS(parent_class)->length)(___stream): \
		((ssize_t )0))
{
#define __GOB_FUNCTION__ "MN:GMime:Stream:VFS::length"
{
#line 208 "src/mn-gmime-stream-vfs.gob"
	
    Self *self = SELF(stream);
    GnomeVFSFileSize bound_end;

    if (stream->bound_start != -1 && stream->bound_end != -1)
      return stream->bound_end - stream->bound_start;

    VFS_SEEK(self, GNOME_VFS_SEEK_END, 0, -1);
    VFS_TELL(self, &bound_end, -1);
    VFS_SEEK(self, GNOME_VFS_SEEK_START, stream->position, -1);

    if (bound_end < stream->bound_start)
      return -1;

    return bound_end - stream->bound_start;
  }}
#line 505 "mn-gmime-stream-vfs.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 225 "src/mn-gmime-stream-vfs.gob"
static GMimeStream * 
___b_mn_gmime_stream_vfs_substream (GMimeStream * stream G_GNUC_UNUSED, off_t start, off_t end)
#line 512 "mn-gmime-stream-vfs.c"
#define PARENT_HANDLER(___stream,___start,___end) \
	((GMIME_STREAM_CLASS(parent_class)->substream)? \
		(* GMIME_STREAM_CLASS(parent_class)->substream)(___stream,___start,___end): \
		((GMimeStream * )0))
{
#define __GOB_FUNCTION__ "MN:GMime:Stream:VFS::substream"
{
#line 227 "src/mn-gmime-stream-vfs.gob"
	
    Self *self;

    self = GET_NEW;
    selfp->handle = SELF(stream)->_priv->handle;
    /* handle of the substream is not owned */

    g_mime_stream_construct(GMIME_STREAM(self), start, end);

    return GMIME_STREAM(self);
  }}
#line 532 "mn-gmime-stream-vfs.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 242 "src/mn-gmime-stream-vfs.gob"
GMimeStream * 
mn_gmime_stream_vfs_new (GnomeVFSHandle * handle, GnomeVFSURI * uri, GnomeVFSResult * result)
{
#line 540 "mn-gmime-stream-vfs.c"
#define __GOB_FUNCTION__ "MN:GMime:Stream:VFS::new"
#line 242 "src/mn-gmime-stream-vfs.gob"
	g_return_val_if_fail (handle != NULL, (GMimeStream * )0);
#line 242 "src/mn-gmime-stream-vfs.gob"
	g_return_val_if_fail (uri != NULL, (GMimeStream * )0);
#line 546 "mn-gmime-stream-vfs.c"
{
#line 246 "src/mn-gmime-stream-vfs.gob"
	
    GMimeStream *stream;
    GnomeVFSResult _result;
    GnomeVFSFileSize current_position;

    if (gnome_vfs_seek(handle, GNOME_VFS_SEEK_CURRENT, 0) != GNOME_VFS_OK
	|| gnome_vfs_tell(handle, &current_position) != GNOME_VFS_OK)
      {
	char *buf;
	int size;

	/* unseekable or untellable file, use a GMimeStreamMem */

	_result = mn_vfs_read_entire_file_uri(uri, &size, &buf);
	if (_result == GNOME_VFS_OK)
	  {
	    stream = g_mime_stream_mem_new_with_buffer(buf, size);
	    g_free(buf);
	  }
	else
	  stream = NULL;

	gnome_vfs_close(handle);
      }
    else
      {
	Self *self;

	_result = GNOME_VFS_OK;

	self = GET_NEW;
	selfp->handle = handle;
	selfp->handle_owned = TRUE;
	selfp->uri = gnome_vfs_uri_to_string(uri, GNOME_VFS_URI_HIDE_NONE);

	stream = GMIME_STREAM(self);
	g_mime_stream_construct(stream, current_position, -1);

	/* check for EOF */
	if (g_mime_stream_length(stream) <= 0)
	  selfp->eof = TRUE;
      }

    if (result)
      *result = _result;

    return stream;
  }}
#line 597 "mn-gmime-stream-vfs.c"
#undef __GOB_FUNCTION__
