/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file IntervalSelectionTypeAttributes.h
    \brief Definition of IntervalSelectionType Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Tue Nov 22 10:53:38 2011
*/
   

#ifndef IntervalSelectionTypeAttributes_H
#define IntervalSelectionTypeAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"



namespace magics {

class XmlNode;



class IntervalSelectionTypeAttributes 
{
public:
//  --  constructor
    IntervalSelectionTypeAttributes();
    
//  --  destructor
    virtual ~IntervalSelectionTypeAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const IntervalSelectionTypeAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief  Contour level from which contour interval is calculated 
    \param reference Setting contour_reference_level - default=0.0
*/
	void setReference(double reference) 
		{ reference_ =  reference; } 
	double getReference() const 
		{ return reference_; } 
        
/*!
    Magics Information:
    \brief  Interval in data units between two contour lines 
    \param interval Setting contour_interval - default=8.0
*/
	void setInterval(double interval) 
		{ interval_ =  interval; } 
	double getInterval() const 
		{ return interval_; } 
        
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	double reference_;
	double interval_;

private:
  
	friend ostream& operator<<(ostream& s,const IntervalSelectionTypeAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
