/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file PageIDAttributes.h
    \brief Definition of PageID Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Tue Nov 22 10:53:39 2011
*/
   

#ifndef PageIDAttributes_H
#define PageIDAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"


#include "LogoPlotting.h"
#include "Colour.h"

namespace magics {

class XmlNode;



class PageIDAttributes 
{
public:
//  --  constructor
    PageIDAttributes();
    
//  --  destructor
    virtual ~PageIDAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const PageIDAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief  Height of identification line
    \param height Setting page_id_line_height - default=0.25
*/
	void setHeight(double height) 
		{ height_ =  height; } 
	double getHeight() const 
		{ return height_; } 
        
/*!
    Magics Information:
    \brief  Colour of identification line. Default based on page_y_length
    \param colour Setting page_id_line_colour - default=blue
*/
	void setColour(Colour* colour) 
		{ auto_ptr<Colour> tmp(colour); colour_ = tmp; } 
	const Colour&  getColour() const 
		{ return *colour_; }
/*!
    Magics Information:
    \brief Display magics version in identification line (ON/OFF)
    \param magics Setting page_id_line_magics - default=on
*/
	void setMagics(bool magics) 
		{ magics_ =  magics; } 
	bool getMagics() const 
		{ return magics_; } 
        
/*!
    Magics Information:
    \brief  User-supplied text for inclusion in identification line 
    \param user_text Setting page_id_line_user_text - default=
*/
	void setUser_text(const string& user_text) 
		{ user_text_ =  user_text; } 
	const string& getUser_text() const 
		{ return user_text_; } 
        
/*!
    Magics Information:
    \brief  Plot system part of the identification line (ON/OFF) 
    \param system Setting page_id_line_system_plot - default=on
*/
	void setSystem(bool system) 
		{ system_ =  system; } 
	bool getSystem() const 
		{ return system_; } 
        
/*!
    Magics Information:
    \brief  Plot date part of the identification line (ON/OFF) 
    \param date Setting page_id_line_date_plot - default=on
*/
	void setDate(bool date) 
		{ date_ =  date; } 
	bool getDate() const 
		{ return date_; } 
        
/*!
    Magics Information:
    \brief  Plot error part of the identification line (ON/OFF) 
    \param errors Setting page_id_line_errors_plot - default=on
*/
	void setErrors(bool errors) 
		{ errors_ =  errors; } 
	bool getErrors() const 
		{ return errors_; } 
        
/*!
    Magics Information:
    \brief  Plot user text part of the identification line (ON/OFF) 
    \param text Setting page_id_line_user_text_plot - default=on
*/
	void setText(bool text) 
		{ text_ =  text; } 
	bool getText() const 
		{ return text_; } 
        
/*!
    Magics Information:
    \brief Plot logo part of the identification line (ON/OFF)
    \param logo Setting page_id_line_logo_plot - default=on
*/
	void setLogo(NoLogoPlotting* logo) 
		{ auto_ptr<NoLogoPlotting> tmp(logo); logo_ = tmp; } 
	const NoLogoPlotting&  getLogo() const 
		{ return *logo_; }
/*!
    Magics Information:
    \brief  Font to be used 
    \param font Setting page_id_line_font - default=sansserif
*/
	void setFont(const string& font) 
		{ font_ =  font; } 
	const string& getFont() const 
		{ return font_; } 
        
/*!
    Magics Information:
    \brief  Style of the Font to be used 
    \param font_style Setting page_id_line_font_style - default=normal
*/
	void setFont_style(const string& font_style) 
		{ font_style_ =  font_style; } 
	const string& getFont_style() const 
		{ return font_style_; } 
        
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	double height_;
	auto_ptr<Colour> colour_;
	bool magics_;
	string user_text_;
	bool system_;
	bool date_;
	bool errors_;
	bool text_;
	auto_ptr<NoLogoPlotting> logo_;
	string font_;
	string font_style_;

private:
  
	friend ostream& operator<<(ostream& s,const PageIDAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
