/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file HiLoAttributes.h
    \brief Definition of HiLo Attributes class.
    \author Graphics Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Thu Jun 16 12:02:56 2011
*/
   

#ifndef HiLoAttributes_H
#define HiLoAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"


#include "HiLoSaveBase.h"
#include "HiLoTechnique.h"
#include "HiLoMarkerBase.h"

namespace magics {

class XmlNode;


template <class P>
class HiLoAttributes 
{
public:
//  --  constructor
    HiLoAttributes();
    
//  --  destructor
    virtual ~HiLoAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const HiLoAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief  Type of high/low (TEXT/NUMBER/BOTH) 
    \param type Setting contour_hilo_type - default=text
*/
	void setType(HiLoTechnique<P> * type) 
		{ auto_ptr<HiLoTechnique<P> > tmp(type); type_ = tmp; } 
	const HiLoTechnique<P> &  getType() const 
		{ return *type_; }
/*!
    Magics Information:
    \brief  Size of the window used to calculate the Hi/Lo 
    \param window_size Setting contour_hilo_window_size - default=3
*/
	void setWindow_size(int window_size) 
		{ window_size_ =  window_size; } 
	int getWindow_size() const 
		{ return window_size_; } 
        
/*!
    Magics Information:
    \brief  Radius of HILO search in grid points (default value is for global cylindrical map) 
    \param suppress_radius Setting contour_hilo_suppress_radius - default=15.0
*/
	void setSuppress_radius(double suppress_radius) 
		{ suppress_radius_ =  suppress_radius; } 
	double getSuppress_radius() const 
		{ return suppress_radius_; } 
        
/*!
    Magics Information:
    \brief  Local HILO above specified value are not drawn 
    \param hilo_max_value Setting contour_hilo_max_value - default=1.0e+21
*/
	void setHilo_max_value(double hilo_max_value) 
		{ hilo_max_value_ =  hilo_max_value; } 
	double getHilo_max_value() const 
		{ return hilo_max_value_; } 
        
/*!
    Magics Information:
    \brief  Local HILO below specified value are not drawn 
    \param hilo_min_value Setting contour_hilo_min_value - default=-1.0e+21
*/
	void setHilo_min_value(double hilo_min_value) 
		{ hilo_min_value_ =  hilo_min_value; } 
	double getHilo_min_value() const 
		{ return hilo_min_value_; } 
        
/*!
    Magics Information:
    \brief  Local HI above specified value are not drawn 
    \param hi_max_value Setting contour_hi_max_value - default=1.0e+21
*/
	void setHi_max_value(double hi_max_value) 
		{ hi_max_value_ =  hi_max_value; } 
	double getHi_max_value() const 
		{ return hi_max_value_; } 
        
/*!
    Magics Information:
    \brief  Local HI below specified value are not drawn 
    \param hi_min_value Setting contour_hi_min_value - default=-1.0e+21
*/
	void setHi_min_value(double hi_min_value) 
		{ hi_min_value_ =  hi_min_value; } 
	double getHi_min_value() const 
		{ return hi_min_value_; } 
        
/*!
    Magics Information:
    \brief  Local LO above specified value are not drawn 
    \param lo_max_value Setting contour_lo_max_value - default=1.0e+21
*/
	void setLo_max_value(double lo_max_value) 
		{ lo_max_value_ =  lo_max_value; } 
	double getLo_max_value() const 
		{ return lo_max_value_; } 
        
/*!
    Magics Information:
    \brief  Local LO below specified value are not drawn 
    \param lo_min_value Setting contour_lo_min_value - default=-1.0e+21
*/
	void setLo_min_value(double lo_min_value) 
		{ lo_min_value_ =  lo_min_value; } 
	double getLo_min_value() const 
		{ return lo_min_value_; } 
        
/*!
    Magics Information:
    \brief  Plot hilo marker (ON/OFF) 
    \param marker Setting contour_hilo_marker - default=off
*/
	void setMarker(HiLoMarkerBase<P> * marker) 
		{ auto_ptr<HiLoMarkerBase<P> > tmp(marker); marker_ = tmp; } 
	const HiLoMarkerBase<P> &  getMarker() const 
		{ return *marker_; }
/*!
    Magics Information:
    \brief  Write HILO values to file (ON/OFF) 
    \param position_write Setting contour_hilo_position_write - default=off
*/
	void setPosition_write(HiLoSaveBase<P> * position_write) 
		{ auto_ptr<HiLoSaveBase<P> > tmp(position_write); position_write_ = tmp; } 
	const HiLoSaveBase<P> &  getPosition_write() const 
		{ return *position_write_; }
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	auto_ptr<HiLoTechnique<P> > type_;
	int window_size_;
	double suppress_radius_;
	double hilo_max_value_;
	double hilo_min_value_;
	double hi_max_value_;
	double hi_min_value_;
	double lo_max_value_;
	double lo_min_value_;
	auto_ptr<HiLoMarkerBase<P> > marker_;
	auto_ptr<HiLoSaveBase<P> > position_write_;

private:
  
	friend ostream& operator<<(ostream& s,const HiLoAttributes<P>& p)
	{ p.print(s); return s; }
};

} // namespace magics
#include "HiLoAttributes.cc" 

#endif
