/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file CellShadingAttributes.h
    \brief Definition of CellShading Attributes class.
    \author Graphics Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Thu Jun 16 12:02:55 2011
*/
   

#ifndef CellShadingAttributes_H
#define CellShadingAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"



namespace magics {

class XmlNode;



class CellShadingAttributes 
{
public:
//  --  constructor
    CellShadingAttributes();
    
//  --  destructor
    virtual ~CellShadingAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const CellShadingAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief  Number of cells per cm for CELL shading 
    \param resolution Setting contour_shade_cell_resolution - default=10
*/
	void setResolution(double resolution) 
		{ resolution_ =  resolution; } 
	double getResolution() const 
		{ return resolution_; } 
        
/*!
    Magics Information:
    \brief  NMethod of determining the colour of a cell (INTERPOLATE/ NEAREST) 
    \param method Setting contour_shade_cell_method - default=nearest
*/
	void setMethod(string method) 
		{ method_ =  method; } 
	string getMethod() const 
		{ return method_; } 
        
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	double resolution_;
	string method_;

private:
  
	friend ostream& operator<<(ostream& s,const CellShadingAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
