/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file MgQLayoutNode.h
    \brief Definition of MgQLayoutNode.
    \author Graphics Section, ECMWF

    Started: Februaryr 2010
*/

#ifndef _MgQLayoutNode_H
#define _MgQLayoutNode_H

#include <magics.h>
#include <Layout.h>
#include <PaperPoint.h>

#include "MgQBaseNode.h"

//namespace magics 
//{

class MgQLayoutNode : public MgQBaseNode 
{
public:
	//OpenGLLayoutNode();
	MgQLayoutNode(QString,const Layout &);
	MgQLayoutNode(const MgQLayoutNode &);

	virtual QRectF boundingRect() const;

	const Layout& layout() {return layout_;};
	AnimationRules* animationRules() {return layout_.animationRules();};
	//void animationRules(AnimationRules *anr) {animationRules_=anr;};

	void  coordRatioX(double f) {coordRatioX_=f;};	 
	void  coordRatioY(double f) {coordRatioY_=f;};
	double coordRatioX() {return coordRatioX_;};	 
	double coordRatioY() {return coordRatioY_;};

	void  dimensionX(double f) {dimensionX_=f;};	 
	void  dimensionY(double f) {dimensionY_=f;};
	double dimensionX() {return dimensionX_;};	 
	double dimensionY() {return dimensionY_;};

	double projectedMinX() {return projectedMinX_;}
	void  projectedMinX(double f) {projectedMinX_=f;}
	double projectedMinY() {return projectedMinY_;}
	void  projectedMinY(double f) {projectedMinY_=f;}

	double projectedMaxX() {return projectedMaxX_;}
	void  projectedMaxX(double f) {projectedMaxX_=f;}
	double projectedMaxY() {return projectedMaxY_;}
	void  projectedMaxY(double f) {projectedMaxY_=f;}

	void  mapFromSceneToProjectionCoords(QPointF&,QPointF&) ;
	void  mapFromSceneToGeoCoords(const QPointF&,QPointF&); 
	void  mapFromSceneToGeoCoords(QRectF&,QList<QPointF>&); 
	void  mapFromGeoToSceneCoords(const QPointF&,QPointF&);
	bool containsSceneCoords(QPointF&);
	bool containsGeoCoords(QPointF&);
	bool containsPoint(QPointF&, qreal tolerance=0.0001);

	MgQBaseNode* parentItemInMainScene() {return parentItemInMainScene_;}
	void setParentItemInMainScene(MgQBaseNode* p) {parentItemInMainScene_=p;}

	void addToMainScene();

protected:
	const Layout& layout_;	

	double coordRatioX_;
	double coordRatioY_;
	
	double dimensionX_;	
	double dimensionY_;

	double projectedMinX_;
	double projectedMinY_;
	double projectedMaxX_;
	double projectedMaxY_;

	MgQBaseNode *parentItemInMainScene_;
	//AnimationRules *animationRules_;			
};


class MgQPreviewLayoutNode : public MgQLayoutNode
{
public:
	MgQPreviewLayoutNode(QString n,const Layout &l) : MgQLayoutNode(n,l)  {};
};

class MgQMagnifierLayoutNode : public MgQLayoutNode
{
public:
	MgQMagnifierLayoutNode(MgQLayoutNode*);
	MgQMagnifierLayoutNode(QString n,const Layout &l) : MgQLayoutNode(n,l) {}; 
	const MagnifierLayout& layout() {return (MagnifierLayout&) layout_;};
	void clearPlotContents();

	const QVector<QPointF>& area() const {return area_;}
	double resolutionX() {return resolutionY_;}
	double resolutionY() {return resolutionY_;}
	AnimationStep* step() {return step_;}
	double zoomFactor() {return zoomFactor_;}

	void setArea(const QVector<QPointF> area) {area_=area;}
	void setResolutionX(double r) {resolutionX_=r;}
	void setResolutionY(double r) {resolutionY_=r;}
	void setStep(AnimationStep *step) {step_=step;}
	void setZoomFactor(double zoomFactor) {zoomFactor_=zoomFactor;}

	virtual QRectF boundingRect() const;	

protected:
	QVector<QPointF> area_;
	double resolutionX_;
	double resolutionY_;
	AnimationStep *step_;	
	double zoomFactor_;
};


//}


#endif
