/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file MgQLayerNode.h
    \brief Definition of MgQLayerNode.
    \author Graphics Section, ECMWF

    Started: February 2010
*/

#ifndef _MgQLayerNode_H
#define _MgQLayerNode_H

#include <Layer.h>
#include "MgQBaseNode.h"

using magics::Layer;
using magics::SceneLayer;
	
class QImage;
class QPainter;

class MgQHistoNode;
class MgQLayoutNode;
class MgQMagnifierLayoutNode;
class MgQScene;
class MgQStepNode;

class MgQLayerState
{
public:
	QString name_;
	QString id_;
	int     stackLevel_;
	float   alpha_;
	bool    visible_;
};

class MgQSceneLayerNode : public MgQBaseNode
{
public:
	MgQSceneLayerNode(QString name,const SceneLayer &sc) : MgQBaseNode(name), 
								sceneLayer_(sc), 
								projectorNode_(0) {};
	~MgQSceneLayerNode() {};

	const SceneLayer& sceneLayer() {return sceneLayer_;};
	void setProjectorNode(MgQLayoutNode *n) {projectorNode_=n;}
	MgQLayoutNode* projectorNode() {return projectorNode_;}

protected:
	const SceneLayer& sceneLayer_;
	MgQLayoutNode* projectorNode_;
};



class MgQLayerNode : public MgQBaseNode
{
public:	
	MgQLayerNode(QString,Layer &,MgQLayoutNode *,int);
	~MgQLayerNode() {};

	enum InfoImageType {HistoImage};
	
	Layer& layer() {return layer_;};
	void  setLayerAlpha(float);
	void  setLayerVisibility(bool);	
	float layerAlpha() const; 
	bool  layerVisibility() const;
	void  updateLayer(const MgQLayerNode*);
	MgQBaseNode* rootNode() {return rootNode_;}
	
	void setStep(int step,MgQStepNode* node) {steps_[step]=node;} 
	void setStepVisible(int,bool);
	bool stepCached(int);
	void clearStep(int);
	int stepNum() {return steps_.count();}
	bool magnifierDataEnabled() {return magnifierDataEnabled_;}
	void setMagnifierDataEnabled(bool b) {magnifierDataEnabled_=b;}

	MgQLayoutNode* parentLayoutNode() {return layout_;}

	MgQMagnifierLayoutNode *magnifierLayoutNode();

	void paint(QPainter *, const QStyleOptionGraphicsItem *,
                QWidget *widget=0);

	void setStackLevel(int);
	int stackLevel();

	void saveLayerState(MgQLayerState*);
	MgQLayoutNode* topLayoutNode();

	void renderPreview();

	const QImage& preview() const {return previewImg_;}


	MgQHistoNode* histoNode(int);
	void addHistoNode(MgQHistoNode *);
	QPixmap histoPixmap(int,QSize);


protected:
	void addContentsToAlphaScene();
	void addContentsBackToScene();
	
	void addContentsToPreviewScene();
	void addContentsBackToSceneFromPreview();

	Layer& layer_;

	MgQBaseNode* rootNode_;
	bool rootNodeIsChild_;

	MgQLayoutNode* layout_;

	MgQScene *alphaScene_;
	QImage *alphaDevice_;
	QPainter* alphaPainter_;

	MgQScene *previewScene_;
	QImage *previewDevice_;
	QPainter* previewPainter_;
	QImage previewImg_;

	QGraphicsScene *histoScene_;
	QImage *histoDevice_;
	QPainter* histoPainter_;

	QList<MgQStepNode*> steps_;
	QList<MgQHistoNode*> histoNodes_;


	MgQMagnifierLayoutNode *magnifierLayout_;

	bool magnifierDataEnabled_;
};



#endif
