/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file Boundaries.cc
    \brief Implementation of the Template class BoundariesBase.
    
    Magics Team - ECMWF 2006
    
    Started: Tue 29-Aug-2006
    
    Changes:
    
*/



#include "Boundaries.h"
#include "Polyline.h"
#include "GeoPoint.h"
#include "MapGenDecoder.h"

using namespace magics;

Boundaries::Boundaries() 
{
}


Boundaries::~Boundaries() 
{
}

/*!
 Class information are given to the output-stream.
*/		
void Boundaries::print(ostream& out)  const
{
	out << "Boundaries[";
	BoundariesAttributes::print(out);
	out << "]";
}

void Boundaries::operator()(BasicGraphicsObjectContainer& task)
{	
	MapGenDecoder<GeoPoint> decoder;
	
	if (file_.empty()) 
		file_ = getEnvVariable("MAGPLUS_HOME") + MAGPLUS_PATH_TO_SHARE_ + "boundaries.mapgen";
	
	decoder.setPath(file_);
	decoder.decode();
	const Transformation& transformation = task.transformation();

	for ( MapGenDecoder<GeoPoint>::const_iterator boundary = decoder.begin(); boundary != decoder.end(); ++boundary) {
		Polyline* poly = new Polyline();
		poly->setColour(*colour_);
		poly->setThickness(thickness_);
		poly->setLineStyle(style_);
		BoxPointsHandler<GeoPoint> box((**boundary), transformation);
		
		     box.setToFirst();
		     while (box.more()) {               		
		          poly->push_back(transformation(box.current()));
		        
		          box.advance();		
		     }  
		
		
		task.push_back(poly);
	} 
	
	
	
}

NoBoundaries::NoBoundaries() 
{
}


NoBoundaries::~NoBoundaries() 
{
}

void NoBoundaries::print(ostream& out)  const
{
	out << "NoBoundaries[";
	out << "]";
}


