/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file MgQSymbol.h
    \brief Definition of MgQSymbol.
    \author Graphics Section, ECMWF

    Started: Feb 2010
*/

#ifndef _MgQSymbol_H
#define _MgQSymbol_H

#include <QList>
#include <QPainterPath>
#include <QString>

class MgQSymbolItem
{
public:
	MgQSymbolItem(QString id,float s) : id_(id), size_(s) {};

	const QString&  id() const   {return id_;}
	float size()  {return size_;};
	bool equal(const QString&,const float);
	const QPainterPath& path() const {return path_;}
	void setPath(QPainterPath &p) {path_=p;}

protected:
	QString id_;
	float size_;
	QPainterPath path_;
};


class MgQSymbolManager : public QList<MgQSymbolItem*>
{
public:
	MgQSymbolManager() {};
	~MgQSymbolManager();
 
	MgQSymbolItem* addSymbol(const QString&,const float);
	MgQSymbolItem* getSymbol(const QString&,const float);	
	void deleteSymbol(const QString&,const float);		

	int    symbolNum() {return symbols_.count();};	

protected:
	QList<MgQSymbolItem*> symbols_;
};	
	



#endif 
