/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.

 *******************************  LICENSE  *******************************/
 
#include "Layer.h"
#include "BaseDriver.h"


LayerSharedInfo::LayerSharedInfo(const string& id) : 
	visibility_(true), 
	zindex_(1), 
	transparency_(0), 
	id_(id)
{
	
}
Layer::Layer(const LayerSharedInfo& info): transparency_(0) 
{ 
	id_ = info.id();;
	name_ = info.id();
}
 
void Layer::redisplay(const BaseDriver& driver) const 
{  
	Log::dev() << "Layer::redisplay-->" << *this << endl;
	driver.redisplay(*this); 
}

void Layer::print(ostream& out) const
{ 
	out << "layer[" << name_;
	string sep = "";
	for (vector<pair<string, string>  >::const_iterator icon = icons_.begin(); icon != icons_.end(); ++icon) {
		out << ", [" << icon->first << ", " << icon->second << "]";
		sep = "]";
	}
	out << sep << "]"; 
}

string Layer::timeStamp(const string& fmt) const
{
	return from_.tostring(fmt);
}

string Layer::timeBegin(const string& fmt) const
{
	return from_.tostring(fmt);
}

string Layer::timeEnd(const string& fmt) const
{
	return to_.tostring(fmt);
}

static string kml("%Y-%m-%dT%H:%M:00Z");

string Layer::kmlTimeBegin() const 
{ 
	return timeBegin(kml); 
}

string Layer::kmlTimeEnd() const 
{ 
	return timeEnd(kml);  
}

string Layer::kmlTimeStamp() const
{
	return timeStamp(kml);
}

LayerSharedInfo& LayerManager::get(const string& name) {
	map<string, LayerSharedInfo>::iterator layer = manager_.find(name);
	assert ( layer != manager_.end() );
	return layer->second;
}




Layer* LayerManager::layer(const string& id) {
	map<string, LayerSharedInfo>::iterator layer = manager_.find(id);
		if (  layer == manager_.end() ) {		
		// Create a new SharedInfo from the Layer and 
			manager_.insert(make_pair(id, LayerSharedInfo(id)));
			 layer = manager_.find(id);
		}
		assert ( layer != manager_.end() );
		return new Layer(layer->second);
}

LayerManager LayerManager::manager_;
