/* libwpd
 * Copyright (C) 2008 Miklos Vajna (vmiklos@frugalware.org)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * For further information visit http://libwpd.sourceforge.net
 */

/* "This product is not manufactured, approved, or supported by
 * Corel Corporation or Corel Corporation Limited."
 */

using org.libwpd;
using System;

public class wpd2raw
{
	public static void Main(String[] args)
	{
		String file = "";

		if(args.Length < 1)
		{
			Console.WriteLine("Usage: wpd2raw [OPTION] <WordPerfect Document>");
			Environment.Exit(-1);
		}
		else if(args[0].Equals("--help"))
		{
			Console.WriteLine("Usage: wpd2raw [OPTION] <WordPerfect Document>");
			Console.WriteLine("");
			Console.WriteLine("Options:");
			Console.WriteLine("--help              Shows this help message");
			Environment.Exit(0);
		}
		else
			file = args[0];

		if (!WPDocumentCSharp.isFileWordPerfectDocument(file))
		{
			Console.WriteLine("ERROR: Unsupported file format!");
			Environment.Exit(1);
		}

		if (!WPDocumentCSharp.parseFile(file, new RawListenerImpl()))
		{
			Console.WriteLine("ERROR: Failed to parse the document!");
			Environment.Exit(1);
		}
	}
}
