# - Try to find GObject2 
# Find GObject2 headers, libraries and the answer to all questions.
#
#  GOBJECT2_FOUND               True if GOBJECT2 got found
#  GOBJECT2_INCLUDE_DIRS        Location of GOBJECT2 headers 
#  GOBJECT2_LIBRARIES           List of libraries to use GOBJECT2 
#
# Copyright (c) 2008 Bjoern Ricks <bjoern.ricks@googlemail.com>
#
#  Redistribution and use is allowed according to the terms of the New
#  BSD license.
#  For details see the accompanying COPYING-CMAKE-SCRIPTS file.
#

INCLUDE( FindPkgConfig )

IF ( GOBJECT2_FIND_REQUIRED )
	SET( _pkgconfig_REQUIRED "REQUIRED" )
ELSE( GOBJECT2_FIND_REQUIRED )
	SET( _pkgconfig_REQUIRED "" )	
ENDIF ( GOBJECT2_FIND_REQUIRED )

IF ( GOBJECT2_MIN_VERSION )
	PKG_SEARCH_MODULE( GOBJECT2 ${_pkgconfig_REQUIRED} gobject-2.0>=${GOBJECT2_MIN_VERSION} )
ELSE ( GOBJECT2_MIN_VERSION )
	PKG_SEARCH_MODULE( GOBJECT2 ${_pkgconfig_REQUIRED} gobject-2.0 )
ENDIF ( GOBJECT2_MIN_VERSION )


IF( NOT GOBJECT2_FOUND AND NOT PKG_CONFIG_FOUND )
	FIND_PATH( GOBJECT2_INCLUDE_DIRS gobject/gobject.h PATH_SUFFIXES glib-2.0)
	FIND_LIBRARY( GOBJECT2_LIBRARIES gobject-2.0 )

	# Report results
	IF ( GOBJECT2_LIBRARIES AND GOBJECT2_INCLUDE_DIRS )	
		SET( GOBJECT2_FOUND 1 )
		IF ( NOT GOBJECT2_FIND_QUIETLY )
			MESSAGE( STATUS "Found GOBJECT2: ${GOBJECT2_LIBRARIES}" )
		ENDIF ( NOT GOBJECT2_FIND_QUIETLY )
	ELSE ( GOBJECT2_LIBRARIES AND GOBJECT2_INCLUDE_DIRS )	
		IF ( GOBJECT2_FIND_REQUIRED )
			MESSAGE( SEND_ERROR "Could NOT find GOBJECT2" )
		ELSE ( GOBJECT2_FIND_REQUIRED )
			IF ( NOT GOBJECT2_FIND_QUIETLY )
				MESSAGE( STATUS "Could NOT find GOBJECT2" )	
			ENDIF ( NOT GOBJECT2_FIND_QUIETLY )
		ENDIF ( GOBJECT2_FIND_REQUIRED )
	ENDIF ( GOBJECT2_LIBRARIES AND GOBJECT2_INCLUDE_DIRS )
ENDIF( NOT GOBJECT2_FOUND AND NOT PKG_CONFIG_FOUND )

MARK_AS_ADVANCED( GOBJECT2_LIBRARIES GOBJECT2_INCLUDE_DIRS )
