/* ItemConfiguration.java
 * =========================================================================
 * This file is part of the SWIRL Library - http://swirl-lib.sourceforge.net
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 * 
 */

package be.ugent.caagt.swirl.menus;

import be.ugent.caagt.swirl.actions.Description;

/**
 * Common superclass of {@link ActionConfiguration}, {@link ToggleConfiguration}
 * and {@link MenuConfiguration}.
 */
abstract class ItemConfiguration extends IdentifiedConfiguration {

    //
    private Description description;

    /**
     * Return the description for this item. This description
     * will determine caption, mnemonics etc. of the resulting
     * menu entry. Will be of type {@link FullDescription}
     * for actions and toggles.
     */
    public Description getDescription() {
        return description;
    }

    /**
     * Set the description for this item.
     * @param description Description of this item. Should be
     * of type {@link FullDescription} for actions and toggles.
     */
    public void setDescription(Description description) {
        this.description = description;
    }
    
    
}
