/* state.c generated by valac 0.14.0, the Vala compiler
 * generated from state.vala, do not modify */

/* -*- coding: utf-8 -*-*/
/*
 * Copyright (C) 2011-2012 Daiki Ueno <ueno@unixuser.org>
 * Copyright (C) 2011-2012 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib/gi18n-lib.h>


#define SKK_TYPE_STATE (skk_state_get_type ())
#define SKK_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_STATE, SkkState))
#define SKK_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_STATE, SkkStateClass))
#define SKK_IS_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_STATE))
#define SKK_IS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_STATE))
#define SKK_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_STATE, SkkStateClass))

typedef struct _SkkState SkkState;
typedef struct _SkkStateClass SkkStateClass;
typedef struct _SkkStatePrivate SkkStatePrivate;

#define SKK_TYPE_DICT (skk_dict_get_type ())
#define SKK_DICT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_DICT, SkkDict))
#define SKK_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_DICT, SkkDictClass))
#define SKK_IS_DICT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_DICT))
#define SKK_IS_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_DICT))
#define SKK_DICT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_DICT, SkkDictClass))

typedef struct _SkkDict SkkDict;
typedef struct _SkkDictClass SkkDictClass;

#define SKK_TYPE_CANDIDATE_LIST (skk_candidate_list_get_type ())
#define SKK_CANDIDATE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_CANDIDATE_LIST, SkkCandidateList))
#define SKK_CANDIDATE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_CANDIDATE_LIST, SkkCandidateListClass))
#define SKK_IS_CANDIDATE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_CANDIDATE_LIST))
#define SKK_IS_CANDIDATE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_CANDIDATE_LIST))
#define SKK_CANDIDATE_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_CANDIDATE_LIST, SkkCandidateListClass))

typedef struct _SkkCandidateList SkkCandidateList;
typedef struct _SkkCandidateListClass SkkCandidateListClass;

#define SKK_TYPE_ROM_KANA_CONVERTER (skk_rom_kana_converter_get_type ())
#define SKK_ROM_KANA_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_ROM_KANA_CONVERTER, SkkRomKanaConverter))
#define SKK_ROM_KANA_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_ROM_KANA_CONVERTER, SkkRomKanaConverterClass))
#define SKK_IS_ROM_KANA_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_ROM_KANA_CONVERTER))
#define SKK_IS_ROM_KANA_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_ROM_KANA_CONVERTER))
#define SKK_ROM_KANA_CONVERTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_ROM_KANA_CONVERTER, SkkRomKanaConverterClass))

typedef struct _SkkRomKanaConverter SkkRomKanaConverter;
typedef struct _SkkRomKanaConverterClass SkkRomKanaConverterClass;

#define SKK_TYPE_UNICODE_STRING (skk_unicode_string_get_type ())
#define SKK_UNICODE_STRING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_UNICODE_STRING, SkkUnicodeString))
#define SKK_UNICODE_STRING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_UNICODE_STRING, SkkUnicodeStringClass))
#define SKK_IS_UNICODE_STRING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_UNICODE_STRING))
#define SKK_IS_UNICODE_STRING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_UNICODE_STRING))
#define SKK_UNICODE_STRING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_UNICODE_STRING, SkkUnicodeStringClass))

typedef struct _SkkUnicodeString SkkUnicodeString;
typedef struct _SkkUnicodeStringClass SkkUnicodeStringClass;

#define SKK_TYPE_KANA_MODE (skk_kana_mode_get_type ())

#define SKK_TYPE_INPUT_MODE (skk_input_mode_get_type ())

#define SKK_TYPE_RULE (skk_rule_get_type ())
#define SKK_RULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_RULE, SkkRule))
#define SKK_RULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_RULE, SkkRuleClass))
#define SKK_IS_RULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_RULE))
#define SKK_IS_RULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_RULE))
#define SKK_RULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_RULE, SkkRuleClass))

typedef struct _SkkRule SkkRule;
typedef struct _SkkRuleClass SkkRuleClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define SKK_TYPE_KEY_EVENT (skk_key_event_get_type ())
#define SKK_KEY_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_KEY_EVENT, SkkKeyEvent))
#define SKK_KEY_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_KEY_EVENT, SkkKeyEventClass))
#define SKK_IS_KEY_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_KEY_EVENT))
#define SKK_IS_KEY_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_KEY_EVENT))
#define SKK_KEY_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_KEY_EVENT, SkkKeyEventClass))

typedef struct _SkkKeyEvent SkkKeyEvent;
typedef struct _SkkKeyEventClass SkkKeyEventClass;
typedef struct _SkkRulePrivate SkkRulePrivate;

#define SKK_TYPE_MAP_FILE (skk_map_file_get_type ())
#define SKK_MAP_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_MAP_FILE, SkkMapFile))
#define SKK_MAP_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_MAP_FILE, SkkMapFileClass))
#define SKK_IS_MAP_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_MAP_FILE))
#define SKK_IS_MAP_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_MAP_FILE))
#define SKK_MAP_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_MAP_FILE, SkkMapFileClass))

typedef struct _SkkMapFile SkkMapFile;
typedef struct _SkkMapFileClass SkkMapFileClass;

#define SKK_TYPE_KEYMAP_MAP_FILE (skk_keymap_map_file_get_type ())
#define SKK_KEYMAP_MAP_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_KEYMAP_MAP_FILE, SkkKeymapMapFile))
#define SKK_KEYMAP_MAP_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_KEYMAP_MAP_FILE, SkkKeymapMapFileClass))
#define SKK_IS_KEYMAP_MAP_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_KEYMAP_MAP_FILE))
#define SKK_IS_KEYMAP_MAP_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_KEYMAP_MAP_FILE))
#define SKK_KEYMAP_MAP_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_KEYMAP_MAP_FILE, SkkKeymapMapFileClass))

typedef struct _SkkKeymapMapFile SkkKeymapMapFile;
typedef struct _SkkKeymapMapFileClass SkkKeymapMapFileClass;

#define SKK_TYPE_ROM_KANA_MAP_FILE (skk_rom_kana_map_file_get_type ())
#define SKK_ROM_KANA_MAP_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_ROM_KANA_MAP_FILE, SkkRomKanaMapFile))
#define SKK_ROM_KANA_MAP_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_ROM_KANA_MAP_FILE, SkkRomKanaMapFileClass))
#define SKK_IS_ROM_KANA_MAP_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_ROM_KANA_MAP_FILE))
#define SKK_IS_ROM_KANA_MAP_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_ROM_KANA_MAP_FILE))
#define SKK_ROM_KANA_MAP_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_ROM_KANA_MAP_FILE, SkkRomKanaMapFileClass))

typedef struct _SkkRomKanaMapFile SkkRomKanaMapFile;
typedef struct _SkkRomKanaMapFileClass SkkRomKanaMapFileClass;
typedef struct _SkkMapFilePrivate SkkMapFilePrivate;
typedef struct _SkkKeymapMapFilePrivate SkkKeymapMapFilePrivate;

#define SKK_TYPE_KEYMAP (skk_keymap_get_type ())
#define SKK_KEYMAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_KEYMAP, SkkKeymap))
#define SKK_KEYMAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_KEYMAP, SkkKeymapClass))
#define SKK_IS_KEYMAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_KEYMAP))
#define SKK_IS_KEYMAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_KEYMAP))
#define SKK_KEYMAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_KEYMAP, SkkKeymapClass))

typedef struct _SkkKeymap SkkKeymap;
typedef struct _SkkKeymapClass SkkKeymapClass;

#define SKK_TYPE_SIMPLE_CANDIDATE_LIST (skk_simple_candidate_list_get_type ())
#define SKK_SIMPLE_CANDIDATE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_SIMPLE_CANDIDATE_LIST, SkkSimpleCandidateList))
#define SKK_SIMPLE_CANDIDATE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_SIMPLE_CANDIDATE_LIST, SkkSimpleCandidateListClass))
#define SKK_IS_SIMPLE_CANDIDATE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_SIMPLE_CANDIDATE_LIST))
#define SKK_IS_SIMPLE_CANDIDATE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_SIMPLE_CANDIDATE_LIST))
#define SKK_SIMPLE_CANDIDATE_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_SIMPLE_CANDIDATE_LIST, SkkSimpleCandidateListClass))

typedef struct _SkkSimpleCandidateList SkkSimpleCandidateList;
typedef struct _SkkSimpleCandidateListClass SkkSimpleCandidateListClass;

#define SKK_TYPE_CANDIDATE (skk_candidate_get_type ())
#define SKK_CANDIDATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_CANDIDATE, SkkCandidate))
#define SKK_CANDIDATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_CANDIDATE, SkkCandidateClass))
#define SKK_IS_CANDIDATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_CANDIDATE))
#define SKK_IS_CANDIDATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_CANDIDATE))
#define SKK_CANDIDATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_CANDIDATE, SkkCandidateClass))

typedef struct _SkkCandidate SkkCandidate;
typedef struct _SkkCandidateClass SkkCandidateClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define SKK_TYPE_STATE_HANDLER (skk_state_handler_get_type ())
#define SKK_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_STATE_HANDLER, SkkStateHandler))
#define SKK_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_STATE_HANDLER, SkkStateHandlerClass))
#define SKK_IS_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_STATE_HANDLER))
#define SKK_IS_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_STATE_HANDLER))
#define SKK_STATE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_STATE_HANDLER, SkkStateHandlerClass))

typedef struct _SkkStateHandler SkkStateHandler;
typedef struct _SkkStateHandlerClass SkkStateHandlerClass;

#define SKK_TYPE_NONE_STATE_HANDLER (skk_none_state_handler_get_type ())
#define SKK_NONE_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_NONE_STATE_HANDLER, SkkNoneStateHandler))
#define SKK_NONE_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_NONE_STATE_HANDLER, SkkNoneStateHandlerClass))
#define SKK_IS_NONE_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_NONE_STATE_HANDLER))
#define SKK_IS_NONE_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_NONE_STATE_HANDLER))
#define SKK_NONE_STATE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_NONE_STATE_HANDLER, SkkNoneStateHandlerClass))

typedef struct _SkkNoneStateHandler SkkNoneStateHandler;
typedef struct _SkkNoneStateHandlerClass SkkNoneStateHandlerClass;

#define SKK_TYPE_KEY_EVENT_FILTER (skk_key_event_filter_get_type ())
#define SKK_KEY_EVENT_FILTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_KEY_EVENT_FILTER, SkkKeyEventFilter))
#define SKK_KEY_EVENT_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_KEY_EVENT_FILTER, SkkKeyEventFilterClass))
#define SKK_IS_KEY_EVENT_FILTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_KEY_EVENT_FILTER))
#define SKK_IS_KEY_EVENT_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_KEY_EVENT_FILTER))
#define SKK_KEY_EVENT_FILTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_KEY_EVENT_FILTER, SkkKeyEventFilterClass))

typedef struct _SkkKeyEventFilter SkkKeyEventFilter;
typedef struct _SkkKeyEventFilterClass SkkKeyEventFilterClass;
#define _g_match_info_free0(var) ((var == NULL) ? NULL : (var = (g_match_info_free (var), NULL)))

#define SKK_TYPE_EXPR_READER (skk_expr_reader_get_type ())
#define SKK_EXPR_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_EXPR_READER, SkkExprReader))
#define SKK_EXPR_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_EXPR_READER, SkkExprReaderClass))
#define SKK_IS_EXPR_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_EXPR_READER))
#define SKK_IS_EXPR_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_EXPR_READER))
#define SKK_EXPR_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_EXPR_READER, SkkExprReaderClass))

typedef struct _SkkExprReader SkkExprReader;
typedef struct _SkkExprReaderClass SkkExprReaderClass;

#define SKK_TYPE_EXPR_NODE (skk_expr_node_get_type ())

#define SKK_TYPE_EXPR_NODE_TYPE (skk_expr_node_type_get_type ())
typedef struct _SkkExprNode SkkExprNode;

#define SKK_TYPE_EXPR_EVALUATOR (skk_expr_evaluator_get_type ())
#define SKK_EXPR_EVALUATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_EXPR_EVALUATOR, SkkExprEvaluator))
#define SKK_EXPR_EVALUATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_EXPR_EVALUATOR, SkkExprEvaluatorClass))
#define SKK_IS_EXPR_EVALUATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_EXPR_EVALUATOR))
#define SKK_IS_EXPR_EVALUATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_EXPR_EVALUATOR))
#define SKK_EXPR_EVALUATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_EXPR_EVALUATOR, SkkExprEvaluatorClass))

typedef struct _SkkExprEvaluator SkkExprEvaluator;
typedef struct _SkkExprEvaluatorClass SkkExprEvaluatorClass;
#define _skk_expr_node_free0(var) ((var == NULL) ? NULL : (var = (skk_expr_node_free (var), NULL)))

#define SKK_TYPE_NUMERIC_CONVERSION_TYPE (skk_numeric_conversion_type_get_type ())

#define SKK_TYPE_PERIOD_STYLE (skk_period_style_get_type ())
typedef struct _SkkStateHandlerPrivate SkkStateHandlerPrivate;
typedef struct _SkkNoneStateHandlerPrivate SkkNoneStateHandlerPrivate;

#define SKK_TYPE_ENTRY (skk_entry_get_type ())
typedef struct _SkkEntry SkkEntry;
typedef struct _SkkUnicodeStringPrivate SkkUnicodeStringPrivate;

#define SKK_TYPE_START_STATE_HANDLER (skk_start_state_handler_get_type ())
#define SKK_START_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_START_STATE_HANDLER, SkkStartStateHandler))
#define SKK_START_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_START_STATE_HANDLER, SkkStartStateHandlerClass))
#define SKK_IS_START_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_START_STATE_HANDLER))
#define SKK_IS_START_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_START_STATE_HANDLER))
#define SKK_START_STATE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_START_STATE_HANDLER, SkkStartStateHandlerClass))

typedef struct _SkkStartStateHandler SkkStartStateHandler;
typedef struct _SkkStartStateHandlerClass SkkStartStateHandlerClass;

#define SKK_TYPE_MODIFIER_TYPE (skk_modifier_type_get_type ())

#define SKK_TYPE_ABBREV_STATE_HANDLER (skk_abbrev_state_handler_get_type ())
#define SKK_ABBREV_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_ABBREV_STATE_HANDLER, SkkAbbrevStateHandler))
#define SKK_ABBREV_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_ABBREV_STATE_HANDLER, SkkAbbrevStateHandlerClass))
#define SKK_IS_ABBREV_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_ABBREV_STATE_HANDLER))
#define SKK_IS_ABBREV_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_ABBREV_STATE_HANDLER))
#define SKK_ABBREV_STATE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_ABBREV_STATE_HANDLER, SkkAbbrevStateHandlerClass))

typedef struct _SkkAbbrevStateHandler SkkAbbrevStateHandler;
typedef struct _SkkAbbrevStateHandlerClass SkkAbbrevStateHandlerClass;

#define SKK_TYPE_KUTEN_STATE_HANDLER (skk_kuten_state_handler_get_type ())
#define SKK_KUTEN_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_KUTEN_STATE_HANDLER, SkkKutenStateHandler))
#define SKK_KUTEN_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_KUTEN_STATE_HANDLER, SkkKutenStateHandlerClass))
#define SKK_IS_KUTEN_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_KUTEN_STATE_HANDLER))
#define SKK_IS_KUTEN_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_KUTEN_STATE_HANDLER))
#define SKK_KUTEN_STATE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_KUTEN_STATE_HANDLER, SkkKutenStateHandlerClass))

typedef struct _SkkKutenStateHandler SkkKutenStateHandler;
typedef struct _SkkKutenStateHandlerClass SkkKutenStateHandlerClass;
typedef struct _SkkKutenStateHandlerPrivate SkkKutenStateHandlerPrivate;

#define SKK_TYPE_ENCODING_CONVERTER (skk_encoding_converter_get_type ())
#define SKK_ENCODING_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_ENCODING_CONVERTER, SkkEncodingConverter))
#define SKK_ENCODING_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_ENCODING_CONVERTER, SkkEncodingConverterClass))
#define SKK_IS_ENCODING_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_ENCODING_CONVERTER))
#define SKK_IS_ENCODING_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_ENCODING_CONVERTER))
#define SKK_ENCODING_CONVERTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_ENCODING_CONVERTER, SkkEncodingConverterClass))

typedef struct _SkkEncodingConverter SkkEncodingConverter;
typedef struct _SkkEncodingConverterClass SkkEncodingConverterClass;
typedef struct _SkkAbbrevStateHandlerPrivate SkkAbbrevStateHandlerPrivate;

#define SKK_TYPE_SELECT_STATE_HANDLER (skk_select_state_handler_get_type ())
#define SKK_SELECT_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_SELECT_STATE_HANDLER, SkkSelectStateHandler))
#define SKK_SELECT_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_SELECT_STATE_HANDLER, SkkSelectStateHandlerClass))
#define SKK_IS_SELECT_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_SELECT_STATE_HANDLER))
#define SKK_IS_SELECT_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_SELECT_STATE_HANDLER))
#define SKK_SELECT_STATE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_SELECT_STATE_HANDLER, SkkSelectStateHandlerClass))

typedef struct _SkkSelectStateHandler SkkSelectStateHandler;
typedef struct _SkkSelectStateHandlerClass SkkSelectStateHandlerClass;
typedef struct _SkkStartStateHandlerPrivate SkkStartStateHandlerPrivate;
typedef struct _SkkSelectStateHandlerPrivate SkkSelectStateHandlerPrivate;

struct _SkkState {
	GObject parent_instance;
	SkkStatePrivate * priv;
	GType handler_type;
	GeeList* dictionaries;
	SkkCandidateList* candidates;
	SkkRomKanaConverter* rom_kana_converter;
	SkkRomKanaConverter* okuri_rom_kana_converter;
	gboolean okuri;
	gchar* midasi;
	GString* output;
	GString* abbrev;
	GString* kuten;
	GeeIterator* completion_iterator;
	gchar** auto_start_henkan_keywords;
	gint auto_start_henkan_keywords_length1;
	gint _auto_start_henkan_keywords_size_;
	gchar* auto_start_henkan_keyword;
	gboolean egg_like_newline;
	SkkUnicodeString* surrounding_text;
	guint surrounding_end;
};

struct _SkkStateClass {
	GObjectClass parent_class;
};

typedef enum  {
	SKK_KANA_MODE_HIRAGANA,
	SKK_KANA_MODE_KATAKANA,
	SKK_KANA_MODE_HANKAKU_KATAKANA
} SkkKanaMode;

typedef enum  {
	SKK_INPUT_MODE_HIRAGANA = SKK_KANA_MODE_HIRAGANA,
	SKK_INPUT_MODE_KATAKANA = SKK_KANA_MODE_KATAKANA,
	SKK_INPUT_MODE_HANKAKU_KATAKANA = SKK_KANA_MODE_HANKAKU_KATAKANA,
	SKK_INPUT_MODE_LATIN,
	SKK_INPUT_MODE_WIDE_LATIN,
	SKK_INPUT_MODE_LAST,
	SKK_INPUT_MODE_DEFAULT = SKK_INPUT_MODE_HIRAGANA
} SkkInputMode;

struct _SkkStatePrivate {
	SkkInputMode _input_mode;
	GeeArrayList* completion;
	SkkRule* _typing_rule;
	GRegex* numeric_regex;
	GRegex* numeric_ref_regex;
};

struct _SkkRule {
	GObject parent_instance;
	SkkRulePrivate * priv;
	SkkKeymapMapFile** keymaps;
	gint keymaps_length1;
	gint _keymaps_size_;
	SkkRomKanaMapFile* rom_kana;
};

struct _SkkRuleClass {
	GObjectClass parent_class;
};

struct _SkkMapFile {
	GObject parent_instance;
	SkkMapFilePrivate * priv;
};

struct _SkkMapFileClass {
	GObjectClass parent_class;
};

struct _SkkKeymapMapFile {
	SkkMapFile parent_instance;
	SkkKeymapMapFilePrivate * priv;
	SkkKeymap* keymap;
};

struct _SkkKeymapMapFileClass {
	SkkMapFileClass parent_class;
};

typedef enum  {
	SKK_RULE_PARSE_ERROR_FAILED
} SkkRuleParseError;
#define SKK_RULE_PARSE_ERROR skk_rule_parse_error_quark ()
typedef enum  {
	SKK_EXPR_NODE_TYPE_ARRAY,
	SKK_EXPR_NODE_TYPE_SYMBOL,
	SKK_EXPR_NODE_TYPE_STRING
} SkkExprNodeType;

struct _SkkExprNode {
	SkkExprNodeType type;
	GeeLinkedList* nodes;
	gchar* data;
};

typedef enum  {
	SKK_NUMERIC_CONVERSION_TYPE_LATIN,
	SKK_NUMERIC_CONVERSION_TYPE_WIDE_LATIN,
	SKK_NUMERIC_CONVERSION_TYPE_KANJI_NUMERAL,
	SKK_NUMERIC_CONVERSION_TYPE_KANJI,
	SKK_NUMERIC_CONVERSION_TYPE_RECONVERT,
	SKK_NUMERIC_CONVERSION_TYPE_DAIJI,
	SKK_NUMERIC_CONVERSION_TYPE_SHOGI
} SkkNumericConversionType;

typedef enum  {
	SKK_PERIOD_STYLE_JA_JA,
	SKK_PERIOD_STYLE_EN_EN,
	SKK_PERIOD_STYLE_JA_EN,
	SKK_PERIOD_STYLE_EN_JA
} SkkPeriodStyle;

typedef gboolean (*SkkCommandHandler) (SkkState* state, void* user_data);
struct _SkkStateHandler {
	GObject parent_instance;
	SkkStateHandlerPrivate * priv;
};

struct _SkkStateHandlerClass {
	GObjectClass parent_class;
	gboolean (*process_key_event) (SkkStateHandler* self, SkkState* state, SkkKeyEvent** key);
	gchar* (*get_preedit) (SkkStateHandler* self, SkkState* state, guint* underline_offset, guint* underline_nchars);
	gchar* (*get_output) (SkkStateHandler* self, SkkState* state);
};

struct _SkkNoneStateHandler {
	SkkStateHandler parent_instance;
	SkkNoneStateHandlerPrivate * priv;
};

struct _SkkNoneStateHandlerClass {
	SkkStateHandlerClass parent_class;
};

struct _SkkEntry {
	gpointer key;
	gpointer value;
};

struct _SkkUnicodeString {
	GObject parent_instance;
	SkkUnicodeStringPrivate * priv;
	gint length;
};

struct _SkkUnicodeStringClass {
	GObjectClass parent_class;
};

typedef enum  {
	SKK_MODIFIER_TYPE_NONE = 0,
	SKK_MODIFIER_TYPE_SHIFT_MASK = 1 << 0,
	SKK_MODIFIER_TYPE_LOCK_MASK = 1 << 1,
	SKK_MODIFIER_TYPE_CONTROL_MASK = 1 << 2,
	SKK_MODIFIER_TYPE_MOD1_MASK = 1 << 3,
	SKK_MODIFIER_TYPE_MOD2_MASK = 1 << 4,
	SKK_MODIFIER_TYPE_MOD3_MASK = 1 << 5,
	SKK_MODIFIER_TYPE_MOD4_MASK = 1 << 6,
	SKK_MODIFIER_TYPE_MOD5_MASK = 1 << 7,
	SKK_MODIFIER_TYPE_LSHIFT_MASK = 1 << 22,
	SKK_MODIFIER_TYPE_RSHIFT_MASK = 1 << 23,
	SKK_MODIFIER_TYPE_USLEEP_MASK = 1 << 24,
	SKK_MODIFIER_TYPE_SUPER_MASK = 1 << 26,
	SKK_MODIFIER_TYPE_HYPER_MASK = 1 << 27,
	SKK_MODIFIER_TYPE_META_MASK = 1 << 28,
	SKK_MODIFIER_TYPE_RELEASE_MASK = 1 << 30
} SkkModifierType;

struct _SkkKutenStateHandler {
	SkkStateHandler parent_instance;
	SkkKutenStateHandlerPrivate * priv;
};

struct _SkkKutenStateHandlerClass {
	SkkStateHandlerClass parent_class;
};

struct _SkkKutenStateHandlerPrivate {
	SkkEncodingConverter* converter;
};

struct _SkkAbbrevStateHandler {
	SkkStateHandler parent_instance;
	SkkAbbrevStateHandlerPrivate * priv;
};

struct _SkkAbbrevStateHandlerClass {
	SkkStateHandlerClass parent_class;
};

struct _SkkStartStateHandler {
	SkkStateHandler parent_instance;
	SkkStartStateHandlerPrivate * priv;
};

struct _SkkStartStateHandlerClass {
	SkkStateHandlerClass parent_class;
};

struct _SkkSelectStateHandler {
	SkkStateHandler parent_instance;
	SkkSelectStateHandlerPrivate * priv;
};

struct _SkkSelectStateHandlerClass {
	SkkStateHandlerClass parent_class;
};


static gpointer skk_state_parent_class = NULL;
static gpointer skk_state_handler_parent_class = NULL;
static gpointer skk_none_state_handler_parent_class = NULL;
static gpointer skk_kuten_state_handler_parent_class = NULL;
static gpointer skk_abbrev_state_handler_parent_class = NULL;
static gpointer skk_start_state_handler_parent_class = NULL;
static gpointer skk_select_state_handler_parent_class = NULL;

GType skk_state_get_type (void) G_GNUC_CONST;
GType skk_dict_get_type (void) G_GNUC_CONST;
GType skk_candidate_list_get_type (void) G_GNUC_CONST;
GType skk_rom_kana_converter_get_type (void) G_GNUC_CONST;
GType skk_unicode_string_get_type (void) G_GNUC_CONST;
GType skk_kana_mode_get_type (void) G_GNUC_CONST;
GType skk_input_mode_get_type (void) G_GNUC_CONST;
GType skk_rule_get_type (void) G_GNUC_CONST;
#define SKK_STATE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SKK_TYPE_STATE, SkkStatePrivate))
enum  {
	SKK_STATE_DUMMY_PROPERTY,
	SKK_STATE_INPUT_MODE,
	SKK_STATE_PERIOD_STYLE,
	SKK_STATE_TYPING_RULE
};
void skk_state_reset (SkkState* self);
GType skk_key_event_get_type (void) G_GNUC_CONST;
gchar* skk_state_lookup_key (SkkState* self, SkkKeyEvent* key);
GType skk_map_file_get_type (void) G_GNUC_CONST;
GType skk_keymap_map_file_get_type (void) G_GNUC_CONST;
GType skk_rom_kana_map_file_get_type (void) G_GNUC_CONST;
SkkInputMode skk_state_get_input_mode (SkkState* self);
GType skk_keymap_get_type (void) G_GNUC_CONST;
gchar* skk_keymap_lookup_key (SkkKeymap* self, SkkKeyEvent* key);
SkkKeyEvent* skk_state_where_is (SkkState* self, const gchar* command);
SkkKeyEvent* skk_keymap_where_is (SkkKeymap* self, const gchar* command);
SkkState* skk_state_new (GeeList* dictionaries);
SkkState* skk_state_construct (GType object_type, GeeList* dictionaries);
SkkSimpleCandidateList* skk_simple_candidate_list_new (guint page_start, guint page_size);
SkkSimpleCandidateList* skk_simple_candidate_list_construct (GType object_type, guint page_start, guint page_size);
GType skk_simple_candidate_list_get_type (void) G_GNUC_CONST;
GType skk_candidate_get_type (void) G_GNUC_CONST;
static void skk_state_candidate_selected (SkkState* self, SkkCandidate* c);
static void _skk_state_candidate_selected_skk_candidate_list_selected (SkkCandidateList* _sender, SkkCandidate* candidate, gpointer self);
SkkRomKanaConverter* skk_rom_kana_converter_new (void);
SkkRomKanaConverter* skk_rom_kana_converter_construct (GType object_type);
static gchar** _vala_array_dup3 (gchar** self, int length);
GQuark skk_rule_parse_error_quark (void);
SkkRule* skk_rule_new (const gchar* name, GError** error);
SkkRule* skk_rule_construct (GType object_type, const gchar* name, GError** error);
const gchar* skk_candidate_get_output (SkkCandidate* self);
const gchar* skk_rom_kana_converter_get_output (SkkRomKanaConverter* self);
void skk_state_output_surrounding_text (SkkState* self);
gchar* skk_unicode_string_substring (SkkUnicodeString* self, glong offset, glong len);
GType skk_state_handler_get_type (void) G_GNUC_CONST;
GType skk_none_state_handler_get_type (void) G_GNUC_CONST;
void skk_rom_kana_converter_reset (SkkRomKanaConverter* self);
GType skk_key_event_filter_get_type (void) G_GNUC_CONST;
SkkKeyEventFilter* skk_rule_get_filter (SkkRule* self);
void skk_key_event_filter_reset (SkkKeyEventFilter* self);
void skk_candidate_list_clear (SkkCandidateList* self);
void skk_state_cancel_okuri (SkkState* self);
void skk_rom_kana_converter_set_output (SkkRomKanaConverter* self, const gchar* value);
static gchar* skk_state_extract_numerics (SkkState* self, const gchar* midasi, gint** numerics, int* numerics_length1);
static gchar* skk_state_expand_expr (SkkState* self, const gchar* text);
SkkExprReader* skk_expr_reader_new (void);
SkkExprReader* skk_expr_reader_construct (GType object_type);
GType skk_expr_reader_get_type (void) G_GNUC_CONST;
GType skk_expr_node_get_type (void) G_GNUC_CONST;
GType skk_expr_node_type_get_type (void) G_GNUC_CONST;
SkkExprNode* skk_expr_node_dup (const SkkExprNode* self);
void skk_expr_node_free (SkkExprNode* self);
void skk_expr_node_copy (const SkkExprNode* self, SkkExprNode* dest);
void skk_expr_node_destroy (SkkExprNode* self);
SkkExprNode* skk_expr_reader_read_expr (SkkExprReader* self, const gchar* expr, gint* index);
SkkExprEvaluator* skk_expr_evaluator_new (void);
SkkExprEvaluator* skk_expr_evaluator_construct (GType object_type);
GType skk_expr_evaluator_get_type (void) G_GNUC_CONST;
gchar* skk_expr_evaluator_eval (SkkExprEvaluator* self, SkkExprNode* node);
static gchar* skk_state_expand_numeric_references (SkkState* self, const gchar* text, gint* numerics, int numerics_length1);
GType skk_numeric_conversion_type_get_type (void) G_GNUC_CONST;
gchar* skk_util_get_numeric (gint numeric, SkkNumericConversionType type);
void skk_state_lookup (SkkState* self, const gchar* midasi, gboolean okuri);
static void skk_state_lookup_internal (SkkState* self, const gchar* midasi, gint* numerics, int numerics_length1, gboolean okuri);
void skk_candidate_list_add_candidates_end (SkkCandidateList* self);
SkkCandidate** skk_dict_lookup (SkkDict* self, const gchar* midasi, gboolean okuri, int* result_length1);
const gchar* skk_candidate_get_text (SkkCandidate* self);
void skk_candidate_set_output (SkkCandidate* self, const gchar* value);
const gchar* skk_candidate_get_annotation (SkkCandidate* self);
void skk_candidate_set_annotation (SkkCandidate* self, const gchar* value);
void skk_candidate_list_add_candidates (SkkCandidateList* self, SkkCandidate** array, int array_length1);
void skk_state_purge_candidate (SkkState* self, SkkCandidate* candidate);
gboolean skk_dict_get_read_only (SkkDict* self);
gboolean skk_dict_purge_candidate (SkkDict* self, SkkCandidate* candidate);
void skk_state_completion_start (SkkState* self, const gchar* midasi);
gchar** skk_dict_complete (SkkDict* self, const gchar* midasi, int* result_length1);
gchar* skk_state_get_yomi (SkkState* self);
const gchar* skk_rom_kana_converter_get_preedit (SkkRomKanaConverter* self);
void skk_state_set_input_mode (SkkState* self, SkkInputMode value);
void skk_rom_kana_converter_set_kana_mode (SkkRomKanaConverter* self, SkkKanaMode value);
GType skk_period_style_get_type (void) G_GNUC_CONST;
SkkPeriodStyle skk_state_get_period_style (SkkState* self);
SkkPeriodStyle skk_rom_kana_converter_get_period_style (SkkRomKanaConverter* self);
void skk_state_set_period_style (SkkState* self, SkkPeriodStyle value);
void skk_rom_kana_converter_set_period_style (SkkRomKanaConverter* self, SkkPeriodStyle value);
SkkRule* skk_state_get_typing_rule (SkkState* self);
void skk_state_set_typing_rule (SkkState* self, SkkRule* value);
void skk_rom_kana_converter_set_rule (SkkRomKanaConverter* self, SkkRomKanaMapFile* value);
static void g_cclosure_user_marshal_BOOLEAN__VOID (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__POINTER_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__INT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void skk_state_finalize (GObject* obj);
static void _vala_skk_state_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_skk_state_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
enum  {
	SKK_STATE_HANDLER_DUMMY_PROPERTY
};
gboolean skk_state_handler_process_key_event (SkkStateHandler* self, SkkState* state, SkkKeyEvent** key);
static gboolean skk_state_handler_real_process_key_event (SkkStateHandler* self, SkkState* state, SkkKeyEvent** key);
gchar* skk_state_handler_get_preedit (SkkStateHandler* self, SkkState* state, guint* underline_offset, guint* underline_nchars);
static gchar* skk_state_handler_real_get_preedit (SkkStateHandler* self, SkkState* state, guint* underline_offset, guint* underline_nchars);
gchar* skk_state_handler_get_output (SkkStateHandler* self, SkkState* state);
static gchar* skk_state_handler_real_get_output (SkkStateHandler* self, SkkState* state);
SkkStateHandler* skk_state_handler_construct (GType object_type);
enum  {
	SKK_NONE_STATE_HANDLER_DUMMY_PROPERTY
};
GType skk_entry_get_type (void) G_GNUC_CONST;
SkkEntry* skk_entry_dup (const SkkEntry* self);
void skk_entry_free (SkkEntry* self);
void skk_entry_copy (const SkkEntry* self, SkkEntry* dest);
void skk_entry_destroy (SkkEntry* self);
static gboolean skk_none_state_handler_real_process_key_event (SkkStateHandler* base, SkkState* state, SkkKeyEvent** key);
SkkUnicodeString* skk_unicode_string_new (const gchar* str);
SkkUnicodeString* skk_unicode_string_construct (GType object_type, const gchar* str);
GType skk_start_state_handler_get_type (void) G_GNUC_CONST;
GType skk_modifier_type_get_type (void) G_GNUC_CONST;
SkkModifierType skk_key_event_get_modifiers (SkkKeyEvent* self);
gboolean skk_rom_kana_converter_can_consume (SkkRomKanaConverter* self, gunichar uc, gboolean preedit_only, gboolean no_carryover);
gunichar skk_key_event_get_code (SkkKeyEvent* self);
gboolean skk_rom_kana_converter_delete (SkkRomKanaConverter* self);
GType skk_abbrev_state_handler_get_type (void) G_GNUC_CONST;
GType skk_kuten_state_handler_get_type (void) G_GNUC_CONST;
gchar* skk_util_convert_by_input_mode (const gchar* str, SkkInputMode input_mode);
gboolean skk_rom_kana_converter_append (SkkRomKanaConverter* self, gunichar uc);
gunichar skk_util_get_wide_latin_char (gchar c);
static gchar* skk_none_state_handler_real_get_preedit (SkkStateHandler* base, SkkState* state, guint* underline_offset, guint* underline_nchars);
SkkNoneStateHandler* skk_none_state_handler_new (void);
SkkNoneStateHandler* skk_none_state_handler_construct (GType object_type);
GType skk_encoding_converter_get_type (void) G_GNUC_CONST;
#define SKK_KUTEN_STATE_HANDLER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SKK_TYPE_KUTEN_STATE_HANDLER, SkkKutenStateHandlerPrivate))
enum  {
	SKK_KUTEN_STATE_HANDLER_DUMMY_PROPERTY
};
SkkKutenStateHandler* skk_kuten_state_handler_new (void);
SkkKutenStateHandler* skk_kuten_state_handler_construct (GType object_type);
SkkEncodingConverter* skk_encoding_converter_new (const gchar* encoding, GError** error);
SkkEncodingConverter* skk_encoding_converter_construct (GType object_type, const gchar* encoding, GError** error);
static gint skk_kuten_state_handler_hex_char_to_int (SkkKutenStateHandler* self, gchar hex);
static gchar* skk_kuten_state_handler_parse_hex (SkkKutenStateHandler* self, const gchar* hex);
static gboolean skk_kuten_state_handler_real_process_key_event (SkkStateHandler* base, SkkState* state, SkkKeyEvent** key);
gchar* skk_encoding_converter_decode (SkkEncodingConverter* self, const gchar* external_str, GError** error);
static gchar* skk_kuten_state_handler_real_get_preedit (SkkStateHandler* base, SkkState* state, guint* underline_offset, guint* underline_nchars);
static void skk_kuten_state_handler_finalize (GObject* obj);
enum  {
	SKK_ABBREV_STATE_HANDLER_DUMMY_PROPERTY
};
static gboolean skk_abbrev_state_handler_real_process_key_event (SkkStateHandler* base, SkkState* state, SkkKeyEvent** key);
GType skk_select_state_handler_get_type (void) G_GNUC_CONST;
gchar* skk_util_get_wide_latin (const gchar* latin);
static gchar* skk_abbrev_state_handler_real_get_preedit (SkkStateHandler* base, SkkState* state, guint* underline_offset, guint* underline_nchars);
SkkAbbrevStateHandler* skk_abbrev_state_handler_new (void);
SkkAbbrevStateHandler* skk_abbrev_state_handler_construct (GType object_type);
enum  {
	SKK_START_STATE_HANDLER_DUMMY_PROPERTY
};
static gboolean skk_start_state_handler_real_process_key_event (SkkStateHandler* base, SkkState* state, SkkKeyEvent** key);
gboolean skk_rom_kana_converter_output_nn_if_any (SkkRomKanaConverter* self);
static gboolean skk_start_state_handler_check_auto_conversion (SkkStartStateHandler* self, SkkState* state, SkkKeyEvent* key);
static gchar* skk_start_state_handler_real_get_preedit (SkkStateHandler* base, SkkState* state, guint* underline_offset, guint* underline_nchars);
SkkStartStateHandler* skk_start_state_handler_new (void);
SkkStartStateHandler* skk_start_state_handler_construct (GType object_type);
enum  {
	SKK_SELECT_STATE_HANDLER_DUMMY_PROPERTY
};
static gboolean skk_select_state_handler_real_process_key_event (SkkStateHandler* base, SkkState* state, SkkKeyEvent** key);
gboolean skk_candidate_list_previous (SkkCandidateList* self);
SkkCandidate* skk_candidate_list_get (SkkCandidateList* self, gint index);
gint skk_candidate_list_get_cursor_pos (SkkCandidateList* self);
gchar* skk_util_get_okurigana_prefix (const gchar* okurigana);
gchar* skk_util_get_hiragana (const gchar* kana);
gint skk_candidate_list_get_size (SkkCandidateList* self);
gboolean skk_candidate_list_next (SkkCandidateList* self);
void skk_candidate_list_select (SkkCandidateList* self);
static gchar* skk_select_state_handler_real_get_preedit (SkkStateHandler* base, SkkState* state, guint* underline_offset, guint* underline_nchars);
SkkSelectStateHandler* skk_select_state_handler_new (void);
SkkSelectStateHandler* skk_select_state_handler_construct (GType object_type);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

const gchar* SKK_AUTO_START_HENKAN_KEYWORDS[28] = {"を", "、", "。", "．", "，", "？", "」", "！", "；", "：", ")", ";", ":", "）", "”", "】", "』", "》", "〉", "｝", "］", "〕", "}", "]", "?", ".", ",", "!"};
static const SkkEntry SKK_NONE_STATE_HANDLER_input_mode_commands[5] = {{"set-input-mode-hiragana", SKK_INPUT_MODE_HIRAGANA}, {"set-input-mode-katakana", SKK_INPUT_MODE_KATAKANA}, {"set-input-mode-hankaku-katakana", SKK_INPUT_MODE_HANKAKU_KATAKANA}, {"set-input-mode-latin", SKK_INPUT_MODE_LATIN}, {"set-input-mode-wide-latin", SKK_INPUT_MODE_WIDE_LATIN}};
static const SkkEntry SKK_START_STATE_HANDLER_end_preedit_commands[3] = {{"set-input-mode-hiragana", SKK_INPUT_MODE_HIRAGANA}, {"set-input-mode-katakana", SKK_INPUT_MODE_KATAKANA}, {"set-input-mode-hankaku-katakana", SKK_INPUT_MODE_HANKAKU_KATAKANA}};

static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


gchar* skk_state_lookup_key (SkkState* self, SkkKeyEvent* key) {
	gchar* result = NULL;
	SkkRule* _tmp0_;
	SkkKeymapMapFile** _tmp1_;
	gint _tmp1__length1;
	SkkInputMode _tmp2_;
	SkkInputMode _tmp3_;
	SkkKeymapMapFile* _tmp4_;
	SkkKeymap* _tmp5_;
	SkkKeymap* _tmp6_;
	SkkKeymap* keymap;
	SkkKeyEvent* _tmp7_;
	gchar* _tmp8_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = self->priv->_typing_rule;
	_tmp1_ = _tmp0_->keymaps;
	_tmp1__length1 = _tmp0_->keymaps_length1;
	_tmp2_ = skk_state_get_input_mode (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp1_[_tmp3_];
	_tmp5_ = _tmp4_->keymap;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	keymap = _tmp6_;
	g_return_val_if_fail (keymap != NULL, NULL);
	_tmp7_ = key;
	_tmp8_ = skk_keymap_lookup_key (keymap, _tmp7_);
	result = _tmp8_;
	_g_object_unref0 (keymap);
	return result;
}


SkkKeyEvent* skk_state_where_is (SkkState* self, const gchar* command) {
	SkkKeyEvent* result = NULL;
	SkkRule* _tmp0_;
	SkkKeymapMapFile** _tmp1_;
	gint _tmp1__length1;
	SkkInputMode _tmp2_;
	SkkInputMode _tmp3_;
	SkkKeymapMapFile* _tmp4_;
	SkkKeymap* _tmp5_;
	SkkKeymap* _tmp6_;
	SkkKeymap* keymap;
	const gchar* _tmp7_;
	SkkKeyEvent* _tmp8_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (command != NULL, NULL);
	_tmp0_ = self->priv->_typing_rule;
	_tmp1_ = _tmp0_->keymaps;
	_tmp1__length1 = _tmp0_->keymaps_length1;
	_tmp2_ = skk_state_get_input_mode (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp1_[_tmp3_];
	_tmp5_ = _tmp4_->keymap;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	keymap = _tmp6_;
	g_return_val_if_fail (keymap != NULL, NULL);
	_tmp7_ = command;
	_tmp8_ = skk_keymap_where_is (keymap, _tmp7_);
	result = _tmp8_;
	_g_object_unref0 (keymap);
	return result;
}


static void _skk_state_candidate_selected_skk_candidate_list_selected (SkkCandidateList* _sender, SkkCandidate* candidate, gpointer self) {
	skk_state_candidate_selected (self, candidate);
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


SkkState* skk_state_construct (GType object_type, GeeList* dictionaries) {
	SkkState * self = NULL;
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	SkkSimpleCandidateList* _tmp2_;
	SkkCandidateList* _tmp3_;
	SkkRomKanaConverter* _tmp4_;
	SkkRomKanaConverter* _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (dictionaries != NULL, NULL);
	self = (SkkState*) g_object_new (object_type, NULL);
	_tmp0_ = dictionaries;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->dictionaries);
	self->dictionaries = _tmp1_;
	_tmp2_ = skk_simple_candidate_list_new ((guint) 4, (guint) 7);
	_g_object_unref0 (self->candidates);
	self->candidates = (SkkCandidateList*) _tmp2_;
	_tmp3_ = self->candidates;
	g_signal_connect_object (_tmp3_, "selected", (GCallback) _skk_state_candidate_selected_skk_candidate_list_selected, self, 0);
	_tmp4_ = skk_rom_kana_converter_new ();
	_g_object_unref0 (self->rom_kana_converter);
	self->rom_kana_converter = _tmp4_;
	_tmp5_ = skk_rom_kana_converter_new ();
	_g_object_unref0 (self->okuri_rom_kana_converter);
	self->okuri_rom_kana_converter = _tmp5_;
	_tmp6_ = (SKK_AUTO_START_HENKAN_KEYWORDS != NULL) ? _vala_array_dup3 (SKK_AUTO_START_HENKAN_KEYWORDS, G_N_ELEMENTS (SKK_AUTO_START_HENKAN_KEYWORDS)) : ((gpointer) SKK_AUTO_START_HENKAN_KEYWORDS);
	_tmp6__length1 = G_N_ELEMENTS (SKK_AUTO_START_HENKAN_KEYWORDS);
	self->auto_start_henkan_keywords = (_vala_array_free (self->auto_start_henkan_keywords, self->auto_start_henkan_keywords_length1, (GDestroyNotify) g_free), NULL);
	self->auto_start_henkan_keywords = _tmp6_;
	self->auto_start_henkan_keywords_length1 = _tmp6__length1;
	self->_auto_start_henkan_keywords_size_ = self->auto_start_henkan_keywords_length1;
	{
		SkkRule* _tmp7_;
		SkkRule* _tmp8_;
		_tmp7_ = skk_rule_new ("default", &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == SKK_RULE_PARSE_ERROR) {
				goto __catch26_skk_rule_parse_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_object_unref0 (self->priv->_typing_rule);
		self->priv->_typing_rule = _tmp8_;
	}
	goto __finally26;
	__catch26_skk_rule_parse_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally26:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	{
		GRegex* _tmp9_;
		GRegex* _tmp10_;
		_tmp9_ = g_regex_new ("[0-9]+", 0, 0, &_inner_error_);
		_tmp10_ = _tmp9_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch27_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_regex_unref0 (self->priv->numeric_regex);
		self->priv->numeric_regex = _tmp10_;
	}
	goto __finally27;
	__catch27_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally27:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	{
		GRegex* _tmp11_;
		GRegex* _tmp12_;
		_tmp11_ = g_regex_new ("#([0-9])", 0, 0, &_inner_error_);
		_tmp12_ = _tmp11_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch28_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_regex_unref0 (self->priv->numeric_ref_regex);
		self->priv->numeric_ref_regex = _tmp12_;
	}
	goto __finally28;
	__catch28_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally28:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	skk_state_reset (self);
	return self;
}


SkkState* skk_state_new (GeeList* dictionaries) {
	return skk_state_construct (SKK_TYPE_STATE, dictionaries);
}


static void skk_state_candidate_selected (SkkState* self, SkkCandidate* c) {
	GString* _tmp0_;
	SkkCandidate* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	SkkInputMode _tmp12_;
	SkkInputMode _tmp13_;
	SkkInputMode _mode;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	_tmp0_ = self->output;
	_tmp1_ = c;
	_tmp2_ = skk_candidate_get_output (_tmp1_);
	_tmp3_ = _tmp2_;
	g_string_append (_tmp0_, _tmp3_);
	_tmp4_ = self->auto_start_henkan_keyword;
	if (_tmp4_ != NULL) {
		GString* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = self->output;
		_tmp6_ = self->auto_start_henkan_keyword;
		g_string_append (_tmp5_, _tmp6_);
	} else {
		gboolean _tmp7_;
		_tmp7_ = self->okuri;
		if (_tmp7_) {
			GString* _tmp8_;
			SkkRomKanaConverter* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			_tmp8_ = self->output;
			_tmp9_ = self->okuri_rom_kana_converter;
			_tmp10_ = skk_rom_kana_converter_get_output (_tmp9_);
			_tmp11_ = _tmp10_;
			g_string_append (_tmp8_, _tmp11_);
		}
	}
	_tmp12_ = skk_state_get_input_mode (self);
	_tmp13_ = _tmp12_;
	_mode = _tmp13_;
	skk_state_reset (self);
	self->priv->_input_mode = _mode;
}


void skk_state_output_surrounding_text (SkkState* self) {
	SkkUnicodeString* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->surrounding_text;
	if (_tmp0_ != NULL) {
		GString* _tmp1_;
		SkkUnicodeString* _tmp2_;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		_tmp1_ = self->output;
		_tmp2_ = self->surrounding_text;
		_tmp3_ = skk_unicode_string_substring (_tmp2_, (glong) 0, (glong) (-1));
		_tmp4_ = _tmp3_;
		g_string_append (_tmp1_, _tmp4_);
		_g_free0 (_tmp4_);
	}
}


void skk_state_reset (SkkState* self) {
	SkkRomKanaConverter* _tmp0_;
	SkkRomKanaConverter* _tmp1_;
	SkkRule* _tmp2_;
	SkkKeyEventFilter* _tmp3_ = NULL;
	SkkKeyEventFilter* _tmp4_;
	GeeArrayList* _tmp5_;
	SkkCandidateList* _tmp6_;
	GString* _tmp7_;
	GString* _tmp8_;
	g_return_if_fail (self != NULL);
	self->handler_type = SKK_TYPE_NONE_STATE_HANDLER;
	_tmp0_ = self->rom_kana_converter;
	skk_rom_kana_converter_reset (_tmp0_);
	_tmp1_ = self->okuri_rom_kana_converter;
	skk_rom_kana_converter_reset (_tmp1_);
	self->okuri = FALSE;
	_tmp2_ = self->priv->_typing_rule;
	_tmp3_ = skk_rule_get_filter (_tmp2_);
	_tmp4_ = _tmp3_;
	skk_key_event_filter_reset (_tmp4_);
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (self->completion_iterator);
	self->completion_iterator = NULL;
	_tmp5_ = self->priv->completion;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp5_);
	_tmp6_ = self->candidates;
	skk_candidate_list_clear (_tmp6_);
	_tmp7_ = self->abbrev;
	g_string_erase (_tmp7_, (gssize) 0, (gssize) (-1));
	_tmp8_ = self->kuten;
	g_string_erase (_tmp8_, (gssize) 0, (gssize) (-1));
	_g_free0 (self->auto_start_henkan_keyword);
	self->auto_start_henkan_keyword = NULL;
	_g_object_unref0 (self->surrounding_text);
	self->surrounding_text = NULL;
	self->surrounding_end = (guint) 0;
}


void skk_state_cancel_okuri (SkkState* self) {
	SkkRomKanaConverter* _tmp0_;
	SkkRomKanaConverter* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	SkkRomKanaConverter* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	SkkRomKanaConverter* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->rom_kana_converter;
	_tmp1_ = self->rom_kana_converter;
	_tmp2_ = skk_rom_kana_converter_get_output (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->okuri_rom_kana_converter;
	_tmp5_ = skk_rom_kana_converter_get_output (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat (_tmp3_, _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	skk_rom_kana_converter_set_output (_tmp1_, _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = self->okuri_rom_kana_converter;
	skk_rom_kana_converter_reset (_tmp9_);
	self->okuri = FALSE;
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


static gchar* skk_state_extract_numerics (SkkState* self, const gchar* midasi, gint** numerics, int* numerics_length1) {
	gint* _vala_numerics = NULL;
	int _vala_numerics_length1 = 0;
	gchar* result = NULL;
	GMatchInfo* info;
	gint start_pos;
	GeeArrayList* _tmp0_;
	GeeArrayList* numeric_list;
	GString* _tmp1_;
	GString* builder;
	GeeArrayList* _tmp25_;
	gint _tmp26_ = 0;
	gpointer* _tmp27_ = NULL;
	GString* _tmp28_;
	const gchar* _tmp29_;
	gint _tmp30_;
	const gchar* _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	gchar* _tmp34_ = NULL;
	gchar* _tmp35_;
	GString* _tmp36_;
	const gchar* _tmp37_;
	gchar* _tmp38_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (midasi != NULL, NULL);
	info = NULL;
	start_pos = 0;
	_tmp0_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL);
	numeric_list = _tmp0_;
	_tmp1_ = g_string_new ("");
	builder = _tmp1_;
	while (TRUE) {
		GMatchInfo* _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* numeric;
		gint match_start_pos = 0;
		gint match_end_pos = 0;
		GMatchInfo* _tmp11_;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		GeeArrayList* _tmp14_;
		const gchar* _tmp15_;
		gint _tmp16_ = 0;
		GString* _tmp17_;
		const gchar* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
		GString* _tmp23_;
		gint _tmp24_;
		{
			GRegex* _tmp2_;
			const gchar* _tmp3_;
			gint _tmp4_;
			GMatchInfo* _tmp5_ = NULL;
			gboolean _tmp6_ = FALSE;
			gboolean _tmp7_;
			_tmp2_ = self->priv->numeric_regex;
			_tmp3_ = midasi;
			_tmp4_ = start_pos;
			_tmp6_ = g_regex_match_full (_tmp2_, _tmp3_, (gssize) (-1), _tmp4_, 0, &_tmp5_, &_inner_error_);
			_g_match_info_free0 (info);
			info = _tmp5_;
			_tmp7_ = _tmp6_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch29_g_regex_error;
				}
				_g_string_free0 (builder);
				_g_object_unref0 (numeric_list);
				_g_match_info_free0 (info);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			if (!_tmp7_) {
				break;
			}
		}
		goto __finally29;
		__catch29_g_regex_error:
		{
			GError* e = NULL;
			const gchar* _tmp8_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp8_ = midasi;
			g_return_val_if_reached (_tmp8_);
			_g_error_free0 (e);
		}
		__finally29:
		if (_inner_error_ != NULL) {
			_g_string_free0 (builder);
			_g_object_unref0 (numeric_list);
			_g_match_info_free0 (info);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp9_ = info;
		_tmp10_ = g_match_info_fetch (_tmp9_, 0);
		numeric = _tmp10_;
		_tmp11_ = info;
		g_match_info_fetch_pos (_tmp11_, 0, &_tmp12_, &_tmp13_);
		match_start_pos = _tmp12_;
		match_end_pos = _tmp13_;
		_tmp14_ = numeric_list;
		_tmp15_ = numeric;
		_tmp16_ = atoi (_tmp15_);
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, GINT_TO_POINTER (_tmp16_));
		_tmp17_ = builder;
		_tmp18_ = midasi;
		_tmp19_ = start_pos;
		_tmp20_ = match_start_pos;
		_tmp21_ = string_slice (_tmp18_, (glong) _tmp19_, (glong) _tmp20_);
		_tmp22_ = _tmp21_;
		g_string_append (_tmp17_, _tmp22_);
		_g_free0 (_tmp22_);
		_tmp23_ = builder;
		g_string_append (_tmp23_, "#");
		_tmp24_ = match_end_pos;
		start_pos = _tmp24_;
		_g_free0 (numeric);
	}
	_tmp25_ = numeric_list;
	_tmp27_ = gee_abstract_collection_to_array ((GeeAbstractCollection*) _tmp25_, &_tmp26_);
	_vala_numerics = (g_free (_vala_numerics), NULL);
	_vala_numerics = _tmp27_;
	_vala_numerics_length1 = _tmp26_;
	_tmp28_ = builder;
	_tmp29_ = midasi;
	_tmp30_ = start_pos;
	_tmp31_ = midasi;
	_tmp32_ = strlen (_tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = string_slice (_tmp29_, (glong) _tmp30_, (glong) _tmp33_);
	_tmp35_ = _tmp34_;
	g_string_append (_tmp28_, _tmp35_);
	_g_free0 (_tmp35_);
	_tmp36_ = builder;
	_tmp37_ = _tmp36_->str;
	_tmp38_ = g_strdup (_tmp37_);
	result = _tmp38_;
	_g_string_free0 (builder);
	_g_object_unref0 (numeric_list);
	_g_match_info_free0 (info);
	if (numerics) {
		*numerics = _vala_numerics;
	} else {
		_vala_numerics = (g_free (_vala_numerics), NULL);
	}
	if (numerics_length1) {
		*numerics_length1 = _vala_numerics_length1;
	}
	return result;
}


static gchar* skk_state_expand_expr (SkkState* self, const gchar* text) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	_tmp0_ = text;
	_tmp1_ = g_str_has_prefix (_tmp0_, "(");
	if (_tmp1_) {
		SkkExprReader* _tmp2_;
		SkkExprReader* reader;
		gint index;
		SkkExprReader* _tmp3_;
		const gchar* _tmp4_;
		SkkExprNode* _tmp5_ = NULL;
		SkkExprNode* node;
		SkkExprEvaluator* _tmp6_;
		SkkExprEvaluator* evaluator;
		SkkExprEvaluator* _tmp7_;
		SkkExprNode* _tmp8_;
		SkkExprNode _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* _text;
		const gchar* _tmp11_;
		_tmp2_ = skk_expr_reader_new ();
		reader = _tmp2_;
		index = 0;
		_tmp3_ = reader;
		_tmp4_ = text;
		_tmp5_ = skk_expr_reader_read_expr (_tmp3_, _tmp4_, &index);
		node = _tmp5_;
		_tmp6_ = skk_expr_evaluator_new ();
		evaluator = _tmp6_;
		_tmp7_ = evaluator;
		_tmp8_ = node;
		_tmp9_ = *_tmp8_;
		_tmp10_ = skk_expr_evaluator_eval (_tmp7_, &_tmp9_);
		_text = _tmp10_;
		_tmp11_ = _text;
		if (_tmp11_ != NULL) {
			result = _text;
			_g_object_unref0 (evaluator);
			_skk_expr_node_free0 (node);
			_g_object_unref0 (reader);
			return result;
		}
		_g_free0 (_text);
		_g_object_unref0 (evaluator);
		_skk_expr_node_free0 (node);
		_g_object_unref0 (reader);
	}
	_tmp12_ = text;
	_tmp13_ = g_strdup (_tmp12_);
	result = _tmp13_;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gchar* skk_state_expand_numeric_references (SkkState* self, const gchar* text, gint* numerics, int numerics_length1) {
	gchar* result = NULL;
	GString* _tmp0_;
	GString* builder;
	GMatchInfo* info;
	gint start_pos;
	GString* _tmp35_;
	const gchar* _tmp36_;
	gint _tmp37_;
	const gchar* _tmp38_;
	gint _tmp39_;
	gint _tmp40_;
	gchar* _tmp41_ = NULL;
	gchar* _tmp42_;
	GString* _tmp43_;
	const gchar* _tmp44_;
	gchar* _tmp45_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	info = NULL;
	start_pos = 0;
	{
		gint numeric_index;
		numeric_index = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_;
				gint _tmp4_;
				gint* _tmp5_;
				gint _tmp5__length1;
				gint match_start_pos = 0;
				gint match_end_pos = 0;
				GMatchInfo* _tmp12_;
				gint _tmp13_ = 0;
				gint _tmp14_ = 0;
				GString* _tmp15_;
				const gchar* _tmp16_;
				gint _tmp17_;
				gint _tmp18_;
				gchar* _tmp19_ = NULL;
				gchar* _tmp20_;
				GMatchInfo* _tmp21_;
				gchar* _tmp22_ = NULL;
				gchar* type;
				const gchar* _tmp23_;
				gchar _tmp24_ = '\0';
				gint _tmp34_;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = numeric_index;
					numeric_index = _tmp3_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp4_ = numeric_index;
				_tmp5_ = numerics;
				_tmp5__length1 = numerics_length1;
				if (!(_tmp4_ < _tmp5__length1)) {
					break;
				}
				{
					GRegex* _tmp6_;
					const gchar* _tmp7_;
					gint _tmp8_;
					GMatchInfo* _tmp9_ = NULL;
					gboolean _tmp10_ = FALSE;
					gboolean _tmp11_;
					_tmp6_ = self->priv->numeric_ref_regex;
					_tmp7_ = text;
					_tmp8_ = start_pos;
					_tmp10_ = g_regex_match_full (_tmp6_, _tmp7_, (gssize) (-1), _tmp8_, 0, &_tmp9_, &_inner_error_);
					_g_match_info_free0 (info);
					info = _tmp9_;
					_tmp11_ = _tmp10_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == G_REGEX_ERROR) {
							goto __catch30_g_regex_error;
						}
						_g_match_info_free0 (info);
						_g_string_free0 (builder);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
					if (!_tmp11_) {
						break;
					}
				}
				goto __finally30;
				__catch30_g_regex_error:
				{
					GError* e = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					g_return_if_reached ();
					_g_error_free0 (e);
				}
				__finally30:
				if (_inner_error_ != NULL) {
					_g_match_info_free0 (info);
					_g_string_free0 (builder);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_tmp12_ = info;
				g_match_info_fetch_pos (_tmp12_, 0, &_tmp13_, &_tmp14_);
				match_start_pos = _tmp13_;
				match_end_pos = _tmp14_;
				_tmp15_ = builder;
				_tmp16_ = text;
				_tmp17_ = start_pos;
				_tmp18_ = match_start_pos;
				_tmp19_ = string_slice (_tmp16_, (glong) _tmp17_, (glong) _tmp18_);
				_tmp20_ = _tmp19_;
				g_string_append (_tmp15_, _tmp20_);
				_g_free0 (_tmp20_);
				_tmp21_ = info;
				_tmp22_ = g_match_info_fetch (_tmp21_, 1);
				type = _tmp22_;
				_tmp23_ = type;
				_tmp24_ = string_get (_tmp23_, (glong) 0);
				switch (_tmp24_) {
					case '0':
					case '1':
					case '2':
					case '3':
					case '5':
					{
						GString* _tmp25_;
						gint* _tmp26_;
						gint _tmp26__length1;
						gint _tmp27_;
						gint _tmp28_;
						const gchar* _tmp29_;
						gchar _tmp30_ = '\0';
						gchar* _tmp31_ = NULL;
						gchar* _tmp32_;
						_tmp25_ = builder;
						_tmp26_ = numerics;
						_tmp26__length1 = numerics_length1;
						_tmp27_ = numeric_index;
						_tmp28_ = _tmp26_[_tmp27_];
						_tmp29_ = type;
						_tmp30_ = string_get (_tmp29_, (glong) 0);
						_tmp31_ = skk_util_get_numeric (_tmp28_, (SkkNumericConversionType) (_tmp30_ - '0'));
						_tmp32_ = _tmp31_;
						g_string_append (_tmp25_, _tmp32_);
						_g_free0 (_tmp32_);
						break;
					}
					case '4':
					case '9':
					{
						break;
					}
					default:
					{
						const gchar* _tmp33_;
						_tmp33_ = type;
						g_warning ("state.vala:285: unknown numeric conversion type: %s", _tmp33_);
						break;
					}
				}
				_tmp34_ = match_end_pos;
				start_pos = _tmp34_;
				_g_free0 (type);
			}
		}
	}
	_tmp35_ = builder;
	_tmp36_ = text;
	_tmp37_ = start_pos;
	_tmp38_ = text;
	_tmp39_ = strlen (_tmp38_);
	_tmp40_ = _tmp39_;
	_tmp41_ = string_slice (_tmp36_, (glong) _tmp37_, (glong) _tmp40_);
	_tmp42_ = _tmp41_;
	g_string_append (_tmp35_, _tmp42_);
	_g_free0 (_tmp42_);
	_tmp43_ = builder;
	_tmp44_ = _tmp43_->str;
	_tmp45_ = g_strdup (_tmp44_);
	result = _tmp45_;
	_g_match_info_free0 (info);
	_g_string_free0 (builder);
	return result;
}


void skk_state_lookup (SkkState* self, const gchar* midasi, gboolean okuri) {
	SkkCandidateList* _tmp0_;
	gint* _tmp1_ = NULL;
	gint* numerics;
	gint numerics_length1;
	gint _numerics_size_;
	const gchar* _tmp2_;
	gint* _tmp3_;
	gint _tmp3__length1;
	gboolean _tmp4_;
	const gchar* _tmp5_;
	gint* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gchar* _tmp8_ = NULL;
	gchar* numeric_midasi;
	gint* _tmp9_;
	gint _tmp9__length1;
	gboolean _tmp10_;
	SkkCandidateList* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (midasi != NULL);
	_tmp0_ = self->candidates;
	skk_candidate_list_clear (_tmp0_);
	_tmp1_ = g_new0 (gint, 0);
	numerics = _tmp1_;
	numerics_length1 = 0;
	_numerics_size_ = numerics_length1;
	_tmp2_ = midasi;
	_tmp3_ = numerics;
	_tmp3__length1 = numerics_length1;
	_tmp4_ = okuri;
	skk_state_lookup_internal (self, _tmp2_, _tmp3_, _tmp3__length1, _tmp4_);
	_tmp5_ = midasi;
	_tmp8_ = skk_state_extract_numerics (self, _tmp5_, &_tmp6_, &_tmp7_);
	numerics = (g_free (numerics), NULL);
	numerics = _tmp6_;
	numerics_length1 = _tmp7_;
	_numerics_size_ = numerics_length1;
	numeric_midasi = _tmp8_;
	_tmp9_ = numerics;
	_tmp9__length1 = numerics_length1;
	_tmp10_ = okuri;
	skk_state_lookup_internal (self, numeric_midasi, _tmp9_, _tmp9__length1, _tmp10_);
	_tmp11_ = self->candidates;
	skk_candidate_list_add_candidates_end (_tmp11_);
	_g_free0 (numeric_midasi);
	numerics = (g_free (numerics), NULL);
}


static void skk_state_lookup_internal (SkkState* self, const gchar* midasi, gint* numerics, int numerics_length1, gboolean okuri) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (midasi != NULL);
	{
		GeeList* _tmp0_;
		GeeList* _tmp1_;
		GeeList* _dict_list;
		GeeList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _dict_size;
		gint _dict_index;
		_tmp0_ = self->dictionaries;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_dict_list = _tmp1_;
		_tmp2_ = _dict_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_dict_size = _tmp4_;
		_dict_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GeeList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_ = NULL;
			SkkDict* dict;
			SkkDict* _tmp11_;
			const gchar* _tmp12_;
			gboolean _tmp13_;
			gint _tmp14_ = 0;
			SkkCandidate** _tmp15_ = NULL;
			SkkCandidate** _candidates;
			gint _candidates_length1;
			gint __candidates_size_;
			SkkCandidate** _tmp16_;
			gint _tmp16__length1;
			SkkCandidateList* _tmp38_;
			SkkCandidate** _tmp39_;
			gint _tmp39__length1;
			_tmp5_ = _dict_index;
			_dict_index = _tmp5_ + 1;
			_tmp6_ = _dict_index;
			_tmp7_ = _dict_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _dict_list;
			_tmp9_ = _dict_index;
			_tmp10_ = gee_list_get (_tmp8_, _tmp9_);
			dict = (SkkDict*) _tmp10_;
			_tmp11_ = dict;
			_tmp12_ = midasi;
			_tmp13_ = okuri;
			_tmp15_ = skk_dict_lookup (_tmp11_, _tmp12_, _tmp13_, &_tmp14_);
			_candidates = _tmp15_;
			_candidates_length1 = _tmp14_;
			__candidates_size_ = _candidates_length1;
			_tmp16_ = _candidates;
			_tmp16__length1 = _candidates_length1;
			{
				SkkCandidate** candidate_collection = NULL;
				gint candidate_collection_length1 = 0;
				gint _candidate_collection_size_ = 0;
				gint candidate_it = 0;
				candidate_collection = _tmp16_;
				candidate_collection_length1 = _tmp16__length1;
				for (candidate_it = 0; candidate_it < _tmp16__length1; candidate_it = candidate_it + 1) {
					SkkCandidate* _tmp17_;
					SkkCandidate* candidate = NULL;
					_tmp17_ = _g_object_ref0 (candidate_collection[candidate_it]);
					candidate = _tmp17_;
					{
						SkkCandidate* _tmp18_;
						const gchar* _tmp19_;
						const gchar* _tmp20_;
						gchar* _tmp21_;
						gchar* text;
						const gchar* _tmp22_;
						gchar* _tmp23_ = NULL;
						const gchar* _tmp24_;
						gint* _tmp25_;
						gint _tmp25__length1;
						gchar* _tmp26_ = NULL;
						SkkCandidate* _tmp27_;
						const gchar* _tmp28_;
						SkkCandidate* _tmp29_;
						const gchar* _tmp30_;
						const gchar* _tmp31_;
						_tmp18_ = candidate;
						_tmp19_ = skk_candidate_get_text (_tmp18_);
						_tmp20_ = _tmp19_;
						_tmp21_ = g_strdup (_tmp20_);
						text = _tmp21_;
						_tmp22_ = text;
						_tmp23_ = skk_state_expand_expr (self, _tmp22_);
						_g_free0 (text);
						text = _tmp23_;
						_tmp24_ = text;
						_tmp25_ = numerics;
						_tmp25__length1 = numerics_length1;
						_tmp26_ = skk_state_expand_numeric_references (self, _tmp24_, _tmp25_, _tmp25__length1);
						_g_free0 (text);
						text = _tmp26_;
						_tmp27_ = candidate;
						_tmp28_ = text;
						skk_candidate_set_output (_tmp27_, _tmp28_);
						_tmp29_ = candidate;
						_tmp30_ = skk_candidate_get_annotation (_tmp29_);
						_tmp31_ = _tmp30_;
						if (_tmp31_ != NULL) {
							SkkCandidate* _tmp32_;
							SkkCandidate* _tmp33_;
							const gchar* _tmp34_;
							const gchar* _tmp35_;
							gchar* _tmp36_ = NULL;
							gchar* _tmp37_;
							_tmp32_ = candidate;
							_tmp33_ = candidate;
							_tmp34_ = skk_candidate_get_annotation (_tmp33_);
							_tmp35_ = _tmp34_;
							_tmp36_ = skk_state_expand_expr (self, _tmp35_);
							_tmp37_ = _tmp36_;
							skk_candidate_set_annotation (_tmp32_, _tmp37_);
							_g_free0 (_tmp37_);
						}
						_g_free0 (text);
						_g_object_unref0 (candidate);
					}
				}
			}
			_tmp38_ = self->candidates;
			_tmp39_ = _candidates;
			_tmp39__length1 = _candidates_length1;
			skk_candidate_list_add_candidates (_tmp38_, _tmp39_, _tmp39__length1);
			_candidates = (_vala_array_free (_candidates, _candidates_length1, (GDestroyNotify) g_object_unref), NULL);
			_g_object_unref0 (dict);
		}
		_g_object_unref0 (_dict_list);
	}
}


void skk_state_purge_candidate (SkkState* self, SkkCandidate* candidate) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (candidate != NULL);
	{
		GeeList* _tmp0_;
		GeeList* _tmp1_;
		GeeList* _dict_list;
		GeeList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _dict_size;
		gint _dict_index;
		_tmp0_ = self->dictionaries;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_dict_list = _tmp1_;
		_tmp2_ = _dict_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_dict_size = _tmp4_;
		_dict_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GeeList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_ = NULL;
			SkkDict* dict;
			SkkDict* _tmp11_;
			gboolean _tmp12_;
			gboolean _tmp13_;
			_tmp5_ = _dict_index;
			_dict_index = _tmp5_ + 1;
			_tmp6_ = _dict_index;
			_tmp7_ = _dict_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _dict_list;
			_tmp9_ = _dict_index;
			_tmp10_ = gee_list_get (_tmp8_, _tmp9_);
			dict = (SkkDict*) _tmp10_;
			_tmp11_ = dict;
			_tmp12_ = skk_dict_get_read_only (_tmp11_);
			_tmp13_ = _tmp12_;
			if (!_tmp13_) {
				SkkDict* _tmp14_;
				SkkCandidate* _tmp15_;
				_tmp14_ = dict;
				_tmp15_ = candidate;
				skk_dict_purge_candidate (_tmp14_, _tmp15_);
			}
			_g_object_unref0 (dict);
		}
		_g_object_unref0 (_dict_list);
	}
}


void skk_state_completion_start (SkkState* self, const gchar* midasi) {
	GeeArrayList* _tmp20_;
	GeeIterator* _tmp21_ = NULL;
	GeeIterator* _tmp22_;
	gboolean _tmp23_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (midasi != NULL);
	{
		GeeList* _tmp0_;
		GeeList* _tmp1_;
		GeeList* _dict_list;
		GeeList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _dict_size;
		gint _dict_index;
		_tmp0_ = self->dictionaries;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_dict_list = _tmp1_;
		_tmp2_ = _dict_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_dict_size = _tmp4_;
		_dict_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GeeList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_ = NULL;
			SkkDict* dict;
			SkkDict* _tmp11_;
			const gchar* _tmp12_;
			gint _tmp13_ = 0;
			gchar** _tmp14_ = NULL;
			gchar** _completion;
			gint _completion_length1;
			gint __completion_size_;
			gchar** _tmp15_;
			gint _tmp15__length1;
			GeeArrayList* _tmp19_;
			_tmp5_ = _dict_index;
			_dict_index = _tmp5_ + 1;
			_tmp6_ = _dict_index;
			_tmp7_ = _dict_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _dict_list;
			_tmp9_ = _dict_index;
			_tmp10_ = gee_list_get (_tmp8_, _tmp9_);
			dict = (SkkDict*) _tmp10_;
			_tmp11_ = dict;
			_tmp12_ = midasi;
			_tmp14_ = skk_dict_complete (_tmp11_, _tmp12_, &_tmp13_);
			_completion = _tmp14_;
			_completion_length1 = _tmp13_;
			__completion_size_ = _completion_length1;
			_tmp15_ = _completion;
			_tmp15__length1 = _completion_length1;
			{
				gchar** word_collection = NULL;
				gint word_collection_length1 = 0;
				gint _word_collection_size_ = 0;
				gint word_it = 0;
				word_collection = _tmp15_;
				word_collection_length1 = _tmp15__length1;
				for (word_it = 0; word_it < _tmp15__length1; word_it = word_it + 1) {
					gchar* _tmp16_;
					gchar* word = NULL;
					_tmp16_ = g_strdup (word_collection[word_it]);
					word = _tmp16_;
					{
						GeeArrayList* _tmp17_;
						const gchar* _tmp18_;
						_tmp17_ = self->priv->completion;
						_tmp18_ = word;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, _tmp18_);
						_g_free0 (word);
					}
				}
			}
			_tmp19_ = self->priv->completion;
			gee_list_sort ((GeeList*) _tmp19_, NULL);
			_completion = (_vala_array_free (_completion, _completion_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (dict);
		}
		_g_object_unref0 (_dict_list);
	}
	_tmp20_ = self->priv->completion;
	_tmp21_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp20_);
	_g_object_unref0 (self->completion_iterator);
	self->completion_iterator = _tmp21_;
	_tmp22_ = self->completion_iterator;
	_tmp23_ = gee_iterator_first (_tmp22_);
	if (!_tmp23_) {
		_g_object_unref0 (self->completion_iterator);
		self->completion_iterator = NULL;
	}
}


gchar* skk_state_get_yomi (SkkState* self) {
	gchar* result = NULL;
	GString* _tmp0_;
	GString* builder;
	GString* _tmp1_;
	gssize _tmp2_;
	GString* _tmp28_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	_tmp1_ = self->abbrev;
	_tmp2_ = _tmp1_->len;
	if (_tmp2_ > ((gssize) 0)) {
		GString* _tmp3_;
		GString* _tmp4_;
		const gchar* _tmp5_;
		_tmp3_ = builder;
		_tmp4_ = self->abbrev;
		_tmp5_ = _tmp4_->str;
		g_string_append (_tmp3_, _tmp5_);
	} else {
		gboolean _tmp6_;
		_tmp6_ = self->okuri;
		if (_tmp6_) {
			GString* _tmp7_;
			SkkRomKanaConverter* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			GString* _tmp11_;
			GString* _tmp12_;
			SkkRomKanaConverter* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			GString* _tmp16_;
			SkkRomKanaConverter* _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			_tmp7_ = builder;
			_tmp8_ = self->rom_kana_converter;
			_tmp9_ = skk_rom_kana_converter_get_output (_tmp8_);
			_tmp10_ = _tmp9_;
			g_string_append (_tmp7_, _tmp10_);
			_tmp11_ = builder;
			g_string_append (_tmp11_, "*");
			_tmp12_ = builder;
			_tmp13_ = self->okuri_rom_kana_converter;
			_tmp14_ = skk_rom_kana_converter_get_output (_tmp13_);
			_tmp15_ = _tmp14_;
			g_string_append (_tmp12_, _tmp15_);
			_tmp16_ = builder;
			_tmp17_ = self->okuri_rom_kana_converter;
			_tmp18_ = skk_rom_kana_converter_get_preedit (_tmp17_);
			_tmp19_ = _tmp18_;
			g_string_append (_tmp16_, _tmp19_);
		} else {
			GString* _tmp20_;
			SkkRomKanaConverter* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			GString* _tmp24_;
			SkkRomKanaConverter* _tmp25_;
			const gchar* _tmp26_;
			const gchar* _tmp27_;
			_tmp20_ = builder;
			_tmp21_ = self->rom_kana_converter;
			_tmp22_ = skk_rom_kana_converter_get_output (_tmp21_);
			_tmp23_ = _tmp22_;
			g_string_append (_tmp20_, _tmp23_);
			_tmp24_ = builder;
			_tmp25_ = self->rom_kana_converter;
			_tmp26_ = skk_rom_kana_converter_get_preedit (_tmp25_);
			_tmp27_ = _tmp26_;
			g_string_append (_tmp24_, _tmp27_);
		}
	}
	_tmp28_ = builder;
	_tmp29_ = _tmp28_->str;
	_tmp30_ = g_strdup (_tmp29_);
	result = _tmp30_;
	_g_string_free0 (builder);
	return result;
}


SkkInputMode skk_state_get_input_mode (SkkState* self) {
	SkkInputMode result;
	SkkInputMode _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_input_mode;
	result = _tmp0_;
	return result;
}


void skk_state_set_input_mode (SkkState* self, SkkInputMode value) {
	GString* _tmp0_;
	SkkRomKanaConverter* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	SkkInputMode _tmp4_;
	SkkInputMode last_input_mode;
	SkkInputMode _tmp5_;
	SkkInputMode _tmp6_;
	SkkInputMode _tmp11_;
	SkkInputMode _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->output;
	_tmp1_ = self->rom_kana_converter;
	_tmp2_ = skk_rom_kana_converter_get_output (_tmp1_);
	_tmp3_ = _tmp2_;
	g_string_append (_tmp0_, _tmp3_);
	_tmp4_ = self->priv->_input_mode;
	last_input_mode = _tmp4_;
	skk_state_reset (self);
	_tmp5_ = value;
	self->priv->_input_mode = _tmp5_;
	_tmp6_ = self->priv->_input_mode;
	switch (_tmp6_) {
		case SKK_INPUT_MODE_HIRAGANA:
		case SKK_INPUT_MODE_KATAKANA:
		case SKK_INPUT_MODE_HANKAKU_KATAKANA:
		{
			SkkRomKanaConverter* _tmp7_;
			SkkInputMode _tmp8_;
			SkkRomKanaConverter* _tmp9_;
			SkkInputMode _tmp10_;
			_tmp7_ = self->rom_kana_converter;
			_tmp8_ = value;
			skk_rom_kana_converter_set_kana_mode (_tmp7_, (SkkKanaMode) _tmp8_);
			_tmp9_ = self->okuri_rom_kana_converter;
			_tmp10_ = value;
			skk_rom_kana_converter_set_kana_mode (_tmp9_, (SkkKanaMode) _tmp10_);
			break;
		}
		default:
		{
			break;
		}
	}
	_tmp11_ = self->priv->_input_mode;
	_tmp12_ = last_input_mode;
	if (_tmp11_ != _tmp12_) {
		g_object_notify ((GObject*) self, "input-mode");
	}
}


SkkPeriodStyle skk_state_get_period_style (SkkState* self) {
	SkkPeriodStyle result;
	SkkRomKanaConverter* _tmp0_;
	SkkPeriodStyle _tmp1_;
	SkkPeriodStyle _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->rom_kana_converter;
	_tmp1_ = skk_rom_kana_converter_get_period_style (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


void skk_state_set_period_style (SkkState* self, SkkPeriodStyle value) {
	SkkRomKanaConverter* _tmp0_;
	SkkPeriodStyle _tmp1_;
	SkkRomKanaConverter* _tmp2_;
	SkkPeriodStyle _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->rom_kana_converter;
	_tmp1_ = value;
	skk_rom_kana_converter_set_period_style (_tmp0_, _tmp1_);
	_tmp2_ = self->okuri_rom_kana_converter;
	_tmp3_ = value;
	skk_rom_kana_converter_set_period_style (_tmp2_, _tmp3_);
	g_object_notify ((GObject *) self, "period-style");
}


SkkRule* skk_state_get_typing_rule (SkkState* self) {
	SkkRule* result;
	SkkRule* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_typing_rule;
	result = _tmp0_;
	return result;
}


void skk_state_set_typing_rule (SkkState* self, SkkRule* value) {
	SkkRule* _tmp0_;
	SkkRule* _tmp1_;
	SkkRomKanaConverter* _tmp2_;
	SkkRule* _tmp3_;
	SkkRomKanaMapFile* _tmp4_;
	SkkRomKanaConverter* _tmp5_;
	SkkRule* _tmp6_;
	SkkRomKanaMapFile* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_typing_rule);
	self->priv->_typing_rule = _tmp1_;
	_tmp2_ = self->rom_kana_converter;
	_tmp3_ = self->priv->_typing_rule;
	_tmp4_ = _tmp3_->rom_kana;
	skk_rom_kana_converter_set_rule (_tmp2_, _tmp4_);
	_tmp5_ = self->okuri_rom_kana_converter;
	_tmp6_ = self->priv->_typing_rule;
	_tmp7_ = _tmp6_->rom_kana;
	skk_rom_kana_converter_set_rule (_tmp5_, _tmp7_);
	g_object_notify ((GObject *) self, "typing-rule");
}


static void g_cclosure_user_marshal_BOOLEAN__VOID (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__VOID) (gpointer data1, gpointer data2);
	register GMarshalFunc_BOOLEAN__VOID callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 1);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__VOID) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, data2);
	g_value_set_boolean (return_value, v_return);
}


static void g_cclosure_user_marshal_BOOLEAN__STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__STRING) (gpointer data1, const char* arg_1, gpointer data2);
	register GMarshalFunc_BOOLEAN__STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__STRING) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, g_value_get_string (param_values + 1), data2);
	g_value_set_boolean (return_value, v_return);
}


static void g_cclosure_user_marshal_VOID__STRING_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_BOOLEAN) (gpointer data1, const char* arg_1, gboolean arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_boolean (param_values + 2), data2);
}


static void g_cclosure_user_marshal_BOOLEAN__POINTER_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__POINTER_POINTER) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_BOOLEAN__POINTER_POINTER callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__POINTER_POINTER) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, g_value_get_pointer (param_values + 1), g_value_get_pointer (param_values + 2), data2);
	g_value_set_boolean (return_value, v_return);
}


static void g_cclosure_user_marshal_BOOLEAN__INT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__INT_UINT) (gpointer data1, gint arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_BOOLEAN__INT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__INT_UINT) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, g_value_get_int (param_values + 1), g_value_get_uint (param_values + 2), data2);
	g_value_set_boolean (return_value, v_return);
}


static void skk_state_class_init (SkkStateClass * klass) {
	skk_state_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SkkStatePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_skk_state_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_skk_state_set_property;
	G_OBJECT_CLASS (klass)->finalize = skk_state_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_STATE_INPUT_MODE, g_param_spec_enum ("input-mode", "input-mode", "input-mode", SKK_TYPE_INPUT_MODE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_STATE_PERIOD_STYLE, g_param_spec_enum ("period-style", "period-style", "period-style", SKK_TYPE_PERIOD_STYLE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_STATE_TYPING_RULE, g_param_spec_object ("typing-rule", "typing-rule", "typing-rule", SKK_TYPE_RULE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("recursive_edit_abort", SKK_TYPE_STATE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__VOID, G_TYPE_BOOLEAN, 0);
	g_signal_new ("recursive_edit_end", SKK_TYPE_STATE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__STRING, G_TYPE_BOOLEAN, 1, G_TYPE_STRING);
	g_signal_new ("recursive_edit_start", SKK_TYPE_STATE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_BOOLEAN);
	g_signal_new ("retrieve_surrounding_text", SKK_TYPE_STATE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__POINTER_POINTER, G_TYPE_BOOLEAN, 2, G_TYPE_POINTER, G_TYPE_POINTER);
	g_signal_new ("delete_surrounding_text", SKK_TYPE_STATE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__INT_UINT, G_TYPE_BOOLEAN, 2, G_TYPE_INT, G_TYPE_UINT);
}


static void skk_state_instance_init (SkkState * self) {
	GString* _tmp0_;
	GString* _tmp1_;
	GString* _tmp2_;
	GeeArrayList* _tmp3_;
	self->priv = SKK_STATE_GET_PRIVATE (self);
	_tmp0_ = g_string_new ("");
	self->output = _tmp0_;
	_tmp1_ = g_string_new ("");
	self->abbrev = _tmp1_;
	_tmp2_ = g_string_new ("");
	self->kuten = _tmp2_;
	_tmp3_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	self->priv->completion = _tmp3_;
	self->auto_start_henkan_keyword = NULL;
	self->egg_like_newline = FALSE;
}


static void skk_state_finalize (GObject* obj) {
	SkkState * self;
	self = SKK_STATE (obj);
	skk_state_reset (self);
	_g_object_unref0 (self->dictionaries);
	_g_object_unref0 (self->candidates);
	_g_object_unref0 (self->rom_kana_converter);
	_g_object_unref0 (self->okuri_rom_kana_converter);
	_g_free0 (self->midasi);
	_g_string_free0 (self->output);
	_g_string_free0 (self->abbrev);
	_g_string_free0 (self->kuten);
	_g_object_unref0 (self->priv->completion);
	_g_object_unref0 (self->completion_iterator);
	self->auto_start_henkan_keywords = (_vala_array_free (self->auto_start_henkan_keywords, self->auto_start_henkan_keywords_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->auto_start_henkan_keyword);
	_g_object_unref0 (self->priv->_typing_rule);
	_g_regex_unref0 (self->priv->numeric_regex);
	_g_regex_unref0 (self->priv->numeric_ref_regex);
	_g_object_unref0 (self->surrounding_text);
	G_OBJECT_CLASS (skk_state_parent_class)->finalize (obj);
}


GType skk_state_get_type (void) {
	static volatile gsize skk_state_type_id__volatile = 0;
	if (g_once_init_enter (&skk_state_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SkkStateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_state_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkState), 0, (GInstanceInitFunc) skk_state_instance_init, NULL };
		GType skk_state_type_id;
		skk_state_type_id = g_type_register_static (G_TYPE_OBJECT, "SkkState", &g_define_type_info, 0);
		g_once_init_leave (&skk_state_type_id__volatile, skk_state_type_id);
	}
	return skk_state_type_id__volatile;
}


static void _vala_skk_state_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SkkState * self;
	self = SKK_STATE (object);
	switch (property_id) {
		case SKK_STATE_INPUT_MODE:
		g_value_set_enum (value, skk_state_get_input_mode (self));
		break;
		case SKK_STATE_PERIOD_STYLE:
		g_value_set_enum (value, skk_state_get_period_style (self));
		break;
		case SKK_STATE_TYPING_RULE:
		g_value_set_object (value, skk_state_get_typing_rule (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_skk_state_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SkkState * self;
	self = SKK_STATE (object);
	switch (property_id) {
		case SKK_STATE_INPUT_MODE:
		skk_state_set_input_mode (self, g_value_get_enum (value));
		break;
		case SKK_STATE_PERIOD_STYLE:
		skk_state_set_period_style (self, g_value_get_enum (value));
		break;
		case SKK_STATE_TYPING_RULE:
		skk_state_set_typing_rule (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static gboolean skk_state_handler_real_process_key_event (SkkStateHandler* self, SkkState* state, SkkKeyEvent** key) {
	g_critical ("Type `%s' does not implement abstract method `skk_state_handler_process_key_event'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


gboolean skk_state_handler_process_key_event (SkkStateHandler* self, SkkState* state, SkkKeyEvent** key) {
	g_return_val_if_fail (self != NULL, FALSE);
	return SKK_STATE_HANDLER_GET_CLASS (self)->process_key_event (self, state, key);
}


static gchar* skk_state_handler_real_get_preedit (SkkStateHandler* self, SkkState* state, guint* underline_offset, guint* underline_nchars) {
	g_critical ("Type `%s' does not implement abstract method `skk_state_handler_get_preedit'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


gchar* skk_state_handler_get_preedit (SkkStateHandler* self, SkkState* state, guint* underline_offset, guint* underline_nchars) {
	g_return_val_if_fail (self != NULL, NULL);
	return SKK_STATE_HANDLER_GET_CLASS (self)->get_preedit (self, state, underline_offset, underline_nchars);
}


static gchar* skk_state_handler_real_get_output (SkkStateHandler* self, SkkState* state) {
	gchar* result = NULL;
	SkkState* _tmp0_;
	GString* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (state != NULL, NULL);
	_tmp0_ = state;
	_tmp1_ = _tmp0_->output;
	_tmp2_ = _tmp1_->str;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}


gchar* skk_state_handler_get_output (SkkStateHandler* self, SkkState* state) {
	g_return_val_if_fail (self != NULL, NULL);
	return SKK_STATE_HANDLER_GET_CLASS (self)->get_output (self, state);
}


SkkStateHandler* skk_state_handler_construct (GType object_type) {
	SkkStateHandler * self = NULL;
	self = (SkkStateHandler*) g_object_new (object_type, NULL);
	return self;
}


static void skk_state_handler_class_init (SkkStateHandlerClass * klass) {
	skk_state_handler_parent_class = g_type_class_peek_parent (klass);
	SKK_STATE_HANDLER_CLASS (klass)->process_key_event = skk_state_handler_real_process_key_event;
	SKK_STATE_HANDLER_CLASS (klass)->get_preedit = skk_state_handler_real_get_preedit;
	SKK_STATE_HANDLER_CLASS (klass)->get_output = skk_state_handler_real_get_output;
}


static void skk_state_handler_instance_init (SkkStateHandler * self) {
}


GType skk_state_handler_get_type (void) {
	static volatile gsize skk_state_handler_type_id__volatile = 0;
	if (g_once_init_enter (&skk_state_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SkkStateHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_state_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkStateHandler), 0, (GInstanceInitFunc) skk_state_handler_instance_init, NULL };
		GType skk_state_handler_type_id;
		skk_state_handler_type_id = g_type_register_static (G_TYPE_OBJECT, "SkkStateHandler", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&skk_state_handler_type_id__volatile, skk_state_handler_type_id);
	}
	return skk_state_handler_type_id__volatile;
}


static gint string_index_of_nth_char (const gchar* self, glong c) {
	gint result = 0;
	glong _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = c;
	_tmp1_ = g_utf8_offset_to_pointer (self, _tmp0_);
	result = (gint) (_tmp1_ - ((gchar*) self));
	return result;
}


static gboolean skk_none_state_handler_real_process_key_event (SkkStateHandler* base, SkkState* state, SkkKeyEvent** key) {
	SkkNoneStateHandler * self;
	gboolean result = FALSE;
	SkkState* _tmp0_;
	SkkKeyEvent* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* command;
	const gchar* _tmp3_;
	gboolean _tmp62_ = FALSE;
	gboolean _tmp63_ = FALSE;
	const gchar* _tmp64_;
	gboolean _tmp67_;
	gboolean _tmp94_;
	const gchar* _tmp101_;
	SkkState* _tmp118_;
	SkkInputMode _tmp119_;
	SkkInputMode _tmp120_;
	self = (SkkNoneStateHandler*) base;
	g_return_val_if_fail (state != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = state;
	_tmp1_ = *key;
	_tmp2_ = skk_state_lookup_key (_tmp0_, _tmp1_);
	command = _tmp2_;
	_tmp3_ = command;
	if (g_strcmp0 (_tmp3_, "abort") == 0) {
		gboolean retval = FALSE;
		SkkState* _tmp4_;
		SkkRomKanaConverter* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		SkkState* _tmp12_;
		_tmp4_ = state;
		_tmp5_ = _tmp4_->rom_kana_converter;
		_tmp6_ = skk_rom_kana_converter_get_preedit (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = strlen (_tmp7_);
		_tmp9_ = _tmp8_;
		if (_tmp9_ > 0) {
			retval = TRUE;
		} else {
			SkkState* _tmp10_;
			gboolean _tmp11_ = FALSE;
			_tmp10_ = state;
			g_signal_emit_by_name (_tmp10_, "recursive-edit-abort", &_tmp11_);
			retval = _tmp11_;
		}
		_tmp12_ = state;
		skk_state_reset (_tmp12_);
		result = retval;
		_g_free0 (command);
		return result;
	} else {
		gboolean _tmp13_ = FALSE;
		const gchar* _tmp14_;
		gboolean _tmp16_;
		_tmp14_ = command;
		if (g_strcmp0 (_tmp14_, "commit") == 0) {
			_tmp13_ = TRUE;
		} else {
			const gchar* _tmp15_;
			_tmp15_ = command;
			_tmp13_ = g_strcmp0 (_tmp15_, "commit-unhandled") == 0;
		}
		_tmp16_ = _tmp13_;
		if (_tmp16_) {
			gboolean retval = FALSE;
			SkkState* _tmp17_;
			SkkRomKanaConverter* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			gint _tmp21_;
			gint _tmp22_;
			SkkState* _tmp35_;
			_tmp17_ = state;
			_tmp18_ = _tmp17_->rom_kana_converter;
			_tmp19_ = skk_rom_kana_converter_get_preedit (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = strlen (_tmp20_);
			_tmp22_ = _tmp21_;
			if (_tmp22_ > 0) {
				retval = TRUE;
			} else {
				SkkState* _tmp23_;
				GString* _tmp24_;
				const gchar* _tmp25_;
				gint _tmp26_;
				gint _tmp27_;
				_tmp23_ = state;
				_tmp24_ = _tmp23_->output;
				_tmp25_ = _tmp24_->str;
				_tmp26_ = strlen (_tmp25_);
				_tmp27_ = _tmp26_;
				if (_tmp27_ == 0) {
					SkkState* _tmp28_;
					gboolean _tmp29_ = FALSE;
					_tmp28_ = state;
					g_signal_emit_by_name (_tmp28_, "recursive-edit-abort", &_tmp29_);
					retval = _tmp29_;
				} else {
					SkkState* _tmp30_;
					SkkState* _tmp31_;
					GString* _tmp32_;
					const gchar* _tmp33_;
					gboolean _tmp34_ = FALSE;
					_tmp30_ = state;
					_tmp31_ = state;
					_tmp32_ = _tmp31_->output;
					_tmp33_ = _tmp32_->str;
					g_signal_emit_by_name (_tmp30_, "recursive-edit-end", _tmp33_, &_tmp34_);
					retval = _tmp34_;
				}
			}
			_tmp35_ = state;
			skk_state_reset (_tmp35_);
			result = retval;
			_g_free0 (command);
			return result;
		} else {
			gboolean _tmp36_ = FALSE;
			const gchar* _tmp37_;
			gboolean _tmp39_;
			_tmp37_ = command;
			if (g_strcmp0 (_tmp37_, "start-preedit") == 0) {
				_tmp36_ = TRUE;
			} else {
				const gchar* _tmp38_;
				_tmp38_ = command;
				_tmp36_ = g_strcmp0 (_tmp38_, "start-preedit-kana") == 0;
			}
			_tmp39_ = _tmp36_;
			if (_tmp39_) {
				gchar* text = NULL;
				guint cursor_pos = 0U;
				SkkState* _tmp40_;
				gchar* _tmp41_ = NULL;
				guint _tmp42_ = 0U;
				gboolean _tmp43_ = FALSE;
				SkkState* _tmp61_;
				_tmp40_ = state;
				g_signal_emit_by_name (_tmp40_, "retrieve-surrounding-text", &_tmp41_, &_tmp42_, &_tmp43_);
				_g_free0 (text);
				text = _tmp41_;
				cursor_pos = _tmp42_;
				if (_tmp43_) {
					SkkState* _tmp44_;
					const gchar* _tmp45_;
					const gchar* _tmp46_;
					guint _tmp47_;
					gint _tmp48_ = 0;
					const gchar* _tmp49_;
					gint _tmp50_;
					gint _tmp51_;
					gchar* _tmp52_ = NULL;
					gchar* _tmp53_;
					SkkUnicodeString* _tmp54_;
					SkkState* _tmp55_;
					SkkState* _tmp56_;
					SkkState* _tmp57_;
					SkkUnicodeString* _tmp58_;
					gint _tmp59_;
					gboolean _tmp60_ = FALSE;
					_tmp44_ = state;
					_tmp45_ = text;
					_tmp46_ = text;
					_tmp47_ = cursor_pos;
					_tmp48_ = string_index_of_nth_char (_tmp46_, (glong) _tmp47_);
					_tmp49_ = text;
					_tmp50_ = strlen (_tmp49_);
					_tmp51_ = _tmp50_;
					_tmp52_ = string_slice (_tmp45_, (glong) _tmp48_, (glong) _tmp51_);
					_tmp53_ = _tmp52_;
					_tmp54_ = skk_unicode_string_new (_tmp53_);
					_g_object_unref0 (_tmp44_->surrounding_text);
					_tmp44_->surrounding_text = _tmp54_;
					_g_free0 (_tmp53_);
					_tmp55_ = state;
					_tmp55_->surrounding_end = (guint) 0;
					_tmp56_ = state;
					_tmp57_ = state;
					_tmp58_ = _tmp57_->surrounding_text;
					_tmp59_ = _tmp58_->length;
					g_signal_emit_by_name (_tmp56_, "delete-surrounding-text", 0, (guint) _tmp59_, &_tmp60_);
				}
				_tmp61_ = state;
				_tmp61_->handler_type = SKK_TYPE_START_STATE_HANDLER;
				result = TRUE;
				_g_free0 (text);
				_g_free0 (command);
				return result;
			}
		}
	}
	_tmp64_ = command;
	if (_tmp64_ != NULL) {
		const gchar* _tmp65_;
		gboolean _tmp66_ = FALSE;
		_tmp65_ = command;
		_tmp66_ = g_str_has_prefix (_tmp65_, "set-input-mode-");
		_tmp63_ = _tmp66_;
	} else {
		_tmp63_ = FALSE;
	}
	_tmp67_ = _tmp63_;
	if (_tmp67_) {
		gboolean _tmp68_ = FALSE;
		gboolean _tmp69_ = FALSE;
		gboolean _tmp70_ = FALSE;
		gboolean _tmp71_ = FALSE;
		SkkState* _tmp72_;
		SkkInputMode _tmp73_;
		SkkInputMode _tmp74_;
		gboolean _tmp78_;
		gboolean _tmp82_;
		gboolean _tmp86_;
		gboolean _tmp93_;
		_tmp72_ = state;
		_tmp73_ = skk_state_get_input_mode (_tmp72_);
		_tmp74_ = _tmp73_;
		if (_tmp74_ == SKK_INPUT_MODE_HIRAGANA) {
			_tmp71_ = TRUE;
		} else {
			SkkState* _tmp75_;
			SkkInputMode _tmp76_;
			SkkInputMode _tmp77_;
			_tmp75_ = state;
			_tmp76_ = skk_state_get_input_mode (_tmp75_);
			_tmp77_ = _tmp76_;
			_tmp71_ = _tmp77_ == SKK_INPUT_MODE_KATAKANA;
		}
		_tmp78_ = _tmp71_;
		if (_tmp78_) {
			_tmp70_ = TRUE;
		} else {
			SkkState* _tmp79_;
			SkkInputMode _tmp80_;
			SkkInputMode _tmp81_;
			_tmp79_ = state;
			_tmp80_ = skk_state_get_input_mode (_tmp79_);
			_tmp81_ = _tmp80_;
			_tmp70_ = _tmp81_ == SKK_INPUT_MODE_HANKAKU_KATAKANA;
		}
		_tmp82_ = _tmp70_;
		if (_tmp82_) {
			SkkKeyEvent* _tmp83_;
			SkkModifierType _tmp84_;
			SkkModifierType _tmp85_;
			_tmp83_ = *key;
			_tmp84_ = skk_key_event_get_modifiers (_tmp83_);
			_tmp85_ = _tmp84_;
			_tmp69_ = _tmp85_ == 0;
		} else {
			_tmp69_ = FALSE;
		}
		_tmp86_ = _tmp69_;
		if (_tmp86_) {
			SkkState* _tmp87_;
			SkkRomKanaConverter* _tmp88_;
			SkkKeyEvent* _tmp89_;
			gunichar _tmp90_;
			gunichar _tmp91_;
			gboolean _tmp92_ = FALSE;
			_tmp87_ = state;
			_tmp88_ = _tmp87_->rom_kana_converter;
			_tmp89_ = *key;
			_tmp90_ = skk_key_event_get_code (_tmp89_);
			_tmp91_ = _tmp90_;
			_tmp92_ = skk_rom_kana_converter_can_consume (_tmp88_, _tmp91_, FALSE, TRUE);
			_tmp68_ = _tmp92_;
		} else {
			_tmp68_ = FALSE;
		}
		_tmp93_ = _tmp68_;
		_tmp62_ = !_tmp93_;
	} else {
		_tmp62_ = FALSE;
	}
	_tmp94_ = _tmp62_;
	if (_tmp94_) {
		{
			SkkEntry* entry_collection = NULL;
			gint entry_collection_length1 = 0;
			gint _entry_collection_size_ = 0;
			gint entry_it = 0;
			entry_collection = SKK_NONE_STATE_HANDLER_input_mode_commands;
			entry_collection_length1 = G_N_ELEMENTS (SKK_NONE_STATE_HANDLER_input_mode_commands);
			for (entry_it = 0; entry_it < G_N_ELEMENTS (SKK_NONE_STATE_HANDLER_input_mode_commands); entry_it = entry_it + 1) {
				SkkEntry entry = {0};
				entry = entry_collection[entry_it];
				{
					SkkEntry _tmp95_;
					gconstpointer _tmp96_;
					const gchar* _tmp97_;
					_tmp95_ = entry;
					_tmp96_ = _tmp95_.key;
					_tmp97_ = command;
					if (g_strcmp0 ((const gchar*) _tmp96_, _tmp97_) == 0) {
						SkkState* _tmp98_;
						SkkEntry _tmp99_;
						gconstpointer _tmp100_;
						_tmp98_ = state;
						_tmp99_ = entry;
						_tmp100_ = _tmp99_.value;
						skk_state_set_input_mode (_tmp98_, GPOINTER_TO_INT (_tmp100_));
						result = TRUE;
						_g_free0 (command);
						return result;
					}
				}
			}
		}
	}
	_tmp101_ = command;
	if (g_strcmp0 (_tmp101_, "delete") == 0) {
		SkkState* _tmp102_;
		SkkRomKanaConverter* _tmp103_;
		gboolean _tmp104_ = FALSE;
		SkkState* _tmp105_;
		GString* _tmp106_;
		gssize _tmp107_;
		_tmp102_ = state;
		_tmp103_ = _tmp102_->rom_kana_converter;
		_tmp104_ = skk_rom_kana_converter_delete (_tmp103_);
		if (_tmp104_) {
			result = TRUE;
			_g_free0 (command);
			return result;
		}
		_tmp105_ = state;
		_tmp106_ = _tmp105_->output;
		_tmp107_ = _tmp106_->len;
		if (_tmp107_ > ((gssize) 0)) {
			SkkState* _tmp108_;
			GString* _tmp109_;
			SkkState* _tmp110_;
			GString* _tmp111_;
			const gchar* _tmp112_;
			SkkState* _tmp113_;
			GString* _tmp114_;
			const gchar* _tmp115_;
			gint _tmp116_ = 0;
			gint _tmp117_ = 0;
			_tmp108_ = state;
			_tmp109_ = _tmp108_->output;
			_tmp110_ = state;
			_tmp111_ = _tmp110_->output;
			_tmp112_ = _tmp111_->str;
			_tmp113_ = state;
			_tmp114_ = _tmp113_->output;
			_tmp115_ = _tmp114_->str;
			_tmp116_ = g_utf8_strlen (_tmp115_, (gssize) (-1));
			_tmp117_ = string_index_of_nth_char (_tmp112_, (glong) (_tmp116_ - 1));
			g_string_truncate (_tmp109_, (gsize) _tmp117_);
			result = TRUE;
			_g_free0 (command);
			return result;
		}
		result = FALSE;
		_g_free0 (command);
		return result;
	}
	_tmp118_ = state;
	_tmp119_ = skk_state_get_input_mode (_tmp118_);
	_tmp120_ = _tmp119_;
	switch (_tmp120_) {
		case SKK_INPUT_MODE_HIRAGANA:
		case SKK_INPUT_MODE_KATAKANA:
		case SKK_INPUT_MODE_HANKAKU_KATAKANA:
		{
			gboolean _tmp121_ = FALSE;
			gboolean _tmp122_ = FALSE;
			SkkKeyEvent* _tmp123_;
			SkkModifierType _tmp124_;
			SkkModifierType _tmp125_;
			gboolean _tmp130_;
			gboolean _tmp135_;
			gboolean _tmp152_ = FALSE;
			const gchar* _tmp153_;
			gboolean _tmp156_;
			SkkKeyEvent* _tmp173_;
			SkkModifierType _tmp174_;
			SkkModifierType _tmp175_;
			_tmp123_ = *key;
			_tmp124_ = skk_key_event_get_modifiers (_tmp123_);
			_tmp125_ = _tmp124_;
			if (_tmp125_ == 0) {
				SkkKeyEvent* _tmp126_;
				gunichar _tmp127_;
				gunichar _tmp128_;
				gboolean _tmp129_ = FALSE;
				_tmp126_ = *key;
				_tmp127_ = skk_key_event_get_code (_tmp126_);
				_tmp128_ = _tmp127_;
				_tmp129_ = g_unichar_isalpha (_tmp128_);
				_tmp122_ = _tmp129_;
			} else {
				_tmp122_ = FALSE;
			}
			_tmp130_ = _tmp122_;
			if (_tmp130_) {
				SkkKeyEvent* _tmp131_;
				gunichar _tmp132_;
				gunichar _tmp133_;
				gboolean _tmp134_ = FALSE;
				_tmp131_ = *key;
				_tmp132_ = skk_key_event_get_code (_tmp131_);
				_tmp133_ = _tmp132_;
				_tmp134_ = g_unichar_isupper (_tmp133_);
				_tmp121_ = _tmp134_;
			} else {
				_tmp121_ = FALSE;
			}
			_tmp135_ = _tmp121_;
			if (_tmp135_) {
				SkkState* _tmp136_;
				_tmp136_ = state;
				_tmp136_->handler_type = SKK_TYPE_START_STATE_HANDLER;
				result = FALSE;
				_g_free0 (command);
				return result;
			} else {
				gboolean _tmp137_ = FALSE;
				SkkKeyEvent* _tmp138_;
				SkkModifierType _tmp139_;
				SkkModifierType _tmp140_;
				gboolean _tmp147_;
				_tmp138_ = *key;
				_tmp139_ = skk_key_event_get_modifiers (_tmp138_);
				_tmp140_ = _tmp139_;
				if (_tmp140_ == 0) {
					SkkState* _tmp141_;
					SkkRomKanaConverter* _tmp142_;
					SkkKeyEvent* _tmp143_;
					gunichar _tmp144_;
					gunichar _tmp145_;
					gboolean _tmp146_ = FALSE;
					_tmp141_ = state;
					_tmp142_ = _tmp141_->rom_kana_converter;
					_tmp143_ = *key;
					_tmp144_ = skk_key_event_get_code (_tmp143_);
					_tmp145_ = _tmp144_;
					_tmp146_ = skk_rom_kana_converter_can_consume (_tmp142_, _tmp145_, TRUE, TRUE);
					_tmp137_ = !_tmp146_;
				} else {
					_tmp137_ = FALSE;
				}
				_tmp147_ = _tmp137_;
				if (_tmp147_) {
					const gchar* _tmp148_;
					_tmp148_ = command;
					if (g_strcmp0 (_tmp148_, "abbrev") == 0) {
						SkkState* _tmp149_;
						_tmp149_ = state;
						_tmp149_->handler_type = SKK_TYPE_ABBREV_STATE_HANDLER;
						result = TRUE;
						_g_free0 (command);
						return result;
					} else {
						const gchar* _tmp150_;
						_tmp150_ = command;
						if (g_strcmp0 (_tmp150_, "kuten") == 0) {
							SkkState* _tmp151_;
							_tmp151_ = state;
							_tmp151_->handler_type = SKK_TYPE_KUTEN_STATE_HANDLER;
							result = TRUE;
							_g_free0 (command);
							return result;
						}
					}
				}
			}
			_tmp153_ = command;
			if (_tmp153_ != NULL) {
				const gchar* _tmp154_;
				gboolean _tmp155_ = FALSE;
				_tmp154_ = command;
				_tmp155_ = g_str_has_prefix (_tmp154_, "insert-kana-");
				_tmp152_ = _tmp155_;
			} else {
				_tmp152_ = FALSE;
			}
			_tmp156_ = _tmp152_;
			if (_tmp156_) {
				const gchar* _tmp157_;
				gint _tmp158_;
				gint _tmp159_;
				const gchar* _tmp160_;
				gint _tmp161_;
				gint _tmp162_;
				gchar* _tmp163_ = NULL;
				gchar* _tmp164_;
				SkkState* _tmp165_;
				SkkInputMode _tmp166_;
				SkkInputMode _tmp167_;
				gchar* _tmp168_ = NULL;
				gchar* _tmp169_;
				gchar* kana;
				SkkState* _tmp170_;
				GString* _tmp171_;
				const gchar* _tmp172_;
				_tmp157_ = command;
				_tmp158_ = strlen ("insert-kana-");
				_tmp159_ = _tmp158_;
				_tmp160_ = command;
				_tmp161_ = strlen (_tmp160_);
				_tmp162_ = _tmp161_;
				_tmp163_ = string_slice (_tmp157_, (glong) _tmp159_, (glong) _tmp162_);
				_tmp164_ = _tmp163_;
				_tmp165_ = state;
				_tmp166_ = skk_state_get_input_mode (_tmp165_);
				_tmp167_ = _tmp166_;
				_tmp168_ = skk_util_convert_by_input_mode (_tmp164_, _tmp167_);
				_tmp169_ = _tmp168_;
				_g_free0 (_tmp164_);
				kana = _tmp169_;
				_tmp170_ = state;
				_tmp171_ = _tmp170_->output;
				_tmp172_ = kana;
				g_string_append (_tmp171_, _tmp172_);
				result = TRUE;
				_g_free0 (kana);
				_g_free0 (command);
				return result;
			}
			_tmp173_ = *key;
			_tmp174_ = skk_key_event_get_modifiers (_tmp173_);
			_tmp175_ = _tmp174_;
			if (_tmp175_ == 0) {
				SkkState* _tmp176_;
				SkkRomKanaConverter* _tmp177_;
				SkkKeyEvent* _tmp178_;
				gunichar _tmp179_;
				gunichar _tmp180_;
				gboolean _tmp181_ = FALSE;
				_tmp176_ = state;
				_tmp177_ = _tmp176_->rom_kana_converter;
				_tmp178_ = *key;
				_tmp179_ = skk_key_event_get_code (_tmp178_);
				_tmp180_ = _tmp179_;
				_tmp181_ = skk_rom_kana_converter_append (_tmp177_, _tmp180_);
				if (_tmp181_) {
					SkkState* _tmp182_;
					GString* _tmp183_;
					SkkState* _tmp184_;
					SkkRomKanaConverter* _tmp185_;
					const gchar* _tmp186_;
					const gchar* _tmp187_;
					SkkState* _tmp188_;
					SkkRomKanaConverter* _tmp189_;
					_tmp182_ = state;
					_tmp183_ = _tmp182_->output;
					_tmp184_ = state;
					_tmp185_ = _tmp184_->rom_kana_converter;
					_tmp186_ = skk_rom_kana_converter_get_output (_tmp185_);
					_tmp187_ = _tmp186_;
					g_string_append (_tmp183_, _tmp187_);
					_tmp188_ = state;
					_tmp189_ = _tmp188_->rom_kana_converter;
					skk_rom_kana_converter_set_output (_tmp189_, "");
					result = TRUE;
					_g_free0 (command);
					return result;
				} else {
					gboolean _tmp190_ = FALSE;
					SkkKeyEvent* _tmp191_;
					gunichar _tmp192_;
					gunichar _tmp193_;
					gboolean _tmp197_;
					_tmp191_ = *key;
					_tmp192_ = skk_key_event_get_code (_tmp191_);
					_tmp193_ = _tmp192_;
					if (((gunichar) 0x20) <= _tmp193_) {
						SkkKeyEvent* _tmp194_;
						gunichar _tmp195_;
						gunichar _tmp196_;
						_tmp194_ = *key;
						_tmp195_ = skk_key_event_get_code (_tmp194_);
						_tmp196_ = _tmp195_;
						_tmp190_ = _tmp196_ <= ((gunichar) 0x7F);
					} else {
						_tmp190_ = FALSE;
					}
					_tmp197_ = _tmp190_;
					if (_tmp197_) {
						SkkState* _tmp198_;
						GString* _tmp199_;
						SkkKeyEvent* _tmp200_;
						gunichar _tmp201_;
						gunichar _tmp202_;
						SkkState* _tmp203_;
						SkkRomKanaConverter* _tmp204_;
						_tmp198_ = state;
						_tmp199_ = _tmp198_->output;
						_tmp200_ = *key;
						_tmp201_ = skk_key_event_get_code (_tmp200_);
						_tmp202_ = _tmp201_;
						g_string_append_c (_tmp199_, (gchar) _tmp202_);
						_tmp203_ = state;
						_tmp204_ = _tmp203_->rom_kana_converter;
						skk_rom_kana_converter_set_output (_tmp204_, "");
						result = TRUE;
						_g_free0 (command);
						return result;
					} else {
						SkkState* _tmp205_;
						SkkRomKanaConverter* _tmp206_;
						_tmp205_ = state;
						_tmp206_ = _tmp205_->rom_kana_converter;
						skk_rom_kana_converter_set_output (_tmp206_, "");
						result = FALSE;
						_g_free0 (command);
						return result;
					}
				}
			}
			break;
		}
		case SKK_INPUT_MODE_LATIN:
		{
			gboolean _tmp207_ = FALSE;
			gboolean _tmp208_ = FALSE;
			SkkKeyEvent* _tmp209_;
			SkkModifierType _tmp210_;
			SkkModifierType _tmp211_;
			gboolean _tmp215_;
			gboolean _tmp219_;
			_tmp209_ = *key;
			_tmp210_ = skk_key_event_get_modifiers (_tmp209_);
			_tmp211_ = _tmp210_;
			if (_tmp211_ == 0) {
				SkkKeyEvent* _tmp212_;
				gunichar _tmp213_;
				gunichar _tmp214_;
				_tmp212_ = *key;
				_tmp213_ = skk_key_event_get_code (_tmp212_);
				_tmp214_ = _tmp213_;
				_tmp208_ = ((gunichar) 0x20) <= _tmp214_;
			} else {
				_tmp208_ = FALSE;
			}
			_tmp215_ = _tmp208_;
			if (_tmp215_) {
				SkkKeyEvent* _tmp216_;
				gunichar _tmp217_;
				gunichar _tmp218_;
				_tmp216_ = *key;
				_tmp217_ = skk_key_event_get_code (_tmp216_);
				_tmp218_ = _tmp217_;
				_tmp207_ = _tmp218_ <= ((gunichar) 0x7F);
			} else {
				_tmp207_ = FALSE;
			}
			_tmp219_ = _tmp207_;
			if (_tmp219_) {
				SkkState* _tmp220_;
				GString* _tmp221_;
				SkkKeyEvent* _tmp222_;
				gunichar _tmp223_;
				gunichar _tmp224_;
				_tmp220_ = state;
				_tmp221_ = _tmp220_->output;
				_tmp222_ = *key;
				_tmp223_ = skk_key_event_get_code (_tmp222_);
				_tmp224_ = _tmp223_;
				g_string_append_c (_tmp221_, (gchar) _tmp224_);
				result = TRUE;
				_g_free0 (command);
				return result;
			}
			break;
		}
		case SKK_INPUT_MODE_WIDE_LATIN:
		{
			gboolean _tmp225_ = FALSE;
			gboolean _tmp226_ = FALSE;
			SkkKeyEvent* _tmp227_;
			SkkModifierType _tmp228_;
			SkkModifierType _tmp229_;
			gboolean _tmp233_;
			gboolean _tmp237_;
			_tmp227_ = *key;
			_tmp228_ = skk_key_event_get_modifiers (_tmp227_);
			_tmp229_ = _tmp228_;
			if (_tmp229_ == 0) {
				SkkKeyEvent* _tmp230_;
				gunichar _tmp231_;
				gunichar _tmp232_;
				_tmp230_ = *key;
				_tmp231_ = skk_key_event_get_code (_tmp230_);
				_tmp232_ = _tmp231_;
				_tmp226_ = ((gunichar) 0x20) <= _tmp232_;
			} else {
				_tmp226_ = FALSE;
			}
			_tmp233_ = _tmp226_;
			if (_tmp233_) {
				SkkKeyEvent* _tmp234_;
				gunichar _tmp235_;
				gunichar _tmp236_;
				_tmp234_ = *key;
				_tmp235_ = skk_key_event_get_code (_tmp234_);
				_tmp236_ = _tmp235_;
				_tmp225_ = _tmp236_ <= ((gunichar) 0x7F);
			} else {
				_tmp225_ = FALSE;
			}
			_tmp237_ = _tmp225_;
			if (_tmp237_) {
				SkkState* _tmp238_;
				GString* _tmp239_;
				SkkKeyEvent* _tmp240_;
				gunichar _tmp241_;
				gunichar _tmp242_;
				gunichar _tmp243_ = 0U;
				_tmp238_ = state;
				_tmp239_ = _tmp238_->output;
				_tmp240_ = *key;
				_tmp241_ = skk_key_event_get_code (_tmp240_);
				_tmp242_ = _tmp241_;
				_tmp243_ = skk_util_get_wide_latin_char ((gchar) _tmp242_);
				g_string_append_unichar (_tmp239_, _tmp243_);
				result = TRUE;
				_g_free0 (command);
				return result;
			}
			break;
		}
		default:
		break;
	}
	result = FALSE;
	_g_free0 (command);
	return result;
}


static gchar* skk_none_state_handler_real_get_preedit (SkkStateHandler* base, SkkState* state, guint* underline_offset, guint* underline_nchars) {
	SkkNoneStateHandler * self;
	guint _vala_underline_offset = 0U;
	guint _vala_underline_nchars = 0U;
	gchar* result = NULL;
	GString* _tmp0_;
	GString* builder;
	SkkState* _tmp1_;
	SkkRomKanaConverter* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	self = (SkkNoneStateHandler*) base;
	g_return_val_if_fail (state != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	_tmp1_ = state;
	_tmp2_ = _tmp1_->rom_kana_converter;
	_tmp3_ = skk_rom_kana_converter_get_preedit (_tmp2_);
	_tmp4_ = _tmp3_;
	g_string_append (builder, _tmp4_);
	_vala_underline_nchars = (guint) 0;
	_vala_underline_offset = _vala_underline_nchars;
	_tmp5_ = builder->str;
	_tmp6_ = g_strdup (_tmp5_);
	result = _tmp6_;
	_g_string_free0 (builder);
	if (underline_offset) {
		*underline_offset = _vala_underline_offset;
	}
	if (underline_nchars) {
		*underline_nchars = _vala_underline_nchars;
	}
	return result;
}


SkkNoneStateHandler* skk_none_state_handler_construct (GType object_type) {
	SkkNoneStateHandler * self = NULL;
	self = (SkkNoneStateHandler*) skk_state_handler_construct (object_type);
	return self;
}


SkkNoneStateHandler* skk_none_state_handler_new (void) {
	return skk_none_state_handler_construct (SKK_TYPE_NONE_STATE_HANDLER);
}


static void skk_none_state_handler_class_init (SkkNoneStateHandlerClass * klass) {
	skk_none_state_handler_parent_class = g_type_class_peek_parent (klass);
	SKK_STATE_HANDLER_CLASS (klass)->process_key_event = skk_none_state_handler_real_process_key_event;
	SKK_STATE_HANDLER_CLASS (klass)->get_preedit = skk_none_state_handler_real_get_preedit;
}


static void skk_none_state_handler_instance_init (SkkNoneStateHandler * self) {
}


GType skk_none_state_handler_get_type (void) {
	static volatile gsize skk_none_state_handler_type_id__volatile = 0;
	if (g_once_init_enter (&skk_none_state_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SkkNoneStateHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_none_state_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkNoneStateHandler), 0, (GInstanceInitFunc) skk_none_state_handler_instance_init, NULL };
		GType skk_none_state_handler_type_id;
		skk_none_state_handler_type_id = g_type_register_static (SKK_TYPE_STATE_HANDLER, "SkkNoneStateHandler", &g_define_type_info, 0);
		g_once_init_leave (&skk_none_state_handler_type_id__volatile, skk_none_state_handler_type_id);
	}
	return skk_none_state_handler_type_id__volatile;
}


SkkKutenStateHandler* skk_kuten_state_handler_construct (GType object_type) {
	SkkKutenStateHandler * self = NULL;
	GError * _inner_error_ = NULL;
	self = (SkkKutenStateHandler*) skk_state_handler_construct (object_type);
	{
		SkkEncodingConverter* _tmp0_;
		SkkEncodingConverter* _tmp1_;
		_tmp0_ = skk_encoding_converter_new ("EUC-JP", &_inner_error_);
		_tmp1_ = _tmp0_;
		if (_inner_error_ != NULL) {
			goto __catch31_g_error;
		}
		_g_object_unref0 (self->priv->converter);
		self->priv->converter = _tmp1_;
	}
	goto __finally31;
	__catch31_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_object_unref0 (self->priv->converter);
		self->priv->converter = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally31:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


SkkKutenStateHandler* skk_kuten_state_handler_new (void) {
	return skk_kuten_state_handler_construct (SKK_TYPE_KUTEN_STATE_HANDLER);
}


static gint skk_kuten_state_handler_hex_char_to_int (SkkKutenStateHandler* self, gchar hex) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gchar _tmp1_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = hex;
	if ('0' <= _tmp1_) {
		gchar _tmp2_;
		_tmp2_ = hex;
		_tmp0_ = _tmp2_ <= '9';
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		gchar _tmp4_;
		_tmp4_ = hex;
		result = (gint) (_tmp4_ - '0');
		return result;
	} else {
		gboolean _tmp5_ = FALSE;
		gchar _tmp6_;
		gchar _tmp7_ = '\0';
		gboolean _tmp10_;
		_tmp6_ = hex;
		_tmp7_ = g_ascii_tolower (_tmp6_);
		if ('a' <= _tmp7_) {
			gchar _tmp8_;
			gchar _tmp9_ = '\0';
			_tmp8_ = hex;
			_tmp9_ = g_ascii_tolower (_tmp8_);
			_tmp5_ = _tmp9_ <= 'f';
		} else {
			_tmp5_ = FALSE;
		}
		_tmp10_ = _tmp5_;
		if (_tmp10_) {
			gchar _tmp11_;
			_tmp11_ = hex;
			result = (_tmp11_ - 'a') + 10;
			return result;
		}
	}
	result = -1;
	return result;
}


static gchar* skk_kuten_state_handler_parse_hex (SkkKutenStateHandler* self, const gchar* hex) {
	gchar* result = NULL;
	GString* _tmp0_;
	GString* builder;
	GString* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (hex != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_;
				gint _tmp4_;
				const gchar* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				const gchar* _tmp8_;
				gint _tmp9_;
				gchar _tmp10_ = '\0';
				gint _tmp11_ = 0;
				const gchar* _tmp12_;
				gint _tmp13_;
				gchar _tmp14_ = '\0';
				gint _tmp15_ = 0;
				gint c;
				GString* _tmp16_;
				gint _tmp17_;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 2;
				}
				_tmp1_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = hex;
				_tmp6_ = strlen (_tmp5_);
				_tmp7_ = _tmp6_;
				if (!(_tmp4_ < (_tmp7_ - 1))) {
					break;
				}
				_tmp8_ = hex;
				_tmp9_ = i;
				_tmp10_ = string_get (_tmp8_, (glong) _tmp9_);
				_tmp11_ = skk_kuten_state_handler_hex_char_to_int (self, _tmp10_);
				_tmp12_ = hex;
				_tmp13_ = i;
				_tmp14_ = string_get (_tmp12_, (glong) (_tmp13_ + 1));
				_tmp15_ = skk_kuten_state_handler_hex_char_to_int (self, _tmp14_);
				c = (_tmp11_ << 4) | _tmp15_;
				_tmp16_ = builder;
				_tmp17_ = c;
				g_string_append_c (_tmp16_, (gchar) _tmp17_);
			}
		}
	}
	_tmp18_ = builder;
	_tmp19_ = _tmp18_->str;
	_tmp20_ = g_strdup (_tmp19_);
	result = _tmp20_;
	_g_string_free0 (builder);
	return result;
}


static gboolean skk_kuten_state_handler_real_process_key_event (SkkStateHandler* base, SkkState* state, SkkKeyEvent** key) {
	SkkKutenStateHandler * self;
	gboolean result = FALSE;
	SkkState* _tmp0_;
	SkkKeyEvent* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* command;
	const gchar* _tmp3_;
	GError * _inner_error_ = NULL;
	self = (SkkKutenStateHandler*) base;
	g_return_val_if_fail (state != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = state;
	_tmp1_ = *key;
	_tmp2_ = skk_state_lookup_key (_tmp0_, _tmp1_);
	command = _tmp2_;
	_tmp3_ = command;
	if (g_strcmp0 (_tmp3_, "abort") == 0) {
		SkkState* _tmp4_;
		_tmp4_ = state;
		skk_state_reset (_tmp4_);
		result = TRUE;
		_g_free0 (command);
		return result;
	} else {
		gboolean _tmp5_ = FALSE;
		const gchar* _tmp6_;
		gboolean _tmp15_;
		_tmp6_ = command;
		if (g_strcmp0 (_tmp6_, "commit-unhandled") == 0) {
			gboolean _tmp7_ = FALSE;
			SkkState* _tmp8_;
			GString* _tmp9_;
			gssize _tmp10_;
			gboolean _tmp14_;
			_tmp8_ = state;
			_tmp9_ = _tmp8_->kuten;
			_tmp10_ = _tmp9_->len;
			if (_tmp10_ == ((gssize) 4)) {
				_tmp7_ = TRUE;
			} else {
				SkkState* _tmp11_;
				GString* _tmp12_;
				gssize _tmp13_;
				_tmp11_ = state;
				_tmp12_ = _tmp11_->kuten;
				_tmp13_ = _tmp12_->len;
				_tmp7_ = _tmp13_ == ((gssize) 6);
			}
			_tmp14_ = _tmp7_;
			_tmp5_ = _tmp14_;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp15_ = _tmp5_;
		if (_tmp15_) {
			SkkEncodingConverter* _tmp16_;
			SkkState* _tmp31_;
			_tmp16_ = self->priv->converter;
			if (_tmp16_ != NULL) {
				SkkState* _tmp17_;
				GString* _tmp18_;
				const gchar* _tmp19_;
				gchar* _tmp20_ = NULL;
				gchar* euc;
				_tmp17_ = state;
				_tmp18_ = _tmp17_->kuten;
				_tmp19_ = _tmp18_->str;
				_tmp20_ = skk_kuten_state_handler_parse_hex (self, _tmp19_);
				euc = _tmp20_;
				{
					SkkEncodingConverter* _tmp21_;
					const gchar* _tmp22_;
					gchar* _tmp23_ = NULL;
					gchar* _tmp24_;
					SkkState* _tmp25_;
					GString* _tmp26_;
					gchar* _tmp27_;
					_tmp21_ = self->priv->converter;
					_tmp22_ = euc;
					_tmp23_ = skk_encoding_converter_decode (_tmp21_, _tmp22_, &_inner_error_);
					_tmp24_ = _tmp23_;
					if (_inner_error_ != NULL) {
						goto __catch32_g_error;
					}
					_tmp25_ = state;
					_tmp26_ = _tmp25_->output;
					_tmp27_ = _tmp24_;
					g_string_append (_tmp26_, _tmp27_);
					_g_free0 (_tmp27_);
				}
				goto __finally32;
				__catch32_g_error:
				{
					GError* e = NULL;
					const gchar* _tmp28_;
					GError* _tmp29_;
					const gchar* _tmp30_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp28_ = euc;
					_tmp29_ = e;
					_tmp30_ = _tmp29_->message;
					g_warning ("state.vala:597: can't decode %s in EUC-JP: %s", _tmp28_, _tmp30_);
					_g_error_free0 (e);
				}
				__finally32:
				if (_inner_error_ != NULL) {
					_g_free0 (euc);
					_g_free0 (command);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
				_g_free0 (euc);
			}
			_tmp31_ = state;
			skk_state_reset (_tmp31_);
			result = TRUE;
			_g_free0 (command);
			return result;
		} else {
			gboolean _tmp32_ = FALSE;
			const gchar* _tmp33_;
			gboolean _tmp37_;
			_tmp33_ = command;
			if (g_strcmp0 (_tmp33_, "delete") == 0) {
				SkkState* _tmp34_;
				GString* _tmp35_;
				gssize _tmp36_;
				_tmp34_ = state;
				_tmp35_ = _tmp34_->kuten;
				_tmp36_ = _tmp35_->len;
				_tmp32_ = _tmp36_ > ((gssize) 0);
			} else {
				_tmp32_ = FALSE;
			}
			_tmp37_ = _tmp32_;
			if (_tmp37_) {
				SkkState* _tmp38_;
				GString* _tmp39_;
				SkkState* _tmp40_;
				GString* _tmp41_;
				gssize _tmp42_;
				_tmp38_ = state;
				_tmp39_ = _tmp38_->kuten;
				_tmp40_ = state;
				_tmp41_ = _tmp40_->kuten;
				_tmp42_ = _tmp41_->len;
				g_string_truncate (_tmp39_, (gsize) (_tmp42_ - 1));
				result = TRUE;
				_g_free0 (command);
				return result;
			} else {
				gboolean _tmp43_ = FALSE;
				gboolean _tmp44_ = FALSE;
				SkkKeyEvent* _tmp45_;
				SkkModifierType _tmp46_;
				SkkModifierType _tmp47_;
				gboolean _tmp76_;
				gboolean _tmp80_;
				_tmp45_ = *key;
				_tmp46_ = skk_key_event_get_modifiers (_tmp45_);
				_tmp47_ = _tmp46_;
				if (_tmp47_ == 0) {
					gboolean _tmp48_ = FALSE;
					gboolean _tmp49_ = FALSE;
					gboolean _tmp50_ = FALSE;
					SkkKeyEvent* _tmp51_;
					gunichar _tmp52_;
					gunichar _tmp53_;
					gboolean _tmp57_;
					gboolean _tmp66_;
					gboolean _tmp75_;
					_tmp51_ = *key;
					_tmp52_ = skk_key_event_get_code (_tmp51_);
					_tmp53_ = _tmp52_;
					if (((gunichar) 'a') <= _tmp53_) {
						SkkKeyEvent* _tmp54_;
						gunichar _tmp55_;
						gunichar _tmp56_;
						_tmp54_ = *key;
						_tmp55_ = skk_key_event_get_code (_tmp54_);
						_tmp56_ = _tmp55_;
						_tmp50_ = _tmp56_ <= ((gunichar) 'f');
					} else {
						_tmp50_ = FALSE;
					}
					_tmp57_ = _tmp50_;
					if (_tmp57_) {
						_tmp49_ = TRUE;
					} else {
						gboolean _tmp58_ = FALSE;
						SkkKeyEvent* _tmp59_;
						gunichar _tmp60_;
						gunichar _tmp61_;
						gboolean _tmp65_;
						_tmp59_ = *key;
						_tmp60_ = skk_key_event_get_code (_tmp59_);
						_tmp61_ = _tmp60_;
						if (((gunichar) 'A') <= _tmp61_) {
							SkkKeyEvent* _tmp62_;
							gunichar _tmp63_;
							gunichar _tmp64_;
							_tmp62_ = *key;
							_tmp63_ = skk_key_event_get_code (_tmp62_);
							_tmp64_ = _tmp63_;
							_tmp58_ = _tmp64_ <= ((gunichar) 'F');
						} else {
							_tmp58_ = FALSE;
						}
						_tmp65_ = _tmp58_;
						_tmp49_ = _tmp65_;
					}
					_tmp66_ = _tmp49_;
					if (_tmp66_) {
						_tmp48_ = TRUE;
					} else {
						gboolean _tmp67_ = FALSE;
						SkkKeyEvent* _tmp68_;
						gunichar _tmp69_;
						gunichar _tmp70_;
						gboolean _tmp74_;
						_tmp68_ = *key;
						_tmp69_ = skk_key_event_get_code (_tmp68_);
						_tmp70_ = _tmp69_;
						if (((gunichar) '0') <= _tmp70_) {
							SkkKeyEvent* _tmp71_;
							gunichar _tmp72_;
							gunichar _tmp73_;
							_tmp71_ = *key;
							_tmp72_ = skk_key_event_get_code (_tmp71_);
							_tmp73_ = _tmp72_;
							_tmp67_ = _tmp73_ <= ((gunichar) '9');
						} else {
							_tmp67_ = FALSE;
						}
						_tmp74_ = _tmp67_;
						_tmp48_ = _tmp74_;
					}
					_tmp75_ = _tmp48_;
					_tmp44_ = _tmp75_;
				} else {
					_tmp44_ = FALSE;
				}
				_tmp76_ = _tmp44_;
				if (_tmp76_) {
					SkkState* _tmp77_;
					GString* _tmp78_;
					gssize _tmp79_;
					_tmp77_ = state;
					_tmp78_ = _tmp77_->kuten;
					_tmp79_ = _tmp78_->len;
					_tmp43_ = _tmp79_ < ((gssize) 6);
				} else {
					_tmp43_ = FALSE;
				}
				_tmp80_ = _tmp43_;
				if (_tmp80_) {
					SkkState* _tmp81_;
					GString* _tmp82_;
					SkkKeyEvent* _tmp83_;
					gunichar _tmp84_;
					gunichar _tmp85_;
					_tmp81_ = state;
					_tmp82_ = _tmp81_->kuten;
					_tmp83_ = *key;
					_tmp84_ = skk_key_event_get_code (_tmp83_);
					_tmp85_ = _tmp84_;
					g_string_append_unichar (_tmp82_, _tmp85_);
					result = TRUE;
					_g_free0 (command);
					return result;
				}
			}
		}
	}
	result = TRUE;
	_g_free0 (command);
	return result;
}


static gchar* skk_kuten_state_handler_real_get_preedit (SkkStateHandler* base, SkkState* state, guint* underline_offset, guint* underline_nchars) {
	SkkKutenStateHandler * self;
	guint _vala_underline_offset = 0U;
	guint _vala_underline_nchars = 0U;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	SkkState* _tmp1_;
	GString* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	self = (SkkKutenStateHandler*) base;
	g_return_val_if_fail (state != NULL, NULL);
	_vala_underline_nchars = (guint) 0;
	_vala_underline_offset = _vala_underline_nchars;
	_tmp0_ = _ ("Kuten([MM]KKTT) ");
	_tmp1_ = state;
	_tmp2_ = _tmp1_->kuten;
	_tmp3_ = _tmp2_->str;
	_tmp4_ = g_strconcat (_tmp0_, _tmp3_, NULL);
	result = _tmp4_;
	if (underline_offset) {
		*underline_offset = _vala_underline_offset;
	}
	if (underline_nchars) {
		*underline_nchars = _vala_underline_nchars;
	}
	return result;
}


static void skk_kuten_state_handler_class_init (SkkKutenStateHandlerClass * klass) {
	skk_kuten_state_handler_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SkkKutenStateHandlerPrivate));
	SKK_STATE_HANDLER_CLASS (klass)->process_key_event = skk_kuten_state_handler_real_process_key_event;
	SKK_STATE_HANDLER_CLASS (klass)->get_preedit = skk_kuten_state_handler_real_get_preedit;
	G_OBJECT_CLASS (klass)->finalize = skk_kuten_state_handler_finalize;
}


static void skk_kuten_state_handler_instance_init (SkkKutenStateHandler * self) {
	self->priv = SKK_KUTEN_STATE_HANDLER_GET_PRIVATE (self);
}


static void skk_kuten_state_handler_finalize (GObject* obj) {
	SkkKutenStateHandler * self;
	self = SKK_KUTEN_STATE_HANDLER (obj);
	_g_object_unref0 (self->priv->converter);
	G_OBJECT_CLASS (skk_kuten_state_handler_parent_class)->finalize (obj);
}


GType skk_kuten_state_handler_get_type (void) {
	static volatile gsize skk_kuten_state_handler_type_id__volatile = 0;
	if (g_once_init_enter (&skk_kuten_state_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SkkKutenStateHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_kuten_state_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkKutenStateHandler), 0, (GInstanceInitFunc) skk_kuten_state_handler_instance_init, NULL };
		GType skk_kuten_state_handler_type_id;
		skk_kuten_state_handler_type_id = g_type_register_static (SKK_TYPE_STATE_HANDLER, "SkkKutenStateHandler", &g_define_type_info, 0);
		g_once_init_leave (&skk_kuten_state_handler_type_id__volatile, skk_kuten_state_handler_type_id);
	}
	return skk_kuten_state_handler_type_id__volatile;
}


static gboolean skk_abbrev_state_handler_real_process_key_event (SkkStateHandler* base, SkkState* state, SkkKeyEvent** key) {
	SkkAbbrevStateHandler * self;
	gboolean result = FALSE;
	SkkState* _tmp0_;
	SkkKeyEvent* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* command;
	const gchar* _tmp3_;
	self = (SkkAbbrevStateHandler*) base;
	g_return_val_if_fail (state != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = state;
	_tmp1_ = *key;
	_tmp2_ = skk_state_lookup_key (_tmp0_, _tmp1_);
	command = _tmp2_;
	_tmp3_ = command;
	if (g_strcmp0 (_tmp3_, "abort") == 0) {
		SkkState* _tmp4_;
		_tmp4_ = state;
		skk_state_reset (_tmp4_);
		result = TRUE;
		_g_free0 (command);
		return result;
	} else {
		const gchar* _tmp5_;
		_tmp5_ = command;
		if (g_strcmp0 (_tmp5_, "next-candidate") == 0) {
			SkkState* _tmp6_;
			_tmp6_ = state;
			_tmp6_->handler_type = SKK_TYPE_SELECT_STATE_HANDLER;
			result = FALSE;
			_g_free0 (command);
			return result;
		} else {
			gboolean _tmp7_ = FALSE;
			SkkKeyEvent* _tmp8_;
			SkkModifierType _tmp9_;
			SkkModifierType _tmp10_;
			gboolean _tmp14_;
			_tmp8_ = *key;
			_tmp9_ = skk_key_event_get_modifiers (_tmp8_);
			_tmp10_ = _tmp9_;
			if ((_tmp10_ & SKK_MODIFIER_TYPE_CONTROL_MASK) != 0) {
				SkkKeyEvent* _tmp11_;
				gunichar _tmp12_;
				gunichar _tmp13_;
				_tmp11_ = *key;
				_tmp12_ = skk_key_event_get_code (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp7_ = _tmp13_ == ((gunichar) 'q');
			} else {
				_tmp7_ = FALSE;
			}
			_tmp14_ = _tmp7_;
			if (_tmp14_) {
				SkkState* _tmp15_;
				GString* _tmp16_;
				SkkState* _tmp17_;
				GString* _tmp18_;
				const gchar* _tmp19_;
				gchar* _tmp20_ = NULL;
				gchar* _tmp21_;
				SkkState* _tmp22_;
				_tmp15_ = state;
				_tmp16_ = _tmp15_->output;
				_tmp17_ = state;
				_tmp18_ = _tmp17_->abbrev;
				_tmp19_ = _tmp18_->str;
				_tmp20_ = skk_util_get_wide_latin (_tmp19_);
				_tmp21_ = _tmp20_;
				g_string_assign (_tmp16_, _tmp21_);
				_g_free0 (_tmp21_);
				_tmp22_ = state;
				skk_state_reset (_tmp22_);
				result = TRUE;
				_g_free0 (command);
				return result;
			} else {
				const gchar* _tmp23_;
				_tmp23_ = command;
				if (g_strcmp0 (_tmp23_, "delete") == 0) {
					SkkState* _tmp24_;
					GString* _tmp25_;
					gssize _tmp26_;
					_tmp24_ = state;
					_tmp25_ = _tmp24_->abbrev;
					_tmp26_ = _tmp25_->len;
					if (_tmp26_ > ((gssize) 0)) {
						SkkState* _tmp27_;
						GString* _tmp28_;
						SkkState* _tmp29_;
						GString* _tmp30_;
						gssize _tmp31_;
						_tmp27_ = state;
						_tmp28_ = _tmp27_->abbrev;
						_tmp29_ = state;
						_tmp30_ = _tmp29_->abbrev;
						_tmp31_ = _tmp30_->len;
						g_string_truncate (_tmp28_, (gsize) (_tmp31_ - 1));
					} else {
						SkkState* _tmp32_;
						_tmp32_ = state;
						skk_state_reset (_tmp32_);
					}
					result = TRUE;
					_g_free0 (command);
					return result;
				} else {
					gboolean _tmp33_ = FALSE;
					gboolean _tmp34_ = FALSE;
					SkkKeyEvent* _tmp35_;
					SkkModifierType _tmp36_;
					SkkModifierType _tmp37_;
					gboolean _tmp41_;
					gboolean _tmp45_;
					_tmp35_ = *key;
					_tmp36_ = skk_key_event_get_modifiers (_tmp35_);
					_tmp37_ = _tmp36_;
					if (_tmp37_ == 0) {
						SkkKeyEvent* _tmp38_;
						gunichar _tmp39_;
						gunichar _tmp40_;
						_tmp38_ = *key;
						_tmp39_ = skk_key_event_get_code (_tmp38_);
						_tmp40_ = _tmp39_;
						_tmp34_ = ((gunichar) 0x20) <= _tmp40_;
					} else {
						_tmp34_ = FALSE;
					}
					_tmp41_ = _tmp34_;
					if (_tmp41_) {
						SkkKeyEvent* _tmp42_;
						gunichar _tmp43_;
						gunichar _tmp44_;
						_tmp42_ = *key;
						_tmp43_ = skk_key_event_get_code (_tmp42_);
						_tmp44_ = _tmp43_;
						_tmp33_ = _tmp44_ <= ((gunichar) 0x7E);
					} else {
						_tmp33_ = FALSE;
					}
					_tmp45_ = _tmp33_;
					if (_tmp45_) {
						SkkState* _tmp46_;
						GString* _tmp47_;
						SkkKeyEvent* _tmp48_;
						gunichar _tmp49_;
						gunichar _tmp50_;
						_tmp46_ = state;
						_tmp47_ = _tmp46_->abbrev;
						_tmp48_ = *key;
						_tmp49_ = skk_key_event_get_code (_tmp48_);
						_tmp50_ = _tmp49_;
						g_string_append_unichar (_tmp47_, _tmp50_);
						result = TRUE;
						_g_free0 (command);
						return result;
					}
				}
			}
		}
	}
	result = TRUE;
	_g_free0 (command);
	return result;
}


static gchar* skk_abbrev_state_handler_real_get_preedit (SkkStateHandler* base, SkkState* state, guint* underline_offset, guint* underline_nchars) {
	SkkAbbrevStateHandler * self;
	guint _vala_underline_offset = 0U;
	guint _vala_underline_nchars = 0U;
	gchar* result = NULL;
	SkkState* _tmp0_;
	GString* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	self = (SkkAbbrevStateHandler*) base;
	g_return_val_if_fail (state != NULL, NULL);
	_vala_underline_nchars = (guint) 0;
	_vala_underline_offset = _vala_underline_nchars;
	_tmp0_ = state;
	_tmp1_ = _tmp0_->abbrev;
	_tmp2_ = _tmp1_->str;
	_tmp3_ = g_strconcat ("▽", _tmp2_, NULL);
	result = _tmp3_;
	if (underline_offset) {
		*underline_offset = _vala_underline_offset;
	}
	if (underline_nchars) {
		*underline_nchars = _vala_underline_nchars;
	}
	return result;
}


SkkAbbrevStateHandler* skk_abbrev_state_handler_construct (GType object_type) {
	SkkAbbrevStateHandler * self = NULL;
	self = (SkkAbbrevStateHandler*) skk_state_handler_construct (object_type);
	return self;
}


SkkAbbrevStateHandler* skk_abbrev_state_handler_new (void) {
	return skk_abbrev_state_handler_construct (SKK_TYPE_ABBREV_STATE_HANDLER);
}


static void skk_abbrev_state_handler_class_init (SkkAbbrevStateHandlerClass * klass) {
	skk_abbrev_state_handler_parent_class = g_type_class_peek_parent (klass);
	SKK_STATE_HANDLER_CLASS (klass)->process_key_event = skk_abbrev_state_handler_real_process_key_event;
	SKK_STATE_HANDLER_CLASS (klass)->get_preedit = skk_abbrev_state_handler_real_get_preedit;
}


static void skk_abbrev_state_handler_instance_init (SkkAbbrevStateHandler * self) {
}


GType skk_abbrev_state_handler_get_type (void) {
	static volatile gsize skk_abbrev_state_handler_type_id__volatile = 0;
	if (g_once_init_enter (&skk_abbrev_state_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SkkAbbrevStateHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_abbrev_state_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkAbbrevStateHandler), 0, (GInstanceInitFunc) skk_abbrev_state_handler_instance_init, NULL };
		GType skk_abbrev_state_handler_type_id;
		skk_abbrev_state_handler_type_id = g_type_register_static (SKK_TYPE_STATE_HANDLER, "SkkAbbrevStateHandler", &g_define_type_info, 0);
		g_once_init_leave (&skk_abbrev_state_handler_type_id__volatile, skk_abbrev_state_handler_type_id);
	}
	return skk_abbrev_state_handler_type_id__volatile;
}


static gboolean skk_start_state_handler_real_process_key_event (SkkStateHandler* base, SkkState* state, SkkKeyEvent** key) {
	SkkStartStateHandler * self;
	gboolean result = FALSE;
	SkkState* _tmp0_;
	SkkKeyEvent* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* command;
	const gchar* _tmp3_;
	const gchar* _tmp33_;
	gboolean _tmp237_ = FALSE;
	SkkKeyEvent* _tmp238_;
	SkkModifierType _tmp239_;
	SkkModifierType _tmp240_;
	gboolean _tmp245_;
	self = (SkkStartStateHandler*) base;
	g_return_val_if_fail (state != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = state;
	_tmp1_ = *key;
	_tmp2_ = skk_state_lookup_key (_tmp0_, _tmp1_);
	command = _tmp2_;
	_tmp3_ = command;
	if (g_strcmp0 (_tmp3_, "abort") == 0) {
		SkkState* _tmp4_;
		_tmp4_ = state;
		skk_state_reset (_tmp4_);
		result = TRUE;
		_g_free0 (command);
		return result;
	}
	{
		SkkEntry* entry_collection = NULL;
		gint entry_collection_length1 = 0;
		gint _entry_collection_size_ = 0;
		gint entry_it = 0;
		entry_collection = SKK_START_STATE_HANDLER_end_preedit_commands;
		entry_collection_length1 = G_N_ELEMENTS (SKK_START_STATE_HANDLER_end_preedit_commands);
		for (entry_it = 0; entry_it < G_N_ELEMENTS (SKK_START_STATE_HANDLER_end_preedit_commands); entry_it = entry_it + 1) {
			SkkEntry entry = {0};
			entry = entry_collection[entry_it];
			{
				SkkEntry _tmp5_;
				gconstpointer _tmp6_;
				const gchar* _tmp7_;
				_tmp5_ = entry;
				_tmp6_ = _tmp5_.key;
				_tmp7_ = command;
				if (g_strcmp0 ((const gchar*) _tmp6_, _tmp7_) == 0) {
					SkkState* _tmp8_;
					SkkRomKanaConverter* _tmp9_;
					SkkState* _tmp10_;
					GString* _tmp11_;
					SkkState* _tmp12_;
					SkkRomKanaConverter* _tmp13_;
					const gchar* _tmp14_;
					const gchar* _tmp15_;
					SkkEntry _tmp16_;
					gconstpointer _tmp17_;
					gchar* _tmp18_ = NULL;
					gchar* _tmp19_;
					SkkState* _tmp20_;
					SkkUnicodeString* _tmp21_;
					SkkState* _tmp30_;
					SkkRomKanaConverter* _tmp31_;
					SkkState* _tmp32_;
					_tmp8_ = state;
					_tmp9_ = _tmp8_->rom_kana_converter;
					skk_rom_kana_converter_output_nn_if_any (_tmp9_);
					_tmp10_ = state;
					_tmp11_ = _tmp10_->output;
					_tmp12_ = state;
					_tmp13_ = _tmp12_->rom_kana_converter;
					_tmp14_ = skk_rom_kana_converter_get_output (_tmp13_);
					_tmp15_ = _tmp14_;
					_tmp16_ = entry;
					_tmp17_ = _tmp16_.value;
					_tmp18_ = skk_util_convert_by_input_mode (_tmp15_, GPOINTER_TO_INT (_tmp17_));
					_tmp19_ = _tmp18_;
					g_string_assign (_tmp11_, _tmp19_);
					_g_free0 (_tmp19_);
					_tmp20_ = state;
					_tmp21_ = _tmp20_->surrounding_text;
					if (_tmp21_ != NULL) {
						SkkState* _tmp22_;
						GString* _tmp23_;
						SkkState* _tmp24_;
						SkkUnicodeString* _tmp25_;
						SkkState* _tmp26_;
						guint _tmp27_;
						gchar* _tmp28_ = NULL;
						gchar* _tmp29_;
						_tmp22_ = state;
						_tmp23_ = _tmp22_->output;
						_tmp24_ = state;
						_tmp25_ = _tmp24_->surrounding_text;
						_tmp26_ = state;
						_tmp27_ = _tmp26_->surrounding_end;
						_tmp28_ = skk_unicode_string_substring (_tmp25_, (glong) _tmp27_, (glong) (-1));
						_tmp29_ = _tmp28_;
						g_string_append (_tmp23_, _tmp29_);
						_g_free0 (_tmp29_);
					}
					_tmp30_ = state;
					_tmp31_ = _tmp30_->rom_kana_converter;
					skk_rom_kana_converter_reset (_tmp31_);
					_tmp32_ = state;
					_tmp32_->handler_type = SKK_TYPE_NONE_STATE_HANDLER;
					result = TRUE;
					_g_free0 (command);
					return result;
				}
			}
		}
	}
	_tmp33_ = command;
	if (g_strcmp0 (_tmp33_, "next-candidate") == 0) {
		SkkState* _tmp34_;
		SkkRomKanaConverter* _tmp35_;
		const gchar* _tmp36_;
		const gchar* _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		SkkState* _tmp51_;
		_tmp34_ = state;
		_tmp35_ = _tmp34_->rom_kana_converter;
		_tmp36_ = skk_rom_kana_converter_get_output (_tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = strlen (_tmp37_);
		_tmp39_ = _tmp38_;
		if (_tmp39_ == 0) {
			SkkState* _tmp40_;
			SkkUnicodeString* _tmp41_;
			SkkState* _tmp50_;
			_tmp40_ = state;
			_tmp41_ = _tmp40_->surrounding_text;
			if (_tmp41_ != NULL) {
				SkkState* _tmp42_;
				GString* _tmp43_;
				SkkState* _tmp44_;
				SkkUnicodeString* _tmp45_;
				SkkState* _tmp46_;
				guint _tmp47_;
				gchar* _tmp48_ = NULL;
				gchar* _tmp49_;
				_tmp42_ = state;
				_tmp43_ = _tmp42_->output;
				_tmp44_ = state;
				_tmp45_ = _tmp44_->surrounding_text;
				_tmp46_ = state;
				_tmp47_ = _tmp46_->surrounding_end;
				_tmp48_ = skk_unicode_string_substring (_tmp45_, (glong) _tmp47_, (glong) (-1));
				_tmp49_ = _tmp48_;
				g_string_append (_tmp43_, _tmp49_);
				_g_free0 (_tmp49_);
			}
			_tmp50_ = state;
			skk_state_reset (_tmp50_);
			result = TRUE;
			_g_free0 (command);
			return result;
		}
		_tmp51_ = state;
		_tmp51_->handler_type = SKK_TYPE_SELECT_STATE_HANDLER;
		result = FALSE;
		_g_free0 (command);
		return result;
	} else {
		const gchar* _tmp52_;
		_tmp52_ = command;
		if (g_strcmp0 (_tmp52_, "commit") == 0) {
			SkkState* _tmp53_;
			GString* _tmp54_;
			SkkState* _tmp55_;
			SkkRomKanaConverter* _tmp56_;
			const gchar* _tmp57_;
			const gchar* _tmp58_;
			SkkState* _tmp59_;
			SkkUnicodeString* _tmp60_;
			SkkState* _tmp69_;
			_tmp53_ = state;
			_tmp54_ = _tmp53_->output;
			_tmp55_ = state;
			_tmp56_ = _tmp55_->rom_kana_converter;
			_tmp57_ = skk_rom_kana_converter_get_output (_tmp56_);
			_tmp58_ = _tmp57_;
			g_string_append (_tmp54_, _tmp58_);
			_tmp59_ = state;
			_tmp60_ = _tmp59_->surrounding_text;
			if (_tmp60_ != NULL) {
				SkkState* _tmp61_;
				GString* _tmp62_;
				SkkState* _tmp63_;
				SkkUnicodeString* _tmp64_;
				SkkState* _tmp65_;
				guint _tmp66_;
				gchar* _tmp67_ = NULL;
				gchar* _tmp68_;
				_tmp61_ = state;
				_tmp62_ = _tmp61_->output;
				_tmp63_ = state;
				_tmp64_ = _tmp63_->surrounding_text;
				_tmp65_ = state;
				_tmp66_ = _tmp65_->surrounding_end;
				_tmp67_ = skk_unicode_string_substring (_tmp64_, (glong) _tmp66_, (glong) (-1));
				_tmp68_ = _tmp67_;
				g_string_append (_tmp62_, _tmp68_);
				_g_free0 (_tmp68_);
			}
			_tmp69_ = state;
			skk_state_reset (_tmp69_);
			result = TRUE;
			_g_free0 (command);
			return result;
		} else {
			const gchar* _tmp70_;
			_tmp70_ = command;
			if (g_strcmp0 (_tmp70_, "commit-unhandled") == 0) {
				SkkState* _tmp71_;
				GString* _tmp72_;
				SkkState* _tmp73_;
				SkkRomKanaConverter* _tmp74_;
				const gchar* _tmp75_;
				const gchar* _tmp76_;
				SkkState* _tmp77_;
				SkkUnicodeString* _tmp78_;
				SkkState* _tmp87_;
				SkkState* _tmp88_;
				gboolean _tmp89_;
				_tmp71_ = state;
				_tmp72_ = _tmp71_->output;
				_tmp73_ = state;
				_tmp74_ = _tmp73_->rom_kana_converter;
				_tmp75_ = skk_rom_kana_converter_get_output (_tmp74_);
				_tmp76_ = _tmp75_;
				g_string_append (_tmp72_, _tmp76_);
				_tmp77_ = state;
				_tmp78_ = _tmp77_->surrounding_text;
				if (_tmp78_ != NULL) {
					SkkState* _tmp79_;
					GString* _tmp80_;
					SkkState* _tmp81_;
					SkkUnicodeString* _tmp82_;
					SkkState* _tmp83_;
					guint _tmp84_;
					gchar* _tmp85_ = NULL;
					gchar* _tmp86_;
					_tmp79_ = state;
					_tmp80_ = _tmp79_->output;
					_tmp81_ = state;
					_tmp82_ = _tmp81_->surrounding_text;
					_tmp83_ = state;
					_tmp84_ = _tmp83_->surrounding_end;
					_tmp85_ = skk_unicode_string_substring (_tmp82_, (glong) _tmp84_, (glong) (-1));
					_tmp86_ = _tmp85_;
					g_string_append (_tmp80_, _tmp86_);
					_g_free0 (_tmp86_);
				}
				_tmp87_ = state;
				skk_state_reset (_tmp87_);
				_tmp88_ = state;
				_tmp89_ = _tmp88_->egg_like_newline;
				result = _tmp89_;
				_g_free0 (command);
				return result;
			} else {
				const gchar* _tmp90_;
				_tmp90_ = command;
				if (g_strcmp0 (_tmp90_, "delete") == 0) {
					SkkState* _tmp91_;
					SkkRomKanaConverter* _tmp92_;
					gboolean _tmp93_ = FALSE;
					SkkState* _tmp117_;
					_tmp91_ = state;
					_tmp92_ = _tmp91_->okuri_rom_kana_converter;
					_tmp93_ = skk_rom_kana_converter_delete (_tmp92_);
					if (_tmp93_) {
						SkkState* _tmp94_;
						SkkRomKanaConverter* _tmp95_;
						const gchar* _tmp96_;
						const gchar* _tmp97_;
						gint _tmp98_;
						gint _tmp99_;
						_tmp94_ = state;
						_tmp95_ = _tmp94_->okuri_rom_kana_converter;
						_tmp96_ = skk_rom_kana_converter_get_preedit (_tmp95_);
						_tmp97_ = _tmp96_;
						_tmp98_ = strlen (_tmp97_);
						_tmp99_ = _tmp98_;
						if (_tmp99_ == 0) {
							SkkState* _tmp100_;
							_tmp100_ = state;
							_tmp100_->okuri = FALSE;
						}
						result = TRUE;
						_g_free0 (command);
						return result;
					} else {
						SkkState* _tmp101_;
						SkkRomKanaConverter* _tmp102_;
						gboolean _tmp103_ = FALSE;
						_tmp101_ = state;
						_tmp102_ = _tmp101_->rom_kana_converter;
						_tmp103_ = skk_rom_kana_converter_delete (_tmp102_);
						if (_tmp103_) {
							result = TRUE;
							_g_free0 (command);
							return result;
						} else {
							SkkState* _tmp104_;
							GString* _tmp105_;
							gssize _tmp106_;
							_tmp104_ = state;
							_tmp105_ = _tmp104_->output;
							_tmp106_ = _tmp105_->len;
							if (_tmp106_ > ((gssize) 0)) {
								SkkState* _tmp107_;
								GString* _tmp108_;
								SkkState* _tmp109_;
								GString* _tmp110_;
								const gchar* _tmp111_;
								SkkState* _tmp112_;
								GString* _tmp113_;
								const gchar* _tmp114_;
								gint _tmp115_ = 0;
								gint _tmp116_ = 0;
								_tmp107_ = state;
								_tmp108_ = _tmp107_->output;
								_tmp109_ = state;
								_tmp110_ = _tmp109_->output;
								_tmp111_ = _tmp110_->str;
								_tmp112_ = state;
								_tmp113_ = _tmp112_->output;
								_tmp114_ = _tmp113_->str;
								_tmp115_ = g_utf8_strlen (_tmp114_, (gssize) (-1));
								_tmp116_ = string_index_of_nth_char (_tmp111_, (glong) (_tmp115_ - 1));
								g_string_truncate (_tmp108_, (gsize) _tmp116_);
								result = TRUE;
								_g_free0 (command);
								return result;
							}
						}
					}
					_tmp117_ = state;
					_tmp117_->handler_type = SKK_TYPE_NONE_STATE_HANDLER;
					result = TRUE;
					_g_free0 (command);
					return result;
				} else {
					const gchar* _tmp118_;
					_tmp118_ = command;
					if (g_strcmp0 (_tmp118_, "complete") == 0) {
						SkkState* _tmp119_;
						GeeIterator* _tmp120_;
						SkkState* _tmp126_;
						GeeIterator* _tmp127_;
						_tmp119_ = state;
						_tmp120_ = _tmp119_->completion_iterator;
						if (_tmp120_ == NULL) {
							SkkState* _tmp121_;
							SkkState* _tmp122_;
							SkkRomKanaConverter* _tmp123_;
							const gchar* _tmp124_;
							const gchar* _tmp125_;
							_tmp121_ = state;
							_tmp122_ = state;
							_tmp123_ = _tmp122_->rom_kana_converter;
							_tmp124_ = skk_rom_kana_converter_get_output (_tmp123_);
							_tmp125_ = _tmp124_;
							skk_state_completion_start (_tmp121_, _tmp125_);
						}
						_tmp126_ = state;
						_tmp127_ = _tmp126_->completion_iterator;
						if (_tmp127_ != NULL) {
							SkkState* _tmp128_;
							GeeIterator* _tmp129_;
							gpointer _tmp130_ = NULL;
							gchar* midasi;
							SkkState* _tmp131_;
							SkkRomKanaConverter* _tmp132_;
							SkkState* _tmp133_;
							SkkRomKanaConverter* _tmp134_;
							const gchar* _tmp135_;
							SkkState* _tmp136_;
							GeeIterator* _tmp137_;
							gboolean _tmp138_ = FALSE;
							_tmp128_ = state;
							_tmp129_ = _tmp128_->completion_iterator;
							_tmp130_ = gee_iterator_get (_tmp129_);
							midasi = (gchar*) _tmp130_;
							_tmp131_ = state;
							_tmp132_ = _tmp131_->rom_kana_converter;
							skk_rom_kana_converter_reset (_tmp132_);
							_tmp133_ = state;
							_tmp134_ = _tmp133_->rom_kana_converter;
							_tmp135_ = midasi;
							skk_rom_kana_converter_set_output (_tmp134_, _tmp135_);
							_tmp136_ = state;
							_tmp137_ = _tmp136_->completion_iterator;
							_tmp138_ = gee_iterator_has_next (_tmp137_);
							if (_tmp138_) {
								SkkState* _tmp139_;
								GeeIterator* _tmp140_;
								_tmp139_ = state;
								_tmp140_ = _tmp139_->completion_iterator;
								gee_iterator_next (_tmp140_);
							}
							_g_free0 (midasi);
						}
						result = TRUE;
						_g_free0 (command);
						return result;
					} else {
						const gchar* _tmp141_;
						_tmp141_ = command;
						if (g_strcmp0 (_tmp141_, "special-midasi") == 0) {
							SkkState* _tmp142_;
							SkkRomKanaConverter* _tmp143_;
							const gchar* _tmp144_;
							const gchar* _tmp145_;
							gint _tmp146_;
							gint _tmp147_;
							_tmp142_ = state;
							_tmp143_ = _tmp142_->rom_kana_converter;
							_tmp144_ = skk_rom_kana_converter_get_output (_tmp143_);
							_tmp145_ = _tmp144_;
							_tmp146_ = strlen (_tmp145_);
							_tmp147_ = _tmp146_;
							if (_tmp147_ > 0) {
								SkkState* _tmp148_;
								SkkRomKanaConverter* _tmp149_;
								SkkKeyEvent* _tmp150_;
								gunichar _tmp151_;
								gunichar _tmp152_;
								gunichar _tmp153_ = 0U;
								SkkState* _tmp154_;
								SkkState* _tmp155_;
								SkkKeyEvent* _tmp156_ = NULL;
								_tmp148_ = state;
								_tmp149_ = _tmp148_->rom_kana_converter;
								_tmp150_ = *key;
								_tmp151_ = skk_key_event_get_code (_tmp150_);
								_tmp152_ = _tmp151_;
								_tmp153_ = g_unichar_tolower (_tmp152_);
								skk_rom_kana_converter_append (_tmp149_, _tmp153_);
								_tmp154_ = state;
								_tmp154_->handler_type = SKK_TYPE_SELECT_STATE_HANDLER;
								_tmp155_ = state;
								_tmp156_ = skk_state_where_is (_tmp155_, "next-candidate");
								_g_object_unref0 (*key);
								*key = _tmp156_;
								result = FALSE;
								_g_free0 (command);
								return result;
							} else {
								SkkState* _tmp157_;
								SkkRomKanaConverter* _tmp158_;
								SkkKeyEvent* _tmp159_;
								gunichar _tmp160_;
								gunichar _tmp161_;
								_tmp157_ = state;
								_tmp158_ = _tmp157_->rom_kana_converter;
								_tmp159_ = *key;
								_tmp160_ = skk_key_event_get_code (_tmp159_);
								_tmp161_ = _tmp160_;
								skk_rom_kana_converter_append (_tmp158_, _tmp161_);
								result = TRUE;
								_g_free0 (command);
								return result;
							}
						} else {
							gboolean _tmp162_ = FALSE;
							const gchar* _tmp163_;
							gboolean _tmp166_;
							_tmp163_ = command;
							if (_tmp163_ != NULL) {
								const gchar* _tmp164_;
								gboolean _tmp165_ = FALSE;
								_tmp164_ = command;
								_tmp165_ = g_str_has_prefix (_tmp164_, "insert-kana-");
								_tmp162_ = _tmp165_;
							} else {
								_tmp162_ = FALSE;
							}
							_tmp166_ = _tmp162_;
							if (_tmp166_) {
								const gchar* _tmp167_;
								gint _tmp168_;
								gint _tmp169_;
								const gchar* _tmp170_;
								gint _tmp171_;
								gint _tmp172_;
								gchar* _tmp173_ = NULL;
								gchar* _tmp174_;
								SkkState* _tmp175_;
								SkkInputMode _tmp176_;
								SkkInputMode _tmp177_;
								gchar* _tmp178_ = NULL;
								gchar* _tmp179_;
								gchar* kana;
								SkkState* _tmp180_;
								gboolean _tmp181_;
								_tmp167_ = command;
								_tmp168_ = strlen ("insert-kana-");
								_tmp169_ = _tmp168_;
								_tmp170_ = command;
								_tmp171_ = strlen (_tmp170_);
								_tmp172_ = _tmp171_;
								_tmp173_ = string_slice (_tmp167_, (glong) _tmp169_, (glong) _tmp172_);
								_tmp174_ = _tmp173_;
								_tmp175_ = state;
								_tmp176_ = skk_state_get_input_mode (_tmp175_);
								_tmp177_ = _tmp176_;
								_tmp178_ = skk_util_convert_by_input_mode (_tmp174_, _tmp177_);
								_tmp179_ = _tmp178_;
								_g_free0 (_tmp174_);
								kana = _tmp179_;
								_tmp180_ = state;
								_tmp181_ = _tmp180_->okuri;
								if (_tmp181_) {
									SkkState* _tmp182_;
									SkkRomKanaConverter* _tmp183_;
									const gchar* _tmp184_;
									SkkState* _tmp185_;
									SkkState* _tmp186_;
									SkkKeyEvent* _tmp187_ = NULL;
									_tmp182_ = state;
									_tmp183_ = _tmp182_->okuri_rom_kana_converter;
									_tmp184_ = kana;
									skk_rom_kana_converter_set_output (_tmp183_, _tmp184_);
									_tmp185_ = state;
									_tmp185_->handler_type = SKK_TYPE_SELECT_STATE_HANDLER;
									_tmp186_ = state;
									_tmp187_ = skk_state_where_is (_tmp186_, "next-candidate");
									_g_object_unref0 (*key);
									*key = _tmp187_;
									result = FALSE;
									_g_free0 (kana);
									_g_free0 (command);
									return result;
								} else {
									SkkState* _tmp188_;
									SkkRomKanaConverter* _tmp189_;
									const gchar* _tmp190_;
									_tmp188_ = state;
									_tmp189_ = _tmp188_->rom_kana_converter;
									_tmp190_ = kana;
									skk_rom_kana_converter_set_output (_tmp189_, _tmp190_);
									result = TRUE;
									_g_free0 (kana);
									_g_free0 (command);
									return result;
								}
								_g_free0 (kana);
							} else {
								const gchar* _tmp191_;
								_tmp191_ = command;
								if (g_strcmp0 (_tmp191_, "start-preedit") == 0) {
									result = TRUE;
									_g_free0 (command);
									return result;
								} else {
									const gchar* _tmp192_;
									_tmp192_ = command;
									if (g_strcmp0 (_tmp192_, "start-preedit-kana") == 0) {
										SkkState* _tmp193_;
										SkkRomKanaConverter* _tmp194_;
										const gchar* _tmp195_;
										const gchar* _tmp196_;
										gint _tmp197_;
										gint _tmp198_;
										_tmp193_ = state;
										_tmp194_ = _tmp193_->rom_kana_converter;
										_tmp195_ = skk_rom_kana_converter_get_output (_tmp194_);
										_tmp196_ = _tmp195_;
										_tmp197_ = strlen (_tmp196_);
										_tmp198_ = _tmp197_;
										if (_tmp198_ > 0) {
											SkkState* _tmp199_;
											_tmp199_ = state;
											_tmp199_->okuri = TRUE;
										}
										result = TRUE;
										_g_free0 (command);
										return result;
									} else {
										const gchar* _tmp200_;
										_tmp200_ = command;
										if (g_strcmp0 (_tmp200_, "expand-preedit") == 0) {
											gboolean _tmp201_ = FALSE;
											SkkState* _tmp202_;
											SkkUnicodeString* _tmp203_;
											gboolean _tmp209_;
											_tmp202_ = state;
											_tmp203_ = _tmp202_->surrounding_text;
											if (_tmp203_ != NULL) {
												SkkState* _tmp204_;
												guint _tmp205_;
												SkkState* _tmp206_;
												SkkUnicodeString* _tmp207_;
												gint _tmp208_;
												_tmp204_ = state;
												_tmp205_ = _tmp204_->surrounding_end;
												_tmp206_ = state;
												_tmp207_ = _tmp206_->surrounding_text;
												_tmp208_ = _tmp207_->length;
												_tmp201_ = _tmp205_ < ((guint) _tmp208_);
											} else {
												_tmp201_ = FALSE;
											}
											_tmp209_ = _tmp201_;
											if (_tmp209_) {
												SkkState* _tmp210_;
												guint _tmp211_;
												SkkState* _tmp212_;
												SkkRomKanaConverter* _tmp213_;
												SkkState* _tmp214_;
												SkkUnicodeString* _tmp215_;
												SkkState* _tmp216_;
												guint _tmp217_;
												gchar* _tmp218_ = NULL;
												gchar* _tmp219_;
												_tmp210_ = state;
												_tmp211_ = _tmp210_->surrounding_end;
												_tmp210_->surrounding_end = _tmp211_ + 1;
												_tmp212_ = state;
												_tmp213_ = _tmp212_->rom_kana_converter;
												_tmp214_ = state;
												_tmp215_ = _tmp214_->surrounding_text;
												_tmp216_ = state;
												_tmp217_ = _tmp216_->surrounding_end;
												_tmp218_ = skk_unicode_string_substring (_tmp215_, (glong) 0, (glong) _tmp217_);
												_tmp219_ = _tmp218_;
												skk_rom_kana_converter_set_output (_tmp213_, _tmp219_);
												_g_free0 (_tmp219_);
												result = TRUE;
												_g_free0 (command);
												return result;
											}
										} else {
											const gchar* _tmp220_;
											_tmp220_ = command;
											if (g_strcmp0 (_tmp220_, "shrink-preedit") == 0) {
												gboolean _tmp221_ = FALSE;
												SkkState* _tmp222_;
												SkkUnicodeString* _tmp223_;
												gboolean _tmp226_;
												_tmp222_ = state;
												_tmp223_ = _tmp222_->surrounding_text;
												if (_tmp223_ != NULL) {
													SkkState* _tmp224_;
													guint _tmp225_;
													_tmp224_ = state;
													_tmp225_ = _tmp224_->surrounding_end;
													_tmp221_ = _tmp225_ > ((guint) 0);
												} else {
													_tmp221_ = FALSE;
												}
												_tmp226_ = _tmp221_;
												if (_tmp226_) {
													SkkState* _tmp227_;
													guint _tmp228_;
													SkkState* _tmp229_;
													SkkRomKanaConverter* _tmp230_;
													SkkState* _tmp231_;
													SkkUnicodeString* _tmp232_;
													SkkState* _tmp233_;
													guint _tmp234_;
													gchar* _tmp235_ = NULL;
													gchar* _tmp236_;
													_tmp227_ = state;
													_tmp228_ = _tmp227_->surrounding_end;
													_tmp227_->surrounding_end = _tmp228_ - 1;
													_tmp229_ = state;
													_tmp230_ = _tmp229_->rom_kana_converter;
													_tmp231_ = state;
													_tmp232_ = _tmp231_->surrounding_text;
													_tmp233_ = state;
													_tmp234_ = _tmp233_->surrounding_end;
													_tmp235_ = skk_unicode_string_substring (_tmp232_, (glong) 0, (glong) _tmp234_);
													_tmp236_ = _tmp235_;
													skk_rom_kana_converter_set_output (_tmp230_, _tmp236_);
													_g_free0 (_tmp236_);
													result = TRUE;
													_g_free0 (command);
													return result;
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp238_ = *key;
	_tmp239_ = skk_key_event_get_modifiers (_tmp238_);
	_tmp240_ = _tmp239_;
	if (_tmp240_ == 0) {
		SkkKeyEvent* _tmp241_;
		gunichar _tmp242_;
		gunichar _tmp243_;
		gboolean _tmp244_ = FALSE;
		_tmp241_ = *key;
		_tmp242_ = skk_key_event_get_code (_tmp241_);
		_tmp243_ = _tmp242_;
		_tmp244_ = g_unichar_isalpha (_tmp243_);
		_tmp237_ = _tmp244_;
	} else {
		_tmp237_ = FALSE;
	}
	_tmp245_ = _tmp237_;
	if (_tmp245_) {
		gboolean _tmp246_ = FALSE;
		SkkState* _tmp247_;
		gboolean _tmp248_;
		gboolean _tmp270_;
		_tmp247_ = state;
		_tmp248_ = _tmp247_->okuri;
		if (_tmp248_) {
			_tmp246_ = TRUE;
		} else {
			gboolean _tmp249_ = FALSE;
			gboolean _tmp250_ = FALSE;
			SkkKeyEvent* _tmp251_;
			gunichar _tmp252_;
			gunichar _tmp253_;
			gboolean _tmp254_ = FALSE;
			gboolean _tmp261_;
			gboolean _tmp269_;
			_tmp251_ = *key;
			_tmp252_ = skk_key_event_get_code (_tmp251_);
			_tmp253_ = _tmp252_;
			_tmp254_ = g_unichar_isupper (_tmp253_);
			if (_tmp254_) {
				SkkState* _tmp255_;
				SkkRomKanaConverter* _tmp256_;
				const gchar* _tmp257_;
				const gchar* _tmp258_;
				gint _tmp259_;
				gint _tmp260_;
				_tmp255_ = state;
				_tmp256_ = _tmp255_->rom_kana_converter;
				_tmp257_ = skk_rom_kana_converter_get_output (_tmp256_);
				_tmp258_ = _tmp257_;
				_tmp259_ = strlen (_tmp258_);
				_tmp260_ = _tmp259_;
				_tmp250_ = _tmp260_ > 0;
			} else {
				_tmp250_ = FALSE;
			}
			_tmp261_ = _tmp250_;
			if (_tmp261_) {
				SkkState* _tmp262_;
				SkkRomKanaConverter* _tmp263_;
				SkkKeyEvent* _tmp264_;
				gunichar _tmp265_;
				gunichar _tmp266_;
				gunichar _tmp267_ = 0U;
				gboolean _tmp268_ = FALSE;
				_tmp262_ = state;
				_tmp263_ = _tmp262_->rom_kana_converter;
				_tmp264_ = *key;
				_tmp265_ = skk_key_event_get_code (_tmp264_);
				_tmp266_ = _tmp265_;
				_tmp267_ = g_unichar_tolower (_tmp266_);
				_tmp268_ = skk_rom_kana_converter_can_consume (_tmp263_, _tmp267_, TRUE, TRUE);
				_tmp249_ = !_tmp268_;
			} else {
				_tmp249_ = FALSE;
			}
			_tmp269_ = _tmp249_;
			_tmp246_ = _tmp269_;
		}
		_tmp270_ = _tmp246_;
		if (_tmp270_) {
			gboolean _tmp271_ = FALSE;
			SkkState* _tmp272_;
			gboolean _tmp273_;
			gboolean _tmp281_;
			SkkState* _tmp288_;
			SkkRomKanaConverter* _tmp289_;
			SkkState* _tmp290_;
			SkkState* _tmp291_;
			SkkRomKanaConverter* _tmp292_;
			SkkKeyEvent* _tmp293_;
			gunichar _tmp294_;
			gunichar _tmp295_;
			gunichar _tmp296_ = 0U;
			SkkState* _tmp297_;
			SkkRomKanaConverter* _tmp298_;
			const gchar* _tmp299_;
			const gchar* _tmp300_;
			gint _tmp301_;
			gint _tmp302_;
			_tmp272_ = state;
			_tmp273_ = _tmp272_->okuri;
			if (!_tmp273_) {
				SkkState* _tmp274_;
				SkkRomKanaConverter* _tmp275_;
				SkkKeyEvent* _tmp276_;
				gunichar _tmp277_;
				gunichar _tmp278_;
				gunichar _tmp279_ = 0U;
				gboolean _tmp280_ = FALSE;
				_tmp274_ = state;
				_tmp275_ = _tmp274_->rom_kana_converter;
				_tmp276_ = *key;
				_tmp277_ = skk_key_event_get_code (_tmp276_);
				_tmp278_ = _tmp277_;
				_tmp279_ = g_unichar_tolower (_tmp278_);
				_tmp280_ = skk_rom_kana_converter_can_consume (_tmp275_, _tmp279_, TRUE, FALSE);
				_tmp271_ = _tmp280_;
			} else {
				_tmp271_ = FALSE;
			}
			_tmp281_ = _tmp271_;
			if (_tmp281_) {
				SkkState* _tmp282_;
				SkkRomKanaConverter* _tmp283_;
				SkkKeyEvent* _tmp284_;
				gunichar _tmp285_;
				gunichar _tmp286_;
				gunichar _tmp287_ = 0U;
				_tmp282_ = state;
				_tmp283_ = _tmp282_->rom_kana_converter;
				_tmp284_ = *key;
				_tmp285_ = skk_key_event_get_code (_tmp284_);
				_tmp286_ = _tmp285_;
				_tmp287_ = g_unichar_tolower (_tmp286_);
				skk_rom_kana_converter_append (_tmp283_, _tmp287_);
			}
			_tmp288_ = state;
			_tmp289_ = _tmp288_->rom_kana_converter;
			skk_rom_kana_converter_output_nn_if_any (_tmp289_);
			_tmp290_ = state;
			_tmp290_->okuri = TRUE;
			_tmp291_ = state;
			_tmp292_ = _tmp291_->okuri_rom_kana_converter;
			_tmp293_ = *key;
			_tmp294_ = skk_key_event_get_code (_tmp293_);
			_tmp295_ = _tmp294_;
			_tmp296_ = g_unichar_tolower (_tmp295_);
			skk_rom_kana_converter_append (_tmp292_, _tmp296_);
			_tmp297_ = state;
			_tmp298_ = _tmp297_->okuri_rom_kana_converter;
			_tmp299_ = skk_rom_kana_converter_get_preedit (_tmp298_);
			_tmp300_ = _tmp299_;
			_tmp301_ = strlen (_tmp300_);
			_tmp302_ = _tmp301_;
			if (_tmp302_ == 0) {
				SkkState* _tmp303_;
				SkkState* _tmp304_;
				SkkKeyEvent* _tmp305_ = NULL;
				_tmp303_ = state;
				_tmp303_->handler_type = SKK_TYPE_SELECT_STATE_HANDLER;
				_tmp304_ = state;
				_tmp305_ = skk_state_where_is (_tmp304_, "next-candidate");
				_g_object_unref0 (*key);
				*key = _tmp305_;
				result = FALSE;
				_g_free0 (command);
				return result;
			}
			result = TRUE;
			_g_free0 (command);
			return result;
		} else {
			SkkState* _tmp306_;
			SkkRomKanaConverter* _tmp307_;
			SkkKeyEvent* _tmp308_;
			gunichar _tmp309_;
			gunichar _tmp310_;
			gunichar _tmp311_ = 0U;
			SkkState* _tmp312_;
			SkkKeyEvent* _tmp313_;
			gboolean _tmp314_ = FALSE;
			_tmp306_ = state;
			_tmp307_ = _tmp306_->rom_kana_converter;
			_tmp308_ = *key;
			_tmp309_ = skk_key_event_get_code (_tmp308_);
			_tmp310_ = _tmp309_;
			_tmp311_ = g_unichar_tolower (_tmp310_);
			skk_rom_kana_converter_append (_tmp307_, _tmp311_);
			_tmp312_ = state;
			_tmp313_ = *key;
			_tmp314_ = skk_start_state_handler_check_auto_conversion (self, _tmp312_, _tmp313_);
			if (_tmp314_) {
				SkkState* _tmp315_;
				SkkState* _tmp316_;
				SkkKeyEvent* _tmp317_ = NULL;
				_tmp315_ = state;
				_tmp315_->handler_type = SKK_TYPE_SELECT_STATE_HANDLER;
				_tmp316_ = state;
				_tmp317_ = skk_state_where_is (_tmp316_, "next-candidate");
				_g_object_unref0 (*key);
				*key = _tmp317_;
				result = FALSE;
				_g_free0 (command);
				return result;
			}
			result = TRUE;
			_g_free0 (command);
			return result;
		}
	} else {
		SkkKeyEvent* _tmp318_;
		SkkModifierType _tmp319_;
		SkkModifierType _tmp320_;
		_tmp318_ = *key;
		_tmp319_ = skk_key_event_get_modifiers (_tmp318_);
		_tmp320_ = _tmp319_;
		if (_tmp320_ == 0) {
			SkkState* _tmp321_;
			SkkRomKanaConverter* _tmp322_;
			SkkKeyEvent* _tmp323_;
			gunichar _tmp324_;
			gunichar _tmp325_;
			gunichar _tmp326_ = 0U;
			SkkState* _tmp327_;
			SkkKeyEvent* _tmp328_;
			gboolean _tmp329_ = FALSE;
			_tmp321_ = state;
			_tmp322_ = _tmp321_->rom_kana_converter;
			_tmp323_ = *key;
			_tmp324_ = skk_key_event_get_code (_tmp323_);
			_tmp325_ = _tmp324_;
			_tmp326_ = g_unichar_tolower (_tmp325_);
			skk_rom_kana_converter_append (_tmp322_, _tmp326_);
			_tmp327_ = state;
			_tmp328_ = *key;
			_tmp329_ = skk_start_state_handler_check_auto_conversion (self, _tmp327_, _tmp328_);
			if (_tmp329_) {
				SkkState* _tmp330_;
				SkkState* _tmp331_;
				SkkKeyEvent* _tmp332_ = NULL;
				_tmp330_ = state;
				_tmp330_->handler_type = SKK_TYPE_SELECT_STATE_HANDLER;
				_tmp331_ = state;
				_tmp332_ = skk_state_where_is (_tmp331_, "next-candidate");
				_g_object_unref0 (*key);
				*key = _tmp332_;
				result = FALSE;
				_g_free0 (command);
				return result;
			}
			result = TRUE;
			_g_free0 (command);
			return result;
		}
	}
	result = TRUE;
	_g_free0 (command);
	return result;
}


static gchar* skk_start_state_handler_real_get_preedit (SkkStateHandler* base, SkkState* state, guint* underline_offset, guint* underline_nchars) {
	SkkStartStateHandler * self;
	guint _vala_underline_offset = 0U;
	guint _vala_underline_nchars = 0U;
	gchar* result = NULL;
	GString* _tmp0_;
	GString* builder;
	guint _tmp1_;
	GString* _tmp2_;
	SkkState* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	SkkState* _tmp6_;
	SkkUnicodeString* _tmp7_;
	GString* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	self = (SkkStartStateHandler*) base;
	g_return_val_if_fail (state != NULL, NULL);
	_tmp0_ = g_string_new ("▽");
	builder = _tmp0_;
	_vala_underline_nchars = (guint) 0;
	_tmp1_ = _vala_underline_nchars;
	_vala_underline_offset = _tmp1_;
	_tmp2_ = builder;
	_tmp3_ = state;
	_tmp4_ = skk_state_get_yomi (_tmp3_);
	_tmp5_ = _tmp4_;
	g_string_append (_tmp2_, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = state;
	_tmp7_ = _tmp6_->surrounding_text;
	if (_tmp7_ != NULL) {
		GString* _tmp8_;
		const gchar* _tmp9_;
		gint _tmp10_ = 0;
		GString* _tmp11_;
		SkkState* _tmp12_;
		SkkUnicodeString* _tmp13_;
		SkkState* _tmp14_;
		guint _tmp15_;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		_vala_underline_offset = (guint) 1;
		_tmp8_ = builder;
		_tmp9_ = _tmp8_->str;
		_tmp10_ = g_utf8_strlen (_tmp9_, (gssize) (-1));
		_vala_underline_nchars = (guint) (_tmp10_ - 1);
		_tmp11_ = builder;
		_tmp12_ = state;
		_tmp13_ = _tmp12_->surrounding_text;
		_tmp14_ = state;
		_tmp15_ = _tmp14_->surrounding_end;
		_tmp16_ = skk_unicode_string_substring (_tmp13_, (glong) _tmp15_, (glong) (-1));
		_tmp17_ = _tmp16_;
		g_string_append (_tmp11_, _tmp17_);
		_g_free0 (_tmp17_);
	}
	_tmp18_ = builder;
	_tmp19_ = _tmp18_->str;
	_tmp20_ = g_strdup (_tmp19_);
	result = _tmp20_;
	_g_string_free0 (builder);
	if (underline_offset) {
		*underline_offset = _vala_underline_offset;
	}
	if (underline_nchars) {
		*underline_nchars = _vala_underline_nchars;
	}
	return result;
}


static gboolean skk_start_state_handler_check_auto_conversion (SkkStartStateHandler* self, SkkState* state, SkkKeyEvent* key) {
	gboolean result = FALSE;
	SkkState* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (state != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = state;
	_tmp1_ = _tmp0_->auto_start_henkan_keywords;
	_tmp1__length1 = _tmp0_->auto_start_henkan_keywords_length1;
	{
		gchar** keyword_collection = NULL;
		gint keyword_collection_length1 = 0;
		gint _keyword_collection_size_ = 0;
		gint keyword_it = 0;
		keyword_collection = _tmp1_;
		keyword_collection_length1 = _tmp1__length1;
		for (keyword_it = 0; keyword_it < _tmp1__length1; keyword_it = keyword_it + 1) {
			gchar* _tmp2_;
			gchar* keyword = NULL;
			_tmp2_ = g_strdup (keyword_collection[keyword_it]);
			keyword = _tmp2_;
			{
				gboolean _tmp3_ = FALSE;
				SkkState* _tmp4_;
				SkkRomKanaConverter* _tmp5_;
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				gint _tmp8_;
				gint _tmp9_;
				const gchar* _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				gboolean _tmp19_;
				_tmp4_ = state;
				_tmp5_ = _tmp4_->rom_kana_converter;
				_tmp6_ = skk_rom_kana_converter_get_output (_tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = strlen (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = keyword;
				_tmp11_ = strlen (_tmp10_);
				_tmp12_ = _tmp11_;
				if (_tmp9_ > _tmp12_) {
					SkkState* _tmp13_;
					SkkRomKanaConverter* _tmp14_;
					const gchar* _tmp15_;
					const gchar* _tmp16_;
					const gchar* _tmp17_;
					gboolean _tmp18_ = FALSE;
					_tmp13_ = state;
					_tmp14_ = _tmp13_->rom_kana_converter;
					_tmp15_ = skk_rom_kana_converter_get_output (_tmp14_);
					_tmp16_ = _tmp15_;
					_tmp17_ = keyword;
					_tmp18_ = g_str_has_suffix (_tmp16_, _tmp17_);
					_tmp3_ = _tmp18_;
				} else {
					_tmp3_ = FALSE;
				}
				_tmp19_ = _tmp3_;
				if (_tmp19_) {
					SkkState* _tmp20_;
					const gchar* _tmp21_;
					gchar* _tmp22_;
					SkkState* _tmp23_;
					SkkRomKanaConverter* _tmp24_;
					SkkState* _tmp25_;
					SkkRomKanaConverter* _tmp26_;
					const gchar* _tmp27_;
					const gchar* _tmp28_;
					const gchar* _tmp29_;
					gint _tmp30_;
					gint _tmp31_;
					gchar* _tmp32_ = NULL;
					gchar* _tmp33_;
					SkkState* _tmp34_;
					_tmp20_ = state;
					_tmp21_ = keyword;
					_tmp22_ = g_strdup (_tmp21_);
					_g_free0 (_tmp20_->auto_start_henkan_keyword);
					_tmp20_->auto_start_henkan_keyword = _tmp22_;
					_tmp23_ = state;
					_tmp24_ = _tmp23_->rom_kana_converter;
					_tmp25_ = state;
					_tmp26_ = _tmp25_->rom_kana_converter;
					_tmp27_ = skk_rom_kana_converter_get_output (_tmp26_);
					_tmp28_ = _tmp27_;
					_tmp29_ = keyword;
					_tmp30_ = strlen (_tmp29_);
					_tmp31_ = _tmp30_;
					_tmp32_ = string_slice (_tmp28_, (glong) 0, (glong) (-_tmp31_));
					_tmp33_ = _tmp32_;
					skk_rom_kana_converter_set_output (_tmp24_, _tmp33_);
					_g_free0 (_tmp33_);
					_tmp34_ = state;
					_tmp34_->handler_type = SKK_TYPE_SELECT_STATE_HANDLER;
					result = TRUE;
					_g_free0 (keyword);
					return result;
				}
				_g_free0 (keyword);
			}
		}
	}
	result = FALSE;
	return result;
}


SkkStartStateHandler* skk_start_state_handler_construct (GType object_type) {
	SkkStartStateHandler * self = NULL;
	self = (SkkStartStateHandler*) skk_state_handler_construct (object_type);
	return self;
}


SkkStartStateHandler* skk_start_state_handler_new (void) {
	return skk_start_state_handler_construct (SKK_TYPE_START_STATE_HANDLER);
}


static void skk_start_state_handler_class_init (SkkStartStateHandlerClass * klass) {
	skk_start_state_handler_parent_class = g_type_class_peek_parent (klass);
	SKK_STATE_HANDLER_CLASS (klass)->process_key_event = skk_start_state_handler_real_process_key_event;
	SKK_STATE_HANDLER_CLASS (klass)->get_preedit = skk_start_state_handler_real_get_preedit;
}


static void skk_start_state_handler_instance_init (SkkStartStateHandler * self) {
}


GType skk_start_state_handler_get_type (void) {
	static volatile gsize skk_start_state_handler_type_id__volatile = 0;
	if (g_once_init_enter (&skk_start_state_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SkkStartStateHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_start_state_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkStartStateHandler), 0, (GInstanceInitFunc) skk_start_state_handler_instance_init, NULL };
		GType skk_start_state_handler_type_id;
		skk_start_state_handler_type_id = g_type_register_static (SKK_TYPE_STATE_HANDLER, "SkkStartStateHandler", &g_define_type_info, 0);
		g_once_init_leave (&skk_start_state_handler_type_id__volatile, skk_start_state_handler_type_id);
	}
	return skk_start_state_handler_type_id__volatile;
}


static gboolean skk_select_state_handler_real_process_key_event (SkkStateHandler* base, SkkState* state, SkkKeyEvent** key) {
	SkkSelectStateHandler * self;
	gboolean result = FALSE;
	SkkState* _tmp0_;
	SkkKeyEvent* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* command;
	const gchar* _tmp3_;
	self = (SkkSelectStateHandler*) base;
	g_return_val_if_fail (state != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = state;
	_tmp1_ = *key;
	_tmp2_ = skk_state_lookup_key (_tmp0_, _tmp1_);
	command = _tmp2_;
	_tmp3_ = command;
	if (g_strcmp0 (_tmp3_, "previous-candidate") == 0) {
		SkkState* _tmp4_;
		SkkCandidateList* _tmp5_;
		gboolean _tmp6_ = FALSE;
		_tmp4_ = state;
		_tmp5_ = _tmp4_->candidates;
		_tmp6_ = skk_candidate_list_previous (_tmp5_);
		if (!_tmp6_) {
			SkkState* _tmp7_;
			SkkCandidateList* _tmp8_;
			SkkState* _tmp9_;
			_tmp7_ = state;
			_tmp8_ = _tmp7_->candidates;
			skk_candidate_list_clear (_tmp8_);
			_tmp9_ = state;
			_tmp9_->handler_type = SKK_TYPE_START_STATE_HANDLER;
		}
		result = TRUE;
		_g_free0 (command);
		return result;
	} else {
		const gchar* _tmp10_;
		_tmp10_ = command;
		if (g_strcmp0 (_tmp10_, "purge-candidate") == 0) {
			SkkState* _tmp11_;
			SkkCandidateList* _tmp12_;
			SkkCandidate* _tmp13_ = NULL;
			SkkCandidate* candidate;
			SkkState* _tmp14_;
			SkkCandidate* _tmp15_;
			SkkState* _tmp16_;
			_tmp11_ = state;
			_tmp12_ = _tmp11_->candidates;
			_tmp13_ = skk_candidate_list_get (_tmp12_, -1);
			candidate = _tmp13_;
			_tmp14_ = state;
			_tmp15_ = candidate;
			skk_state_purge_candidate (_tmp14_, _tmp15_);
			_tmp16_ = state;
			skk_state_reset (_tmp16_);
			result = TRUE;
			_g_object_unref0 (candidate);
			_g_free0 (command);
			return result;
		} else {
			const gchar* _tmp17_;
			_tmp17_ = command;
			if (g_strcmp0 (_tmp17_, "next-candidate") == 0) {
				SkkState* _tmp18_;
				SkkCandidateList* _tmp19_;
				gint _tmp20_;
				gint _tmp21_;
				SkkState* _tmp60_;
				SkkState* _tmp61_;
				gchar* _tmp62_ = NULL;
				gchar* _tmp63_;
				SkkState* _tmp64_;
				gboolean _tmp65_;
				SkkState* _tmp66_;
				SkkCandidateList* _tmp67_;
				gint _tmp68_;
				gint _tmp69_;
				_tmp18_ = state;
				_tmp19_ = _tmp18_->candidates;
				_tmp20_ = skk_candidate_list_get_cursor_pos (_tmp19_);
				_tmp21_ = _tmp20_;
				if (_tmp21_ < 0) {
					gchar* midasi = NULL;
					gboolean okuri;
					SkkState* _tmp22_;
					GString* _tmp23_;
					gssize _tmp24_;
					SkkState* _tmp50_;
					const gchar* _tmp51_;
					gboolean _tmp52_;
					SkkState* _tmp53_;
					SkkCandidateList* _tmp54_;
					gint _tmp55_;
					gint _tmp56_;
					okuri = FALSE;
					_tmp22_ = state;
					_tmp23_ = _tmp22_->abbrev;
					_tmp24_ = _tmp23_->len;
					if (_tmp24_ > ((gssize) 0)) {
						SkkState* _tmp25_;
						GString* _tmp26_;
						const gchar* _tmp27_;
						gchar* _tmp28_;
						_tmp25_ = state;
						_tmp26_ = _tmp25_->abbrev;
						_tmp27_ = _tmp26_->str;
						_tmp28_ = g_strdup (_tmp27_);
						_g_free0 (midasi);
						midasi = _tmp28_;
					} else {
						GString* _tmp29_;
						GString* builder;
						SkkState* _tmp30_;
						SkkRomKanaConverter* _tmp31_;
						GString* _tmp32_;
						SkkState* _tmp33_;
						SkkRomKanaConverter* _tmp34_;
						const gchar* _tmp35_;
						const gchar* _tmp36_;
						SkkState* _tmp37_;
						gboolean _tmp38_;
						GString* _tmp47_;
						const gchar* _tmp48_;
						gchar* _tmp49_ = NULL;
						_tmp29_ = g_string_new ("");
						builder = _tmp29_;
						_tmp30_ = state;
						_tmp31_ = _tmp30_->rom_kana_converter;
						skk_rom_kana_converter_output_nn_if_any (_tmp31_);
						_tmp32_ = builder;
						_tmp33_ = state;
						_tmp34_ = _tmp33_->rom_kana_converter;
						_tmp35_ = skk_rom_kana_converter_get_output (_tmp34_);
						_tmp36_ = _tmp35_;
						g_string_append (_tmp32_, _tmp36_);
						_tmp37_ = state;
						_tmp38_ = _tmp37_->okuri;
						if (_tmp38_) {
							SkkState* _tmp39_;
							SkkRomKanaConverter* _tmp40_;
							const gchar* _tmp41_;
							const gchar* _tmp42_;
							gchar* _tmp43_ = NULL;
							gchar* prefix;
							const gchar* _tmp44_;
							_tmp39_ = state;
							_tmp40_ = _tmp39_->okuri_rom_kana_converter;
							_tmp41_ = skk_rom_kana_converter_get_output (_tmp40_);
							_tmp42_ = _tmp41_;
							_tmp43_ = skk_util_get_okurigana_prefix (_tmp42_);
							prefix = _tmp43_;
							_tmp44_ = prefix;
							if (_tmp44_ != NULL) {
								GString* _tmp45_;
								const gchar* _tmp46_;
								_tmp45_ = builder;
								_tmp46_ = prefix;
								g_string_append (_tmp45_, _tmp46_);
								okuri = TRUE;
							}
							_g_free0 (prefix);
						}
						_tmp47_ = builder;
						_tmp48_ = _tmp47_->str;
						_tmp49_ = skk_util_get_hiragana (_tmp48_);
						_g_free0 (midasi);
						midasi = _tmp49_;
						_g_string_free0 (builder);
					}
					_tmp50_ = state;
					_tmp51_ = midasi;
					_tmp52_ = okuri;
					skk_state_lookup (_tmp50_, _tmp51_, _tmp52_);
					_tmp53_ = state;
					_tmp54_ = _tmp53_->candidates;
					_tmp55_ = skk_candidate_list_get_size (_tmp54_);
					_tmp56_ = _tmp55_;
					if (_tmp56_ > 0) {
						result = TRUE;
						_g_free0 (midasi);
						_g_free0 (command);
						return result;
					}
					_g_free0 (midasi);
				} else {
					SkkState* _tmp57_;
					SkkCandidateList* _tmp58_;
					gboolean _tmp59_ = FALSE;
					_tmp57_ = state;
					_tmp58_ = _tmp57_->candidates;
					_tmp59_ = skk_candidate_list_next (_tmp58_);
					if (_tmp59_) {
						result = TRUE;
						_g_free0 (command);
						return result;
					}
				}
				_tmp60_ = state;
				_tmp61_ = state;
				_tmp62_ = skk_state_get_yomi (_tmp61_);
				_tmp63_ = _tmp62_;
				_tmp64_ = state;
				_tmp65_ = _tmp64_->okuri;
				g_signal_emit_by_name (_tmp60_, "recursive-edit-start", _tmp63_, _tmp65_);
				_g_free0 (_tmp63_);
				_tmp66_ = state;
				_tmp67_ = _tmp66_->candidates;
				_tmp68_ = skk_candidate_list_get_size (_tmp67_);
				_tmp69_ = _tmp68_;
				if (_tmp69_ == 0) {
					SkkState* _tmp70_;
					SkkCandidateList* _tmp71_;
					SkkState* _tmp72_;
					_tmp70_ = state;
					_tmp71_ = _tmp70_->candidates;
					skk_candidate_list_clear (_tmp71_);
					_tmp72_ = state;
					_tmp72_->handler_type = SKK_TYPE_START_STATE_HANDLER;
				}
				result = TRUE;
				_g_free0 (command);
				return result;
			} else {
				const gchar* _tmp73_;
				_tmp73_ = command;
				if (g_strcmp0 (_tmp73_, "abort") == 0) {
					SkkState* _tmp74_;
					SkkCandidateList* _tmp75_;
					SkkState* _tmp76_;
					SkkState* _tmp77_;
					_tmp74_ = state;
					_tmp75_ = _tmp74_->candidates;
					skk_candidate_list_clear (_tmp75_);
					_tmp76_ = state;
					skk_state_cancel_okuri (_tmp76_);
					_tmp77_ = state;
					_tmp77_->handler_type = SKK_TYPE_START_STATE_HANDLER;
					result = TRUE;
					_g_free0 (command);
					return result;
				} else {
					gchar* _tmp78_;
					gchar* surrounding_after;
					SkkState* _tmp79_;
					SkkUnicodeString* _tmp80_;
					SkkState* _tmp86_;
					SkkCandidateList* _tmp87_;
					SkkState* _tmp88_;
					GString* _tmp89_;
					const gchar* _tmp90_;
					const gchar* _tmp91_;
					_tmp78_ = g_strdup ("");
					surrounding_after = _tmp78_;
					_tmp79_ = state;
					_tmp80_ = _tmp79_->surrounding_text;
					if (_tmp80_ != NULL) {
						SkkState* _tmp81_;
						SkkUnicodeString* _tmp82_;
						SkkState* _tmp83_;
						guint _tmp84_;
						gchar* _tmp85_ = NULL;
						_tmp81_ = state;
						_tmp82_ = _tmp81_->surrounding_text;
						_tmp83_ = state;
						_tmp84_ = _tmp83_->surrounding_end;
						_tmp85_ = skk_unicode_string_substring (_tmp82_, (glong) _tmp84_, (glong) (-1));
						_g_free0 (surrounding_after);
						surrounding_after = _tmp85_;
					}
					_tmp86_ = state;
					_tmp87_ = _tmp86_->candidates;
					skk_candidate_list_select (_tmp87_);
					_tmp88_ = state;
					_tmp89_ = _tmp88_->output;
					_tmp90_ = surrounding_after;
					g_string_append (_tmp89_, _tmp90_);
					_tmp91_ = command;
					if (g_strcmp0 (_tmp91_, "special-midasi") == 0) {
						SkkState* _tmp92_;
						SkkCandidateList* _tmp93_;
						SkkState* _tmp94_;
						_tmp92_ = state;
						_tmp93_ = _tmp92_->candidates;
						skk_candidate_list_clear (_tmp93_);
						_tmp94_ = state;
						_tmp94_->handler_type = SKK_TYPE_START_STATE_HANDLER;
						result = FALSE;
						_g_free0 (surrounding_after);
						_g_free0 (command);
						return result;
					} else {
						SkkState* _tmp95_;
						gboolean _tmp96_ = FALSE;
						gboolean _tmp97_ = FALSE;
						gboolean _tmp98_ = FALSE;
						gboolean _tmp99_ = FALSE;
						SkkKeyEvent* _tmp100_;
						SkkModifierType _tmp101_;
						SkkModifierType _tmp102_;
						gboolean _tmp106_;
						gboolean _tmp110_;
						gboolean _tmp112_;
						gboolean _tmp118_;
						_tmp95_ = state;
						skk_state_reset (_tmp95_);
						_tmp100_ = *key;
						_tmp101_ = skk_key_event_get_modifiers (_tmp100_);
						_tmp102_ = _tmp101_;
						if (_tmp102_ == 0) {
							SkkKeyEvent* _tmp103_;
							gunichar _tmp104_;
							gunichar _tmp105_;
							_tmp103_ = *key;
							_tmp104_ = skk_key_event_get_code (_tmp103_);
							_tmp105_ = _tmp104_;
							_tmp99_ = ((gunichar) 0x20) <= _tmp105_;
						} else {
							_tmp99_ = FALSE;
						}
						_tmp106_ = _tmp99_;
						if (_tmp106_) {
							SkkKeyEvent* _tmp107_;
							gunichar _tmp108_;
							gunichar _tmp109_;
							_tmp107_ = *key;
							_tmp108_ = skk_key_event_get_code (_tmp107_);
							_tmp109_ = _tmp108_;
							_tmp98_ = _tmp109_ <= ((gunichar) 0x7E);
						} else {
							_tmp98_ = FALSE;
						}
						_tmp110_ = _tmp98_;
						if (_tmp110_) {
							_tmp97_ = TRUE;
						} else {
							const gchar* _tmp111_;
							_tmp111_ = command;
							_tmp97_ = g_strcmp0 (_tmp111_, "delete") == 0;
						}
						_tmp112_ = _tmp97_;
						if (_tmp112_) {
							_tmp96_ = TRUE;
						} else {
							gboolean _tmp113_ = FALSE;
							SkkState* _tmp114_;
							gboolean _tmp115_;
							gboolean _tmp117_;
							_tmp114_ = state;
							_tmp115_ = _tmp114_->egg_like_newline;
							if (!_tmp115_) {
								const gchar* _tmp116_;
								_tmp116_ = command;
								_tmp113_ = g_strcmp0 (_tmp116_, "commit-unhandled") == 0;
							} else {
								_tmp113_ = FALSE;
							}
							_tmp117_ = _tmp113_;
							_tmp96_ = _tmp117_;
						}
						_tmp118_ = _tmp96_;
						if (_tmp118_) {
							result = FALSE;
							_g_free0 (surrounding_after);
							_g_free0 (command);
							return result;
						} else {
							result = TRUE;
							_g_free0 (surrounding_after);
							_g_free0 (command);
							return result;
						}
					}
					_g_free0 (surrounding_after);
				}
			}
		}
	}
	_g_free0 (command);
}


static gchar* skk_select_state_handler_real_get_preedit (SkkStateHandler* base, SkkState* state, guint* underline_offset, guint* underline_nchars) {
	SkkSelectStateHandler * self;
	guint _vala_underline_offset = 0U;
	guint _vala_underline_nchars = 0U;
	gchar* result = NULL;
	GString* _tmp0_;
	GString* builder;
	guint _tmp1_;
	SkkState* _tmp2_;
	SkkCandidateList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	SkkState* _tmp18_;
	const gchar* _tmp19_;
	GString* _tmp42_;
	const gchar* _tmp43_;
	gchar* _tmp44_;
	self = (SkkSelectStateHandler*) base;
	g_return_val_if_fail (state != NULL, NULL);
	_tmp0_ = g_string_new ("▼");
	builder = _tmp0_;
	_vala_underline_nchars = (guint) 0;
	_tmp1_ = _vala_underline_nchars;
	_vala_underline_offset = _tmp1_;
	_tmp2_ = state;
	_tmp3_ = _tmp2_->candidates;
	_tmp4_ = skk_candidate_list_get_cursor_pos (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ >= 0) {
		SkkState* _tmp6_;
		SkkCandidateList* _tmp7_;
		SkkCandidate* _tmp8_ = NULL;
		SkkCandidate* c;
		GString* _tmp9_;
		SkkCandidate* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		_tmp6_ = state;
		_tmp7_ = _tmp6_->candidates;
		_tmp8_ = skk_candidate_list_get (_tmp7_, -1);
		c = _tmp8_;
		_tmp9_ = builder;
		_tmp10_ = c;
		_tmp11_ = skk_candidate_get_output (_tmp10_);
		_tmp12_ = _tmp11_;
		g_string_append (_tmp9_, _tmp12_);
		_g_object_unref0 (c);
	} else {
		GString* _tmp13_;
		SkkState* _tmp14_;
		SkkRomKanaConverter* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		_tmp13_ = builder;
		_tmp14_ = state;
		_tmp15_ = _tmp14_->rom_kana_converter;
		_tmp16_ = skk_rom_kana_converter_get_output (_tmp15_);
		_tmp17_ = _tmp16_;
		g_string_append (_tmp13_, _tmp17_);
	}
	_tmp18_ = state;
	_tmp19_ = _tmp18_->auto_start_henkan_keyword;
	if (_tmp19_ != NULL) {
		GString* _tmp20_;
		SkkState* _tmp21_;
		const gchar* _tmp22_;
		_tmp20_ = builder;
		_tmp21_ = state;
		_tmp22_ = _tmp21_->auto_start_henkan_keyword;
		g_string_append (_tmp20_, _tmp22_);
	} else {
		SkkState* _tmp23_;
		gboolean _tmp24_;
		_tmp23_ = state;
		_tmp24_ = _tmp23_->okuri;
		if (_tmp24_) {
			GString* _tmp25_;
			SkkState* _tmp26_;
			SkkRomKanaConverter* _tmp27_;
			const gchar* _tmp28_;
			const gchar* _tmp29_;
			_tmp25_ = builder;
			_tmp26_ = state;
			_tmp27_ = _tmp26_->okuri_rom_kana_converter;
			_tmp28_ = skk_rom_kana_converter_get_output (_tmp27_);
			_tmp29_ = _tmp28_;
			g_string_append (_tmp25_, _tmp29_);
		} else {
			SkkState* _tmp30_;
			SkkUnicodeString* _tmp31_;
			_tmp30_ = state;
			_tmp31_ = _tmp30_->surrounding_text;
			if (_tmp31_ != NULL) {
				GString* _tmp32_;
				const gchar* _tmp33_;
				gint _tmp34_ = 0;
				GString* _tmp35_;
				SkkState* _tmp36_;
				SkkUnicodeString* _tmp37_;
				SkkState* _tmp38_;
				guint _tmp39_;
				gchar* _tmp40_ = NULL;
				gchar* _tmp41_;
				_vala_underline_offset = (guint) 1;
				_tmp32_ = builder;
				_tmp33_ = _tmp32_->str;
				_tmp34_ = g_utf8_strlen (_tmp33_, (gssize) (-1));
				_vala_underline_nchars = (guint) (_tmp34_ - 1);
				_tmp35_ = builder;
				_tmp36_ = state;
				_tmp37_ = _tmp36_->surrounding_text;
				_tmp38_ = state;
				_tmp39_ = _tmp38_->surrounding_end;
				_tmp40_ = skk_unicode_string_substring (_tmp37_, (glong) _tmp39_, (glong) (-1));
				_tmp41_ = _tmp40_;
				g_string_append (_tmp35_, _tmp41_);
				_g_free0 (_tmp41_);
			}
		}
	}
	_tmp42_ = builder;
	_tmp43_ = _tmp42_->str;
	_tmp44_ = g_strdup (_tmp43_);
	result = _tmp44_;
	_g_string_free0 (builder);
	if (underline_offset) {
		*underline_offset = _vala_underline_offset;
	}
	if (underline_nchars) {
		*underline_nchars = _vala_underline_nchars;
	}
	return result;
}


SkkSelectStateHandler* skk_select_state_handler_construct (GType object_type) {
	SkkSelectStateHandler * self = NULL;
	self = (SkkSelectStateHandler*) skk_state_handler_construct (object_type);
	return self;
}


SkkSelectStateHandler* skk_select_state_handler_new (void) {
	return skk_select_state_handler_construct (SKK_TYPE_SELECT_STATE_HANDLER);
}


static void skk_select_state_handler_class_init (SkkSelectStateHandlerClass * klass) {
	skk_select_state_handler_parent_class = g_type_class_peek_parent (klass);
	SKK_STATE_HANDLER_CLASS (klass)->process_key_event = skk_select_state_handler_real_process_key_event;
	SKK_STATE_HANDLER_CLASS (klass)->get_preedit = skk_select_state_handler_real_get_preedit;
}


static void skk_select_state_handler_instance_init (SkkSelectStateHandler * self) {
}


GType skk_select_state_handler_get_type (void) {
	static volatile gsize skk_select_state_handler_type_id__volatile = 0;
	if (g_once_init_enter (&skk_select_state_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SkkSelectStateHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_select_state_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkSelectStateHandler), 0, (GInstanceInitFunc) skk_select_state_handler_instance_init, NULL };
		GType skk_select_state_handler_type_id;
		skk_select_state_handler_type_id = g_type_register_static (SKK_TYPE_STATE_HANDLER, "SkkSelectStateHandler", &g_define_type_info, 0);
		g_once_init_leave (&skk_select_state_handler_type_id__volatile, skk_select_state_handler_type_id);
	}
	return skk_select_state_handler_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



