/* skk-internals-1.0.vapi generated by valac 0.14.0, do not modify. */

namespace Skk {
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	internal class RomKanaNode : GLib.Object {
		internal Skk.RomKanaEntry? entry;
		internal weak Skk.RomKanaNode parent;
		internal Skk.RomKanaNode[] children;
		internal char c;
		internal uint n_children;
		internal RomKanaNode (Skk.RomKanaEntry? entry);
		internal void insert (string key, Skk.RomKanaEntry entry);
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	public class RomKanaConverter : GLib.Object {
		public RomKanaConverter ();
		public bool output_nn_if_any ();
		public void append_text (string text);
		public bool append (unichar uc);
		public bool can_consume (unichar uc, bool preedit_only = false, bool no_carryover = true);
		public void reset ();
		public bool @delete ();
		internal Skk.RomKanaMapFile rule { get; set; }
		public Skk.KanaMode kana_mode { get; set; }
		public Skk.PeriodStyle period_style { get; set; }
		public string output { get; internal set; }
		public string preedit { get; }
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	public class KanaKanConverter : GLib.Object {
		public KanaKanConverter (Skk.KanaKanDict dict, Skk.KanaKanScoreMap map);
		public string convert (string kana);
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	public class KanaKanDict : GLib.Object {
		public KanaKanDict (string path) throws GLib.Error, GLib.IOError;
		public void add (string pron, string word);
		internal Gee.Set<string> lookup (string pron);
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	public class KanaKanScoreMap : GLib.Object {
		public KanaKanScoreMap (string path, Skk.KanaKanDict dict) throws GLib.Error, GLib.IOError;
		internal double get_node_score (Skk.KanaKanNode node);
		internal double get_edge_score (Skk.KanaKanNode prev_node, Skk.KanaKanNode node);
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	internal class KanaKanNode : GLib.Object {
		internal string word;
		internal string pron;
		internal int endpos;
		internal double score;
		internal Skk.KanaKanNode? prev;
		internal KanaKanNode (string word, string pron, int endpos);
		internal bool is_bos ();
		internal bool is_eos ();
		internal int length { get; }
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	internal class KanaKanGraph : GLib.Object {
		internal Gee.ArrayList<Skk.KanaKanNode>[] nodes;
		internal Skk.KanaKanNode bos;
		internal Skk.KanaKanNode eos;
		internal KanaKanGraph (Skk.KanaKanDict dict, string str);
		internal Gee.ArrayList<Skk.KanaKanNode> get_prev_nodes (Skk.KanaKanNode node);
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	internal class EncodingConverter : GLib.Object {
		internal EncodingConverter (string encoding) throws GLib.Error;
		internal string encode (string internal_str) throws GLib.Error;
		internal string decode (string external_str) throws GLib.Error;
		internal string encoding { get; private set; }
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	public abstract class Dict : GLib.Object {
		protected Skk.Candidate[] split_candidates (string midasi, bool okuri, string line);
		protected string join_candidates (Skk.Candidate[] candidates);
		public abstract void reload () throws GLib.Error;
		public abstract Skk.Candidate[] lookup (string midasi, bool okuri = false);
		public abstract string[] complete (string midasi);
		public virtual bool select_candidate (Skk.Candidate candidate);
		public virtual bool purge_candidate (Skk.Candidate candidate);
		public virtual void save () throws GLib.Error;
		public Dict ();
		public abstract bool read_only { get; }
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	public class EmptyDict : Skk.Dict {
		public override void reload () throws GLib.Error;
		public override Skk.Candidate[] lookup (string midasi, bool okuri = false);
		public override string[] complete (string midasi);
		public EmptyDict ();
		public override bool read_only { get; }
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	public class FileDict : Skk.Dict {
		public override void reload () throws GLib.Error;
		public override Skk.Candidate[] lookup (string midasi, bool okuri = false);
		public override string[] complete (string midasi);
		public FileDict (string path, string encoding = "EUC-JP") throws GLib.Error;
		public override bool read_only { get; }
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	public class CdbDict : Skk.Dict {
		public override void reload () throws GLib.Error;
		public override Skk.Candidate[] lookup (string midasi, bool okuri = false);
		public override string[] complete (string midasi);
		public CdbDict (string path, string encoding = "EUC-JP") throws GLib.Error;
		public override bool read_only { get; }
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	public class UserDict : Skk.Dict {
		public override void reload () throws GLib.Error;
		public override void save () throws GLib.Error;
		public override Skk.Candidate[] lookup (string midasi, bool okuri = false);
		public override string[] complete (string midasi);
		public override bool select_candidate (Skk.Candidate candidate);
		public override bool purge_candidate (Skk.Candidate candidate);
		public UserDict (string path, string encoding = "UTF-8") throws GLib.Error;
		public override bool read_only { get; }
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	public class SkkServ : Skk.Dict {
		public override void reload ();
		public override Skk.Candidate[] lookup (string midasi, bool okuri = false);
		public override string[] complete (string midasi);
		public SkkServ (string host, uint16 port = 1178, string encoding = "EUC-JP") throws GLib.Error;
		public override bool read_only { get; }
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	public class KeyEvent : GLib.Object {
		public KeyEvent (string? name, unichar code, Skk.ModifierType modifiers);
		public Skk.KeyEvent copy ();
		public KeyEvent.from_string (string key);
		public string to_string ();
		public bool base_equal (Skk.KeyEvent key);
		public string? name { get; private set; }
		public unichar code { get; private set; }
		public Skk.ModifierType modifiers { get; set; }
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	public abstract class KeyEventFilter : GLib.Object {
		public abstract Skk.KeyEvent? filter_key_event (Skk.KeyEvent key);
		public virtual void reset ();
		public KeyEventFilter ();
		public signal void forwarded (Skk.KeyEvent key);
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	internal class SimpleKeyEventFilter : Skk.KeyEventFilter {
		public override Skk.KeyEvent? filter_key_event (Skk.KeyEvent key);
		public SimpleKeyEventFilter ();
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	internal class Keymap : GLib.Object {
		public new void @set (string key, string command);
		public string? lookup_key (Skk.KeyEvent key);
		public Skk.KeyEvent? where_is (string command);
		public Keymap ();
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	internal class KeymapMapFile : Skk.MapFile {
		internal Skk.Keymap keymap;
		internal KeymapMapFile (string name, string mode) throws Skk.RuleParseError;
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	internal class RomKanaMapFile : Skk.MapFile {
		internal Skk.RomKanaNode root_node;
		public RomKanaMapFile (string name) throws Skk.RuleParseError;
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	public class Rule : GLib.Object {
		internal Skk.KeymapMapFile[] keymaps;
		internal Skk.RomKanaMapFile rom_kana;
		internal Skk.KeyEventFilter get_filter ();
		public Rule (string name) throws Skk.RuleParseError;
		public static Skk.RuleMetadata? find_rule (string name);
		public static Skk.RuleMetadata[] list ();
		public Skk.RuleMetadata metadata { get; private set; }
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	internal abstract class MapFile : GLib.Object {
		internal MapFile (string rule, string type, string name) throws Skk.RuleParseError;
		internal bool has_map (string name);
		internal new Gee.Map<string,Json.Node> @get (string name);
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	internal class State : GLib.Object {
		internal GLib.Type handler_type;
		internal Gee.List<Skk.Dict> dictionaries;
		internal Skk.CandidateList candidates;
		internal Skk.RomKanaConverter rom_kana_converter;
		internal Skk.RomKanaConverter okuri_rom_kana_converter;
		internal bool okuri;
		internal string midasi;
		internal GLib.StringBuilder output;
		internal GLib.StringBuilder abbrev;
		internal GLib.StringBuilder kuten;
		internal Gee.Iterator<string> completion_iterator;
		internal string[] auto_start_henkan_keywords;
		internal string? auto_start_henkan_keyword;
		internal bool egg_like_newline;
		internal Skk.UnicodeString? surrounding_text;
		internal uint surrounding_end;
		internal string? lookup_key (Skk.KeyEvent key);
		internal Skk.KeyEvent? where_is (string command);
		internal State (Gee.List<Skk.Dict> dictionaries);
		internal void output_surrounding_text ();
		internal void reset ();
		internal void cancel_okuri ();
		internal void lookup (string midasi, bool okuri = false);
		internal void purge_candidate (Skk.Candidate candidate);
		internal void completion_start (string midasi);
		internal string get_yomi ();
		[CCode (notify = false)]
		internal Skk.InputMode input_mode { get; set; }
		internal Skk.PeriodStyle period_style { get; set; }
		internal Skk.Rule typing_rule { get; set; }
		internal signal bool recursive_edit_abort ();
		internal signal bool recursive_edit_end (string text);
		internal signal void recursive_edit_start (string midasi, bool okuri);
		internal signal bool retrieve_surrounding_text (out string text, out uint cursor_pos);
		internal signal bool delete_surrounding_text (int offset, uint nchars);
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	internal abstract class StateHandler : GLib.Object {
		internal abstract bool process_key_event (Skk.State state, ref Skk.KeyEvent key);
		internal abstract string get_preedit (Skk.State state, out uint underline_offset, out uint underline_nchars);
		internal virtual string get_output (Skk.State state);
		public StateHandler ();
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	internal class NoneStateHandler : Skk.StateHandler {
		internal override bool process_key_event (Skk.State state, ref Skk.KeyEvent key);
		internal override string get_preedit (Skk.State state, out uint underline_offset, out uint underline_nchars);
		public NoneStateHandler ();
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	internal class KutenStateHandler : Skk.StateHandler {
		internal KutenStateHandler ();
		internal override bool process_key_event (Skk.State state, ref Skk.KeyEvent key);
		internal override string get_preedit (Skk.State state, out uint underline_offset, out uint underline_nchars);
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	internal class AbbrevStateHandler : Skk.StateHandler {
		internal override bool process_key_event (Skk.State state, ref Skk.KeyEvent key);
		internal override string get_preedit (Skk.State state, out uint underline_offset, out uint underline_nchars);
		public AbbrevStateHandler ();
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	internal class StartStateHandler : Skk.StateHandler {
		internal override bool process_key_event (Skk.State state, ref Skk.KeyEvent key);
		internal override string get_preedit (Skk.State state, out uint underline_offset, out uint underline_nchars);
		public StartStateHandler ();
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	internal class SelectStateHandler : Skk.StateHandler {
		internal override bool process_key_event (Skk.State state, ref Skk.KeyEvent key);
		internal override string get_preedit (Skk.State state, out uint underline_offset, out uint underline_nchars);
		public SelectStateHandler ();
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	public class Context : GLib.Object {
		public void add_dictionary (Skk.Dict dict);
		public void remove_dictionary (Skk.Dict dict);
		public Context (Skk.Dict[] dictionaries);
		public bool process_key_events (string keyseq);
		public bool process_key_event (Skk.KeyEvent key);
		public void reset ();
		public string get_output ();
		public string peek_output ();
		public string poll_output ();
		public void clear_output ();
		public void get_preedit_underline (out uint offset, out uint nchars);
		public void save_dictionaries () throws GLib.Error;
		public Skk.Dict[] dictionaries { owned get; set; }
		public Skk.CandidateList candidates { get; }
		public Skk.InputMode input_mode { get; set; }
		public string[] auto_start_henkan_keywords { get; set; }
		public bool egg_like_newline { get; set; }
		public Skk.PeriodStyle period_style { get; set; }
		public Skk.Rule typing_rule { get; set; }
		public Skk.KeyEventFilter key_event_filter { owned get; }
		[CCode (notify = false)]
		public string preedit { get; private set; }
		public signal bool retrieve_surrounding_text (out string text, out uint cursor_pos);
		public signal bool delete_surrounding_text (int offset, uint nchars);
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	public class Candidate : GLib.Object {
		public string to_string ();
		public Candidate (string midasi, bool okuri, string text, string? annotation = null, string? output = null);
		public string midasi { get; private set; }
		public bool okuri { get; private set; }
		public string text { get; set; }
		public string? annotation { get; set; }
		public string output { get; set; }
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	public abstract class CandidateList : GLib.Object {
		public abstract new Skk.Candidate @get (int index = -1);
		internal abstract void clear ();
		internal abstract void add_candidates (Skk.Candidate[] array);
		internal abstract void add_candidates_end ();
		public abstract bool cursor_up ();
		public abstract bool cursor_down ();
		public abstract bool page_up ();
		public abstract bool page_down ();
		public virtual bool next ();
		public virtual bool previous ();
		protected uint get_page_start_cursor_pos ();
		public abstract bool select_at (uint index_in_page);
		public abstract void select ();
		public CandidateList ();
		public abstract int cursor_pos { get; }
		public abstract int size { get; }
		public abstract uint page_start { get; set; }
		public abstract uint page_size { get; set; }
		public abstract bool page_visible { get; }
		public signal void populated ();
		public signal void selected (Skk.Candidate candidate);
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	internal class SimpleCandidateList : Skk.CandidateList {
		public override Skk.Candidate @get (int index = -1);
		internal override void clear ();
		internal override void add_candidates (Skk.Candidate[] array);
		internal override void add_candidates_end ();
		public override bool select_at (uint index_in_page);
		public override void select ();
		public SimpleCandidateList (uint page_start = 4, uint page_size = 7);
		public override bool cursor_up ();
		public override bool cursor_down ();
		public override bool page_up ();
		public override bool page_down ();
		public override int cursor_pos { get; }
		public override int size { get; }
		public override uint page_start { get; set; }
		public override uint page_size { get; set; }
		public override bool page_visible { get; }
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	internal class ProxyCandidateList : Skk.CandidateList {
		public override Skk.Candidate @get (int index = -1);
		internal override void clear ();
		internal override void add_candidates (Skk.Candidate[] array);
		internal override void add_candidates_end ();
		public override bool select_at (uint index_in_page);
		public override void select ();
		public ProxyCandidateList (Skk.CandidateList candidates);
		public override bool cursor_up ();
		public override bool cursor_down ();
		public override bool page_up ();
		public override bool page_down ();
		public Skk.CandidateList candidates { get; set; }
		public override int cursor_pos { get; }
		public override int size { get; }
		public override uint page_start { get; set; }
		public override uint page_size { get; set; }
		public override bool page_visible { get; }
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	public class NicolaKeyEventFilter : Skk.KeyEventFilter {
		public Skk.GetTime get_time_func;
		public int64 timeout;
		public int64 overlap;
		public int64 maxwait;
		public string[] special_doubles;
		public override Skk.KeyEvent? filter_key_event (Skk.KeyEvent key);
		public override void reset ();
		public NicolaKeyEventFilter ();
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	internal class ExprReader : GLib.Object {
		public Skk.ExprNode read_symbol (string expr, ref int index);
		public Skk.ExprNode read_string (string expr, ref int index);
		public Skk.ExprNode? read_expr (string expr, ref int index);
		public ExprReader ();
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	internal class ExprEvaluator : GLib.Object {
		public string? eval (Skk.ExprNode node);
		public ExprEvaluator ();
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	internal class Util : GLib.Object {
		internal static string? get_okurigana_prefix (string okurigana);
		internal static unichar get_wide_latin_char (char c);
		internal static string get_wide_latin (string latin);
		internal static string get_katakana (string kana);
		internal static string get_hiragana (string kana);
		internal static string get_hankaku_katakana (string kana);
		internal static string convert_by_input_mode (string str, Skk.InputMode input_mode);
		internal static string get_numeric (int numeric, Skk.NumericConversionType type);
		internal static string[] build_data_path (string subdir);
		public Util ();
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	internal class UnicodeString : GLib.Object {
		internal int length;
		internal UnicodeString (string str);
		internal string substring (long offset, long len = -1);
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	internal class MemoryMappedFile : GLib.Object {
		public MemoryMappedFile (GLib.File file);
		public void remap () throws Skk.SkkDictError;
		public void* memory { get; }
		public size_t length { get; }
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	internal struct RomKanaEntry {
		public string rom;
		public string carryover;
		public string hiragana;
		public string katakana;
		public string hankaku_katakana;
		internal string get_kana (Skk.KanaMode kana_mode);
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	public struct RuleMetadata {
		public string base_dir;
		public string name;
		public string label;
		public string description;
		public string filter;
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	internal struct ExprNode {
		public Skk.ExprNodeType type;
		public Gee.LinkedList<Skk.ExprNode?> nodes;
		public string data;
		public ExprNode (Skk.ExprNodeType type);
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	internal struct Entry<K,V> {
		public K key;
		public V value;
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	public enum KanaMode {
		HIRAGANA,
		KATAKANA,
		HANKAKU_KATAKANA
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	public enum PeriodStyle {
		JA_JA,
		EN_EN,
		JA_EN,
		EN_JA
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	public enum ModifierType {
		NONE,
		SHIFT_MASK,
		LOCK_MASK,
		CONTROL_MASK,
		MOD1_MASK,
		MOD2_MASK,
		MOD3_MASK,
		MOD4_MASK,
		MOD5_MASK,
		LSHIFT_MASK,
		RSHIFT_MASK,
		USLEEP_MASK,
		SUPER_MASK,
		HYPER_MASK,
		META_MASK,
		RELEASE_MASK
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	public enum InputMode {
		HIRAGANA,
		KATAKANA,
		HANKAKU_KATAKANA,
		LATIN,
		WIDE_LATIN,
		LAST,
		DEFAULT
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	internal enum ExprNodeType {
		ARRAY,
		SYMBOL,
		STRING
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	internal enum NumericConversionType {
		LATIN,
		WIDE_LATIN,
		KANJI_NUMERAL,
		KANJI,
		RECONVERT,
		DAIJI,
		SHOGI
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	internal errordomain SkkDictError {
		NOT_READABLE,
		MALFORMED_INPUT
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	internal errordomain SkkServError {
		NOT_READABLE,
		INVALID_RESPONSE
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	public errordomain RuleParseError {
		FAILED
	}
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	internal delegate bool CommandHandler (Skk.State state);
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	public delegate int64 GetTime ();
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	internal const string[] PERIOD_RULE;
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	internal const string[] AUTO_START_HENKAN_KEYWORDS;
	[CCode (cheader_filename = "libskk/libskk-internals.h")]
	public static void init ();
}
