/* telnet.hh - implementation of the telnet protocol
 * Copyright 2003 Bas Wijnen <wijnen@debian.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef SHEVEK_TELNET_HH
#define SHEVEK_TELNET_HH

#include "socket.hh"

namespace shevek
{
  /// Input and output filters for shevek::socket to make them telnet sockets.
  class telnet : public socket
  {
    enum command {
      SE = 240,
      NOP = 241,
      MARK = 242,
      BREAK = 243,
      IP = 244,
      AO = 245,
      AYT = 246,
      EC = 247,
      EL = 248,
      GA = 249,
      SB = 250,
      WILL = 251,
      WONT = 252,
      DO = 253,
      DONT = 254,
      IAC = 255
    };
    enum option {
      BINARY = 0,
      ECHO = 1,
      SUPPRESS_GA = 3,
      STATUS = 5,
      TIMING_MARK = 6,
      EXOPL = 255
    };
    enum option_idx {
      BINARY_IDX = 0,
      ECHO_IDX = 1,
      SUPPRESS_GA_IDX = 2,
      STATUS_IDX = 3,
      TIMING_MARK_IDX = 4,
      EXOPL_IDX = 5
    };      
    struct option_t;
    typedef void (telnet::*action)(option_t *opt);
    struct option_t
    {
      char type;
      action will, wont, doo, dont;
      bool here, there, not_both;
    };
    static option_t options[6];
    option_t nop_option;
    option_t *s_find (char opt);
    void nop (option_t *);
    void nopwill (option_t *opt);
    void nopdo (option_t *opt);
    void l_will (option_t *opt);
    void l_wont (option_t *opt);
    void l_do (option_t *opt);
    void l_dont (option_t *opt);
    void will_check (option_t *opt);
    void do_check (option_t *opt);
    void wont_check (option_t *opt);
    void dont_check (option_t *opt);
    void l_do_sub (std::string const &data, std::string::size_type &pos);
    bool m_ignore;
    void l_in_filter (std::string &data);
    void l_out_filter (std::string &data);
    std::string m_am_here, m_inbuffer;
  protected:
    /// Derived classes have their own create function and may call the constructor.
    telnet (Glib::RefPtr <Glib::MainContext> main);
  public:
    /// Create a new telnet socket.
    static Glib::RefPtr <telnet> create (Glib::RefPtr <Glib::MainContext> main = Glib::MainContext::get_default () );
    /// Return the string that is used in reply to ARE_YOU_THERE requests.
    /** This can also be used to change the reply.
     */
    std::string &you_there ();
  };
}

#endif
