# @file    TestDelay.rb
# @brief   SBML Delay unit tests
#
# @author  Akiya Jouraku (Ruby conversion)
# @author  Sarah Keating 
#
#
# ====== WARNING ===== WARNING ===== WARNING ===== WARNING ===== WARNING ======
#
# DO NOT EDIT THIS FILE.
#
# This file was generated automatically by converting the file located at
# src/sbml/test/TestDelay.c
# using the conversion program dev/utilities/translateTests/translateTests.pl.
# Any changes made here will be lost the next time the file is regenerated.
#
# -----------------------------------------------------------------------------
# This file is part of libSBML.  Please visit http://sbml.org for more
# information about SBML, and the latest version of libSBML.
#
# Copyright 2005-2010 California Institute of Technology.
# Copyright 2002-2005 California Institute of Technology and
#                     Japan Science and Technology Corporation.
# 
# This library is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation.  A copy of the license agreement is provided
# in the file named "LICENSE.txt" included with this software distribution
# and also available online as http://sbml.org/software/libsbml/license.html
# -----------------------------------------------------------------------------
require 'test/unit'
require 'libSBML'

class TestDelay < Test::Unit::TestCase

  def setup
    @@d = LibSBML::Delay.new(2,4)
    if (@@d == nil)
    end
  end

  def teardown
    @@d = nil
  end

  def test_Delay_create
    assert( @@d.getTypeCode() == LibSBML::SBML_DELAY )
    assert( @@d.getMetaId() == "" )
    assert( @@d.getNotes() == nil )
    assert( @@d.getAnnotation() == nil )
    assert( @@d.getMath() == nil )
  end

  def test_Delay_createWithNS
    xmlns = LibSBML::XMLNamespaces.new()
    xmlns.add( "http://www.sbml.org", "testsbml")
    sbmlns = LibSBML::SBMLNamespaces.new(2,1)
    sbmlns.addNamespaces(xmlns)
    object = LibSBML::Delay.new(sbmlns)
    assert( object.getTypeCode() == LibSBML::SBML_DELAY )
    assert( object.getMetaId() == "" )
    assert( object.getNotes() == nil )
    assert( object.getAnnotation() == nil )
    assert( object.getLevel() == 2 )
    assert( object.getVersion() == 1 )
    assert( object.getNamespaces() != nil )
    assert( object.getNamespaces().getLength() == 2 )
    object = nil
  end

  def test_Delay_free_NULL
  end

  def test_Delay_setMath
    math = LibSBML::parseFormula("lambda(x, x^3)")
    @@d.setMath(math)
    math1 = @@d.getMath()
    assert( math1 != nil )
    formula = LibSBML::formulaToString(math1)
    assert( formula != nil )
    assert ((  "lambda(x, x^3)" == formula ))
    assert( @@d.getMath() != math )
    assert_equal true, @@d.isSetMath()
    @@d.setMath(@@d.getMath())
    math1 = @@d.getMath()
    assert( math1 != nil )
    formula = LibSBML::formulaToString(math1)
    assert( formula != nil )
    assert ((  "lambda(x, x^3)" == formula ))
    @@d.setMath(nil)
    assert_equal false, @@d.isSetMath()
    if (@@d.getMath() != nil)
    end
  end

  def test_Delay_setMath1
    math = LibSBML::parseFormula("2 * k")
    i = @@d.setMath(math)
    assert( i == LibSBML::LIBSBML_OPERATION_SUCCESS )
    assert( @@d.getMath() != math )
    assert_equal true, @@d.isSetMath()
    i = @@d.setMath(nil)
    assert( i == LibSBML::LIBSBML_OPERATION_SUCCESS )
    assert( @@d.getMath() == nil )
    assert_equal false, @@d.isSetMath()
    math = nil
  end

  def test_Delay_setMath2
    math = LibSBML::ASTNode.new(LibSBML::AST_TIMES)
    i = @@d.setMath(math)
    assert( i == LibSBML::LIBSBML_INVALID_OBJECT )
    assert_equal false, @@d.isSetMath()
    math = nil
  end

end

