/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.4
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 * Representation of errors, warnings and other diagnostics
 * <p>
 * <p style='color: #777; font-style: italic'>
This class of objects is defined by libSBML only and has no direct
equivalent in terms of SBML components.  This class is not prescribed by
the SBML specifications, although it is used to implement features
defined in SBML.
</p>

 * <p>
 * When a libSBML operation on SBML content results in an error, or when
 * there is something wrong with the SBML content, the problems are
 * reported as {@link SBMLError} objects.  These are generally stored in an
 * {@link SBMLErrorLog} object; this log object, in turn, is kept in the
 * {@link SBMLDocument} object containing the SBML content.  Applications can
 * obtain the list of logged errors using {@link SBMLDocument#getErrorLog()} and
 * then use the methods provided by {@link SBMLErrorLog} to access individual
 * {@link SBMLError} objects.  (Note that despite the word 'error' in the name,
 * {@link SBMLError} objects are used to represent not only 'true' errors, but also
 * warnings and some informational diagnostics.  The name is a historical
 * hold-over from early versions of libSBML, in which the object really was
 * only used to report errors.)
 * <p>
 * * Each {@link SBMLError} object instance has an identification number that
 * identifies the nature of the problem.  This 'error id' number will be up
 * to five digits long, and it will come from one of two sets of static
 * integer constants defined in the interface class <code><a
 * href='libsbmlConstants.html'> libsbmlConstants</a></code>: either the
 * SBML error identifiers <a class='el' href='#SBMLErrorCode_t'> (described
 * below)</a> or the XML error identifiers (described in the documentation
 * for the class <code><a href='{@link XMLError}.html'> {@link XMLError}</a></code>).  The
 * former set of constants includes all the SBML validation rule numbers
 * listed in the appendices of the SBML specification documents, as well as
 * some additional libSBML-specific error codes.
 * <p>
 * <p>
 * Error codes are useful mainly for software.  For human readers,
 * {@link SBMLError} also includes text messages that describe the nature of a
 * given problem.  The messages can be accessed using
 * {@link SBMLError#getShortMessage()} and {@link SBMLError#getMessage()}.  The former
 * provides a brief one-line description of the issue, while
 * {@link SBMLError#getMessage()} provides a more detailed text, including (if
 * appropriate) references to sections of the SBML specifications where
 * relevant topics are discussed.  These text strings are suitable for
 * displaying to human users.
 * <p>
 * * An {@link SBMLError} object also contains a category code; its value may be
 * retrieved using the method {@link SBMLError#getCategory()}.  Category values
 * are drawn from a set of static integer constants
 * defined in <code><a href='libsbmlConstants.html'>libsbmlConstants</a></code>,
 * and having names beginning with the characters
 * <code>LIBSBML_CAT_</code>.  The list of possible codes is described in a
 * separate section below.  Categories are used to partition errors into
 * distinct conceptual groups.  This is principally used by the libSBML
 * validation system to group classes of validation checks.  For example,
 * {@link  libsbmlConstants#LIBSBML_CAT_IDENTIFIER_CONSISTENCY LIBSBML_CAT_IDENTIFIER_CONSISTENCY}
 * is the category for tests that check identifier consistency;
 * {@link  libsbmlConstants#LIBSBML_CAT_MATHML_CONSISTENCY LIBSBML_CAT_MATHML_CONSISTENCY}
 * is the category for MathML consistency checking; and
 * so on.
 * <p>
 * <p>
 * In addition, {@link SBMLError} also has a severity code.  Its value may be
 * retrieved using the method {@link SBMLError#getSeverity()}.  The possible
 * severity values are the same as those reported by <code><a href='{@link XMLError}.html'>{@link XMLError}</a></code>. 
 * Severity levels currently range from informational
 * ({@link  libsbmlConstants#LIBSBML_SEV_INFO LIBSBML_SEV_INFO})
 * to fatal errors
 * ({@link  libsbmlConstants#LIBSBML_SEV_FATAL LIBSBML_SEV_FATAL}).
 * They can be
 * used by an application to evaluate how serious a given problem
 * is. 
 * <p>
 * Finally, {@link SBMLError} records the line and column near where the problem
 * occurred in the SBML content.  The values may be retrieved using the
 * methods {@link SBMLError#getLine()} and {@link SBMLError#getColumn()}.  We say 'near',
 * because a lot of factors affect how accurate the line/column information
 * ultimately is.  For example, different XML parsers have different
 * conventions for which line and column number they report for a
 * particular problem (which makes a difference when a problem involves an
 * opening XML tag on one line and a closing tag on another line).  In some
 * situations, some parsers report invalid line and/or column numbers
 * altogether.  If this occurs, libSBML sets the line and/or column number
 * in the {@link SBMLError} object to the the value of the maximum unsigned long
 * integer representable on the platform where libSBML is running.  (This
 * is equal to the constant named <code>ULONG_MAX</code> in C and C++.)
 * The probability that a true line or column number in an SBML model would
 * equal this value is vanishingly small; thus, if an application
 * encounters these values in an {@link XMLError} object, it can assume no valid
 * line/column number could be provided by libSBML in that situation.
 * <p>
 * <h3><a class='anchor' 
 * name='SBMLErrorCode_t'>Error codes associated with {@link SBMLError} objects</a></h3>
 * <p>
 * The error and warning codes returned by libSBML are listed in the table
 * below.  The method {@link SBMLError#getErrorId()} returns the error code of a
 * given {@link SBMLError} object instance.  In the libSBML Java language
 * interface, these error identifiers are currently
 * implemented as static integer constants defined in the interface class
 * <code><a href='libsbmlConstants.html'>libsbmlConstants</a></code>.  This
 * is admittedly not an ideal approach from the standpoint of modern Java
 * programming, but it was necessary to work around the lack of
 * enumerations in Java prior to JDK 1.5.  Future versions of libSBML may
 * use a proper Java enumeration type to define the error identifiers.
 * <p>
 * In this table, the right-hand columns titled 'L1V1', 'L1V2', etc. refer
 * to Levels and Versions of the SBML specifications, and the entries in
 * each column refer to whether the severity of the condition in that
 * particular Level+Version of SBML.  The codes stand for the following:
 * <p>
 * <p>
 * <p>
 * <table cellspacing='1' cellpadding='2' border='0' class='normal-font'>
 * <tr><td class='s-na'>N</td><td>= Not applicable</td></tr>
 * <tr><td class='s-info'>I</td><td>= Informational</td></tr>
 * <tr><td class='s-warning'>W</td><td>= Warning</td></tr>
 * <tr><td class='s-error'>E</td><td>= Error</td></tr>
 * <tr><td class='s-fatal'>F</td><td>= Fatal</td></tr>
 * </table>
 * <p>
 * The text shown in the 'Meaning' is the text returned by the
 * {@link SBMLError#getShortMessage()} method on a given {@link SBMLError} object.  A
 * longer and (hopefully) clearer explanation of the issue is returned by
 * {@link SBMLError#getMessage()}.
 * <p>
 * <center>
<table width='95%' cellspacing='1' cellpadding='2' border='0' class='text-table small-font alt-row-colors'>
 <tr style='background: lightgray' class='normal-font'>
     <th valign='bottom'><strong>Enumerator</strong></th>
     <th valign='bottom'><strong>Meaning</strong></th>
     <th align='center' width='15'>L 1 V 1</th>
     <th align='center' width='15'>L 1 V 2</th>
     <th align='center' width='15'>L 2 V 1</th>
     <th align='center' width='15'>L 2 V 2</th>
     <th align='center' width='15'>L 2 V 3</th>
     <th align='center' width='15'>L 2 V 4</th>
     <th align='center' width='15'>L 3 V 1</th>
 </tr>
<tr><td><code>UnknownError</code></td><td>Encountered unknown internal libSBML error</td><td class='s-fatal'>F</td><td class='s-fatal'>F</td><td class='s-fatal'>F</td><td class='s-fatal'>F</td><td class='s-fatal'>F</td><td class='s-fatal'>F</td><td class='s-fatal'>F</td></tr>
<tr><td><code>NotUTF8</code></td><td>File does not use UTF-8 encoding</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>UnrecognizedElement</code></td><td>Encountered unrecognized element</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>NotSchemaConformant</code></td><td>Document does not conform to the SBML XML schema</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>L3NotSchemaConformant</code></td><td>Document is not well-formed XML</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>InvalidMathElement</code></td><td>Invalid MathML</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>DisallowedMathMLSymbol</code></td><td>Disallowed MathML symbol found</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>DisallowedMathMLEncodingUse</code></td><td>Use of the MathML 'encoding' attribute is not allowed on this element</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>DisallowedDefinitionURLUse</code></td><td>Use of the MathML 'definitionURL' attribute is not allowed on this element</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>BadCsymbolDefinitionURLValue</code></td><td>Invalid <code>&lt;csymbol&gt;</code> 'definitionURL' attribute value</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>DisallowedMathTypeAttributeUse</code></td><td>Use of the MathML 'type' attribute is not allowed on this element</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>DisallowedMathTypeAttributeValue</code></td><td>Disallowed MathML 'type' attribute value</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>LambdaOnlyAllowedInFunctionDef</code></td><td>Use of <code>&lt;lambda&gt;</code> not permitted outside of {@link FunctionDefinition} objects</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>BooleanOpsNeedBooleanArgs</code></td><td>Non-Boolean argument given to Boolean operator</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>NumericOpsNeedNumericArgs</code></td><td>Non-numerical argument given to numerical operator</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>ArgsToEqNeedSameType</code></td><td>Arguments to <code>&lt;eq&gt;</code> and <code>&lt;neq&gt;</code> must have the same data types</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>PiecewiseNeedsConsistentTypes</code></td><td>Terms in a <code>&lt;piecewise&gt;</code> expression must have consistent data types</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>PieceNeedsBoolean</code></td><td>The second argument of a <code>&lt;piece&gt;</code> expression must yield a Boolean value</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>ApplyCiMustBeUserFunction</code></td><td>A <code>&lt;ci&gt;</code> element in this context must refer to a function definition</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>ApplyCiMustBeModelComponent</code></td><td>A <code>&lt;ci&gt;</code> element in this context must refer to a model component</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>KineticLawParametersAreLocalOnly</code></td><td>Cannot use a {@link KineticLaw} local parameter outside of its local scope</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>MathResultMustBeNumeric</code></td><td>A formula's result in this context must be a numerical value</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>OpsNeedCorrectNumberOfArgs</code></td><td>Incorrect number of arguments given to MathML operator</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>InvalidNoArgsPassedToFunctionDef</code></td><td>Incorrect number of arguments given to function invocation</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>DisallowedMathUnitsUse</code></td><td>Attribute 'units' is only permitted on <code>&lt;cn&gt;</code> elements</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>InvalidUnitsValue</code></td><td>Invalid value given for the 'units' attribute</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>DuplicateComponentId</code></td><td>Duplicate 'id' attribute value</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>DuplicateUnitDefinitionId</code></td><td>Duplicate unit definition 'id' attribute value</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>DuplicateLocalParameterId</code></td><td>Duplicate local parameter 'id' attribute value</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>MultipleAssignmentOrRateRules</code></td><td>Multiple rules for the same variable are not allowed</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>MultipleEventAssignmentsForId</code></td><td>Multiple event assignments for the same variable are not allowed</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>EventAndAssignmentRuleForId</code></td><td>An event assignment and an assignment rule must not have the same value for 'variable'</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>DuplicateMetaId</code></td><td>Duplicate 'metaid' attribute value</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>InvalidSBOTermSyntax</code></td><td>Invalid syntax for an 'sboTerm' attribute value</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>InvalidMetaidSyntax</code></td><td>Invalid syntax for a 'metaid' attribute value</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>InvalidIdSyntax</code></td><td>Invalid syntax for an 'id' attribute value</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>InvalidUnitIdSyntax</code></td><td>Invalid syntax for the identifier of a unit</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>InvalidNameSyntax</code></td><td>Invalid syntax for a 'name' attribute value</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>MissingAnnotationNamespace</code></td><td>Missing declaration of the XML namespace for the annotation</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>DuplicateAnnotationNamespaces</code></td><td>Multiple annotations using the same XML namespace</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>SBMLNamespaceInAnnotation</code></td><td>The SBML XML namespace cannot be used in an Annotation object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td></tr>
<tr><td><code>MultipleAnnotations</code></td><td>Only one Annotation object is permitted under a given SBML object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>InconsistentArgUnits</code></td><td>The units of the function call's arguments are not consistent with its definition</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-warning'>W</td><td class='s-warning'>W</td></tr>
<tr><td><code>InconsistentKineticLawUnitsL3</code></td><td>The kinetic law's units are inconsistent with those of other kinetic laws in the model</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td></tr>
<tr><td><code>AssignRuleCompartmentMismatch</code></td><td>Mismatched units in assignment rule for compartment</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-warning'>W</td><td class='s-warning'>W</td></tr>
<tr><td><code>AssignRuleSpeciesMismatch</code></td><td>Mismatched units in assignment rule for species</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-warning'>W</td><td class='s-warning'>W</td></tr>
<tr><td><code>AssignRuleParameterMismatch</code></td><td>Mismatched units in assignment rule for parameter</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-warning'>W</td><td class='s-warning'>W</td></tr>
<tr><td><code>AssignRuleStoichiometryMismatch</code></td><td>Mismatched units in assignment rule for stoichiometry</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td></tr>
<tr><td><code>InitAssignCompartmenMismatch</code></td><td>Mismatched units in initial assignment to compartment</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-warning'>W</td><td class='s-warning'>W</td></tr>
<tr><td><code>InitAssignSpeciesMismatch</code></td><td>Mismatched units in initial assignment to species</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-warning'>W</td><td class='s-warning'>W</td></tr>
<tr><td><code>InitAssignParameterMismatch</code></td><td>Mismatched units in initial assignment to parameter</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-warning'>W</td><td class='s-warning'>W</td></tr>
<tr><td><code>InitAssignStoichiometryMismatch</code></td><td>Mismatched units in initial assignment to stoichiometry</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td></tr>
<tr><td><code>RateRuleCompartmentMismatch</code></td><td>Mismatched units in rate rule for compartment</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-warning'>W</td><td class='s-warning'>W</td></tr>
<tr><td><code>RateRuleSpeciesMismatch</code></td><td>Mismatched units in rate rule for species</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-warning'>W</td><td class='s-warning'>W</td></tr>
<tr><td><code>RateRuleParameterMismatch</code></td><td>Mismatched units in rate rule for parameter</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-warning'>W</td><td class='s-warning'>W</td></tr>
<tr><td><code>RateRuleStoichiometryMismatch</code></td><td>Mismatched units in rate rule for stoichiometry</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td></tr>
<tr><td><code>KineticLawNotSubstancePerTime</code></td><td>The units of the kinetic law are not 'substance'/'time'</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-warning'>W</td><td class='s-warning'>W</td></tr>
<tr><td><code>SpeciesInvalidExtentUnits</code></td><td>The species' units are not consistent with units of extent</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td></tr>
<tr><td><code>DelayUnitsNotTime</code></td><td>The units of the delay expression are not units of time</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-warning'>W</td><td class='s-warning'>W</td></tr>
<tr><td><code>EventAssignCompartmentMismatch</code></td><td>Mismatched units in event assignment for compartment</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-warning'>W</td><td class='s-warning'>W</td></tr>
<tr><td><code>EventAssignSpeciesMismatch</code></td><td>Mismatched units in event assignment for species</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-warning'>W</td><td class='s-warning'>W</td></tr>
<tr><td><code>EventAssignParameterMismatch</code></td><td>Mismatched units in event assignment for parameter</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-warning'>W</td><td class='s-warning'>W</td></tr>
<tr><td><code>EventAssignStoichiometryMismatch</code></td><td>Mismatched units in event assignment for stoichiometry</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td></tr>
<tr><td><code>PriorityUnitsNotDimensionless</code></td><td>The units of a priority expression must be 'dimensionless'</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td></tr>
<tr><td><code>UpperUnitBound</code></td><td>Upper boundary of unit validation diagnostic codes</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>OverdeterminedSystem</code></td><td>The model is overdetermined</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>InvalidModelSBOTerm</code></td><td>Invalid 'sboTerm' attribute value for a {@link Model} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-warning'>W</td><td class='s-warning'>W</td></tr>
<tr><td><code>InvalidFunctionDefSBOTerm</code></td><td>Invalid 'sboTerm' attribute value for a {@link FunctionDefinition} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-warning'>W</td><td class='s-warning'>W</td></tr>
<tr><td><code>InvalidParameterSBOTerm</code></td><td>Invalid 'sboTerm' attribute value for a {@link Parameter} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-warning'>W</td><td class='s-warning'>W</td></tr>
<tr><td><code>InvalidInitAssignSBOTerm</code></td><td>Invalid 'sboTerm' attribute value for an {@link InitialAssignment} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-warning'>W</td><td class='s-warning'>W</td></tr>
<tr><td><code>InvalidRuleSBOTerm</code></td><td>Invalid 'sboTerm' attribute value for a {@link Rule} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-warning'>W</td><td class='s-warning'>W</td></tr>
<tr><td><code>InvalidConstraintSBOTerm</code></td><td>Invalid 'sboTerm' attribute value for a {@link Constraint} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-warning'>W</td><td class='s-warning'>W</td></tr>
<tr><td><code>InvalidReactionSBOTerm</code></td><td>Invalid 'sboTerm' attribute value for a {@link Reaction} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-warning'>W</td><td class='s-warning'>W</td></tr>
<tr><td><code>InvalidSpeciesReferenceSBOTerm</code></td><td>Invalid 'sboTerm' attribute value for a {@link SpeciesReference} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-warning'>W</td><td class='s-warning'>W</td></tr>
<tr><td><code>InvalidKineticLawSBOTerm</code></td><td>Invalid 'sboTerm' attribute value for a {@link KineticLaw} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-warning'>W</td><td class='s-warning'>W</td></tr>
<tr><td><code>InvalidEventSBOTerm</code></td><td>Invalid 'sboTerm' attribute value for an {@link Event} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-warning'>W</td><td class='s-warning'>W</td></tr>
<tr><td><code>InvalidEventAssignmentSBOTerm</code></td><td>Invalid 'sboTerm' attribute value for an {@link EventAssignment} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-warning'>W</td><td class='s-warning'>W</td></tr>
<tr><td><code>InvalidCompartmentSBOTerm</code></td><td>Invalid 'sboTerm' attribute value for a {@link Compartment} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-warning'>W</td><td class='s-warning'>W</td></tr>
<tr><td><code>InvalidSpeciesSBOTerm</code></td><td>Invalid 'sboTerm' attribute value for a {@link Species} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-warning'>W</td><td class='s-warning'>W</td></tr>
<tr><td><code>InvalidCompartmentTypeSBOTerm</code></td><td>Invalid 'sboTerm' attribute value for a {@link CompartmentType} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-warning'>W</td><td class='s-na'>N</td></tr>
<tr><td><code>InvalidSpeciesTypeSBOTerm</code></td><td>Invalid 'sboTerm' attribute value for a {@link SpeciesType} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-warning'>W</td><td class='s-na'>N</td></tr>
<tr><td><code>InvalidTriggerSBOTerm</code></td><td>Invalid 'sboTerm' attribute value for an {@link Event} Trigger object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-warning'>W</td><td class='s-warning'>W</td></tr>
<tr><td><code>InvalidDelaySBOTerm</code></td><td>Invalid 'sboTerm' attribute value for an {@link Event} Delay object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-warning'>W</td><td class='s-warning'>W</td></tr>
<tr><td><code>NotesNotInXHTMLNamespace</code></td><td>Notes must be placed in the XHTML XML namespace</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>NotesContainsXMLDecl</code></td><td>XML declarations are not permitted in Notes objects</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>NotesContainsDOCTYPE</code></td><td>XML DOCTYPE elements are not permitted in Notes objects</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>InvalidNotesContent</code></td><td>Invalid notes content found</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td></tr>
<tr><td><code>OnlyOneNotesElementAllowed</code></td><td>Only one Notes subobject is permitted on a given SBML object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>InvalidNamespaceOnSBML</code></td><td>Invalid XML namespace for the SBML container element</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>MissingOrInconsistentLevel</code></td><td>Missing or inconsistent value for the 'level' attribute</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>MissingOrInconsistentVersion</code></td><td>Missing or inconsistent value for the 'version' attribute</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>PackageNSMustMatch</code></td><td>Inconsistent or invalid SBML Level/Version for the package namespace declaration</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>LevelPositiveInteger</code></td><td>The 'level' attribute must have a positive integer value</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>VersionPositiveInteger</code></td><td>The 'version' attribute must have a positive integer value</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>AllowedAttributesOnSBML</code></td><td>Invalid attribute found on the SBML container element</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>MissingModel</code></td><td>No model definition found</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>IncorrectOrderInModel</code></td><td>Incorrect ordering of components within the {@link Model} object</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td></tr>
<tr><td><code>EmptyListElement</code></td><td>Empty ListOf___ object found</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>NeedCompartmentIfHaveSpecies</code></td><td>The presence of a species requires a compartment</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>OneOfEachListOf</code></td><td>Only one of each kind of ListOf___ object is allowed inside a {@link Model} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>OnlyFuncDefsInListOfFuncDefs</code></td><td>Only {@link FunctionDefinition}, Notes and Annotation objects are allowed in {@link ListOfFunctionDefinitions}</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>OnlyUnitDefsInListOfUnitDefs</code></td><td>Only {@link UnitDefinition}, Notes and Annotation objects are allowed in {@link ListOfUnitDefinitions} objects</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>OnlyCompartmentsInListOfCompartments</code></td><td>Only {@link Compartment}, Notes and Annotation objects are allowed in {@link ListOfCompartments} objects</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>OnlySpeciesInListOfSpecies</code></td><td>Only {@link Species}, Notes and Annotation objects are allowed in {@link ListOfSpecies} objects</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>OnlyParametersInListOfParameters</code></td><td>Only {@link Parameter}, Notes and Annotation objects are allowed in {@link ListOfParameters} objects</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>OnlyInitAssignsInListOfInitAssigns</code></td><td>Only {@link InitialAssignment}, Notes and Annotation objects are allowed in {@link ListOfInitialAssignments} objects</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>OnlyRulesInListOfRules</code></td><td>Only {@link Rule}, Notes and Annotation objects are allowed in {@link ListOfRules} objects</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>OnlyConstraintsInListOfConstraints</code></td><td>Only {@link Constraint}, Notes and Annotation objects are allowed in {@link ListOfConstraints} objects</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>OnlyReactionsInListOfReactions</code></td><td>Only {@link Reaction}, Notes and Annotation objects are allowed in {@link ListOfReactions} objects</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>OnlyEventsInListOfEvents</code></td><td>Only {@link Event}, Notes and Annotation objects are allowed in {@link ListOfEvents} objects</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>L3ConversionFactorOnModel</code></td><td>A 'conversionFactor' attribute value must reference a {@link Parameter} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>L3TimeUnitsOnModel</code></td><td>Invalid 'timeUnits' attribute value</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td></tr>
<tr><td><code>L3VolumeUnitsOnModel</code></td><td>Invalid 'volumeUnits' attribute value</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td></tr>
<tr><td><code>L3AreaUnitsOnModel</code></td><td>Invalid 'areaUnits' attribute value</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td></tr>
<tr><td><code>L3LengthUnitsOnModel</code></td><td>Invalid 'lengthUnits' attribute value</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td></tr>
<tr><td><code>L3ExtentUnitsOnModel</code></td><td>Invalid 'extentUnits' attribute value</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td></tr>
<tr><td><code>AllowedAttributesOnModel</code></td><td>Invalid attribute found on the {@link Model} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>AllowedAttributesOnListOfFuncs</code></td><td>Invalid attribute found on the {@link ListOfFunctionDefinitions} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>AllowedAttributesOnListOfUnitDefs</code></td><td>Invalid attribute found on the {@link ListOfUnitDefinitions} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>AllowedAttributesOnListOfComps</code></td><td>Invalid attribute found on the {@link ListOfCompartments} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>AllowedAttributesOnListOfSpecies</code></td><td>Invalid attribute found on the {@link ListOfSpecies} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>AllowedAttributesOnListOfParams</code></td><td>Invalid attribute found on the {@link ListOfParameters} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>AllowedAttributesOnListOfInitAssign</code></td><td>Invalid attribute found on the {@link ListOfInitialAssignments} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>AllowedAttributesOnListOfRules</code></td><td>Invalid attribute found on the {@link ListOfRules} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>AllowedAttributesOnListOfConstraints</code></td><td>Invalid attribute found on the {@link ListOfConstraints} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>AllowedAttributesOnListOfReactions</code></td><td>Invalid attribute found on the {@link ListOfReactions} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>AllowedAttributesOnListOfEvents</code></td><td>Invalid attribute found on the {@link ListOfEvents} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>FunctionDefMathNotLambda</code></td><td>Invalid expression found in the function definition</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>InvalidApplyCiInLambda</code></td><td>Invalid forward reference in the MathML <code>&lt;apply&gt;</code><code>&lt;ci&gt;</code>...<code>&lt;/ci&gt;</code><code>&lt;/apply&gt;</code> expression</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>RecursiveFunctionDefinition</code></td><td>Recursive function definitions are not permitted</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>InvalidCiInLambda</code></td><td>Invalid <code>&lt;ci&gt;</code> reference found inside the <code>&lt;lambda&gt;</code> mathematical formula</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>InvalidFunctionDefReturnType</code></td><td>A function's return type must be either a number or a Boolean</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>OneMathElementPerFunc</code></td><td>A {@link FunctionDefinition} object must contain one <code>&lt;math&gt;</code> element</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>AllowedAttributesOnFunc</code></td><td>Invalid attribute found on the {@link FunctionDefinition} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>InvalidUnitDefId</code></td><td>Invalid 'id' attribute value for a {@link UnitDefinition} object</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>InvalidSubstanceRedefinition</code></td><td>Invalid redefinition of built-in type 'substance'</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td></tr>
<tr><td><code>InvalidLengthRedefinition</code></td><td>Invalid redefinition of built-in type 'length'</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td></tr>
<tr><td><code>InvalidAreaRedefinition</code></td><td>Invalid redefinition of built-in type name 'area'</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td></tr>
<tr><td><code>InvalidTimeRedefinition</code></td><td>Invalid redefinition of built-in type name 'time'</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td></tr>
<tr><td><code>InvalidVolumeRedefinition</code></td><td>Invalid redefinition of built-in type name 'volume'</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td></tr>
<tr><td><code>VolumeLitreDefExponentNotOne</code></td><td>Must use 'exponent'=1 when defining 'volume' in terms of litres</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>VolumeMetreDefExponentNot3</code></td><td>Must use 'exponent'=3 when defining 'volume' in terms of metres</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>EmptyListOfUnits</code></td><td>An empty list of {@link Unit} objects is not permitted in a {@link UnitDefinition} object</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td></tr>
<tr><td><code>InvalidUnitKind</code></td><td>Invalid value for the 'kind' attribute of a {@link UnitDefinition} object</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>OffsetNoLongerValid</code></td><td>{@link Unit} attribute 'offset' is not supported in this Level+Version of SBML</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td></tr>
<tr><td><code>CelsiusNoLongerValid</code></td><td>{@link Unit} name 'Celsius' is not defined in this Level+Version of SBML</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td></tr>
<tr><td><code>EmptyUnitListElement</code></td><td>A {@link ListOfUnits} object must not be empty</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>OneListOfUnitsPerUnitDef</code></td><td>At most one {@link ListOfUnits} object is allowed inside a {@link UnitDefinition} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>OnlyUnitsInListOfUnits</code></td><td>Only {@link Unit}, Notes and Annotation objects are allowed in {@link ListOfUnits} objects</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>AllowedAttributesOnUnitDefinition</code></td><td>Invalid attribute found on the {@link UnitDefinition} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>AllowedAttributesOnListOfUnits</code></td><td>Invalid attribute found on the {@link ListOfUnits} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>AllowedAttributesOnUnit</code></td><td>Invalid attribute found on the {@link Unit} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>ZeroDimensionalCompartmentSize</code></td><td>Invalid use of the 'size' attribute for a zero-dimensional compartment</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td></tr>
<tr><td><code>ZeroDimensionalCompartmentUnits</code></td><td>Invalid use of the 'units' attribute for a zero-dimensional compartment</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td></tr>
<tr><td><code>ZeroDimensionalCompartmentConst</code></td><td>Zero-dimensional compartments must be defined to be constant</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td></tr>
<tr><td><code>UndefinedOutsideCompartment</code></td><td>Invalid value for the 'outside' attribute of a {@link Compartment} object</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td></tr>
<tr><td><code>RecursiveCompartmentContainment</code></td><td>Recursive nesting of compartments via the 'outside' attribute is not permitted</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td></tr>
<tr><td><code>ZeroDCompartmentContainment</code></td><td>Invalid nesting of zero-dimensional compartments</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td></tr>
<tr><td><code>Invalid1DCompartmentUnits</code></td><td>Invalid value for the 'units' attribute of a one-dimensional compartment</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-warning'>W</td></tr>
<tr><td><code>Invalid2DCompartmentUnits</code></td><td>Invalid value for the 'units' attribute of a two-dimensional compartment</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-warning'>W</td></tr>
<tr><td><code>Invalid3DCompartmentUnits</code></td><td>Invalid value for the 'units' attribute of a three-dimensional compartment</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-warning'>W</td></tr>
<tr><td><code>InvalidCompartmentTypeRef</code></td><td>Invalid value for the 'compartmentType' attribute of a compartment</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td></tr>
<tr><td><code>OneDimensionalCompartmentUnits</code></td><td>No units defined for 1-D compartment</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td></tr>
<tr><td><code>TwoDimensionalCompartmentUnits</code></td><td>No units defined for 2-D compartment</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td></tr>
<tr><td><code>ThreeDimensionalCompartmentUnits</code></td><td>No units defined for 3-D {@link Compartment} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td></tr>
<tr><td><code>AllowedAttributesOnCompartment</code></td><td>Invalid attribute found on {@link Compartment} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>NoUnitsOnCompartment</code></td><td>No units defined for {@link Compartment} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td></tr>
<tr><td><code>InvalidSpeciesCompartmentRef</code></td><td>Invalid value found for {@link Species} 'compartment' attribute</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>HasOnlySubsNoSpatialUnits</code></td><td>Attribute 'spatialSizeUnits' must not be set if 'hasOnlySubstanceUnits'='true'</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>NoSpatialUnitsInZeroD</code></td><td>Attribute 'spatialSizeUnits' must not be set if the compartment is zero-dimensional</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>NoConcentrationInZeroD</code></td><td>Attribute 'initialConcentration' must not be set if the compartment is zero-dimensional</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td></tr>
<tr><td><code>SpatialUnitsInOneD</code></td><td>Invalid value for 'spatialSizeUnits' attribute of a one-dimensional compartment</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>SpatialUnitsInTwoD</code></td><td>Invalid value for the 'spatialSizeUnits' attribute of a two-dimensional compartment</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>SpatialUnitsInThreeD</code></td><td>Invalid value for the 'spatialSizeUnits' attribute of a three-dimensional compartment</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>InvalidSpeciesSusbstanceUnits</code></td><td>Invalid value for a {@link Species} 'units' attribute</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-warning'>W</td></tr>
<tr><td><code>BothAmountAndConcentrationSet</code></td><td>Cannot set both 'initialConcentration' and 'initialAmount' attributes simultaneously</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>NonBoundarySpeciesAssignedAndUsed</code></td><td>Cannot use a non-boundary species in both reactions and rules simultaneously</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>NonConstantSpeciesUsed</code></td><td>Cannot use a constant, non-boundary species as a reactant or product</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>InvalidSpeciesTypeRef</code></td><td>Invalid value for the 'speciesType' attribute of a species</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td></tr>
<tr><td><code>MultSpeciesSameTypeInCompartment</code></td><td>Cannot have multiple species of the same species type in the same compartment</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td></tr>
<tr><td><code>MissingSpeciesCompartment</code></td><td>Missing value for the 'compartment' attribute</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>SpatialSizeUnitsRemoved</code></td><td>Attribute 'spatialSizeUnits' is not supported in this Level+Version of SBML</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td></tr>
<tr><td><code>SubstanceUnitsOnSpecies</code></td><td>No substance units defined for the species</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td></tr>
<tr><td><code>ConversionFactorOnSpecies</code></td><td>Invalid value for the 'conversionFactor' attribute</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>AllowedAttributesOnSpecies</code></td><td>Invalid attribute found on {@link Species} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>InvalidParameterUnits</code></td><td>Invalid value for the 'units' attribute of a {@link Parameter} object</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>ParameterUnits</code></td><td>No units defined for the parameter</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td></tr>
<tr><td><code>ConversionFactorMustConstant</code></td><td>A conversion factor must reference a {@link Parameter} object declared to be a constant</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>AllowedAttributesOnParameter</code></td><td>Invalid attribute found on {@link Parameter} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>InvalidInitAssignSymbol</code></td><td>Invalid value for the 'symbol' attribute of an {@link InitialAssignment} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>MultipleInitAssignments</code></td><td>Multiple initial assignments for the same 'symbol' value are not allowed</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>InitAssignmentAndRuleForSameId</code></td><td>Cannot set a value using both an initial assignment and an assignment rule simultaneously</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>OneMathElementPerInitialAssign</code></td><td>An {@link InitialAssignment} object must contain one <code>&lt;math&gt;</code> element</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>AllowedAttributesOnInitialAssign</code></td><td>Invalid attribute found on an {@link InitialAssignment} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>InvalidAssignRuleVariable</code></td><td>Invalid value for the 'variable' attribute of an {@link AssignmentRule} object</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>InvalidRateRuleVariable</code></td><td>Invalid value for the 'variable' attribute of a {@link RateRule} object</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>AssignmentToConstantEntity</code></td><td>An assignment rule cannot assign an entity declared to be constant</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>RateRuleForConstantEntity</code></td><td>A rate rule cannot assign an entity declared to be constant</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>CircularRuleDependency</code></td><td>Circular dependencies involving rules and reactions are not permitted</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>OneMathElementPerRule</code></td><td>A rule object must contain one <code>&lt;math&gt;</code> element</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>AllowedAttributesOnAssignRule</code></td><td>Invalid attribute found on an {@link AssignmentRule} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>AllowedAttributesOnRateRule</code></td><td>Invalid attribute found on a {@link RateRule} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>AllowedAttributesOnAlgRule</code></td><td>Invalid attribute found on an {@link AlgebraicRule} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>ConstraintMathNotBoolean</code></td><td>A {@link Constraint} object's <code>&lt;math&gt;</code> must evaluate to a Boolean value</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>IncorrectOrderInConstraint</code></td><td>Subobjects inside the {@link Constraint} object are not in the prescribed order</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td></tr>
<tr><td><code>ConstraintNotInXHTMLNamespace</code></td><td>A {@link Constraint}'s Message subobject must be in the XHTML XML namespace</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td></tr>
<tr><td><code>ConstraintContainsXMLDecl</code></td><td>XML declarations are not permitted within {@link Constraint}'s Message objects</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>ConstraintContainsDOCTYPE</code></td><td>XML DOCTYPE elements are not permitted within {@link Constraint}'s Message objects</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>InvalidConstraintContent</code></td><td>Invalid content for a {@link Constraint} object's Message object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td></tr>
<tr><td><code>OneMathElementPerConstraint</code></td><td>A {@link Constraint} object must contain one <code>&lt;math&gt;</code> element</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>OneMessageElementPerConstraint</code></td><td>A {@link Constraint} object must contain one Message subobject</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>AllowedAttributesOnConstraint</code></td><td>Invalid attribute found on {@link Constraint} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>NoReactantsOrProducts</code></td><td>Cannot have a reaction with neither reactants nor products</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>IncorrectOrderInReaction</code></td><td>Subobjects inside the {@link Reaction} object are not in the prescribed order</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td></tr>
<tr><td><code>EmptyListInReaction</code></td><td>{@link Reaction} components, if present, cannot be empty</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>InvalidReactantsProductsList</code></td><td>Invalid object found in the list of reactants or products</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>InvalidModifiersList</code></td><td>Invalid object found in the list of modifiers</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>OneSubElementPerReaction</code></td><td>A {@link Reaction} object can only contain one of each allowed type of object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>CompartmentOnReaction</code></td><td>Invalid value for the {@link Reaction} 'compartment' attribute</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>AllowedAttributesOnReaction</code></td><td>Invalid attribute for a {@link Reaction} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>InvalidSpeciesReference</code></td><td>Invalid 'species' attribute value in {@link SpeciesReference} object</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>BothStoichiometryAndMath</code></td><td>The 'stoichiometry' attribute and {@link StoichiometryMath} subobject are mutually exclusive</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td></tr>
<tr><td><code>AllowedAttributesOnSpeciesReference</code></td><td>Invalid attribute found on the {@link SpeciesReference} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>AllowedAttributesOnModifier</code></td><td>Invalid attribute found on the {@link ModifierSpeciesReference} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>UndeclaredSpeciesRef</code></td><td>Unknown species referenced in the kinetic law <code>&lt;math&gt;</code> formula</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>IncorrectOrderInKineticLaw</code></td><td>Incorrect ordering of components in the {@link KineticLaw} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td></tr>
<tr><td><code>EmptyListInKineticLaw</code></td><td>The list of parameters, if present, cannot be empty</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>NonConstantLocalParameter</code></td><td>Parameters local to a {@link KineticLaw} object must have a 'constant' attribute value of 'true'</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td></tr>
<tr><td><code>SubsUnitsNoLongerValid</code></td><td>Attribute 'substanceUnits' is not supported in this Level+Version of SBML</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td></tr>
<tr><td><code>TimeUnitsNoLongerValid</code></td><td>Attribute 'timeUnits' is not supported in this Level+Version of SBML</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td></tr>
<tr><td><code>OneListOfPerKineticLaw</code></td><td>Only one {@link ListOfLocalParameters} object is permitted within a {@link KineticLaw} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>OnlyLocalParamsInListOfLocalParams</code></td><td>Only {@link LocalParameter}, Notes and Annotation objects are allowed in ListOfLocalParameter objects</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>AllowedAttributesOnListOfLocalParam</code></td><td>Invalid attribute found on the {@link ListOfLocalParameters} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>OneMathPerKineticLaw</code></td><td>Only one <code>&lt;math&gt;</code> element is allowed in a {@link KineticLaw} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>UndeclaredSpeciesInStoichMath</code></td><td>Unknown species referenced in the {@link StoichiometryMath} object's <code>&lt;math&gt;</code> formula</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td></tr>
<tr><td><code>AllowedAttributesOnKineticLaw</code></td><td>Invalid attribute found on the {@link KineticLaw} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>AllowedAttributesOnListOfSpeciesRef</code></td><td>Invalid attribute found on the {@link ListOfSpeciesReferences} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>AllowedAttributesOnListOfMods</code></td><td>Invalid attribute found on the ListOfModifiers object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>AllowedAttributesOnLocalParameter</code></td><td>Invalid attribute found on the {@link LocalParameter} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>MissingTriggerInEvent</code></td><td>The {@link Event} object is missing a {@link Trigger} subobject</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>TriggerMathNotBoolean</code></td><td>A {@link Trigger} object's <code>&lt;math&gt;</code> expression must evaluate to a Boolean value</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>MissingEventAssignment</code></td><td>The {@link Event} object is missing an {@link EventAssignment} subobject</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>TimeUnitsEvent</code></td><td>Units referenced by 'timeUnits' attribute are not compatible with units of time</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>IncorrectOrderInEvent</code></td><td>Incorrect ordering of components in {@link Event} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td></tr>
<tr><td><code>ValuesFromTriggerTimeNeedDelay</code></td><td>Attribute 'useValuesFromTriggerTime'='false', but the {@link Event} object does not define a delay</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-na'>N</td></tr>
<tr><td><code>DelayNeedsValuesFromTriggerTime</code></td><td>The use of a {@link Delay} object requires the {@link Event} attribute 'useValuesFromTriggerTime'</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>OneMathPerTrigger</code></td><td>A {@link Trigger} object must have one <code>&lt;math&gt;</code> element</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>OneMathPerDelay</code></td><td>A {@link Delay} object must have one <code>&lt;math&gt;</code> element</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>InvalidEventAssignmentVariable</code></td><td>Invalid 'variable' attribute value in {@link Event} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>EventAssignmentForConstantEntity</code></td><td>An {@link EventAssignment} object cannot assign to a component having attribute 'constant'='true'</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>OneMathPerEventAssignment</code></td><td>An {@link EventAssignment} object must have one <code>&lt;math&gt;</code> element</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>AllowedAttributesOnEventAssignment</code></td><td>Invalid attribute found on the {@link EventAssignment} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>OnlyOneDelayPerEvent</code></td><td>An {@link Event} object can only have one {@link Delay} subobject</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>OneListOfEventAssignmentsPerEvent</code></td><td>An {@link Event} object can only have one {@link ListOfEventAssignments} subobject</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>OnlyEventAssignInListOfEventAssign</code></td><td>Only {@link EventAssignment}, Notes and Annotation objects are allowed in {@link ListOfEventAssignments}</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>AllowedAttributesOnListOfEventAssign</code></td><td>Invalid attribute found on the {@link ListOfEventAssignments} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>AllowedAttributesOnEvent</code></td><td>Invalid attribute found on the {@link Event} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>AllowedAttributesOnTrigger</code></td><td>Invalid attribute found on the {@link Trigger} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>AllowedAttributesOnDelay</code></td><td>Invalid attribute found on the {@link Delay} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>PersistentNotBoolean</code></td><td>The {@link Trigger} attribute 'persistent' must evaluate to a Boolean value</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>InitialValueNotBoolean</code></td><td>The {@link Trigger} attribute 'initialValue' must evaluate to a Boolean value</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>OnlyOnePriorityPerEvent</code></td><td>An {@link Event} object can only have one Priority subobject</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>OneMathPerPriority</code></td><td>A Priority object must have one <code>&lt;math&gt;</code> element</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>AllowedAttributesOnPriority</code></td><td>Invalid attribute found on the Priority object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>GeneralWarningNotSpecified</code></td><td>Unknown error</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>CompartmentShouldHaveSize</code></td><td>It's best to define a size for every compartment in a model</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td></tr>
<tr><td><code>SpeciesShouldHaveValue</code></td><td>It's best to define an initial amount or initial concentration for every species in a model</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td></tr>
<tr><td><code>ParameterShouldHaveUnits</code></td><td>It's best to declare units for every parameter in a model</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td></tr>
<tr><td><code>LocalParameterShadowsId</code></td><td>Local parameters defined within a kinetic law shadow global object symbols</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td></tr>
<tr><td><code>CannotConvertToL1V1</code></td><td>Cannot convert to SBML Level 1 Version 1</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>NoEventsInL1</code></td><td>SBML Level 1 does not support events</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>NoFunctionDefinitionsInL1</code></td><td>SBML Level 1 does not support function definitions</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>NoConstraintsInL1</code></td><td>SBML Level 1 does not support constraints</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td></tr>
<tr><td><code>NoInitialAssignmentsInL1</code></td><td>SBML Level 1 does not support initial assignments</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>NoSpeciesTypesInL1</code></td><td>SBML Level 1 does not support species types</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-na'>N</td></tr>
<tr><td><code>NoCompartmentTypeInL1</code></td><td>SBML Level 1 does not support compartment types</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-na'>N</td></tr>
<tr><td><code>NoNon3DCompartmentsInL1</code></td><td>SBML Level 1 only supports three-dimensional compartments</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>NoFancyStoichiometryMathInL1</code></td><td>SBML Level 1 does not support non-integer nor non-rational stoichiometry formulas</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>NoNonIntegerStoichiometryInL1</code></td><td>SBML Level 1 does not support non-integer 'stoichiometry' attribute values</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>NoUnitMultipliersOrOffsetsInL1</code></td><td>SBML Level 1 does not support multipliers or offsets in unit definitions</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>SpeciesCompartmentRequiredInL1</code></td><td>In SBML Level 1, a value for 'compartment' is mandatory in species definitions</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>NoSpeciesSpatialSizeUnitsInL1</code></td><td>SBML Level 1 does not support species 'spatialSizeUnits' settings</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td></tr>
<tr><td><code>NoSBOTermsInL1</code></td><td>SBML Level 1 does not support the 'sboTerm' attribute</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td></tr>
<tr><td><code>StrictUnitsRequiredInL1</code></td><td>SBML Level 1 requires strict unit consistency</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td><td class='s-warning'>W</td></tr>
<tr><td><code>ConversionFactorNotInL1</code></td><td>SBML Level 1 does not support the 'conversionFactor' attribute</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>CompartmentNotOnL1Reaction</code></td><td>SBML Level 1 does not support the 'compartment' attribute on {@link Reaction} objects</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td></tr>
<tr><td><code>ExtentUnitsNotSubstance</code></td><td>Units of extent must be compatible with units of substance</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>NoConstraintsInL2v1</code></td><td>SBML Level 2 Version 1 does not support {@link Constraint} objects</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td></tr>
<tr><td><code>NoInitialAssignmentsInL2v1</code></td><td>SBML Level 2 Version 1 does not support {@link InitialAssignment} objects</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>NoSpeciesTypeInL2v1</code></td><td>SBML Level 2 Version 1 does not support {@link SpeciesType} objects</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-na'>N</td></tr>
<tr><td><code>NoCompartmentTypeInL2v1</code></td><td>SBML Level 2 Version 1 does not support {@link CompartmentType} objects</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-na'>N</td></tr>
<tr><td><code>NoSBOTermsInL2v1</code></td><td>SBML Level 2 Version 1 does not support the 'sboTerm' attribute</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td></tr>
<tr><td><code>NoIdOnSpeciesReferenceInL2v1</code></td><td>SBML Level 2 Version 1 does not support the 'id' attribute on {@link SpeciesReference} objects</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td></tr>
<tr><td><code>NoDelayedEventAssignmentInL2v1</code></td><td>SBML Level 2 Version 1 does not support the 'useValuesFromTriggerTime' attribute</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>StrictUnitsRequiredInL2v1</code></td><td>SBML Level 2 Version 1 requires strict unit consistency</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td><td class='s-warning'>W</td></tr>
<tr><td><code>IntegerSpatialDimensions</code></td><td>SBML Level 2 Version 1 requires that compartments have spatial dimensions of 0-3</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>StoichiometryMathNotYetSupported</code></td><td>Conversion to {@link StoichiometryMath} objects not yet supported</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>PriorityLostFromL3</code></td><td>SBML Level 2 Version 1 does not support priorities on {@link Event} objects</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td></tr>
<tr><td><code>NonPersistentNotSupported</code></td><td>SBML Level 2 Version 1 does not support the 'persistent' attribute on {@link Trigger} objects</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>InitialValueFalseEventNotSupported</code></td><td>SBML Level 2 Version 1 does not support the 'initialValue' attribute on {@link Trigger} objects</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>SBOTermNotUniversalInL2v2</code></td><td>The 'sboTerm' attribute is invalid for this component in SBML Level 2 Version 2</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td></tr>
<tr><td><code>NoUnitOffsetInL2v2</code></td><td>This Level+Version of SBML does not support the 'offset' attribute on {@link Unit} objects</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>NoKineticLawTimeUnitsInL2v2</code></td><td>This Level+Version of SBML does not support the 'timeUnits' attribute on {@link KineticLaw} objects</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>NoKineticLawSubstanceUnitsInL2v2</code></td><td>This Level+Version of SBML does not support the 'substanceUnits' attribute on {@link KineticLaw} objects</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>NoDelayedEventAssignmentInL2v2</code></td><td>This Level+Version of SBML does not support the 'useValuesFromTriggerTime' attribute</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>ModelSBOBranchChangedBeyondL2v2</code></td><td>The allowable 'sboTerm' attribute values for {@link Model} objects differ for this SBML Level+Version</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>StrictUnitsRequiredInL2v2</code></td><td>SBML Level 2 Version 2 requires strict unit consistency</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td><td class='s-warning'>W</td></tr>
<tr><td><code>StrictSBORequiredInL2v2</code></td><td>SBML Level 2 Version 2 requires strict {@link SBO} term consistency</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td><td class='s-warning'>W</td></tr>
<tr><td><code>DuplicateAnnotationInvalidInL2v2</code></td><td>Duplicate top-level annotations are invalid in SBML Level 2 Version 2</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>NoUnitOffsetInL2v3</code></td><td>This Level+Version of SBML does not support the 'offset' attribute on {@link Unit} objects</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>NoKineticLawTimeUnitsInL2v3</code></td><td>This Level+Version of SBML does not support the 'timeUnits' attribute on {@link KineticLaw} objects</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>NoKineticLawSubstanceUnitsInL2v3</code></td><td>This Level+Version of SBML does not support the 'substanceUnits' attribute on {@link KineticLaw} objects</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>NoSpeciesSpatialSizeUnitsInL2v3</code></td><td>This Level+Version of SBML does not support the 'spatialSizeUnit' attribute on {@link Species} objects</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>NoEventTimeUnitsInL2v3</code></td><td>This Level+Version of SBML does not support the 'timeUnits' attribute on {@link Event} objects</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>NoDelayedEventAssignmentInL2v3</code></td><td>This Level+Version of SBML does not support the 'useValuesFromTriggerTime' attribute</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>ModelSBOBranchChangedBeyondL2v3</code></td><td>The allowable 'sboTerm' attribute values for {@link Model} objects differ for this SBML Level+Version</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>StrictUnitsRequiredInL2v3</code></td><td>SBML Level 2 Version 3 requires strict unit consistency</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td><td class='s-warning'>W</td></tr>
<tr><td><code>StrictSBORequiredInL2v3</code></td><td>SBML Level 2 Version 3 requires strict {@link SBO} term consistency</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td><td class='s-warning'>W</td></tr>
<tr><td><code>DuplicateAnnotationInvalidInL2v3</code></td><td>Duplicate top-level annotations are invalid in SBML Level 2 Version 3</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>NoUnitOffsetInL2v4</code></td><td>This Level+Version of SBML does not support the 'offset' attribute on {@link Unit} objects</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>NoKineticLawTimeUnitsInL2v4</code></td><td>This Level+Version of SBML does not support the 'timeUnits' attribute on {@link KineticLaw} objects</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>NoKineticLawSubstanceUnitsInL2v4</code></td><td>This Level+Version of SBML does not support the 'substanceUnits' attribute on {@link KineticLaw} objects</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>NoSpeciesSpatialSizeUnitsInL2v4</code></td><td>This Level+Version of SBML does not support the 'spatialSizeUnit' attribute on {@link Species} objects</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>NoEventTimeUnitsInL2v4</code></td><td>This Level+Version of SBML does not support the 'timeUnits' attribute on {@link Event} objects</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>ModelSBOBranchChangedInL2v4</code></td><td>The allowable 'sboTerm' attribute values for {@link Model} objects differ for this SBML Level+Version</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>DuplicateAnnotationInvalidInL2v4</code></td><td>Duplicate top-level annotations are invalid in SBML Level 2 Version 4</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>NoSpeciesTypeInL3v1</code></td><td>SBML Level 3 Version 1 does not support {@link SpeciesType} objects</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-na'>N</td></tr>
<tr><td><code>NoCompartmentTypeInL3v1</code></td><td>SBML Level 3 Version 1 does not support {@link CompartmentType} objects</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-na'>N</td></tr>
<tr><td><code>NoUnitOffsetInL3v1</code></td><td>This Level+Version of SBML does not support the 'offset' attribute on {@link Unit} objects</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>NoKineticLawTimeUnitsInL3v1</code></td><td>This Level+Version of SBML does not support the 'timeUnits' attribute on {@link KineticLaw} objects</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>NoKineticLawSubstanceUnitsInL3v1</code></td><td>This Level+Version of SBML does not support the 'substanceUnits' attribute on {@link KineticLaw} objects</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>NoSpeciesSpatialSizeUnitsInL3v1</code></td><td>This Level+Version of SBML does not support the 'spatialSizeUnit' attribute on {@link Species} objects</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>NoEventTimeUnitsInL3v1</code></td><td>This Level+Version of SBML does not support the 'timeUnits' attribute on {@link Event} objects</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>ModelSBOBranchChangedInL3v1</code></td><td>The allowable 'sboTerm' attribute values for {@link Model} objects differ for this SBML Level+Version</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>DuplicateAnnotationInvalidInL3v1</code></td><td>Duplicate top-level annotations are invalid in SBML Level 3 Version 1</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>NoCompartmentOutsideInL3v1</code></td><td>This Level+Version of SBML does not support the 'outside' attribute on {@link Compartment} objects</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-na'>N</td></tr>
<tr><td><code>NoStoichiometryMathInL3v1</code></td><td>This Level+Version of SBML does not support the {@link StoichiometryMath} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td></tr>
<tr><td><code>InvalidSBMLLevelVersion</code></td><td>Unknown Level+Version combination of SBML</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>AnnotationNotesNotAllowedLevel1</code></td><td>Annotation objects on the SBML container element are not permitted in SBML Level 1</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>InvalidRuleOrdering</code></td><td>Invalid ordering of rules</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>RequiredPackagePresent</code></td><td>The SBML document requires an SBML Level 3 package unavailable in this software</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>UnrequiredPackagePresent</code></td><td>The SBML document uses an SBML Level 3 package unavailable in this software</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td></tr>
<tr><td><code>SubsUnitsAllowedInKL</code></td><td>Disallowed value for attribute 'substanceUnits' on {@link KineticLaw} object</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>TimeUnitsAllowedInKL</code></td><td>Disallowed value for attribute 'timeUnits' on {@link KineticLaw} object</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>FormulaInLevel1KL</code></td><td>Only predefined functions are allowed in SBML Level 1 formulas</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>TimeUnitsRemoved</code></td><td>This Level+Version of SBML does not support the 'timeUnits' attribute on {@link Event} objects</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>BadMathML</code></td><td>Invalid MathML expression</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>FailedMathMLReadOfDouble</code></td><td>Missing or invalid floating-point number in MathML expression</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>FailedMathMLReadOfInteger</code></td><td>Missing or invalid integer in MathML expression</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>FailedMathMLReadOfExponential</code></td><td>Missing or invalid exponential expression in MathML</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>FailedMathMLReadOfRational</code></td><td>Missing or invalid rational expression in MathML</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>BadMathMLNodeType</code></td><td>Invalid MathML element</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>NoTimeSymbolInFunctionDef</code></td><td>Use of <code>&lt;csymbol&gt;</code> for 'time' not allowed within {@link FunctionDefinition} objects</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>NoBodyInFunctionDef</code></td><td>There must be a <code>&lt;lambda&gt;</code> body within the <code>&lt;math&gt;</code> element of a {@link FunctionDefinition} object</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>UndeclaredUnits</code></td><td>Missing unit declarations on parameters or literal numbers in expression</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td></tr>
<tr><td><code>UndeclaredTimeUnitsL3</code></td><td>Unable to verify consistency of units: the unit of time has not been declared</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td></tr>
<tr><td><code>UndeclaredExtentUnitsL3</code></td><td>Unable to verify consistency of units: the units of reaction extent have not been declared</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td></tr>
<tr><td><code>UndeclaredObjectUnitsL3</code></td><td>Unable to verify consistency of units: encountered a model entity with no declared units</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td></tr>
<tr><td><code>UnrecognisedSBOTerm</code></td><td>Unrecognized 'sboTerm' attribute value</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td></tr>
<tr><td><code>ObseleteSBOTerm</code></td><td>Obsolete 'sboTerm' attribute value</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td><td class='s-warning'>W</td></tr>
<tr><td><code>IncorrectCompartmentSpatialDimensions</code></td><td>In SBML Level 1, only three-dimensional compartments are allowed</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>CompartmentTypeNotValidAttribute</code></td><td>{@link CompartmentType} objects are not available in this Level+Version of SBML</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>ConstantNotValidAttribute</code></td><td>This Level+Version of SBML does not support the 'constant' attribute on this component</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>MetaIdNotValidAttribute</code></td><td>Attribute 'metaid' is not available in SBML Level 1</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>SBOTermNotValidAttributeBeforeL2V3</code></td><td>The 'sboTerm' attribute is not available on this component before SBML Level 2 Version 3</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>InvalidL1CompartmentUnits</code></td><td>Invalid units for a compartment in SBML Level 1</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>L1V1CompartmentVolumeReqd</code></td><td>In SBML Level 1, a compartment's volume must be specified</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>CompartmentTypeNotValidComponent</code></td><td>{@link CompartmentType} objects are not available in this Level+Version of SBML</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>ConstraintNotValidComponent</code></td><td>{@link Constraint} objects are not available in this Level+Version of SBML</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>EventNotValidComponent</code></td><td>{@link Event} objects are not available in this Level+Version of SBML</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>SBOTermNotValidAttributeBeforeL2V2</code></td><td>The 'sboTerm' attribute is invalid for this component before Level 2 Version 2</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>FuncDefNotValidComponent</code></td><td>{@link FunctionDefinition} objects are not available in this Level+Version of SBML</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>InitialAssignNotValidComponent</code></td><td>{@link InitialAssignment} objects are not available in this Level+Version of SBML</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>VariableNotValidAttribute</code></td><td>Attribute 'variable' is not available on this component in this Level+Version of SBML</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>UnitsNotValidAttribute</code></td><td>Attribute 'units' is not available on this component in this Level+Version of SBML</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>ConstantSpeciesNotValidAttribute</code></td><td>Attribute 'constant' is not available on {@link Species} objects in SBML Level 1</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>SpatialSizeUnitsNotValidAttribute</code></td><td>Attribute 'spatialSizeUnits' is not available on {@link Species} objects in SBML Level 1</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>SpeciesTypeNotValidAttribute</code></td><td>Attribute 'speciesType' is not available on {@link Species} objects in SBML Level 1</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>HasOnlySubsUnitsNotValidAttribute</code></td><td>Attribute 'hasOnlySubstanceUnits' is not available on {@link Species} objects in SBML Level 1</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>IdNotValidAttribute</code></td><td>Attribute 'id' is not available on {@link SpeciesReference} objects in SBML Level 1</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>NameNotValidAttribute</code></td><td>Attribute 'name' is not available on {@link SpeciesReference} objects in SBML Level 1</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>SpeciesTypeNotValidComponent</code></td><td>The {@link SpeciesType} object is not supported in SBML Level 1</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>StoichiometryMathNotValidComponent</code></td><td>The {@link StoichiometryMath} object is not supported in SBML Level 1</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-error'>E</td></tr>
<tr><td><code>MultiplierNotValidAttribute</code></td><td>Attribute 'multiplier' on {@link Unit} objects is not supported in SBML Level 1</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>OffsetNotValidAttribute</code></td><td>Attribute 'offset' on {@link Unit} objects is only available in SBML Level 2 Version 1</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td></tr>
<tr><td><code>L3SpatialDimensionsUnset</code></td><td>No value given for 'spatialDimensions' attribute; assuming a value of 3</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-na'>N</td><td class='s-warning'>W</td></tr>
<tr><td><code>PackageConversionNotSupported</code></td><td>Conversion of SBML Level 3 package constructs is not yet supported</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>InvalidTargetLevelVersion</code></td><td>The requested SBML Level/Version combination is not known to exist</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<tr><td><code>L3NotSupported</code></td><td>SBML Level 3 is not yet supported</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td><td class='s-error'>E</td></tr>
<table>
</center>

 * <p>
 * <h3><a class='anchor'
 * name='SBMLErrorCategory_t'>Category codes associated with {@link SBMLError} objects</a></h3>
 * <p>
 * As discussed above, each {@link SBMLError} object contains a value for a
 * category identifier, describing the type of issue that the {@link SBMLError}
 * object represents.  The category can be retrieved from an {@link SBMLError}
 * object using the method {@link SBMLError#getCategory()}.  The following table
 * lists each possible value and a brief description of its meaning.
 * <p>
 * As is the case with the error codes, in the libSBML Java language
 * interface, the category identifiers are currently implemented as static
 * integer constants defined in the interface class
 * {@link libsbmlConstants}.
 * <p>
 * The following table lists each possible value and a brief description of
 * its meaning.
 * <p>
 * <p>
 * <p>
 * <center>
 * <table width='90%' cellspacing='1' cellpadding='4' border='0'  class='text-table normal-font alt-row-colors'>
 *  <tr style='background: lightgray' class='normal-font'>
 *      <th>Enumerator</td>
 *      <th>Meaning</td>
 *  </tr>
 * <tr><td>{@link  libsbmlConstants#LIBSBML_CAT_SBML LIBSBML_CAT_SBML}</td><td>General error not falling into
 * another category below.</td></tr> 
 * <tr><td>{@link  libsbmlConstants#LIBSBML_CAT_SBML_L1_COMPAT LIBSBML_CAT_SBML_L1_COMPAT}</td><td>Category of errors
 * that can only occur during attempted translation from one Level/Version
 * of SBML to another.  This particular category applies to errors
 * encountered while trying to convert a model from SBML Level&nbsp;2 to SBML
 * Level&nbsp;1.</td></tr> 
 * <tr><td>{@link  libsbmlConstants#LIBSBML_CAT_SBML_L2V1_COMPAT LIBSBML_CAT_SBML_L2V1_COMPAT}</td><td>Category of errors
 * that can only occur during attempted translation from one Level/Version
 * of SBML to another.  This particular category applies to errors
 * encountered while trying to convert a model to SBML Level&nbsp;2
 * Version&nbsp;1.</td></tr> 
 * <tr><td>{@link  libsbmlConstants#LIBSBML_CAT_SBML_L2V2_COMPAT LIBSBML_CAT_SBML_L2V2_COMPAT}</td><td>Category of errors
 * that can only occur during attempted translation from one Level/Version
 * of SBML to another.  This particular category applies to errors
 * encountered while trying to convert a model to SBML Level&nbsp;2
 * Version&nbsp;2.</td></tr> 
 * <tr><td>{@link  libsbmlConstants#LIBSBML_CAT_GENERAL_CONSISTENCY LIBSBML_CAT_GENERAL_CONSISTENCY}</td><td>Category of
 * errors that can occur while validating general SBML constructs.  With
 * respect to the SBML specification, these concern failures in applying
 * the validation rules numbered 2xxxx in the Level&nbsp;2 Versions&nbsp;2&ndash;4
 * and Level&nbsp;3 Version&nbsp;1 specifications.</td></tr>
 * <tr><td>{@link  libsbmlConstants#LIBSBML_CAT_IDENTIFIER_CONSISTENCY LIBSBML_CAT_IDENTIFIER_CONSISTENCY}</td><td>Category of
 * errors that can occur while validating symbol identifiers in a model.
 * With respect to the SBML specification, these concern failures in
 * applying the validation rules numbered 103xx in the Level&nbsp;2 Versions&nbsp;2&ndash;4
 * and Level&nbsp;3 Version&nbsp;1 specifications.</td></tr>  
 * <tr><td>{@link  libsbmlConstants#LIBSBML_CAT_UNITS_CONSISTENCY LIBSBML_CAT_UNITS_CONSISTENCY}</td><td>Category of
 * errors that can occur while validating the units of measurement on
 * quantities in a model.  With respect to the SBML specification, these
 * concern failures in applying the validation rules numbered 105xx in the
 * Level&nbsp;2 Versions&nbsp;2&ndash;4
 * and Level&nbsp;3 Version&nbsp;1 specifications.</td></tr> 
 * <tr><td>{@link  libsbmlConstants#LIBSBML_CAT_MATHML_CONSISTENCY LIBSBML_CAT_MATHML_CONSISTENCY}</td><td>Category of
 * errors that can occur while validating MathML formulas in a model.  With
 * respect to the SBML specification, these concern failures in applying
 * the validation rules numbered 102xx in the Level&nbsp;2 Versions&nbsp;2&ndash;4
 * and Level&nbsp;3 Version&nbsp;1 specifications.</td></tr> 
 * <tr><td>{@link  libsbmlConstants#LIBSBML_CAT_SBO_CONSISTENCY LIBSBML_CAT_SBO_CONSISTENCY}</td><td>Category of errors
 * that can occur while validating {@link SBO} identifiers in a model.  With
 * respect to the SBML specification, these concern failures in applying
 * the validation rules numbered 107xx in the Level&nbsp;2 Versions&nbsp;2&ndash;4
 * and Level&nbsp;3 Version&nbsp;1 specifications.</td></tr> 
 * <tr><td>{@link  libsbmlConstants#LIBSBML_CAT_OVERDETERMINED_MODEL LIBSBML_CAT_OVERDETERMINED_MODEL}</td><td>Error in the
 * system of equations in the model: the system is overdetermined,
 * therefore violating a tenet of proper SBML.  With respect to the SBML
 * specification, this is validation rule #10601 in the SBML Level&nbsp;2 Versions&nbsp;2&ndash;4
 * and Level&nbsp;3 Version&nbsp;1 specifications.</td></tr> 
 * <tr><td>{@link  libsbmlConstants#LIBSBML_CAT_SBML_L2V3_COMPAT LIBSBML_CAT_SBML_L2V3_COMPAT}</td><td>Category of errors
 * that can only occur during attempted translation from one Level/Version
 * of SBML to another.  This particular category applies to errors
 * encountered while trying to convert a model to SBML Level&nbsp;2
 * Version&nbsp;3.</td></tr> 
 * <tr><td>{@link  libsbmlConstants#LIBSBML_CAT_MODELING_PRACTICE LIBSBML_CAT_MODELING_PRACTICE}</td><td>Category of
 * warnings about recommended good practices involving SBML and
 * computational modeling.  (These are tests performed by libSBML and do
 * not have equivalent SBML validation rules.)</td></tr> 
 * <tr><td>{@link  libsbmlConstants#LIBSBML_CAT_INTERNAL_CONSISTENCY LIBSBML_CAT_INTERNAL_CONSISTENCY}</td><td>Category of
 * errors that can occur while validating libSBML's internal representation
 * of SBML constructs. (These are tests performed by libSBML and do
 * not have equivalent SBML validation rules.)</td></tr> 
 * <tr><td>{@link  libsbmlConstants#LIBSBML_CAT_SBML_L2V4_COMPAT LIBSBML_CAT_SBML_L2V4_COMPAT}</td><td>Category of errors
 * that can only occur during attempted translation from one Level/Version
 * of SBML to another.  This particular category applies to errors
 * encountered while trying to convert a model to SBML Level&nbsp;2
 * Version&nbsp;4.</td></tr> 
 * <tr><td>{@link  libsbmlConstants#LIBSBML_CAT_SBML_L3V1_COMPAT LIBSBML_CAT_SBML_L3V1_COMPAT}</td><td>Category of errors
 * that can only occur during attempted translation from one Level/Version
 * of SBML to another.  This particular category applies to errors
 * encountered while trying to convert a model to SBML Level&nbsp;3
 * Version&nbsp;1.</td></tr> 
 * <p>
 * </table>
 * </center>
 * <p>
 * <h3><a class='anchor'
 * name='SBMLErrorSeverity_t'>Severity codes associated with {@link SBMLError}
 * objects</h3>
 * <p>
 * In libSBML version 5.2.0
 * there are no additional severity codes beyond those defined by {@link XMLError}.  
 * They are implemented as static integer constants defined in the interface 
 * class <code><a href='libsbmlConstants.html'>libsbmlConstants</a></code>, 
 * and have names beginning with <code>LIBSBML_SEV_</code>.
 * <p>
 */
public class SBMLError extends XMLError {
   private long swigCPtr;

   protected SBMLError(long cPtr, boolean cMemoryOwn)
   {
     super(libsbmlJNI.SBMLError_SWIGUpcast(cPtr), cMemoryOwn);
     swigCPtr = cPtr;
   }

   protected static long getCPtr(SBMLError obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (SBMLError obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_SBMLError(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  
  /**
   * Creates a new {@link SBMLError} to report that something occurred during SBML
   * processing.
   * <p>
   * When a libSBML operation on SBML content results in a warning, error
   * or other diagnostic, the issue is reported as an {@link SBMLError} object.
   * {@link SBMLError} objects have identification numbers to indicate the nature
   * of the exception.  These numbers are
   * defined as longeger constants in the file
   * 'libsbmlConstants.html'.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings.  The argument 
   * <code>errorId</code> to this constructor <em>can</em> be (but does not have to be) a
   * value from this set of constants.  If it 
   * <em>is</em> one of the predefined error identifiers, the {@link SBMLError} class
   * assumes the error is a low-level system or SBML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument <code>details</code> to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the 
   * <code>severity</code> and <code>category</code> codes, and these fields are filled-in using
   * the libSBML defaults for each different error identifier. 
   * <p>
   * If the error identifier <code>errorId</code> is a number greater than 99999, the
   * {@link SBMLError} class assumes the error was generated from another part of
   * the software and does not do additional filling in of values beyond
   * the default in the constructor itself.  This allows {@link SBMLError} to serve
   * as a base class for other errors, such as for user-defined validation
   * rules (see Validator).  Callers should fill in all the parameters with
   * suitable values if generating errors with codes greater than 99999 to
   * make maximum use of the {@link SBMLError} facilities.
   * <p>
   * As mentioned above, 
   * there are additional constants defined for <a class='el'
   * href='#SBMLErrorSeverity_t'>standard severity</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>standard category</a> codes, and every predefined 
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of <code>errorId</code> is one of the standard error
   * codes, callers do not need to fill in <code>severity</code> and <code>category</code> in a
   * call to this constructor.  Conversely, if <code>errorId</code> is not an existing
   * SBML-level error code, callers can use other values for <code>severity</code> and
   * <code>category</code>. 
   * <p>
   * Please see the top of the documentation for {@link SBMLError} for a longer
   * discussion of the possible error codes, their meanings, and their
   * applicability to different combinations of Level+Version of SBML.
   * <p>
   * @param errorId a long integer, the identification number of the error.
   * <p>
   * @param level the SBML Level of the SBML model
   * <p>
   * @param version the SBML Version within the Level of the SBML model
   * <p>
   * @param details a string containing additional details about the error.
   * If the error code in <code>errorId</code> is one that is recognized by {@link SBMLError},
   * the given message is <em>appended</em> to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   * <p>
   * @param line a long integer, the line number at which the error occured.
   * <p>
   * @param column a long integer, the column number at which the error occured.
   * <p>
   * @param severity an integer indicating severity of the error.
   * <p>
   * @param category an integer indicating the category to which the error
   * belongs.
   * <p>
   * @docnote The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
 
   */
 public SBMLError(long errorId, long level, long version, String details, long line, long column, long severity, long category) {
    this(libsbmlJNI.new_SBMLError__SWIG_0(errorId, level, version, details, line, column, severity, category), true);
  }

  
  /**
   * Creates a new {@link SBMLError} to report that something occurred during SBML
   * processing.
   * <p>
   * When a libSBML operation on SBML content results in a warning, error
   * or other diagnostic, the issue is reported as an {@link SBMLError} object.
   * {@link SBMLError} objects have identification numbers to indicate the nature
   * of the exception.  These numbers are
   * defined as longeger constants in the file
   * 'libsbmlConstants.html'.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings.  The argument 
   * <code>errorId</code> to this constructor <em>can</em> be (but does not have to be) a
   * value from this set of constants.  If it 
   * <em>is</em> one of the predefined error identifiers, the {@link SBMLError} class
   * assumes the error is a low-level system or SBML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument <code>details</code> to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the 
   * <code>severity</code> and <code>category</code> codes, and these fields are filled-in using
   * the libSBML defaults for each different error identifier. 
   * <p>
   * If the error identifier <code>errorId</code> is a number greater than 99999, the
   * {@link SBMLError} class assumes the error was generated from another part of
   * the software and does not do additional filling in of values beyond
   * the default in the constructor itself.  This allows {@link SBMLError} to serve
   * as a base class for other errors, such as for user-defined validation
   * rules (see Validator).  Callers should fill in all the parameters with
   * suitable values if generating errors with codes greater than 99999 to
   * make maximum use of the {@link SBMLError} facilities.
   * <p>
   * As mentioned above, 
   * there are additional constants defined for <a class='el'
   * href='#SBMLErrorSeverity_t'>standard severity</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>standard category</a> codes, and every predefined 
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of <code>errorId</code> is one of the standard error
   * codes, callers do not need to fill in <code>severity</code> and <code>category</code> in a
   * call to this constructor.  Conversely, if <code>errorId</code> is not an existing
   * SBML-level error code, callers can use other values for <code>severity</code> and
   * <code>category</code>. 
   * <p>
   * Please see the top of the documentation for {@link SBMLError} for a longer
   * discussion of the possible error codes, their meanings, and their
   * applicability to different combinations of Level+Version of SBML.
   * <p>
   * @param errorId a long integer, the identification number of the error.
   * <p>
   * @param level the SBML Level of the SBML model
   * <p>
   * @param version the SBML Version within the Level of the SBML model
   * <p>
   * @param details a string containing additional details about the error.
   * If the error code in <code>errorId</code> is one that is recognized by {@link SBMLError},
   * the given message is <em>appended</em> to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   * <p>
   * @param line a long integer, the line number at which the error occured.
   * <p>
   * @param column a long integer, the column number at which the error occured.
   * <p>
   * @param severity an integer indicating severity of the error.
   * <p>
   * @param category an integer indicating the category to which the error
   * belongs.
   * <p>
   * @docnote The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
 
   */
 public SBMLError(long errorId, long level, long version, String details, long line, long column, long severity) {
    this(libsbmlJNI.new_SBMLError__SWIG_1(errorId, level, version, details, line, column, severity), true);
  }

  
  /**
   * Creates a new {@link SBMLError} to report that something occurred during SBML
   * processing.
   * <p>
   * When a libSBML operation on SBML content results in a warning, error
   * or other diagnostic, the issue is reported as an {@link SBMLError} object.
   * {@link SBMLError} objects have identification numbers to indicate the nature
   * of the exception.  These numbers are
   * defined as longeger constants in the file
   * 'libsbmlConstants.html'.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings.  The argument 
   * <code>errorId</code> to this constructor <em>can</em> be (but does not have to be) a
   * value from this set of constants.  If it 
   * <em>is</em> one of the predefined error identifiers, the {@link SBMLError} class
   * assumes the error is a low-level system or SBML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument <code>details</code> to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the 
   * <code>severity</code> and <code>category</code> codes, and these fields are filled-in using
   * the libSBML defaults for each different error identifier. 
   * <p>
   * If the error identifier <code>errorId</code> is a number greater than 99999, the
   * {@link SBMLError} class assumes the error was generated from another part of
   * the software and does not do additional filling in of values beyond
   * the default in the constructor itself.  This allows {@link SBMLError} to serve
   * as a base class for other errors, such as for user-defined validation
   * rules (see Validator).  Callers should fill in all the parameters with
   * suitable values if generating errors with codes greater than 99999 to
   * make maximum use of the {@link SBMLError} facilities.
   * <p>
   * As mentioned above, 
   * there are additional constants defined for <a class='el'
   * href='#SBMLErrorSeverity_t'>standard severity</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>standard category</a> codes, and every predefined 
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of <code>errorId</code> is one of the standard error
   * codes, callers do not need to fill in <code>severity</code> and <code>category</code> in a
   * call to this constructor.  Conversely, if <code>errorId</code> is not an existing
   * SBML-level error code, callers can use other values for <code>severity</code> and
   * <code>category</code>. 
   * <p>
   * Please see the top of the documentation for {@link SBMLError} for a longer
   * discussion of the possible error codes, their meanings, and their
   * applicability to different combinations of Level+Version of SBML.
   * <p>
   * @param errorId a long integer, the identification number of the error.
   * <p>
   * @param level the SBML Level of the SBML model
   * <p>
   * @param version the SBML Version within the Level of the SBML model
   * <p>
   * @param details a string containing additional details about the error.
   * If the error code in <code>errorId</code> is one that is recognized by {@link SBMLError},
   * the given message is <em>appended</em> to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   * <p>
   * @param line a long integer, the line number at which the error occured.
   * <p>
   * @param column a long integer, the column number at which the error occured.
   * <p>
   * @param severity an integer indicating severity of the error.
   * <p>
   * @param category an integer indicating the category to which the error
   * belongs.
   * <p>
   * @docnote The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
 
   */
 public SBMLError(long errorId, long level, long version, String details, long line, long column) {
    this(libsbmlJNI.new_SBMLError__SWIG_2(errorId, level, version, details, line, column), true);
  }

  
  /**
   * Creates a new {@link SBMLError} to report that something occurred during SBML
   * processing.
   * <p>
   * When a libSBML operation on SBML content results in a warning, error
   * or other diagnostic, the issue is reported as an {@link SBMLError} object.
   * {@link SBMLError} objects have identification numbers to indicate the nature
   * of the exception.  These numbers are
   * defined as longeger constants in the file
   * 'libsbmlConstants.html'.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings.  The argument 
   * <code>errorId</code> to this constructor <em>can</em> be (but does not have to be) a
   * value from this set of constants.  If it 
   * <em>is</em> one of the predefined error identifiers, the {@link SBMLError} class
   * assumes the error is a low-level system or SBML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument <code>details</code> to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the 
   * <code>severity</code> and <code>category</code> codes, and these fields are filled-in using
   * the libSBML defaults for each different error identifier. 
   * <p>
   * If the error identifier <code>errorId</code> is a number greater than 99999, the
   * {@link SBMLError} class assumes the error was generated from another part of
   * the software and does not do additional filling in of values beyond
   * the default in the constructor itself.  This allows {@link SBMLError} to serve
   * as a base class for other errors, such as for user-defined validation
   * rules (see Validator).  Callers should fill in all the parameters with
   * suitable values if generating errors with codes greater than 99999 to
   * make maximum use of the {@link SBMLError} facilities.
   * <p>
   * As mentioned above, 
   * there are additional constants defined for <a class='el'
   * href='#SBMLErrorSeverity_t'>standard severity</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>standard category</a> codes, and every predefined 
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of <code>errorId</code> is one of the standard error
   * codes, callers do not need to fill in <code>severity</code> and <code>category</code> in a
   * call to this constructor.  Conversely, if <code>errorId</code> is not an existing
   * SBML-level error code, callers can use other values for <code>severity</code> and
   * <code>category</code>. 
   * <p>
   * Please see the top of the documentation for {@link SBMLError} for a longer
   * discussion of the possible error codes, their meanings, and their
   * applicability to different combinations of Level+Version of SBML.
   * <p>
   * @param errorId a long integer, the identification number of the error.
   * <p>
   * @param level the SBML Level of the SBML model
   * <p>
   * @param version the SBML Version within the Level of the SBML model
   * <p>
   * @param details a string containing additional details about the error.
   * If the error code in <code>errorId</code> is one that is recognized by {@link SBMLError},
   * the given message is <em>appended</em> to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   * <p>
   * @param line a long integer, the line number at which the error occured.
   * <p>
   * @param column a long integer, the column number at which the error occured.
   * <p>
   * @param severity an integer indicating severity of the error.
   * <p>
   * @param category an integer indicating the category to which the error
   * belongs.
   * <p>
   * @docnote The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
 
   */
 public SBMLError(long errorId, long level, long version, String details, long line) {
    this(libsbmlJNI.new_SBMLError__SWIG_3(errorId, level, version, details, line), true);
  }

  
  /**
   * Creates a new {@link SBMLError} to report that something occurred during SBML
   * processing.
   * <p>
   * When a libSBML operation on SBML content results in a warning, error
   * or other diagnostic, the issue is reported as an {@link SBMLError} object.
   * {@link SBMLError} objects have identification numbers to indicate the nature
   * of the exception.  These numbers are
   * defined as longeger constants in the file
   * 'libsbmlConstants.html'.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings.  The argument 
   * <code>errorId</code> to this constructor <em>can</em> be (but does not have to be) a
   * value from this set of constants.  If it 
   * <em>is</em> one of the predefined error identifiers, the {@link SBMLError} class
   * assumes the error is a low-level system or SBML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument <code>details</code> to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the 
   * <code>severity</code> and <code>category</code> codes, and these fields are filled-in using
   * the libSBML defaults for each different error identifier. 
   * <p>
   * If the error identifier <code>errorId</code> is a number greater than 99999, the
   * {@link SBMLError} class assumes the error was generated from another part of
   * the software and does not do additional filling in of values beyond
   * the default in the constructor itself.  This allows {@link SBMLError} to serve
   * as a base class for other errors, such as for user-defined validation
   * rules (see Validator).  Callers should fill in all the parameters with
   * suitable values if generating errors with codes greater than 99999 to
   * make maximum use of the {@link SBMLError} facilities.
   * <p>
   * As mentioned above, 
   * there are additional constants defined for <a class='el'
   * href='#SBMLErrorSeverity_t'>standard severity</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>standard category</a> codes, and every predefined 
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of <code>errorId</code> is one of the standard error
   * codes, callers do not need to fill in <code>severity</code> and <code>category</code> in a
   * call to this constructor.  Conversely, if <code>errorId</code> is not an existing
   * SBML-level error code, callers can use other values for <code>severity</code> and
   * <code>category</code>. 
   * <p>
   * Please see the top of the documentation for {@link SBMLError} for a longer
   * discussion of the possible error codes, their meanings, and their
   * applicability to different combinations of Level+Version of SBML.
   * <p>
   * @param errorId a long integer, the identification number of the error.
   * <p>
   * @param level the SBML Level of the SBML model
   * <p>
   * @param version the SBML Version within the Level of the SBML model
   * <p>
   * @param details a string containing additional details about the error.
   * If the error code in <code>errorId</code> is one that is recognized by {@link SBMLError},
   * the given message is <em>appended</em> to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   * <p>
   * @param line a long integer, the line number at which the error occured.
   * <p>
   * @param column a long integer, the column number at which the error occured.
   * <p>
   * @param severity an integer indicating severity of the error.
   * <p>
   * @param category an integer indicating the category to which the error
   * belongs.
   * <p>
   * @docnote The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
 
   */
 public SBMLError(long errorId, long level, long version, String details) {
    this(libsbmlJNI.new_SBMLError__SWIG_4(errorId, level, version, details), true);
  }

  
  /**
   * Creates a new {@link SBMLError} to report that something occurred during SBML
   * processing.
   * <p>
   * When a libSBML operation on SBML content results in a warning, error
   * or other diagnostic, the issue is reported as an {@link SBMLError} object.
   * {@link SBMLError} objects have identification numbers to indicate the nature
   * of the exception.  These numbers are
   * defined as longeger constants in the file
   * 'libsbmlConstants.html'.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings.  The argument 
   * <code>errorId</code> to this constructor <em>can</em> be (but does not have to be) a
   * value from this set of constants.  If it 
   * <em>is</em> one of the predefined error identifiers, the {@link SBMLError} class
   * assumes the error is a low-level system or SBML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument <code>details</code> to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the 
   * <code>severity</code> and <code>category</code> codes, and these fields are filled-in using
   * the libSBML defaults for each different error identifier. 
   * <p>
   * If the error identifier <code>errorId</code> is a number greater than 99999, the
   * {@link SBMLError} class assumes the error was generated from another part of
   * the software and does not do additional filling in of values beyond
   * the default in the constructor itself.  This allows {@link SBMLError} to serve
   * as a base class for other errors, such as for user-defined validation
   * rules (see Validator).  Callers should fill in all the parameters with
   * suitable values if generating errors with codes greater than 99999 to
   * make maximum use of the {@link SBMLError} facilities.
   * <p>
   * As mentioned above, 
   * there are additional constants defined for <a class='el'
   * href='#SBMLErrorSeverity_t'>standard severity</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>standard category</a> codes, and every predefined 
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of <code>errorId</code> is one of the standard error
   * codes, callers do not need to fill in <code>severity</code> and <code>category</code> in a
   * call to this constructor.  Conversely, if <code>errorId</code> is not an existing
   * SBML-level error code, callers can use other values for <code>severity</code> and
   * <code>category</code>. 
   * <p>
   * Please see the top of the documentation for {@link SBMLError} for a longer
   * discussion of the possible error codes, their meanings, and their
   * applicability to different combinations of Level+Version of SBML.
   * <p>
   * @param errorId a long integer, the identification number of the error.
   * <p>
   * @param level the SBML Level of the SBML model
   * <p>
   * @param version the SBML Version within the Level of the SBML model
   * <p>
   * @param details a string containing additional details about the error.
   * If the error code in <code>errorId</code> is one that is recognized by {@link SBMLError},
   * the given message is <em>appended</em> to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   * <p>
   * @param line a long integer, the line number at which the error occured.
   * <p>
   * @param column a long integer, the column number at which the error occured.
   * <p>
   * @param severity an integer indicating severity of the error.
   * <p>
   * @param category an integer indicating the category to which the error
   * belongs.
   * <p>
   * @docnote The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
 
   */
 public SBMLError(long errorId, long level, long version) {
    this(libsbmlJNI.new_SBMLError__SWIG_5(errorId, level, version), true);
  }

  
  /**
   * Creates a new {@link SBMLError} to report that something occurred during SBML
   * processing.
   * <p>
   * When a libSBML operation on SBML content results in a warning, error
   * or other diagnostic, the issue is reported as an {@link SBMLError} object.
   * {@link SBMLError} objects have identification numbers to indicate the nature
   * of the exception.  These numbers are
   * defined as longeger constants in the file
   * 'libsbmlConstants.html'.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings.  The argument 
   * <code>errorId</code> to this constructor <em>can</em> be (but does not have to be) a
   * value from this set of constants.  If it 
   * <em>is</em> one of the predefined error identifiers, the {@link SBMLError} class
   * assumes the error is a low-level system or SBML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument <code>details</code> to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the 
   * <code>severity</code> and <code>category</code> codes, and these fields are filled-in using
   * the libSBML defaults for each different error identifier. 
   * <p>
   * If the error identifier <code>errorId</code> is a number greater than 99999, the
   * {@link SBMLError} class assumes the error was generated from another part of
   * the software and does not do additional filling in of values beyond
   * the default in the constructor itself.  This allows {@link SBMLError} to serve
   * as a base class for other errors, such as for user-defined validation
   * rules (see Validator).  Callers should fill in all the parameters with
   * suitable values if generating errors with codes greater than 99999 to
   * make maximum use of the {@link SBMLError} facilities.
   * <p>
   * As mentioned above, 
   * there are additional constants defined for <a class='el'
   * href='#SBMLErrorSeverity_t'>standard severity</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>standard category</a> codes, and every predefined 
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of <code>errorId</code> is one of the standard error
   * codes, callers do not need to fill in <code>severity</code> and <code>category</code> in a
   * call to this constructor.  Conversely, if <code>errorId</code> is not an existing
   * SBML-level error code, callers can use other values for <code>severity</code> and
   * <code>category</code>. 
   * <p>
   * Please see the top of the documentation for {@link SBMLError} for a longer
   * discussion of the possible error codes, their meanings, and their
   * applicability to different combinations of Level+Version of SBML.
   * <p>
   * @param errorId a long integer, the identification number of the error.
   * <p>
   * @param level the SBML Level of the SBML model
   * <p>
   * @param version the SBML Version within the Level of the SBML model
   * <p>
   * @param details a string containing additional details about the error.
   * If the error code in <code>errorId</code> is one that is recognized by {@link SBMLError},
   * the given message is <em>appended</em> to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   * <p>
   * @param line a long integer, the line number at which the error occured.
   * <p>
   * @param column a long integer, the column number at which the error occured.
   * <p>
   * @param severity an integer indicating severity of the error.
   * <p>
   * @param category an integer indicating the category to which the error
   * belongs.
   * <p>
   * @docnote The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
 
   */
 public SBMLError(long errorId, long level) {
    this(libsbmlJNI.new_SBMLError__SWIG_6(errorId, level), true);
  }

  
  /**
   * Creates a new {@link SBMLError} to report that something occurred during SBML
   * processing.
   * <p>
   * When a libSBML operation on SBML content results in a warning, error
   * or other diagnostic, the issue is reported as an {@link SBMLError} object.
   * {@link SBMLError} objects have identification numbers to indicate the nature
   * of the exception.  These numbers are
   * defined as longeger constants in the file
   * 'libsbmlConstants.html'.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings.  The argument 
   * <code>errorId</code> to this constructor <em>can</em> be (but does not have to be) a
   * value from this set of constants.  If it 
   * <em>is</em> one of the predefined error identifiers, the {@link SBMLError} class
   * assumes the error is a low-level system or SBML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument <code>details</code> to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the 
   * <code>severity</code> and <code>category</code> codes, and these fields are filled-in using
   * the libSBML defaults for each different error identifier. 
   * <p>
   * If the error identifier <code>errorId</code> is a number greater than 99999, the
   * {@link SBMLError} class assumes the error was generated from another part of
   * the software and does not do additional filling in of values beyond
   * the default in the constructor itself.  This allows {@link SBMLError} to serve
   * as a base class for other errors, such as for user-defined validation
   * rules (see Validator).  Callers should fill in all the parameters with
   * suitable values if generating errors with codes greater than 99999 to
   * make maximum use of the {@link SBMLError} facilities.
   * <p>
   * As mentioned above, 
   * there are additional constants defined for <a class='el'
   * href='#SBMLErrorSeverity_t'>standard severity</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>standard category</a> codes, and every predefined 
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of <code>errorId</code> is one of the standard error
   * codes, callers do not need to fill in <code>severity</code> and <code>category</code> in a
   * call to this constructor.  Conversely, if <code>errorId</code> is not an existing
   * SBML-level error code, callers can use other values for <code>severity</code> and
   * <code>category</code>. 
   * <p>
   * Please see the top of the documentation for {@link SBMLError} for a longer
   * discussion of the possible error codes, their meanings, and their
   * applicability to different combinations of Level+Version of SBML.
   * <p>
   * @param errorId a long integer, the identification number of the error.
   * <p>
   * @param level the SBML Level of the SBML model
   * <p>
   * @param version the SBML Version within the Level of the SBML model
   * <p>
   * @param details a string containing additional details about the error.
   * If the error code in <code>errorId</code> is one that is recognized by {@link SBMLError},
   * the given message is <em>appended</em> to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   * <p>
   * @param line a long integer, the line number at which the error occured.
   * <p>
   * @param column a long integer, the column number at which the error occured.
   * <p>
   * @param severity an integer indicating severity of the error.
   * <p>
   * @param category an integer indicating the category to which the error
   * belongs.
   * <p>
   * @docnote The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
 
   */
 public SBMLError(long errorId) {
    this(libsbmlJNI.new_SBMLError__SWIG_7(errorId), true);
  }

  
  /**
   * Creates a new {@link SBMLError} to report that something occurred during SBML
   * processing.
   * <p>
   * When a libSBML operation on SBML content results in a warning, error
   * or other diagnostic, the issue is reported as an {@link SBMLError} object.
   * {@link SBMLError} objects have identification numbers to indicate the nature
   * of the exception.  These numbers are
   * defined as longeger constants in the file
   * 'libsbmlConstants.html'.  See the <a class='el'
   * href='#SBMLErrorCode_t'>top of this documentation page</a> for a table
   * listing the possible values and their meanings.  The argument 
   * <code>errorId</code> to this constructor <em>can</em> be (but does not have to be) a
   * value from this set of constants.  If it 
   * <em>is</em> one of the predefined error identifiers, the {@link SBMLError} class
   * assumes the error is a low-level system or SBML layer error and
   * <em>prepends</em> a built-in, predefined error message to any string
   * passed in the argument <code>details</code> to this constructor.  In addition,
   * all the predefined error identifiers have associated values for the 
   * <code>severity</code> and <code>category</code> codes, and these fields are filled-in using
   * the libSBML defaults for each different error identifier. 
   * <p>
   * If the error identifier <code>errorId</code> is a number greater than 99999, the
   * {@link SBMLError} class assumes the error was generated from another part of
   * the software and does not do additional filling in of values beyond
   * the default in the constructor itself.  This allows {@link SBMLError} to serve
   * as a base class for other errors, such as for user-defined validation
   * rules (see Validator).  Callers should fill in all the parameters with
   * suitable values if generating errors with codes greater than 99999 to
   * make maximum use of the {@link SBMLError} facilities.
   * <p>
   * As mentioned above, 
   * there are additional constants defined for <a class='el'
   * href='#SBMLErrorSeverity_t'>standard severity</a> and <a class='el'
   * href='#SBMLErrorCategory_t'>standard category</a> codes, and every predefined 
   * error in libSBML has an associated value for severity and category taken
   * from these predefined sets.  These constants have symbol names
   * prefixed with <code>LIBSBML_SEV_</code> and <code>LIBSBML_CAT_</code>,
   * respectively.  If the value of <code>errorId</code> is one of the standard error
   * codes, callers do not need to fill in <code>severity</code> and <code>category</code> in a
   * call to this constructor.  Conversely, if <code>errorId</code> is not an existing
   * SBML-level error code, callers can use other values for <code>severity</code> and
   * <code>category</code>. 
   * <p>
   * Please see the top of the documentation for {@link SBMLError} for a longer
   * discussion of the possible error codes, their meanings, and their
   * applicability to different combinations of Level+Version of SBML.
   * <p>
   * @param errorId a long integer, the identification number of the error.
   * <p>
   * @param level the SBML Level of the SBML model
   * <p>
   * @param version the SBML Version within the Level of the SBML model
   * <p>
   * @param details a string containing additional details about the error.
   * If the error code in <code>errorId</code> is one that is recognized by {@link SBMLError},
   * the given message is <em>appended</em> to a predefined message associated
   * with the given code.  If the error code is not recognized, the message
   * is stored as-is as the text of the error.
   * <p>
   * @param line a long integer, the line number at which the error occured.
   * <p>
   * @param column a long integer, the column number at which the error occured.
   * <p>
   * @param severity an integer indicating severity of the error.
   * <p>
   * @param category an integer indicating the category to which the error
   * belongs.
   * <p>
   * @docnote The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
 
   */
 public SBMLError() {
    this(libsbmlJNI.new_SBMLError__SWIG_8(), true);
  }

  
  /**
   * Copy constructor; creates a copy of this {@link SBMLError}.
   */
 public SBMLError(SBMLError orig) {
    this(libsbmlJNI.new_SBMLError__SWIG_9(SBMLError.getCPtr(orig), orig), true);
  }

}
