/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.4
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 * LibSBML implementation of SBML's KineticLaw construct.
 * <p>
 * An object of class {@link KineticLaw} is used to describe the rate at which the
 * process defined by a given {@link Reaction} takes place.  {@link KineticLaw} has
 * subelements called 'math' (for MathML content) and 'listOfParameters'
 * (of class {@link ListOfParameters}), in addition to the attributes and
 * subelements it inherits from {@link SBase}.
 * <p>
 * {@link KineticLaw}'s 'math' subelement for holding a MathML formula defines the
 * rate of the reaction.  The formula may refer to other entities in a
 * model as well as local parameter definitions within the scope of the
 * {@link Reaction} (see below).  It is important to keep in mind, however, that
 * the only {@link Species} identifiers that can be used in this formula are those
 * declared in the lists of reactants, products and modifiers in the
 * {@link Reaction} structure.  (In other words, before a species can be referenced
 * in the {@link KineticLaw}, it must be declared in one of those lists.)
 * <p>
 * {@link KineticLaw} provides a way to define <em>local</em> parameters whose
 * identifiers can be used in the 'math' formula of that {@link KineticLaw}
 * instance.  Prior to SBML Level&nbsp;3, these parameter definitions are
 * stored inside a 'listOfParameters' subelement containing {@link Parameter}
 * objects; in SBML Level&nbsp;3, this is achieved using a specialized
 * object class called {@link LocalParameter} and the containing subelement is
 * called 'listOfLocalParameters'.  In both cases, the parameters so
 * defined are only visible within the {@link KineticLaw}; they cannot be accessed
 * outside.  A local parameter within one reaction is not visible from
 * within another reaction, nor is it visible to any other construct
 * outside of the {@link KineticLaw} in which it is defined.  In addition, another
 * important feature is that if such a {@link Parameter} (or in Level&nbsp;3,
 * {@link LocalParameter}) object has the same identifier as another object in the
 * scope of the enclosing {@link Model}, the definition inside the {@link KineticLaw} takes
 * precedence.  In other words, within the {@link KineticLaw}'s 'math' formula,
 * references to local parameter identifiers <strong>shadow any identical
 * global identifiers</strong>.
 * <p>
 * The values of local parameters defined within {@link KineticLaw} objects cannot
 * change.  In SBML Level&nbsp;3, this quality is built into the
 * {@link LocalParameter} construct.  In Level&nbsp;2, where the same kind of
 * {@link Parameter} object class is used as for global parameters, the {@link Parameter}
 * objects' 'constant' attribute must always have a value of <code>true</code>
 * (either explicitly or left to its default value).
 * <p>
 * <p>
 * <h2>A warning about identifier shadowing</h2>
 * <p>
 * A common misconception is that different classes of objects (e.g.,
 * species, compartments, parameters) in SBML have different identifier
 * scopes.  They do not.  The implication is that if a {@link KineticLaw}'s local
 * parameter definition uses an identifier identical to <em>any</em> other
 * identifier defined in the model outside the {@link KineticLaw}, even if the
 * other identifier does <em>not</em> belong to a parameter type of object, the
 * local parameter's identifier takes precedence within that {@link KineticLaw}'s
 * 'math' formula.  It is not an error in SBML for identifiers to shadow
 * each other this way, but can lead to confusing and subtle errors.
 * <p>
 * <p>
 * <h2>SBML Level/Version differences</h2>
 * <p>
 * In SBML Level&nbsp;2 Version&nbsp;1, the SBML specification
 * included two additional attributes on {@link KineticLaw} called 'substanceUnits'
 * and 'timeUnits'.  They were removed beginning with SBML Level&nbsp;2
 * Version&nbsp;2 because further research determined they introduced many
 * problems.  The most significant problem was that their use could easily
 * lead to the creation of valid models whose reactions nevertheless could
 * not be integrated into a system of equations without outside knowledge
 * for converting the quantities used.  Examination of real-life models
 * revealed that a common reason for using 'substanceUnits' on {@link KineticLaw}
 * was to set the units of all reactions to the same set of substance
 * units, something that is better achieved by using {@link UnitDefinition} to
 * redefine <code>'substance'</code> for the whole {@link Model}.
 * <p>
 * As mentioned above, in SBML Level&nbsp;2 Versions 2&ndash;4, local
 * parameters are of class {@link Parameter}.  In SBML Level&nbsp;3, the class of
 * object is {@link LocalParameter}.
 */
public class KineticLaw extends SBase {
   private long swigCPtr;

   protected KineticLaw(long cPtr, boolean cMemoryOwn)
   {
     super(libsbmlJNI.KineticLaw_SWIGUpcast(cPtr), cMemoryOwn);
     swigCPtr = cPtr;
   }

   protected static long getCPtr(KineticLaw obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (KineticLaw obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_KineticLaw(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  
  /**
   * Creates a new {@link KineticLaw} using the given SBML <code>level</code> and <code>version</code>
   * values.
   * <p>
   * @param level a long integer, the SBML Level to assign to this {@link KineticLaw}
   * <p>
   * @param version a long integer, the SBML Version to assign to this
   * {@link KineticLaw}
   * <p>
   * @note Upon the addition of a {@link KineticLaw} object to an {@link SBMLDocument}
   * (e.g., using {@link Reaction#setKineticLaw(KineticLaw kl)}), the SBML Level, SBML Version
   * and XML namespace of the document <em>override</em> the values used
   * when creating the {@link KineticLaw} object via this constructor.  This is
   * necessary to ensure that an SBML document is a consistent structure.
   * Nevertheless, the ability to supply the values at the time of creation
   * of a {@link KineticLaw} is an important aid to producing valid SBML.  Knowledge
   * of the intented SBML Level and Version determine whether it is valid
   * to assign a particular value to an attribute, or whether it is valid
   * to add an object to an existing {@link SBMLDocument}.
   */
 public KineticLaw(long level, long version) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_KineticLaw__SWIG_0(level, version), true);
  }

  
  /**
   * Creates a new {@link KineticLaw} using the given {@link SBMLNamespaces} object
   * <code>sbmlns</code>.
   * <p>
   * The {@link SBMLNamespaces} object encapsulates SBML Level/Version/namespaces
   * information.  It is used to communicate the SBML Level, Version, and
   * (in Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.
   * A common approach to using this class constructor is to create an
   * {@link SBMLNamespaces} object somewhere in a program, once, then pass it to
   * object constructors such as this one when needed.
   * <p>
   * @param sbmlns an {@link SBMLNamespaces} object.
   * <p>
   * @note Upon the addition of a {@link KineticLaw} object to an {@link SBMLDocument}
   * (e.g., using {@link Reaction#setKineticLaw(KineticLaw kl)}), the SBML XML namespace of the
   * document <em>overrides</em> the value used when creating the {@link KineticLaw}
   * object via this constructor.  This is necessary to ensure that an SBML
   * document is a consistent structure.  Nevertheless, the ability to
   * supply the values at the time of creation of a {@link KineticLaw} is an
   * important aid to producing valid SBML.  Knowledge of the intented SBML
   * Level and Version determine whether it is valid to assign a particular
   * value to an attribute, or whether it is valid to add an object to an
   * existing {@link SBMLDocument}.
   */
 public KineticLaw(SBMLNamespaces sbmlns) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_KineticLaw__SWIG_1(SBMLNamespaces.getCPtr(sbmlns), sbmlns), true);
  }

  
  /**
   * Copy constructor; creates a copy of this {@link KineticLaw}.
   */
 public KineticLaw(KineticLaw orig) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_KineticLaw__SWIG_2(KineticLaw.getCPtr(orig), orig), true);
  }

  
  /**
   * Creates and returns a deep copy of this {@link KineticLaw} object.
   * <p>
   * @return a (deep) copy of this {@link KineticLaw}.
   */
 public KineticLaw cloneObject() {
    long cPtr = libsbmlJNI.KineticLaw_cloneObject(swigCPtr, this);
    return (cPtr == 0) ? null : new KineticLaw(cPtr, true);
  }

  
   /**
   * Returns the first child element found that has the given id in the model-wide SId namespace, or null if no such object is found.
   * <p>
   * @param id string representing the id of objects to find.
   * <p>
   * @return pointer to the first element found with the given id.
   */
 public SBase getElementBySId(String id) {
  return libsbml.DowncastSBase(libsbmlJNI.KineticLaw_getElementBySId(swigCPtr, this, id), false);
}

  
  /**
   * Returns the first child element it can find with the given metaid, or null if no such object is found.
   * <p>
   * @param metaid string representing the metaid of objects to find
   * <p>
   * @return pointer to the first element found with the given metaid.
   */
 public SBase getElementByMetaId(String metaid) {
  return libsbml.DowncastSBase(libsbmlJNI.KineticLaw_getElementByMetaId(swigCPtr, this, metaid), false);
}

  
/**
   * Returns the mathematical formula for this {@link KineticLaw} object and return
   * it as as a text string.
   * <p>
   * This is fundamentally equivalent to
   * {@link KineticLaw#getMath()}.
   * This variant is provided principally for compatibility compatibility
   * with SBML Level&nbsp;1.
   * <p>
   * @return a string representing the formula of this {@link KineticLaw}.
   * <p>
   * @note SBML Level&nbsp;1 uses a text-string format for mathematical formulas.
SBML Level&nbsp;2 uses MathML, an XML format for representing mathematical
expressions.  LibSBML provides an Abstract Syntax Tree API for working with
mathematical expressions; this API is more powerful than working with
formulas directly in text form, and ASTs can be translated into either
MathML or the text-string syntax.  The libSBML methods that accept
text-string formulas directly (such as this constructor) are provided for
SBML Level&nbsp;1 compatibility, but developers are encouraged to use the
AST mechanisms.

   * <p>
   * @see #getMath()
   */
 public String getFormula() {
    return libsbmlJNI.KineticLaw_getFormula(swigCPtr, this);
  }

  
  /**
   * Returns the mathematical formula for this {@link KineticLaw} object and return
   * it as as an AST.
   * <p>
   * This is fundamentally equivalent to
   * {@link KineticLaw#getFormula()}.
   * The latter is provided principally for compatibility compatibility
   * with SBML Level&nbsp;1, which represented mathematical formulas in
   * text-string form.
   * <p>
   * @return the {@link ASTNode} representation of the mathematical formula.
   * <p>
   * @see #getFormula()
   */
 public ASTNode getMath() {
    long cPtr = libsbmlJNI.KineticLaw_getMath(swigCPtr, this);
    return (cPtr == 0) ? null : new ASTNode(cPtr, false);
  }

  
  /**
   * (SBML Level&nbsp;2 Version&nbsp;1 only) Returns the value of the
   * 'timeUnits' attribute of this {@link KineticLaw} object.
   * <p>
   * @return the 'timeUnits' attribute value.
   * <p>
   * @note The attributes 'timeUnits' and 'substanceUnits' are present only
   * in SBML Level&nbsp;2 Version&nbsp;1.  In SBML Level&nbsp;2
   * Version&nbsp;2, the 'timeUnits' and 'substanceUnits' attributes were
   * removed.  For compatibility with new versions of SBML, users are
   * cautioned to avoid these attributes.
   */
 public String getTimeUnits() {
    return libsbmlJNI.KineticLaw_getTimeUnits(swigCPtr, this);
  }

  
  /**
   * (SBML Level&nbsp;2 Version&nbsp;1 only) Returns the value of the
   * 'substanceUnits' attribute of this {@link KineticLaw} object.
   * <p>
   * @return the 'substanceUnits' attribute value.
   * <p>
   * @note The attributes 'timeUnits' and 'substanceUnits' are present only
   * in SBML Level&nbsp;2 Version&nbsp;1.  In SBML Level&nbsp;2
   * Version&nbsp;2, the 'timeUnits' and 'substanceUnits' attributes were
   * removed.  For compatibility with new versions of SBML, users are
   * cautioned to avoid these attributes.
   */
 public String getSubstanceUnits() {
    return libsbmlJNI.KineticLaw_getSubstanceUnits(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> if this
   * {@link KineticLaw}'s 'formula' attribute is set.
   * <p>
   * This is functionally identical to the method
   * {@link KineticLaw#isSetMath()}.  It is
   * provided in order to mirror the parallel between
   * {@link KineticLaw#getFormula()} and
   * {@link KineticLaw#getMath()}.
   * <p>
   * @return <code>true</code> if the formula (meaning the <code>math</code> subelement) of
   * this {@link KineticLaw} is set, <code>false</code> otherwise.
   * <p>
   * @note SBML Level&nbsp;1 uses a text-string format for mathematical formulas.
SBML Level&nbsp;2 uses MathML, an XML format for representing mathematical
expressions.  LibSBML provides an Abstract Syntax Tree API for working with
mathematical expressions; this API is more powerful than working with
formulas directly in text form, and ASTs can be translated into either
MathML or the text-string syntax.  The libSBML methods that accept
text-string formulas directly (such as this constructor) are provided for
SBML Level&nbsp;1 compatibility, but developers are encouraged to use the
AST mechanisms.

   * <p>
   * @see #isSetMath()
   */  
 public boolean isSetFormula() {
    return libsbmlJNI.KineticLaw_isSetFormula(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> if this
   * Kinetic's 'math' subelement is set.
   * <p>
   * This is identical to the method
   * {@link KineticLaw#isSetFormula()}.
   * It is provided in order to mirror the parallel between
   * {@link KineticLaw#getFormula()} and
   * {@link KineticLaw#getMath()}.
   * <p>
   * @return <code>true</code> if the formula (meaning the <code>math</code> subelement) of
   * this {@link KineticLaw} is set, <code>false</code> otherwise.
   * <p>
   * @see #isSetFormula()
   */
 public boolean isSetMath() {
    return libsbmlJNI.KineticLaw_isSetMath(swigCPtr, this);
  }

  
  /**
   * (SBML Level&nbsp;2 Version&nbsp;1 only) Predicate returning <code>true</code> if
   * this {@link SpeciesReference}'s 'timeUnits' attribute is set.
   * <p>
   * @return <code>true</code> if the 'timeUnits' attribute of this {@link KineticLaw} object
   * is set, <code>false</code> otherwise.
   * <p>
   * @note The attributes 'timeUnits' and 'substanceUnits' are present only
   * in SBML Level&nbsp;2 Version&nbsp;1.  In SBML Level&nbsp;2
   * Version&nbsp;2, the 'timeUnits' and 'substanceUnits' attributes were
   * removed.  For compatibility with new versions of SBML, users are
   * cautioned to avoid these attributes.
   */
 public boolean isSetTimeUnits() {
    return libsbmlJNI.KineticLaw_isSetTimeUnits(swigCPtr, this);
  }

  
  /**
   * (SBML Level&nbsp;2 Version&nbsp;1 only) Predicate returning <code>true</code> if
   * this {@link SpeciesReference}'s 'substanceUnits' attribute is set.
   * <p>
   * @return <code>true</code> if the 'substanceUnits' attribute of this {@link KineticLaw}
   * object is set, <code>false</code> otherwise.
   * <p>
   * @note The attributes 'timeUnits' and 'substanceUnits' are present only
   * in SBML Level&nbsp;2 Version&nbsp;1.  In SBML Level&nbsp;2
   * Version&nbsp;2, the 'timeUnits' and 'substanceUnits' attributes were
   * removed.  For compatibility with new versions of SBML, users are
   * cautioned to avoid these attributes.
   */
 public boolean isSetSubstanceUnits() {
    return libsbmlJNI.KineticLaw_isSetSubstanceUnits(swigCPtr, this);
  }

  
  /**
   * Sets the mathematical expression of this {@link KineticLaw} instance to the
   * given <code>formula</code>.
   * <p>
   * The given <code>formula</code> string is copied.  Internally, libSBML stores the
   * mathematical expression as an {@link ASTNode}.
   * <p>
   * @param formula the mathematical expression to use, represented in
   * text-string form.
   * <p>
   * @return integer value indicating success/failure of the
   * function. The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT }
   * </ul>
   * <p>
   * @note SBML Level&nbsp;1 uses a text-string format for mathematical formulas.
SBML Level&nbsp;2 uses MathML, an XML format for representing mathematical
expressions.  LibSBML provides an Abstract Syntax Tree API for working with
mathematical expressions; this API is more powerful than working with
formulas directly in text form, and ASTs can be translated into either
MathML or the text-string syntax.  The libSBML methods that accept
text-string formulas directly (such as this constructor) are provided for
SBML Level&nbsp;1 compatibility, but developers are encouraged to use the
AST mechanisms.

   * <p>
   * @see #setMath(ASTNode math)
   */
 public int setFormula(String formula) {
    return libsbmlJNI.KineticLaw_setFormula(swigCPtr, this, formula);
  }

  
  /**
   * Sets the mathematical expression of this {@link KineticLaw} instance to a copy
   * of the given {@link ASTNode}.
   * <p>
   * This is fundamentally identical to
   * {@link KineticLaw#setFormula(String formula)}.
   * The latter is provided principally for compatibility compatibility with
   * SBML Level&nbsp;1, which represented mathematical formulas in text-string
   * form.
   * <p>
   * @param math an {@link ASTNode} representing a formula tree.
   * <p>
   * @return integer value indicating success/failure of the
   * function. The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT }
   * </ul>
   * <p>
   * @see #setFormula(String formula)
   */
 public int setMath(ASTNode math) {
    return libsbmlJNI.KineticLaw_setMath(swigCPtr, this, ASTNode.getCPtr(math), math);
  }

  
  /**
   * (SBML Level&nbsp;2 Version&nbsp;1 only) Sets the 'timeUnits' attribute
   * of this {@link KineticLaw} object to a copy of the identifier in <code>sid</code>.
   * <p>
   * @param sid the identifier of the units to use.
   * <p>
   * @return integer value indicating success/failure of the
   * function. The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE }
   * <li> {@link  libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE }
   * </ul>
   * <p>
   * @note The attributes 'timeUnits' and 'substanceUnits' are present only
   * in SBML Level&nbsp;2 Version&nbsp;1.  In SBML Level&nbsp;2
   * Version&nbsp;2, the 'timeUnits' and 'substanceUnits' attributes were
   * removed.  For compatibility with new versions of SBML, users are
   * cautioned to avoid these attributes.
   */
 public int setTimeUnits(String sid) {
    return libsbmlJNI.KineticLaw_setTimeUnits(swigCPtr, this, sid);
  }

  
  /**
   * (SBML Level&nbsp;2 Version&nbsp;1 only) Sets the 'substanceUnits'
   * attribute of this {@link KineticLaw} object to a copy of the identifier given
   * in <code>sid</code>.
   * <p>
   * @param sid the identifier of the units to use.
   * <p>
   * @return integer value indicating success/failure of the
   * function. The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE }
   * <li> {@link  libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE }
   * </ul>
   * <p>
   * @note The attributes 'timeUnits' and 'substanceUnits' are present only
   * in SBML Level&nbsp;2 Version&nbsp;1.  In SBML Level&nbsp;2
   * Version&nbsp;2, the 'timeUnits' and 'substanceUnits' attributes were
   * removed.  For compatibility with new versions of SBML, users are
   * cautioned to avoid these attributes.
   */
 public int setSubstanceUnits(String sid) {
    return libsbmlJNI.KineticLaw_setSubstanceUnits(swigCPtr, this, sid);
  }

  
  /**
   * (SBML Level&nbsp;2 Version&nbsp;1 only) Unsets the 'timeUnits'
   * attribugte of this {@link KineticLaw} object.
   * <p>
   * @return integer value indicating success/failure of the
   * function. The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * <li> {@link  libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE }
   * </ul>
   * <p>
   * @note The attributes 'timeUnits' and 'substanceUnits' are present only
   * in SBML Level&nbsp;2 Version&nbsp;1.  In SBML Level&nbsp;2
   * Version&nbsp;2, the 'timeUnits' and 'substanceUnits' attributes were
   * removed.  For compatibility with new versions of SBML, users are
   * cautioned to avoid these attributes.
   */
 public int unsetTimeUnits() {
    return libsbmlJNI.KineticLaw_unsetTimeUnits(swigCPtr, this);
  }

  
  /**
   * (SBML Level&nbsp;2 Version&nbsp;1 only) Unsets the 'substanceUnits'
   * attribute of this {@link KineticLaw} object.
   * <p>
   * @return integer value indicating success/failure of the
   * function. The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * <li> {@link  libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE }
   * </ul>
   * <p>
   * @note The attributes 'timeUnits' and 'substanceUnits' are present only
   * in SBML Level&nbsp;2 Version&nbsp;1.  In SBML Level&nbsp;2
   * Version&nbsp;2, the 'timeUnits' and 'substanceUnits' attributes were
   * removed.  For compatibility with new versions of SBML, users are
   * cautioned to avoid these attributes.
   */
 public int unsetSubstanceUnits() {
    return libsbmlJNI.KineticLaw_unsetSubstanceUnits(swigCPtr, this);
  }

  
  /**
   * Adds a copy of the given {@link Parameter} object to the list of local
   * parameters in this {@link KineticLaw}.
   * <p>
   * @param p the {@link Parameter} to add
   * <p>
   * @return integer value indicating success/failure of the
   * function. The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH }
   * <li> {@link  libsbmlConstants#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH }
   * <li> {@link  libsbmlConstants#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID }
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * </ul>
   * <p>
   * @note This method should be used with some caution.  The fact that
   * this method <em>copies</em> the object passed to it means that the caller
   * will be left holding a physically different object instance than the
   * one contained in this {@link KineticLaw}.  Changes made to the original object
   * instance (such as resetting attribute values) will <em>not affect the
   * instance in the {@link KineticLaw}</em>.  In addition, the caller should make
   * sure to free the original object if it is no longer being used, or
   * else a memory leak will result.  Please see
   * {@link KineticLaw#createParameter()}
   * for a method that does not lead to these issues.
   * <p>
   * @see #createParameter()
   */
 public int addParameter(Parameter p) {
    return libsbmlJNI.KineticLaw_addParameter(swigCPtr, this, Parameter.getCPtr(p), p);
  }

  
  /**
   * Adds a copy of the given {@link LocalParameter} object to the list of local
   * parameters in this {@link KineticLaw}.
   * <p>
   * @param p the {@link LocalParameter} to add
   * <p>
   * @return integer value indicating success/failure of the
   * function. The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH }
   * <li> {@link  libsbmlConstants#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH }
   * <li> {@link  libsbmlConstants#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID }
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * </ul>
   * <p>
   * @note This method should be used with some caution.  The fact that
   * this method <em>copies</em> the object passed to it means that the caller
   * will be left holding a physically different object instance than the
   * one contained in this {@link KineticLaw}.  Changes made to the original object
   * instance (such as resetting attribute values) will <em>not affect the
   * instance in the {@link KineticLaw}</em>.  In addition, the caller should make
   * sure to free the original object if it is no longer being used, or
   * else a memory leak will result.  Please see
   * {@link KineticLaw#createParameter()}
   * for a method that does not lead to these issues.
   * <p>
   * @see #createLocalParameter()
   */
 public int addLocalParameter(LocalParameter p) {
    return libsbmlJNI.KineticLaw_addLocalParameter(swigCPtr, this, LocalParameter.getCPtr(p), p);
  }

  
  /**
   * Creates a new {@link Parameter} object, adds it to this {@link KineticLaw}'s list of
   * local parameters, and returns the {@link Parameter} object created.
   * <p>
   * @return a new {@link Parameter} object instance
   * <p>
   * @see #addParameter(Parameter p)
   */
 public Parameter createParameter() {
    long cPtr = libsbmlJNI.KineticLaw_createParameter(swigCPtr, this);
    return (cPtr == 0) ? null : new Parameter(cPtr, false);
  }

  
  /**
   * Creates a new {@link LocalParameter} object, adds it to this {@link KineticLaw}'s list
   * of local parameters, and returns the {@link LocalParameter} object created.
   * <p>
   * @return a new {@link LocalParameter} object instance
   * <p>
   * @see #addLocalParameter(LocalParameter p)
   */
 public LocalParameter createLocalParameter() {
    long cPtr = libsbmlJNI.KineticLaw_createLocalParameter(swigCPtr, this);
    return (cPtr == 0) ? null : new LocalParameter(cPtr, false);
  }

  
  /**
   * Returns the list of local parameters in this {@link KineticLaw} object.
   * <p>
   * @return the list of Parameters for this {@link KineticLaw}.
   */
 public ListOfParameters getListOfParameters() {
    long cPtr = libsbmlJNI.KineticLaw_getListOfParameters__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new ListOfParameters(cPtr, false);
  }

  
  /**
   * Returns the list of local parameters in this {@link KineticLaw} object.
   * <p>
   * @return the list of LocalParameters for this {@link KineticLaw}.
   */
 public ListOfLocalParameters getListOfLocalParameters() {
    long cPtr = libsbmlJNI.KineticLaw_getListOfLocalParameters__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new ListOfLocalParameters(cPtr, false);
  }

  
  /**
   * Returns the nth {@link Parameter} object in the list of local parameters in
   * this {@link KineticLaw} instance.
   * <p>
   * @param n the index of the {@link Parameter} object sought
   * <p>
   * @return the nth {@link Parameter} of this {@link KineticLaw}.
   */
 public Parameter getParameter(long n) {
    long cPtr = libsbmlJNI.KineticLaw_getParameter__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new Parameter(cPtr, false);
  }

  
  /**
   * Returns the nth {@link LocalParameter} object in the list of local parameters in
   * this {@link KineticLaw} instance.
   * <p>
   * @param n the index of the {@link LocalParameter} object sought
   * <p>
   * @return the nth {@link LocalParameter} of this {@link KineticLaw}.
   */
 public LocalParameter getLocalParameter(long n) {
    long cPtr = libsbmlJNI.KineticLaw_getLocalParameter__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new LocalParameter(cPtr, false);
  }

  
  /**
   * Returns a local parameter based on its identifier.
   * <p>
   * @param sid the identifier of the {@link Parameter} being sought.
   * <p>
   * @return the {@link Parameter} object in this {@link KineticLaw} instace having the
   * given 'id', or <code>null</code> if no such {@link Parameter} exists.
   */
 public Parameter getParameter(String sid) {
    long cPtr = libsbmlJNI.KineticLaw_getParameter__SWIG_2(swigCPtr, this, sid);
    return (cPtr == 0) ? null : new Parameter(cPtr, false);
  }

  
  /**
   * Returns a local parameter based on its identifier.
   * <p>
   * @param sid the identifier of the {@link LocalParameter} being sought.
   * <p>
   * @return the {@link LocalParameter} object in this {@link KineticLaw} instace having the
   * given 'id', or <code>null</code> if no such {@link LocalParameter} exists.
   */
 public LocalParameter getLocalParameter(String sid) {
    long cPtr = libsbmlJNI.KineticLaw_getLocalParameter__SWIG_2(swigCPtr, this, sid);
    return (cPtr == 0) ? null : new LocalParameter(cPtr, false);
  }

  
  /**
   * Returns the number of local parameters in this {@link KineticLaw} instance.
   * <p>
   * @return the number of Parameters in this {@link KineticLaw}.
   */
 public long getNumParameters() {
    return libsbmlJNI.KineticLaw_getNumParameters(swigCPtr, this);
  }

  
  /**
   * Returns the number of local parameters in this {@link KineticLaw} instance.
   * <p>
   * @return the number of LocalParameters in this {@link KineticLaw}.
   */
 public long getNumLocalParameters() {
    return libsbmlJNI.KineticLaw_getNumLocalParameters(swigCPtr, this);
  }

  
  /**
   * Calculates and returns a {@link UnitDefinition} that expresses the units
   * of measurement assumed for the 'math' expression of this
   * {@link KineticLaw}.
   * <p>
   * The units are calculated based on the mathematical expression in the
   * {@link KineticLaw} and the model quantities referenced by
   * <code>&lt;ci&gt;</code> elements used within that expression.  The
   * {@link KineticLaw#getDerivedUnitDefinition()}
   * method returns the calculated units.
   * <p>
   * Note that the functionality that facilitates unit analysis depends 
   * on the model as a whole.  Thus, in cases where the object has not 
   * been added to a model or the model itself is incomplete,
   * unit analysis is not possible and this method will return <code>null.</code>
   * <p>
   * @warning Note that it is possible the 'math' expression in the
   * {@link KineticLaw} contains pure numbers or parameters with undeclared
   * units.  In those cases, it is not possible to calculate the units of
   * the overall expression without making assumptions.  LibSBML does not
   * make assumptions about the units, and
   * {@link KineticLaw#getDerivedUnitDefinition()}
   * only returns the units as far as it is able to determine them.  For
   * example, in an expression <em>X + Y</em>, if <em>X</em> has
   * unambiguously-defined units and <em>Y</em> does not, it will return
   * the units of <em>X</em>.  <strong>It is important that callers also
   * invoke the method</strong>
   * {@link KineticLaw#containsUndeclaredUnits()}
   * <strong>to determine whether this situation holds</strong>.  Callers may
   * wish to take suitable actions in those scenarios.
   * <p>
   * @return a {@link UnitDefinition} that expresses the units of the math 
   * expression of this {@link KineticLaw}, or <code>null</code> if one cannot be constructed.
   * <p>
   * @see #containsUndeclaredUnits()
   */
 public UnitDefinition getDerivedUnitDefinition() {
    long cPtr = libsbmlJNI.KineticLaw_getDerivedUnitDefinition__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new UnitDefinition(cPtr, false);
  }

  
  /**
   * Predicate returning <code>true</code> if 
   * the math expression of this {@link KineticLaw} contains
   * parameters/numbers with undeclared units.
   * <p>
   * @return <code>true</code> if the math expression of this {@link KineticLaw}
   * includes parameters/numbers 
   * with undeclared units, <code>false</code> otherwise.
   * <p>
   * @note A return value of <code>true</code> indicates that the {@link UnitDefinition}
   * returned by
   * {@link KineticLaw#getDerivedUnitDefinition()}
   * may not accurately represent the units of the expression.
   * <p>
   * @see #getDerivedUnitDefinition()
   */
 public boolean containsUndeclaredUnits() {
    return libsbmlJNI.KineticLaw_containsUndeclaredUnits__SWIG_0(swigCPtr, this);
  }

  
  /**
   * Removes the nth {@link Parameter} object in the list of local parameters 
   * in this {@link KineticLaw} instance and returns a pointer to it.
   * <p>
   * The caller owns the returned object and is responsible for deleting it.
   * <p>
   * @param n the index of the {@link Parameter} object to remove
   * <p>
   * @return the {@link Parameter} object removed.  As mentioned above, 
   * the caller owns the returned item. <code>null</code> is returned if the given index 
   * is out of range.
   */
 public Parameter removeParameter(long n) {
    long cPtr = libsbmlJNI.KineticLaw_removeParameter__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new Parameter(cPtr, true);
  }

  
  /**
   * Removes the nth {@link LocalParameter} object in the list of local parameters 
   * in this {@link KineticLaw} instance and returns a pointer to it.
   * <p>
   * The caller owns the returned object and is responsible for deleting it.
   * <p>
   * @param n the index of the {@link LocalParameter} object to remove
   * <p>
   * @return the {@link LocalParameter} object removed.  As mentioned above, 
   * the caller owns the returned item. <code>null</code> is returned if the given index 
   * is out of range.
   */
 public LocalParameter removeLocalParameter(long n) {
    long cPtr = libsbmlJNI.KineticLaw_removeLocalParameter__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new LocalParameter(cPtr, true);
  }

  
  /**
   * Removes a {@link Parameter} object with the given identifier in the list of
   * local parameters in this {@link KineticLaw} instance and returns a pointer to it.
   * <p>
   * The caller owns the returned object and is responsible for deleting it.
   * <p>
   * @param sid the identifier of the {@link Parameter} to remove
   * <p>
   * @return the {@link Parameter} object removed.  As mentioned above, the 
   * caller owns the returned object. <code>null</code> is returned if no {@link Parameter}
   * object with the identifier exists in this {@link KineticLaw} instance.
   */
 public Parameter removeParameter(String sid) {
    long cPtr = libsbmlJNI.KineticLaw_removeParameter__SWIG_1(swigCPtr, this, sid);
    return (cPtr == 0) ? null : new Parameter(cPtr, true);
  }

  
  /**
   * Removes a {@link LocalParameter} object with the given identifier in the list of
   * local parameters in this {@link KineticLaw} instance and returns a pointer to it.
   * <p>
   * The caller owns the returned object and is responsible for deleting it.
   * <p>
   * @param sid the identifier of the {@link LocalParameter} to remove
   * <p>
   * @return the {@link LocalParameter} object removed.  As mentioned above, the 
   * caller owns the returned object. <code>null</code> is returned if no {@link LocalParameter}
   * object with the identifier exists in this {@link KineticLaw} instance.
   */
 public LocalParameter removeLocalParameter(String sid) {
    long cPtr = libsbmlJNI.KineticLaw_removeLocalParameter__SWIG_1(swigCPtr, this, sid);
    return (cPtr == 0) ? null : new LocalParameter(cPtr, true);
  }

  
  /**
   * Sets this SBML object to child SBML objects (if any).
   * (Creates a child-parent relationship by the parent)
   * <p>
   * Subclasses must override this function if they define
   * one ore more child elements.
   * Basically, this function needs to be called in
   * constructor, copy constructor and assignment operator.
   * <p>
   * @see setSBMLDocument
   * @see enablePackageInternal
   * @internal
   */
 public void connectToChild() {
    libsbmlJNI.KineticLaw_connectToChild(swigCPtr, this);
  }

  
  /**
   * Enables/Disables the given package with this element and child
   * elements (if any).
   * (This is an internal implementation for enablePackage function)
   * <p>
   * @note Subclasses of the SBML Core package in which one or more child
   * elements are defined must override this function.
   * @internal
   */
 public void enablePackageInternal(String pkgURI, String pkgPrefix, boolean flag) {
    libsbmlJNI.KineticLaw_enablePackageInternal(swigCPtr, this, pkgURI, pkgPrefix, flag);
  }

  
  /**
   * Returns the libSBML type code for this SBML object.
   * <p>
   * LibSBML attaches an identifying code to every
   * kind of SBML object.  These are known as <em>SBML type codes</em>.  In
   * other languages, the set of type codes is stored in an enumeration; in
   * the Java language interface for libSBML, the type codes are defined as
   * static integer constants in the interface class {@link
   * libsbmlConstants}.  The names of the type codes all begin with the
   * characters <code>SBML_.</code> 
   * <p>
   * @return the SBML type code for this object, or {@link 
   * libsbmlConstants#SBML_UNKNOWN SBML_UNKNOWN} (default).
   * <p>
   * @see #getElementName()
   */
 public int getTypeCode() {
    return libsbmlJNI.KineticLaw_getTypeCode(swigCPtr, this);
  }

  
  /**
   * Returns the XML element name of this object, which for {@link Species}, is
   * always <code>'kineticLaw'.</code>
   * <p>
   * @return the name of this element, i.e., <code>'kineticLaw'.</code>
   */
 public String getElementName() {
    return libsbmlJNI.KineticLaw_getElementName(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> if
   * all the required attributes for this {@link KineticLaw} object
   * have been set.
   * <p>
   * @note The required attributes for a {@link KineticLaw} object are:
   * <ul>
   * <li> 'formula' (SBML Level&nbsp;1 only)
   * </ul>
   * <p>
   * @return a boolean value indicating whether all the required
   * attributes for this object have been defined.
   */
 public boolean hasRequiredAttributes() {
    return libsbmlJNI.KineticLaw_hasRequiredAttributes(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> if
   * all the required elements for this {@link KineticLaw} object
   * have been set.
   * <p>
   * @note The required elements for a {@link KineticLaw} object are:
   * <ul>
   * <li> 'math'
   * </ul>
   * <p>
   * @return a boolean value indicating whether all the required
   * elements for this object have been defined.
   */
 public boolean hasRequiredElements() {
    return libsbmlJNI.KineticLaw_hasRequiredElements(swigCPtr, this);
  }

  
  /**
   * Finds this {@link KineticLaw}'s {@link Reaction} parent and calls unsetKineticLaw() on it, indirectly deleting itself.  Overridden from the {@link SBase} function since the parent is not a {@link ListOf}.
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * </ul>
   */
 public int removeFromParentAndDelete() {
    return libsbmlJNI.KineticLaw_removeFromParentAndDelete(swigCPtr, this);
  }

  
  /**
   * Renames all the SIdRef attributes on this element, including any found in MathML
   */
 public void renameSIdRefs(String oldid, String newid) {
    libsbmlJNI.KineticLaw_renameSIdRefs(swigCPtr, this, oldid, newid);
  }

  
  /**
   * Renames all the UnitSIdRef attributes on this element
   */
 public void renameUnitSIdRefs(String oldid, String newid) {
    libsbmlJNI.KineticLaw_renameUnitSIdRefs(swigCPtr, this, oldid, newid);
  }

  
  /**
   * Replace all nodes with the name 'id' from the child 'math' object with the provided function. 
   * <p>
   * @internal
   */
 public void replaceSIDWithFunction(String id, ASTNode function) {
    libsbmlJNI.KineticLaw_replaceSIDWithFunction(swigCPtr, this, id, ASTNode.getCPtr(function), function);
  }

  
  /**
   * If this reaction id matches the provided 'id' string, replace the 'math' object with the function (existing/function). 
   * @internal 
   */
 public void divideAssignmentsToSIdByFunction(String id, ASTNode function) {
    libsbmlJNI.KineticLaw_divideAssignmentsToSIdByFunction(swigCPtr, this, id, ASTNode.getCPtr(function), function);
  }

}
