/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.4
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

namespace libsbmlcs {

 using System;
 using System.Runtime.InteropServices;

/** 
 * Representation of a token in an XML stream.
 *
 * @htmlinclude not-sbml-warning.html
 *
 */
public class XMLToken : IDisposable {
	private HandleRef swigCPtr;
	protected bool swigCMemOwn;
	
	internal XMLToken(IntPtr cPtr, bool cMemoryOwn)
	{
		swigCMemOwn = cMemoryOwn;
		swigCPtr    = new HandleRef(this, cPtr);
	}
	
	internal static HandleRef getCPtr(XMLToken obj)
	{
		return (obj == null) ? new HandleRef(null, IntPtr.Zero) : obj.swigCPtr;
	}
	
	internal static HandleRef getCPtrAndDisown (XMLToken obj)
	{
		HandleRef ptr = new HandleRef(null, IntPtr.Zero);
		
		if (obj != null)
		{
			ptr             = obj.swigCPtr;
			obj.swigCMemOwn = false;
		}
		
		return ptr;
	}

  ~XMLToken() {
    Dispose();
  }

  public virtual void Dispose() {
    lock(this) {
      if (swigCPtr.Handle != IntPtr.Zero) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          libsbmlPINVOKE.delete_XMLToken(swigCPtr);
        }
        swigCPtr = new HandleRef(null, IntPtr.Zero);
      }
      GC.SuppressFinalize(this);
    }
  }

  public static bool operator==(XMLToken lhs, XMLToken rhs)
  {
    if((Object)lhs == (Object)rhs)
    {
      return true;
    }

    if( ((Object)lhs == null) || ((Object)rhs == null) )
    {
      return false;
    }

    return (getCPtr(lhs).Handle.ToString() == getCPtr(rhs).Handle.ToString());
  }

  public static bool operator!=(XMLToken lhs, XMLToken rhs)
  {
    return !(lhs == rhs);
  }

  public override bool Equals(Object sb)
  {
    if ( ! (sb is XMLToken) )
    {
      return false;
    }

    return this == (XMLToken)sb;
  }

  public override int GetHashCode()
  {
    return swigCPtr.Handle.ToInt32();
  }

  
  /**
   * Creates a new empty XMLToken.
   */
 public XMLToken() : this(libsbmlPINVOKE.new_XMLToken__SWIG_0(), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
  /**
   * Creates a start element XMLToken with the given set of attributes and
   * namespace declarations.
   *
   * @param triple XMLTriple.
   * @param attributes XMLAttributes, the attributes to set.
   * @param namespaces XMLNamespaces, the namespaces to set.
   * @param line a long integer, the line number (default = 0).
   * @param column a long integer, the column number (default = 0).
   *
   * @if notcpp @docnote @htmlinclude warn-default-args-in-docs.html @endif
   */
 public XMLToken(XMLTriple triple, XMLAttributes attributes, XMLNamespaces namespaces, long line, long column) : this(libsbmlPINVOKE.new_XMLToken__SWIG_1(XMLTriple.getCPtr(triple), XMLAttributes.getCPtr(attributes), XMLNamespaces.getCPtr(namespaces), line, column), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
  /**
   * Creates a start element XMLToken with the given set of attributes and
   * namespace declarations.
   *
   * @param triple XMLTriple.
   * @param attributes XMLAttributes, the attributes to set.
   * @param namespaces XMLNamespaces, the namespaces to set.
   * @param line a long integer, the line number (default = 0).
   * @param column a long integer, the column number (default = 0).
   *
   * @if notcpp @docnote @htmlinclude warn-default-args-in-docs.html @endif
   */
 public XMLToken(XMLTriple triple, XMLAttributes attributes, XMLNamespaces namespaces, long line) : this(libsbmlPINVOKE.new_XMLToken__SWIG_2(XMLTriple.getCPtr(triple), XMLAttributes.getCPtr(attributes), XMLNamespaces.getCPtr(namespaces), line), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
  /**
   * Creates a start element XMLToken with the given set of attributes and
   * namespace declarations.
   *
   * @param triple XMLTriple.
   * @param attributes XMLAttributes, the attributes to set.
   * @param namespaces XMLNamespaces, the namespaces to set.
   * @param line a long integer, the line number (default = 0).
   * @param column a long integer, the column number (default = 0).
   *
   * @if notcpp @docnote @htmlinclude warn-default-args-in-docs.html @endif
   */
 public XMLToken(XMLTriple triple, XMLAttributes attributes, XMLNamespaces namespaces) : this(libsbmlPINVOKE.new_XMLToken__SWIG_3(XMLTriple.getCPtr(triple), XMLAttributes.getCPtr(attributes), XMLNamespaces.getCPtr(namespaces)), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
  /**
   * Creates a start element XMLToken with the given set of attributes.
   *
   * @param triple XMLTriple.
   * @param attributes XMLAttributes, the attributes to set.
   * @param line a long integer, the line number (default = 0).
   * @param column a long integer, the column number (default = 0).
   *
   * @if notcpp @docnote @htmlinclude warn-default-args-in-docs.html @endif
   */
 public XMLToken(XMLTriple triple, XMLAttributes attributes, long line, long column) : this(libsbmlPINVOKE.new_XMLToken__SWIG_4(XMLTriple.getCPtr(triple), XMLAttributes.getCPtr(attributes), line, column), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
  /**
   * Creates a start element XMLToken with the given set of attributes.
   *
   * @param triple XMLTriple.
   * @param attributes XMLAttributes, the attributes to set.
   * @param line a long integer, the line number (default = 0).
   * @param column a long integer, the column number (default = 0).
   *
   * @if notcpp @docnote @htmlinclude warn-default-args-in-docs.html @endif
   */
 public XMLToken(XMLTriple triple, XMLAttributes attributes, long line) : this(libsbmlPINVOKE.new_XMLToken__SWIG_5(XMLTriple.getCPtr(triple), XMLAttributes.getCPtr(attributes), line), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
  /**
   * Creates a start element XMLToken with the given set of attributes.
   *
   * @param triple XMLTriple.
   * @param attributes XMLAttributes, the attributes to set.
   * @param line a long integer, the line number (default = 0).
   * @param column a long integer, the column number (default = 0).
   *
   * @if notcpp @docnote @htmlinclude warn-default-args-in-docs.html @endif
   */
 public XMLToken(XMLTriple triple, XMLAttributes attributes) : this(libsbmlPINVOKE.new_XMLToken__SWIG_6(XMLTriple.getCPtr(triple), XMLAttributes.getCPtr(attributes)), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
  /**
   * Creates an end element XMLToken.
   *
   * @param triple XMLTriple.
   * @param line a long integer, the line number (default = 0).
   * @param column a long integer, the column number (default = 0).
   *
   * @if notcpp @docnote @htmlinclude warn-default-args-in-docs.html @endif
   */
 public XMLToken(XMLTriple triple, long line, long column) : this(libsbmlPINVOKE.new_XMLToken__SWIG_7(XMLTriple.getCPtr(triple), line, column), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
  /**
   * Creates an end element XMLToken.
   *
   * @param triple XMLTriple.
   * @param line a long integer, the line number (default = 0).
   * @param column a long integer, the column number (default = 0).
   *
   * @if notcpp @docnote @htmlinclude warn-default-args-in-docs.html @endif
   */
 public XMLToken(XMLTriple triple, long line) : this(libsbmlPINVOKE.new_XMLToken__SWIG_8(XMLTriple.getCPtr(triple), line), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
  /**
   * Creates an end element XMLToken.
   *
   * @param triple XMLTriple.
   * @param line a long integer, the line number (default = 0).
   * @param column a long integer, the column number (default = 0).
   *
   * @if notcpp @docnote @htmlinclude warn-default-args-in-docs.html @endif
   */
 public XMLToken(XMLTriple triple) : this(libsbmlPINVOKE.new_XMLToken__SWIG_9(XMLTriple.getCPtr(triple)), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
  /**
   * Creates a text XMLToken.
   *
   * @param chars a string, the text to be added to the XMLToken
   * @param line a long integer, the line number (default = 0).
   * @param column a long integer, the column number (default = 0).
   *
   * @if notcpp @docnote @htmlinclude warn-default-args-in-docs.html @endif
   */
 public XMLToken(string chars, long line, long column) : this(libsbmlPINVOKE.new_XMLToken__SWIG_10(chars, line, column), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
  /**
   * Creates a text XMLToken.
   *
   * @param chars a string, the text to be added to the XMLToken
   * @param line a long integer, the line number (default = 0).
   * @param column a long integer, the column number (default = 0).
   *
   * @if notcpp @docnote @htmlinclude warn-default-args-in-docs.html @endif
   */
 public XMLToken(string chars, long line) : this(libsbmlPINVOKE.new_XMLToken__SWIG_11(chars, line), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
  /**
   * Creates a text XMLToken.
   *
   * @param chars a string, the text to be added to the XMLToken
   * @param line a long integer, the line number (default = 0).
   * @param column a long integer, the column number (default = 0).
   *
   * @if notcpp @docnote @htmlinclude warn-default-args-in-docs.html @endif
   */
 public XMLToken(string chars) : this(libsbmlPINVOKE.new_XMLToken__SWIG_12(chars), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
  /**
   * Copy constructor; creates a copy of this XMLToken.
   */
 public XMLToken(XMLToken orig) : this(libsbmlPINVOKE.new_XMLToken__SWIG_13(XMLToken.getCPtr(orig)), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
  /**
   * Creates and returns a deep copy of this XMLToken.
   * 
   * @return a (deep) copy of this XMLToken set.
   */
 public XMLToken clone() {
    IntPtr cPtr = libsbmlPINVOKE.XMLToken_clone(swigCPtr);
    XMLToken ret = (cPtr == IntPtr.Zero) ? null : new XMLToken(cPtr, true);
    return ret;
  }

  
  /**
   * Returns the attributes of this element.
   *
   * @return the XMLAttributes of this XML element.
   */
 public XMLAttributes getAttributes() {
    XMLAttributes ret = new XMLAttributes(libsbmlPINVOKE.XMLToken_getAttributes(swigCPtr), false);
    return ret;
  }

  
  /**
   * Sets an XMLAttributes to this XMLToken.
   * Nothing will be done if this XMLToken is not a start element.
   *
   * @param attributes XMLAttributes to be set to this XMLToken.
   *
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT @endlink
   *
   * @note This function replaces the existing XMLAttributes with the new one.
   */
 public int setAttributes(XMLAttributes attributes) {
    int ret = libsbmlPINVOKE.XMLToken_setAttributes(swigCPtr, XMLAttributes.getCPtr(attributes));
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
  /**
   * Adds an attribute to the attribute set in this XMLToken optionally 
   * with a prefix and URI defining a namespace.
   * Nothing will be done if this XMLToken is not a start element.
   *
   * @param name a string, the local name of the attribute.
   * @param value a string, the value of the attribute.
   * @param namespaceURI a string, the namespace URI of the attribute.
   * @param prefix a string, the prefix of the namespace
   *
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION @endlink
   *
   * @note if local name with the same namespace URI already exists in the
   * attribute set, its value and prefix will be replaced.
   *
   * @if notcpp @docnote @htmlinclude warn-default-args-in-docs.html @endif
   */
 public int addAttr(string name, string value, string namespaceURI, string prefix) {
    int ret = libsbmlPINVOKE.XMLToken_addAttr__SWIG_0(swigCPtr, name, value, namespaceURI, prefix);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
  /**
   * Adds an attribute to the attribute set in this XMLToken optionally 
   * with a prefix and URI defining a namespace.
   * Nothing will be done if this XMLToken is not a start element.
   *
   * @param name a string, the local name of the attribute.
   * @param value a string, the value of the attribute.
   * @param namespaceURI a string, the namespace URI of the attribute.
   * @param prefix a string, the prefix of the namespace
   *
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION @endlink
   *
   * @note if local name with the same namespace URI already exists in the
   * attribute set, its value and prefix will be replaced.
   *
   * @if notcpp @docnote @htmlinclude warn-default-args-in-docs.html @endif
   */
 public int addAttr(string name, string value, string namespaceURI) {
    int ret = libsbmlPINVOKE.XMLToken_addAttr__SWIG_1(swigCPtr, name, value, namespaceURI);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
  /**
   * Adds an attribute to the attribute set in this XMLToken optionally 
   * with a prefix and URI defining a namespace.
   * Nothing will be done if this XMLToken is not a start element.
   *
   * @param name a string, the local name of the attribute.
   * @param value a string, the value of the attribute.
   * @param namespaceURI a string, the namespace URI of the attribute.
   * @param prefix a string, the prefix of the namespace
   *
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION @endlink
   *
   * @note if local name with the same namespace URI already exists in the
   * attribute set, its value and prefix will be replaced.
   *
   * @if notcpp @docnote @htmlinclude warn-default-args-in-docs.html @endif
   */
 public int addAttr(string name, string value) {
    int ret = libsbmlPINVOKE.XMLToken_addAttr__SWIG_2(swigCPtr, name, value);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
  /**
   * Adds an attribute with the given XMLTriple/value pair to the attribute set
   * in this XMLToken.
   * Nothing will be done if this XMLToken is not a start element.
   *
   * @note if local name with the same namespace URI already exists in the 
   * attribute set, its value and prefix will be replaced.
   *
   * @param triple an XMLTriple, the XML triple of the attribute.
   * @param value a string, the value of the attribute.
   *
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION @endlink
   */
 public int addAttr(XMLTriple triple, string value) {
    int ret = libsbmlPINVOKE.XMLToken_addAttr__SWIG_3(swigCPtr, XMLTriple.getCPtr(triple), value);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
  /**
   * Removes an attribute with the given index from the attribute set in
   * this XMLToken.
   * Nothing will be done if this XMLToken is not a start element.
   *
   * @param n an integer the index of the resource to be deleted
   *
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE @endlink
   */
 public int removeAttr(int n) {
    int ret = libsbmlPINVOKE.XMLToken_removeAttr__SWIG_0(swigCPtr, n);
    return ret;
  }

  
  /**
   * Removes an attribute with the given local name and namespace URI from 
   * the attribute set in this XMLToken.
   * Nothing will be done if this XMLToken is not a start element.
   *
   * @param name   a string, the local name of the attribute.
   * @param uri    a string, the namespace URI of the attribute.
   *
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE @endlink
   */
 public int removeAttr(string name, string uri) {
    int ret = libsbmlPINVOKE.XMLToken_removeAttr__SWIG_1(swigCPtr, name, uri);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
  /**
   * Removes an attribute with the given local name and namespace URI from 
   * the attribute set in this XMLToken.
   * Nothing will be done if this XMLToken is not a start element.
   *
   * @param name   a string, the local name of the attribute.
   * @param uri    a string, the namespace URI of the attribute.
   *
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE @endlink
   */
 public int removeAttr(string name) {
    int ret = libsbmlPINVOKE.XMLToken_removeAttr__SWIG_2(swigCPtr, name);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
  /**
   * Removes an attribute with the given XMLTriple from the attribute set 
   * in this XMLToken.  
   * Nothing will be done if this XMLToken is not a start element.
   *
   * @param triple an XMLTriple, the XML triple of the attribute.
   *
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE @endlink
   */
 public int removeAttr(XMLTriple triple) {
    int ret = libsbmlPINVOKE.XMLToken_removeAttr__SWIG_3(swigCPtr, XMLTriple.getCPtr(triple));
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
  /**
   * Clears (deletes) all attributes in this XMLToken.
   * Nothing will be done if this XMLToken is not a start element.
   *
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION @endlink
   */
 public int clearAttributes() {
    int ret = libsbmlPINVOKE.XMLToken_clearAttributes(swigCPtr);
    return ret;
  }

  
  /**
   * Return the index of an attribute with the given local name and namespace URI.
   *
   * @param name a string, the local name of the attribute.
   * @param uri  a string, the namespace URI of the attribute.
   *
   * @return the index of an attribute with the given local name and namespace URI, 
   * or <c>-1</c> if not present.
   *
   * @if notcpp @docnote @htmlinclude warn-default-args-in-docs.html @endif
   */
 public int getAttrIndex(string name, string uri) {
    int ret = libsbmlPINVOKE.XMLToken_getAttrIndex__SWIG_0(swigCPtr, name, uri);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
  /**
   * Return the index of an attribute with the given local name and namespace URI.
   *
   * @param name a string, the local name of the attribute.
   * @param uri  a string, the namespace URI of the attribute.
   *
   * @return the index of an attribute with the given local name and namespace URI, 
   * or <c>-1</c> if not present.
   *
   * @if notcpp @docnote @htmlinclude warn-default-args-in-docs.html @endif
   */
 public int getAttrIndex(string name) {
    int ret = libsbmlPINVOKE.XMLToken_getAttrIndex__SWIG_1(swigCPtr, name);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
  /**
   * Return the index of an attribute with the given XMLTriple.
   *
   * @param triple an XMLTriple, the XML triple of the attribute for which 
   *        the index is required.
   *
   * @return the index of an attribute with the given XMLTriple, or <c>-1</c> if not present.
   */
 public int getAttrIndex(XMLTriple triple) {
    int ret = libsbmlPINVOKE.XMLToken_getAttrIndex__SWIG_2(swigCPtr, XMLTriple.getCPtr(triple));
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
  /**
   * Return the number of attributes in the attributes set.
   *
   * @return the number of attributes in the attributes set in this XMLToken.
   */
 public int getAttributesLength() {
    int ret = libsbmlPINVOKE.XMLToken_getAttributesLength(swigCPtr);
    return ret;
  }

  
  /**
   * Return the local name of an attribute in the attributes set in this 
   * XMLToken (by position).
   *
   * @param index an integer, the position of the attribute whose local name 
   * is required.
   *
   * @return the local name of an attribute in this list (by position).  
   *
   * @note If index
   * is out of range, an empty string will be returned.  Use
   * XMLToken::hasAttr(@if java int index@endif)
   * to test for the attribute existence.
   */
 public string getAttrName(int index) {
    string ret = libsbmlPINVOKE.XMLToken_getAttrName(swigCPtr, index);
    return ret;
  }

  
  /**
   * Return the prefix of an attribute in the attribute set in this 
   * XMLToken (by position).
   *
   * @param index an integer, the position of the attribute whose prefix is 
   * required.
   *
   * @return the namespace prefix of an attribute in the attribute set
   * (by position).  
   *
   * @note If index is out of range, an empty string will be returned. Use
   * XMLToken::hasAttr(@if java int index@endif) to test
   * for the attribute existence.
   */
 public string getAttrPrefix(int index) {
    string ret = libsbmlPINVOKE.XMLToken_getAttrPrefix(swigCPtr, index);
    return ret;
  }

  
  /**
   * Return the prefixed name of an attribute in the attribute set in this 
   * XMLToken (by position).
   *
   * @param index an integer, the position of the attribute whose prefixed 
   * name is required.
   *
   * @return the prefixed name of an attribute in the attribute set 
   * (by position).  
   *
   * @note If index is out of range, an empty string will be returned.  Use
   * XMLToken::hasAttr(@if java int index@endif) to test
   * for attribute existence.
   */
 public string getAttrPrefixedName(int index) {
    string ret = libsbmlPINVOKE.XMLToken_getAttrPrefixedName(swigCPtr, index);
    return ret;
  }

  
  /**
   * Return the namespace URI of an attribute in the attribute set in this 
   * XMLToken (by position).
   *
   * @param index an integer, the position of the attribute whose namespace 
   * URI is required.
   *
   * @return the namespace URI of an attribute in the attribute set (by position).
   *
   * @note If index is out of range, an empty string will be returned.  Use
   * XMLToken::hasAttr(@if java int index@endif) to test
   * for attribute existence.
   */
 public string getAttrURI(int index) {
    string ret = libsbmlPINVOKE.XMLToken_getAttrURI(swigCPtr, index);
    return ret;
  }

  
  /**
   * Return the value of an attribute in the attribute set in this XMLToken  
   * (by position).
   *
   * @param index an integer, the position of the attribute whose value is 
   * required.
   *
   * @return the value of an attribute in the attribute set (by position).  
   *
   * @note If index is out of range, an empty string will be returned. Use
   * XMLToken::hasAttr(@if java int index@endif) to test
   * for attribute existence.
   */
 public string getAttrValue(int index) {
    string ret = libsbmlPINVOKE.XMLToken_getAttrValue__SWIG_0(swigCPtr, index);
    return ret;
  }

  
  /**
   * Return a value of an attribute with the given local name and namespace URI.
   *
   * @param name a string, the local name of the attribute whose value is required.
   * @param uri  a string, the namespace URI of the attribute.
   *
   * @return The attribute value as a string.  
   *
   * @note If an attribute with the 
   * given local name and namespace URI does not exist, an empty string will be 
   * returned.  
   * Use XMLToken::hasAttr(@if java String name, String uri@endif)
   * to test for attribute existence.
   *
   * @if notcpp @docnote @htmlinclude warn-default-args-in-docs.html @endif
   */
 public string getAttrValue(string name, string uri) {
    string ret = libsbmlPINVOKE.XMLToken_getAttrValue__SWIG_1(swigCPtr, name, uri);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
  /**
   * Return a value of an attribute with the given local name and namespace URI.
   *
   * @param name a string, the local name of the attribute whose value is required.
   * @param uri  a string, the namespace URI of the attribute.
   *
   * @return The attribute value as a string.  
   *
   * @note If an attribute with the 
   * given local name and namespace URI does not exist, an empty string will be 
   * returned.  
   * Use XMLToken::hasAttr(@if java String name, String uri@endif)
   * to test for attribute existence.
   *
   * @if notcpp @docnote @htmlinclude warn-default-args-in-docs.html @endif
   */
 public string getAttrValue(string name) {
    string ret = libsbmlPINVOKE.XMLToken_getAttrValue__SWIG_2(swigCPtr, name);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
  /**
   * Return a value of an attribute with the given XMLTriple.
   *
   * @param triple an XMLTriple, the XML triple of the attribute whose 
   *        value is required.
   *
   * @return The attribute value as a string.  
   *
   * @note If an attribute with the
   * given XMLTriple does not exist, an empty string will be returned.  
   * Use XMLToken::hasAttr(@if java XMLTriple triple@endif)
   * to test for attribute existence.
   */
 public string getAttrValue(XMLTriple triple) {
    string ret = libsbmlPINVOKE.XMLToken_getAttrValue__SWIG_3(swigCPtr, XMLTriple.getCPtr(triple));
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
  /**
   * Predicate returning @c true or @c false depending on whether
   * an attribute with the given index exists in the attribute set in this 
   * XMLToken.
   *
   * @param index an integer, the position of the attribute.
   *
   * @return @c true if an attribute with the given index exists in the attribute 
   * set in this XMLToken, @c false otherwise.
   */
 public bool hasAttr(int index) {
    bool ret = libsbmlPINVOKE.XMLToken_hasAttr__SWIG_0(swigCPtr, index);
    return ret;
  }

  
  /**
   * Predicate returning @c true or @c false depending on whether
   * an attribute with the given local name and namespace URI exists 
   * in the attribute set in this XMLToken.
   *
   * @param name a string, the local name of the attribute.
   * @param uri  a string, the namespace URI of the attribute.
   *
   * @return @c true if an attribute with the given local name and namespace 
   * URI exists in the attribute set in this XMLToken, @c false otherwise.
   *
   * @if notcpp @docnote @htmlinclude warn-default-args-in-docs.html @endif
   */
 public bool hasAttr(string name, string uri) {
    bool ret = libsbmlPINVOKE.XMLToken_hasAttr__SWIG_1(swigCPtr, name, uri);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
  /**
   * Predicate returning @c true or @c false depending on whether
   * an attribute with the given local name and namespace URI exists 
   * in the attribute set in this XMLToken.
   *
   * @param name a string, the local name of the attribute.
   * @param uri  a string, the namespace URI of the attribute.
   *
   * @return @c true if an attribute with the given local name and namespace 
   * URI exists in the attribute set in this XMLToken, @c false otherwise.
   *
   * @if notcpp @docnote @htmlinclude warn-default-args-in-docs.html @endif
   */
 public bool hasAttr(string name) {
    bool ret = libsbmlPINVOKE.XMLToken_hasAttr__SWIG_2(swigCPtr, name);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
  /**
   * Predicate returning @c true or @c false depending on whether
   * an attribute with the given XML triple exists in the attribute set in 
   * this XMLToken 
   *
   * @param triple an XMLTriple, the XML triple of the attribute 
   *
   * @return @c true if an attribute with the given XML triple exists
   * in the attribute set in this XMLToken, @c false otherwise.
   *
   */
 public bool hasAttr(XMLTriple triple) {
    bool ret = libsbmlPINVOKE.XMLToken_hasAttr__SWIG_3(swigCPtr, XMLTriple.getCPtr(triple));
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
  /**
   * Predicate returning @c true or @c false depending on whether 
   * the attribute set in this XMLToken set is empty.
   * 
   * @return @c true if the attribute set in this XMLToken is empty, 
   * @c false otherwise.
   */
 public bool isAttributesEmpty() {
    bool ret = libsbmlPINVOKE.XMLToken_isAttributesEmpty(swigCPtr);
    return ret;
  }

  
  /**
   * Returns the XML namespace declarations for this XML element.
   *
   * @return the XML namespace declarations for this XML element.
   */
 public XMLNamespaces getNamespaces() {
    XMLNamespaces ret = new XMLNamespaces(libsbmlPINVOKE.XMLToken_getNamespaces(swigCPtr), false);
    return ret;
  }

  
  /**
   * Sets an XMLnamespaces to this XML element.
   * Nothing will be done if this XMLToken is not a start element.
   *
   * @param namespaces XMLNamespaces to be set to this XMLToken.
   *
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT @endlink
   *
   * @note This function replaces the existing XMLNamespaces with the new one.
   */
 public int setNamespaces(XMLNamespaces namespaces) {
    int ret = libsbmlPINVOKE.XMLToken_setNamespaces(swigCPtr, XMLNamespaces.getCPtr(namespaces));
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
  /**
   * Appends an XML namespace prefix and URI pair to this XMLToken.
   * If there is an XML namespace with the given prefix in this XMLToken, 
   * then the existing XML namespace will be overwritten by the new one.
   *
   * Nothing will be done if this XMLToken is not a start element.
   *
   * @param uri a string, the uri for the namespace
   * @param prefix a string, the prefix for the namespace
   *
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION @endlink
   *
   * @if notcpp @docnote @htmlinclude warn-default-args-in-docs.html @endif
   */
 public int addNamespace(string uri, string prefix) {
    int ret = libsbmlPINVOKE.XMLToken_addNamespace__SWIG_0(swigCPtr, uri, prefix);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
  /**
   * Appends an XML namespace prefix and URI pair to this XMLToken.
   * If there is an XML namespace with the given prefix in this XMLToken, 
   * then the existing XML namespace will be overwritten by the new one.
   *
   * Nothing will be done if this XMLToken is not a start element.
   *
   * @param uri a string, the uri for the namespace
   * @param prefix a string, the prefix for the namespace
   *
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION @endlink
   *
   * @if notcpp @docnote @htmlinclude warn-default-args-in-docs.html @endif
   */
 public int addNamespace(string uri) {
    int ret = libsbmlPINVOKE.XMLToken_addNamespace__SWIG_1(swigCPtr, uri);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
  /**
   * Removes an XML Namespace stored in the given position of the XMLNamespaces
   * of this XMLToken.
   * Nothing will be done if this XMLToken is not a start element.
   *
   * @param index an integer, position of the removed namespace.
   *
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE @endlink
   */
 public int removeNamespace(int index) {
    int ret = libsbmlPINVOKE.XMLToken_removeNamespace__SWIG_0(swigCPtr, index);
    return ret;
  }

  
  /**
   * Removes an XML Namespace with the given prefix.
   * Nothing will be done if this XMLToken is not a start element.
   *
   * @param prefix a string, prefix of the required namespace.
   *
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE @endlink
   */
 public int removeNamespace(string prefix) {
    int ret = libsbmlPINVOKE.XMLToken_removeNamespace__SWIG_1(swigCPtr, prefix);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
  /**
   * Clears (deletes) all XML namespace declarations in the XMLNamespaces of
   * this XMLToken.
   * Nothing will be done if this XMLToken is not a start element.
   *
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION @endlink
   */
 public int clearNamespaces() {
    int ret = libsbmlPINVOKE.XMLToken_clearNamespaces(swigCPtr);
    return ret;
  }

  
  /**
   * Look up the index of an XML namespace declaration by URI.
   *
   * @param uri a string, uri of the required namespace.
   *
   * @return the index of the given declaration, or <c>-1</c> if not present.
   */
 public int getNamespaceIndex(string uri) {
    int ret = libsbmlPINVOKE.XMLToken_getNamespaceIndex(swigCPtr, uri);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
  /**
   * Look up the index of an XML namespace declaration by prefix.
   *
   * @param prefix a string, prefix of the required namespace.
   *
   * @return the index of the given declaration, or <c>-1</c> if not present.
   */
 public int getNamespaceIndexByPrefix(string prefix) {
    int ret = libsbmlPINVOKE.XMLToken_getNamespaceIndexByPrefix(swigCPtr, prefix);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
  /**
   * Returns the number of XML namespaces stored in the XMLNamespaces 
   * of this XMLToken.
   *
   * @return the number of namespaces in this list.
   */
 public int getNamespacesLength() {
    int ret = libsbmlPINVOKE.XMLToken_getNamespacesLength(swigCPtr);
    return ret;
  }

  
  /**
   * Look up the prefix of an XML namespace declaration by position.
   *
   * Callers should use getNamespacesLength() to find out how many 
   * namespaces are stored in the XMLNamespaces.
   *
   * @param index an integer, position of the required prefix.
   *
   * @return the prefix of an XML namespace declaration in the XMLNamespaces 
   * (by position).  
   *
   * @note If index is out of range, an empty string will be
   * returned.
   *
   * @see getNamespacesLength()
   */
 public string getNamespacePrefix(int index) {
    string ret = libsbmlPINVOKE.XMLToken_getNamespacePrefix__SWIG_0(swigCPtr, index);
    return ret;
  }

  
  /**
   * Look up the prefix of an XML namespace declaration by its URI.
   *
   * @param uri a string, the URI of the prefix being sought
   *
   * @return the prefix of an XML namespace declaration given its URI.  
   *
   * @note If @p uri does not exist, an empty string will be returned.
   */
 public string getNamespacePrefix(string uri) {
    string ret = libsbmlPINVOKE.XMLToken_getNamespacePrefix__SWIG_1(swigCPtr, uri);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
  /**
   * Look up the URI of an XML namespace declaration by its position.
   *
   * @param index an integer, position of the required URI.
   *
   * @return the URI of an XML namespace declaration in the XMLNamespaces
   * (by position).  
   *
   * @note If @p index is out of range, an empty string will be
   * returned.
   *
   * @see getNamespacesLength()
   */
 public string getNamespaceURI(int index) {
    string ret = libsbmlPINVOKE.XMLToken_getNamespaceURI__SWIG_0(swigCPtr, index);
    return ret;
  }

  
  /**
   * Look up the URI of an XML namespace declaration by its prefix.
   *
   * @param prefix a string, the prefix of the required URI
   *
   * @return the URI of an XML namespace declaration given its prefix.  
   *
   * @note If @p prefix does not exist, an empty string will be returned.
   *
   * @if notcpp @docnote @htmlinclude warn-default-args-in-docs.html @endif
   */
 public string getNamespaceURI(string prefix) {
    string ret = libsbmlPINVOKE.XMLToken_getNamespaceURI__SWIG_1(swigCPtr, prefix);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
  /**
   * Look up the URI of an XML namespace declaration by its prefix.
   *
   * @param prefix a string, the prefix of the required URI
   *
   * @return the URI of an XML namespace declaration given its prefix.  
   *
   * @note If @p prefix does not exist, an empty string will be returned.
   *
   * @if notcpp @docnote @htmlinclude warn-default-args-in-docs.html @endif
   */
 public string getNamespaceURI() {
    string ret = libsbmlPINVOKE.XMLToken_getNamespaceURI__SWIG_2(swigCPtr);
    return ret;
  }

  
  /**
   * Predicate returning @c true or @c false depending on whether 
   * the XMLNamespaces of this XMLToken is empty.
   * 
   * @return @c true if the XMLNamespaces of this XMLToken is empty, 
   * @c false otherwise.
   */
 public bool isNamespacesEmpty() {
    bool ret = libsbmlPINVOKE.XMLToken_isNamespacesEmpty(swigCPtr);
    return ret;
  }

  
  /**
   * Predicate returning @c true or @c false depending on whether 
   * an XML Namespace with the given URI is contained in the XMLNamespaces of
   * this XMLToken.
   * 
   * @param uri a string, the uri for the namespace
   *
   * @return @c true if an XML Namespace with the given URI is contained in the
   * XMLNamespaces of this XMLToken,  @c false otherwise.
   */
 public bool hasNamespaceURI(string uri) {
    bool ret = libsbmlPINVOKE.XMLToken_hasNamespaceURI(swigCPtr, uri);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
  /**
   * Predicate returning @c true or @c false depending on whether 
   * an XML Namespace with the given prefix is contained in the XMLNamespaces of
   * this XMLToken.
   *
   * @param prefix a string, the prefix for the namespace
   * 
   * @return @c true if an XML Namespace with the given URI is contained in the
   * XMLNamespaces of this XMLToken, @c false otherwise.
   */
 public bool hasNamespacePrefix(string prefix) {
    bool ret = libsbmlPINVOKE.XMLToken_hasNamespacePrefix(swigCPtr, prefix);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
  /**
   * Predicate returning @c true or @c false depending on whether 
   * an XML Namespace with the given uri/prefix pair is contained in the 
   * XMLNamespaces ofthis XMLToken.
   *
   * @param uri a string, the uri for the namespace
   * @param prefix a string, the prefix for the namespace
   * 
   * @return @c true if an XML Namespace with the given uri/prefix pair is 
   * contained in the XMLNamespaces of this XMLToken,  @c false otherwise.
   */
 public bool hasNamespaceNS(string uri, string prefix) {
    bool ret = libsbmlPINVOKE.XMLToken_hasNamespaceNS(swigCPtr, uri, prefix);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
  /**
   * Sets the XMLTripe (name, uri and prefix) of this XML element.
   * Nothing will be done if this XML element is a text node.
   *
   * @param triple XMLTriple to be added to this XML element.
   *
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INVALID_XML_OPERATION LIBSBML_INVALID_XML_OPERATION @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT @endlink
   */
 public int setTriple(XMLTriple triple) {
    int ret = libsbmlPINVOKE.XMLToken_setTriple(swigCPtr, XMLTriple.getCPtr(triple));
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
  /**
   * Returns the (unqualified) name of this XML element.
   *
   * @return the (unqualified) name of this XML element.
   */
 public string getName() {
    string ret = libsbmlPINVOKE.XMLToken_getName(swigCPtr);
    return ret;
  }

  
  /**
   * Returns the namespace prefix of this XML element.
   *
   * @return the namespace prefix of this XML element.  
   *
   * @note If no prefix
   * exists, an empty string will be return.
   */
 public string getPrefix() {
    string ret = libsbmlPINVOKE.XMLToken_getPrefix(swigCPtr);
    return ret;
  }

  
  /**
   * Returns the namespace URI of this XML element.
   *
   * @return the namespace URI of this XML element.
   */
 public string getURI() {
    string ret = libsbmlPINVOKE.XMLToken_getURI(swigCPtr);
    return ret;
  }

  
  /**
   * Returns the text of this element.
   *
   * @return the characters of this XML text.
   */
 public string getCharacters() {
    string ret = libsbmlPINVOKE.XMLToken_getCharacters(swigCPtr);
    return ret;
  }

  
  /**
   * Appends characters to this XML text content.
   *
   * @param chars string, characters to append
   *
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   */
 public int append(string chars) {
    int ret = libsbmlPINVOKE.XMLToken_append(swigCPtr, chars);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
  /**
   * Returns the column at which this XMLToken occurred in the input
   * document or data stream.
   *
   * @return the column at which this XMLToken occurred.
   */
 public long getColumn() { return (long)libsbmlPINVOKE.XMLToken_getColumn(swigCPtr); }

  
  /**
   * Returns the line at which this XMLToken occurred in the input document
   * or data stream.
   *
   * @return the line at which this XMLToken occurred.
   */
 public long getLine() { return (long)libsbmlPINVOKE.XMLToken_getLine(swigCPtr); }

  
  /**
   * Predicate returning @c true or @c false depending on whether 
   * this XMLToken is an XML element.
   * 
   * @return @c true if this XMLToken is an XML element, @c false otherwise.
   */
 public bool isElement() {
    bool ret = libsbmlPINVOKE.XMLToken_isElement(swigCPtr);
    return ret;
  }

  
  /**
   * Predicate returning @c true or @c false depending on whether 
   * this XMLToken is an XML end element.
   * 
   * @return @c true if this XMLToken is an XML end element, @c false otherwise.
   */
 public bool isEnd() {
    bool ret = libsbmlPINVOKE.XMLToken_isEnd(swigCPtr);
    return ret;
  }

  
  /**
   * Predicate returning @c true or @c false depending on whether 
   * this XMLToken is an XML end element for the given start element.
   * 
   * @param element XMLToken, element for which query is made.
   *
   * @return @c true if this XMLToken is an XML end element for the given
   * XMLToken start element, @c false otherwise.
   */
 public bool isEndFor(XMLToken element) {
    bool ret = libsbmlPINVOKE.XMLToken_isEndFor(swigCPtr, XMLToken.getCPtr(element));
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
  /**
   * Predicate returning @c true or @c false depending on whether 
   * this XMLToken is an end of file marker.
   * 
   * @return @c true if this XMLToken is an end of file (input) marker, @c false
   * otherwise.
   */
 public bool isEOF() {
    bool ret = libsbmlPINVOKE.XMLToken_isEOF(swigCPtr);
    return ret;
  }

  
  /**
   * Predicate returning @c true or @c false depending on whether 
   * this XMLToken is an XML start element.
   * 
   * @return @c true if this XMLToken is an XML start element, @c false otherwise.
   */
 public bool isStart() {
    bool ret = libsbmlPINVOKE.XMLToken_isStart(swigCPtr);
    return ret;
  }

  
  /**
   * Predicate returning @c true or @c false depending on whether 
   * this XMLToken is an XML text element.
   * 
   * @return @c true if this XMLToken is an XML text element, @c false otherwise.
   */
 public bool isText() {
    bool ret = libsbmlPINVOKE.XMLToken_isText(swigCPtr);
    return ret;
  }

  
  /**
   * Declares this XML start element is also an end element.
   *
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   */
 public int setEnd() {
    int ret = libsbmlPINVOKE.XMLToken_setEnd(swigCPtr);
    return ret;
  }

  
  /**
   * Declares this XMLToken is an end-of-file (input) marker.
   *
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   */
 public int setEOF() {
    int ret = libsbmlPINVOKE.XMLToken_setEOF(swigCPtr);
    return ret;
  }

  
  /**
   * Declares this XML start/end element is no longer an end element.
   *
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   */
 public int unsetEnd() {
    int ret = libsbmlPINVOKE.XMLToken_unsetEnd(swigCPtr);
    return ret;
  }

  
  /**
   * Prints a string representation of the underlying token stream, for
   * debugging purposes.
   */
 public string toString() {
    string ret = libsbmlPINVOKE.XMLToken_toString(swigCPtr);
    return ret;
  }

}

}
