// $Id: mail.pike,v 1.4 1999/01/18 16:16:52 linus Exp $
// A module for presenting mail.
// 
// Author: Linus Tolke, Epact
//
#include <module.h>
inherit "module";

inherit "http";

import Array;

#define SURROUND(str, tag)      "<" + tag + ">\n" + str + "\n</" + tag + ">\n"

#define HEAD(str)       SURROUND(str, "head")
#define TITLE(str)      SURROUND(str, "title")
#define BODY(str)       SURROUND(str, "body")
#define H1(str)		SURROUND(str, "h1")
#define PRE(str)	SURROUND(str, "pre")

mixed * 
register_module()
{
    return ({ MODULE_FILE_EXTENSION,
	      "Mail presentation.",
	      "Generate a html-page from a saved email. " +
	      "Every mail has to be saved in a file by its own."
		  });
}


void
create()
{
    defvar("extensions", ({ "mail", }), "Extensions", TYPE_STRING_LIST,
           "The extensions. "
	   + "All files with the extensions given in this list will be "
	   + "modified by this module.");
    defvar("ignoredheaders", ({ 
	"content-disposition: ",
	"content-id: ",
	"content-transfer-encoding: ",
	"content-type: ",
	"lines: ",
	"message-id:",
	"mime-version: ",
	"precedence: ",
	"received: ",
	"references: ",
	"return-path: ",
	"sender: ",
	"status: ",
	"x-authentication-warning: ",
	"x-from-line: ",
	"x-gnus-article-number: ",
	"x-keywords: ",
	"x-loop: ",
	"x-mailer: ",
	"x-mime-autoconverted: ",
	"x-status: ",
	"x-uid: ",
	"xref: ",
	}), "Ignored header lines.", TYPE_STRING_LIST,
	   "These header lines are ignored in the presentation of the mail. "
	   + "The comparison is made against the beginning of the header "
	   + "line.");
    defvar("strongheaders", ({
	"subject: ",
	}), "Strong header lines.", TYPE_STRING_LIST,
	   "These header lines are shown using strong in the presentation "
	   + "of the mail.");
}

array(string)
query_file_extensions()
{
    return query("extensions");
}

string
enable_links(string input)
{
    string sofar;
    string moresofar;
    string what;
    string rest;

    sofar = "";

    while (sscanf(input,
		  "%shttp://%[a-zA-Z/.?#0-9~%]%s", moresofar, what, rest)
	   == 3)
    {
	sofar += moresofar;
	sofar += "<a href=\"http://" + what + "\">http://" + what + "</a>";
	input = rest;
    }

    return sofar + input;
}


string
unpack_quoted_printable(string input)
{
    string sofar;
    string moresofar;
    string what;
    string rest;

    sofar = "";

    while (sscanf(input, "%s=%s", moresofar, rest) == 2)
    {
	if (strlen(rest) == 0)
	{
	    input = rest;
	    break;
	}

	sofar += moresofar;
	if (rest[0..0] == "\n")
	{
	    input = rest[1..strlen(rest)];
	    continue;
	}

	if (strlen(rest) < 2)
	{
	    input = rest;
	    break;
	}

	if (rest[0..1] == "\r\n")
	{
	    input = rest[2..strlen(rest)];
	    continue;
	}

	int msn, lsn;
	if (sscanf(rest[0..0], "%x", msn) == 1
	    && sscanf(rest[1..1], "%x", lsn) == 1)
	{
	    sofar += sprintf("%c", msn * 16 + lsn);
	    rest = rest[2..strlen(rest)];
	}
	else
	{
	    sofar += rest[0..0];
	    rest = rest[1..strlen(rest)];	    
	}
		
	input = rest;
    }

    return sofar + input;
}



string title;

mapping
handle_file_extension(object file, string extension, object request_id)
{
    string data = file->read(0x7ffffff);

    if (request_id->variables["dump"]
	&& request_id->variables["dump"] == "yes")
    {
	return http_string_answer(data, "text/plain");
    }

    string * headerlines = ({ });
    string rest = data;

    string lastline = "*";

    int quoted_printable = 0;

    while (lastline != ""
	   && sscanf(rest, "%s\n%s", lastline, rest) == 2)
    {
	if (lastline == "")
	    break;

	if (lower_case(lastline)
	    == "content-transfer-encoding: quoted-printable")
	{
	    quoted_printable = 1;
	}

	if (lastline[0] == '\t'
	    || lastline [0] == ' ')
	{
	    headerlines[sizeof(headerlines) - 1] += lastline;
	}
	else
	    headerlines += ({ lastline });
    }

    title = headerlines[0];

    headerlines = filter(headerlines, lambda(string line) {
	string lowline = lower_case(line);

	for (int i = 0; i < sizeof(query("ignoredheaders")); i++)
	{
	    string header = lower_case(query("ignoredheaders")[i]);

	    if (lowline[..strlen(header) - 1] == header)
		return 0;
	}
	return 1;
    });

    headerlines = map(headerlines, lambda(string line) {
	string lowline = lower_case(line);

	for (int i = 0; i < sizeof(query("strongheaders")); i++)
	{
	    string header = lower_case(query("strongheaders")[i]);

	    if (lowline[..strlen(header) - 1] == header)
		return "<strong>" + line + "</strong><br>\n";
	}

	return line + "<br>\n";
    });


    if (quoted_printable)
	rest = unpack_quoted_printable(rest);

    rest = enable_links(rest);

    string bottom = "\n<hr>\n"
	+ "This mail was formatted.\n"
	+ "You can see <A HREF=\"" + request_id->raw_url + "?dump=yes\">the original mail</A>"
	+ " if you want.\n";

    return http_string_answer(HEAD(TITLE(title))
			      + BODY((headerlines * "\n")
				     + PRE(rest)
				     + bottom));
}
