#include <module.h>
#include <stdio.h>
#include <simulate.h>
inherit "module";
#ifdef ROXEN
inherit "roxenlib";
#else
#define roxen spinner
inherit "spiderlib";
#endif
#define multiset list

mapping rooms=([]);
mapping users=([]);

#define HEAD2(X) "<html><head><title>"+X+"</title></head>\n\
<body bgcolor=black text=white LINK=#ffee30 ALINK=#FF5500 VLINK=#ff6666>\n\
<font color=#00aaff><h1 align=center>"+X+"</h1></font>\n\n"

#define HEAD(X) HEAD2("ICS: "+X)
void send_message(mixed room, string|object id, string message);

void create()
{
  defvar("mountpoint", "/chat/", "Mountpoint", TYPE_LOCATION,
         "This is where the module will be inserted in the "+
         "namespace of your server.");

  defvar("searchpath", "NONE", "Icon Searchpath", TYPE_DIR,
         "This is where the module will find the icons that people "
         "can use as \"faces\".");
  defvar("savedir", "NONE", "Savedir", TYPE_DIR,
         "The directory where the users profiles will be saved.");
  defvar("chatrooms", "default=The Default Room", "Available Chatrooms",
         TYPE_TEXT_FIELD,
         "This is a list of all chatrooms that will be made available "
         "to the visitiors. The syntax is:\n"
         "<pre>"
         "      short=Full name\n"
         "      test=Test room\n</pre>");
}


mixed *register_module()
{
  return ({
    MODULE_LOCATION,
    "Internet Conferencing System",
      ("A web based chat system, which is much faster than all "
       "the other ones, using icky CGI-scripts. It has support for "
       "multiple chat rooms and personal messages. ")
    });
}

string iconpath, savedir;


string query_location()
{
  return QUERY(mountpoint);
}
void save_rooms() {}

int load_user(string user)
{
  mapping u_tmp;
  if(users[user])
    return 1;
  string f = read_file(savedir+user);
  if(f && strlen(f))
    u_tmp = decode_value(f);
  if(u_tmp && sizeof(u_tmp))
  {
    users[user] = u_tmp;
    return 1;
  } else
    return 0;
}

void save_user(string user)
{
  if(users[user]->modified > users[user]->saved) {
    users[user]->saved = time();
    rm(savedir+user);
    write_file(savedir+user, encode_value(users[user]));
  }
}

void check_idle()
{
  mixed room;
  string u;
  if(sizeof(rooms)) {
    array bar = indices(rooms);
    int e;
    for(e = 0; e < sizeof(rooms); e++) {
      room = bar[e];
      array foo = indices(rooms[room]->users);
      int i;
      for(i = 0; i < sizeof(foo); i++) {
        u = foo[i];
        if((users[u]->action + 300) < time()) {
          if(objectp(rooms[room]->users[u])) {
            rooms[room]->users[u]->
              write("<h1 align=center>You have idled "
                    "for too long time!<br><a href=frame "
                    "target=_top>Click here to enter the room"
                    " again!</h1>");
            rooms[room]->users[u]->close();
            destruct(rooms[room]->users[u]);
            rooms[room]->users[u] = 0;
          }
          rooms[room]->users -= ([u:0]);
          send_message(room, u,
                       "Darn, now I have been idle for too long time! "
                       "Bye, bye!");
          save_user(u);
        }
      }
    }
  }
  remove_call_out(check_idle);
  call_out(check_idle, 60);
}

void start()
{
  mixed room;
  string u;
  if(sizeof(rooms)) {
    array bar = indices(rooms);
    int e;
    for(e = 0; e < sizeof(rooms); e++) {
      room = bar[e];
      array foo = indices(rooms[room]->users);
      int i;
      for(i = 0; i < sizeof(foo); i++) {
        u = foo[i];
        if(objectp(rooms[room]->users[u])) {
          rooms[room]->users[u]->write("<h1 align=center>Module "
                                       "reloaded or variables "
                                       "changed. Closing down."
                                       "<br><a href=frame "
                                       "target=_top>Click here to enter the "
                                       "room again!</h1>");
          rooms[room]->users[u]->close();
          destruct(rooms[room]->users[u]);
          rooms[room]->users[u] = 1;
        }
      }
    }
    foreach(indices(users), u)
      save_user(u);
    save_rooms();
  }
  iconpath = QUERY(searchpath);
  savedir = QUERY(savedir);
  rooms = ([]);
  foreach(QUERY(chatrooms)/"\n", room) {
    room = room/"=";
    room[0] -= " ";
    if(sizeof(room) > 1)
    {
      rooms[room[0]] = (["name": room[1..]*"=",
                        "users": ([]) ]);
    }
  }
  remove_call_out(check_idle);
  call_out(check_idle, 60);
}

#define UV(X) (user ? users[user]->X : "")

string ID_form(void|string user)
{
  string out;
  array files;
  int images;
  if(user && !load_user(user))
    user = 0;
  out = sprintf("<p><form method=post action=%s>\n"
                "<pre><b>"
                "*Name:     <input size=30 name=\"name\" value=\"%s\">"
                "  *Email:      <input size=30 name=email value=\"%s\">\n"
                "Homepage:  <input size=30 name=www value=\"%s\">"
                "  *Login ID:   "+
                (user || "<input size=30 name=login>") +"\n"
                "*Password: <input type=password size=30 name=pw value=\"\">"
                "  *Verify PW:  <input type=password size=30 name=pw2 "
                "value=\"\">\n</b></pre><p>", user ? "pref2": "new2",
                UV(name), UV(email), UV(www));
  files = get_dir(iconpath);
  if(files && sizeof(files))
  {
    string f;

    foreach(sort_array(files), f) {
      if(f[-1] != '~')
      {
        if(!images++)
          out += "<b>To submit the form, click on the image you want:</b><p>";

        out += sprintf("<input type=image src=%s/face/%s border=%d alt=\"%s\""
                       "name=\"icon:%s:\">\n", query_location(), f,
                       f == UV(icon) ? 1 : 0, f, f);
      }

    }
  }
  if(!images)
    out += "<input type=submit value=\"Submit form\">";

  return out +"</form>";
}

#define OK(x) (v->x && strlen(v->x))

int match_passwd(string org, string try)
{
  if(!strlen(org))   return 1;
  if(crypt(try, org)) return 1;
}

int valid_user(array auth)
{
  if(!load_user(auth[0]))
    return 0;
  return match_passwd(users[auth[0]]->password, auth[1]);
}

void send_message(string room, mixed id, string message)
{
  mapping v;
  string u;
  array rec;
  if(stringp(id))
    id = (["auth": ({id}), "variables":([]) ]);
  v=id->variables;
  if(v->recipient)
    rec = v->recipient / "\0";


  load_user(id->auth[0]);
  message = replace(message, ({ "&", "<", ">"}),
                    ({"&amp;", "&lt;", "&gt;"}));
  if(rec && sizeof(rec)) {
    message =
      sprintf("<hr><img align=center src=../../face/%s hspace=5>"
              "<b>Personal message from <a target=finger "
              "href=../../finger/%s>%s</a> (%s) "
              "at %s:</b>\n<br><pre>%s</pre><P><BR><P>\n",
              (users[id->auth[0]]->icon), id->auth[0],
              users[id->auth[0]]->name, capitalize(id->auth[0]),
              ctime(time()), message);
  } else {
    message =
      sprintf("<hr><img align=center src=../../face/%s hspace=5>"
              "<b>Broadcast from <a target=finger "
              "href=../../finger/%s>%s</a> (%s) "
              "at %s:</b>\n<br><pre>%s</pre>\n",
              (users[id->auth[0]]->icon), id->auth[0],
	      users[id->auth[0]]->name, capitalize(id->auth[0]),
              ctime(time()),message);

    rec = indices(rooms[room]->users);
  }

  foreach(rec, u) {
    if(!load_user(u))
      continue;

    if(objectp(rooms[room]->users[u]))
      rooms[room]->users[u]->write(parse_rxml(message, id));
    else {
      if(!users[u]->messages)
        users[u]->messages = ([]);
      if(!users[u]->messages[room])
        users[u]->messages[room] = "";
      users[u]->messages[room] += message;
      users[u]->modified=time();
    }
  }
}

void closed_fd(array id)
{
  id[0]->close();
  destruct(id[0]);
  rooms[id[1]]->users[id[2]] = 1;
}

mixed find_file(string f, object id)
{
  mapping v = id->variables;
  array action = f / "/";
  array auth = (id->realauth||"")/":" - ({""});
  string out;
  id->auth = auth;
  if(!sizeof(action))
    action = ({"menu"});
  if(sizeof(auth) && valid_user(auth))
  {
    mixed tmp;
    users[auth[0]]->action = time();
    tmp = (id->my_fd->query_address() / " ")[0];
    if(tmp != users[auth[0]]->ip) {
      users[auth[0]]->ip = tmp;
      users[auth[0]]->modified = time();
    }
    if(roxen->quick_ip_to_host(users[auth[0]]->ip) !=
users[auth[0]]->host) {
      users[auth[0]]->host =
roxen->quick_ip_to_host(users[auth[0]]->ip);
      users[auth[0]]->modified = time();
    }
  }

  switch(action[0])
  {
   case "": case "menu":
    out = (HEAD2("Welcome to the Internet Conferencing System!") +
           "<ul><h3>"
           "<li><a href=new>Create a new login ID</a>"
           "<li><a href=rooms>Login and join a chat room</a>"
           "<li><a href=preferences>Change your preferences</a>"
           "</h3></ul>");
             break;

   case "new":
    out = (HEAD("Create a new login ID")+
           "<b>It's necessary to have an ID to be able to use "
           "the Internet Conferencing System. Please fill in all the "
           "information correctly! You only need to fill in fields marked "
           "with a star (*).</b>\n"+
           ID_form());
    break;

   case "new2":
#define U users[v->login]
    if(!OK(email) || !OK(name) || !OK(pw) || !OK(pw2) ||
       (v->pw != v->pw2))
    {
      out = HEAD("Missing information!") +
        "<h3 align=center>You forgot filling in the obligatory fields, "
        "or the passwords doesn't match!</h3>";
    } else {
      if(load_user(v->login))
      {
        out = HEAD("User ID already exists.")+"<h3 align=center>The user ID "
          "(login ID) you have chosen is already taken. Select another one "
          "instead!</h3>";
      } else {
        U = ([]);
        U->name = v->name;
        U->password = crypt(v->pw);
        U->www = v->www;
        U->email = v->email;
        foreach(indices(v), f) {
          action = f/":";
          if(sizeof(action) > 1 && action[0] == "icon") {
            U->icon = action[1];
            break;
          }
        }
        save_user(v->login);
        out = HEAD("New login ID created")+
          "<h3 align=center><a href="">Back to main menu!</a></h3>";
      }
    }
#undef U
    break;
   case "finger":
    if(sizeof(action) < 2 || !strlen(action[1])) {
      out = HEAD("Finger who?!");
    } else {
      action[1] = action[1..]*"/";
      if(!load_user(action[1])) {
        out = HEAD("Finger who?!") +
          "<h3 align=center>"+action[1] +" isn't a valid user!</h3>";
      } else {
        out = HEAD("Finger information for "+ action[1])+
          sprintf("<table width=100%%>"
                  "<tr><th align=left><font size=4>Real Name:</font>"
                  "</th><td><font size=4>%s</font></td>\n"
                  "<th align=left><font size=4>Email:</font></th>"
                  "<td><font size=4><a href=mailto:%s>%s</a></font></td></tr>"
                  "<tr><th align=left><font size=4>Homepage:</font>"
                  "</th><td><font size=4>%s</font></td>\n"
                  "<th align=left><font size=4>Last Action:</font></th>"
                  "<td><font size=4>%s</font></td></tr>"
                  "<tr><th align=left><font size=4>Calls from:</font>"
                  "</th><td colspan=3><font size=4>%s (%s)</font></td>\n"
                  "</tr></table>",
                  users[action[1]]->name,
                  users[action[1]]->email,
                  users[action[1]]->email,
                  (users[action[1]]->www &&
                  strstr(users[action[1]]->www, "http://") != -1) ?
                  "<a target=new_page href="+users[action[1]]->www+">"+
                  users[action[1]]->www+"</a>": "None",
                  ctime(users[action[1]]->action),
                  users[action[1]]->host, users[action[1]]->ip);
      }
    }
    break;

   case "preferences":
    if(!sizeof(auth))
      return http_auth_required("ICS Login",
                                HEAD("Login needed")+
                                "<h3 align=center>You need to "
                                "<a href=new>create a user</a> to be able "
                                "to use ICS!</h3>");
    else if(!valid_user(auth))
      return http_auth_required("ICS Login",
                                HEAD("Invalid login needed")+
                                "<h3 align=center>The login you used is not "+
                                "valid.</h3>");

    out = (HEAD("Modify existing login ID")+
           "<b>All the fields left empty will be unchanged.</b>\n"+
           ID_form(auth[0]));
    break;

   case "pref2":
#define U users[auth[0]]
    if(!load_user(auth[0]))
    {
      out = HEAD("Unknown user!")+
        "<h3 align=center>Hey, this ID doesn't exist! Wierd, dude!!</h3>";
      break;
    }
    if(OK(name))
      U->name = v->name;
    if(OK(pw) || OK(pw2))
      if(v->pw != v->pw2) {
        out = HEAD("Passwords doesn't match")+
          "<h3 align=center>Your new passwords doesn't match - "
          "try again!</h3>";
        break;
      } else {
        U->password = crypt(v->pw);
      }
    if(OK(www))
      U->www = v->www;
    if(OK(email))
      U->email = v->email;
    foreach(indices(v), f) {
      action = f/":";
      if(sizeof(action) > 1 && action[0] == "icon") {
        U->icon = action[1];
        break;
      }
    }
    save_user(auth[0]);
    out = HEAD("Information changed ")+
      "<h3 align=center><a href="">Return to the main menu!</a>";
    break;
#endif
   case "rooms":
    if(!sizeof(auth))
      return http_auth_required("ICS Login",
                                HEAD("Login needed")+
                                "<h3 align=center>You need to "
                                "<a href=new>create a user</a> to be able "
                                "to use ICS!</h3>");
    else if(!valid_user(auth))
      return http_auth_required("ICS Login",
                                HEAD("Invalid login needed")+
                                "<h3 align=center>The login you used is not "+
                                "valid.</h3>");
    if(sizeof(action) == 1 || action[1] == "") {

      out = HEAD("Available Conferences") +
        "<h2 align=center>Select the conference you want to join!</h2>"
        "<center><table cellspacing=0 cellpadding=0><tr valign=top "
        "align=center>"
        "<td><h3><i>Room Name</i></h3></td><td>"
        "<h3><i># of logged<br>in users</i></h3></td></tr>";

      foreach(sort_array(indices(rooms)), f)
        out += sprintf("<tr valign=middle align=center><td>"
                       "<h3>%s</h3></td><td>"
                       "<h3>%d</h3></td><td>"
                       "<form method=post action=\"rooms/%s/frame\">"
                       "<input type=submit value=\"Enter Chatroom\"></form>"
                     "</td></tr>", rooms[f]->name, sizeof(rooms[f]->users), f);

      out += "</table></center>";
    } else {
#define R rooms[action[1]]
      if(!R)
      {
        out = HEAD("Error A18 b") +
          "<h3 align=center>Unknown conference!</h3>";
        break;
      }
      if(!(R->users[auth[0]])) {
        mapping foo = id->variables;
        id->variables = ([]);
        send_message(action[1], id,
                     "Hello! I just entered this room!");
        id->variables = foo;
        R->users[auth[0]] = 1;
      }
      switch(action[2])
      {
       case "frame":
        return
          http_string_answer("<title>ICS: Chatting in "+R->name+"</title>"
                             "<frameset rows=270,*>"
                             "<frame src=read name=read>"
                             "<frame src=bar name=bar>"
                             "</frameset>");
       case "read":
        id->my_fd->write(HEAD("Welcome to "+R->name));
        if(users[auth[0]]->messages &&
           users[auth[0]]->messages[action[1]]) {
          id->my_fd->write(parse_rxml(users[auth[0]]->messages[action[1]]+"\n",
id));
          users[auth[0]]->messages[action[1]] = 0;
        }
        id->my_fd->set_id(({ id->my_fd, action[1], auth[0]}));
        id->my_fd->set_nonblocking(closed_fd, 0, closed_fd);
        R->users[auth[0]] = id->my_fd;
        return http_pipe_in_progress();

       case "bar":
        if(OK(message)) {
          send_message(action[1], id, v->message);
        }
        if(OK(quit)) {

          if(objectp(rooms[action[1]]->users[auth[0]])) {
            rooms[action[1]]->users[auth[0]]->
              write("<h1 align=center>You have left "
                    "the building!<br><a href=frame "
                    "target=_top>Click here to enter "
                    "the room again!</h1>");
            rooms[action[1]]->users[auth[0]]->close();
            destruct(rooms[action[1]]->users[auth[0]]);
            rooms[action[1]]->users[auth[0]] = 0;
          }
          rooms[action[1]]->users -= ([auth[0]:0]);
          send_message(action[1], id,
                       "Bye bye! I just left the room!");

        }

        out = sprintf("<body bgcolor=black text=white>"
                      "<select name=recipient %s multiple>",
                      sizeof(R->users) > 7 ? "size=7": "");
        foreach(indices(R->users), f) {
          out += sprintf("<option value=\"%s\">%s", f, users[f]->name);
        }
        out += "</select>";
        
        return
          http_string_answer("<form method=get>"
                             "<table cellpadding=0 cellspacing=0><tr><td>"+out+"</td>"
                             "<td><textarea name=message "
                             "cols=60 rows=6 wrap=hard>"
                             "</textarea></td></tr><tr><td colspan=2>"
                             "<input type=submit value=\"Send Message\">"
                             "<input type=submit name=quit value=\"Leave Room\">"
                             "</td></tr></table></form>");
      }
    }
    break;

   case "face":
    object file;

    if(sizeof(action) == 2 && strlen(action[1]) &&
       (file = open(iconpath+action[1], "r")))
      return file;
    else
      return 0;

   default:
    return http_string_answer(HEAD("Unknown action!"));
  }

  if(out)
    return http_string_answer(parse_rxml(out, id));
  else
    return 0;

}


string query_name()
{
  return sprintf("ICS mounted on <i>%s</i>", query("mountpoint"));
}
