#!/usr/bin/perl

generateSource (loadSourceCode ());

exit;

sub loadSourceCode()
{
	open (IN, "<custom-shapes.log");

	my %sources;

	while (<IN>)
	{
		if (/==cscode== /)
		{
			if (/shape name: '/)
			{
				chop;
				s/.*shape name: '([^']+)'.*/$1/;
				$name = $_;
			}
			else
			{
				if (/==cscode== begin/)
				{
					$inside = true;
					@code = ();
				}
				else
				{
					if (/==cscode== end/)
					{
						s/^  <\/([^>]+)>/$1/;
						undef $inside;
						$sources{$name} = [ @code ];
						#print "added ", $name, "\n";
					}
				}
			}
		}
		else
		{
			if ($inside)
			{
				push @code, $_;
			}
		}
	}

	close (IN);

	return \%sources;
}

sub startSource
{
	my $count = shift;
	my $head = "// this file was generated by: " . $0 . "
// please do not edit

#include \"oox/drawingml/customshapeproperties.hxx\"
#include \"oox/token/tokenmap.hxx\"
#include <com/sun/star/awt/Rectangle.hpp>
#include <com/sun/star/drawing/EnhancedCustomShapeAdjustmentValue.hpp>
#include <com/sun/star/drawing/EnhancedCustomShapeSegment.hpp>
#include <com/sun/star/drawing/EnhancedCustomShapeParameterPair.hpp>
#include <com/sun/star/drawing/EnhancedCustomShapeParameterType.hpp>

using rtl::OUString;
using namespace ::com::sun::star;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::drawing;
using namespace ::com::sun::star::uno;

namespace oox { namespace drawingml {

void CustomShapeProperties::initializePresetsMap" . $count . "()
{
";

	open (OUT, ">customshapepresets" . $count . ".cxx");
	print OUT $head;
}

sub endSource
{
	my $endBrace = shift;
    my $tail = "
}
}

";

	if ($endBrace > 0) {
		print OUT "}\n\n";
	}

	print OUT $tail;
	close (OUT);
}

sub generateSource
{
	$sources = shift;
	$count = 1;
	$shCount = 0;

	startSource($count++);

	foreach $shape (keys %$sources)
	{
		print OUT "  {\n";
		print OUT "    PropertyMap aPropertyMap;\n\n";
		print OUT @{$sources->{$shape}};
		print OUT "    aPropertyMap [ PROP_Type ] <<= CREATE_OUSTRING(\"ooxml-", $shape, "\");\n\n";
		print OUT "    maPresetsMap [ StaticTokenMap::get().getTokenFromUnicode( OUString( RTL_CONSTASCII_USTRINGPARAM( \"", $shape, "\" ) ) ) ] = aPropertyMap;\n";
		print OUT "  }\n";

        $shCount++;

        if ($shCount >= 35) {
            $shCount = 0;

			endSource(1);
			startSource($count++);
        }
	}

	print OUT "
}

void CustomShapeProperties::initializePresetsMap()
{\n";

    for ($i=1; $i < $count; $i++) {
         print OUT "initializePresetsMap" . $i . "();\n";
	}

    print OUT "}\n";

    if ($shCount > 0) {
		endSource(0);
    }
}
