//******************************************************************************
//  Copyright (c) 2005-2011 by Jan Van hijfte
//
//  See the included file COPYING.TXT for details about the copyright.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//******************************************************************************


#ifndef QOBJECT_C_H
#define QOBJECT_C_H

#include <QtCore>
#include "pascalbind.h"

C_EXPORT QObjectH QObject_create(QObjectH parent);
C_EXPORT void QObject_destroy(QObjectH handle);
C_EXPORT bool QObject_event(QObjectH handle, QEventH p1);
C_EXPORT bool QObject_eventFilter(QObjectH handle, QObjectH p1, QEventH p2);
C_EXPORT void QObject_tr(PWideString retval, const char* sourceText, const char* comment, int n);
C_EXPORT void QObject_trUtf8(PWideString retval, const char* sourceText, const char* comment, int n);
C_EXPORT const QMetaObjectH QObject_metaObject(QObjectH handle);
C_EXPORT void QObject_objectName(QObjectH handle, PWideString retval);
C_EXPORT void QObject_setObjectName(QObjectH handle, PWideString name);
C_EXPORT bool QObject_isWidgetType(QObjectH handle);
C_EXPORT bool QObject_signalsBlocked(QObjectH handle);
C_EXPORT bool QObject_blockSignals(QObjectH handle, bool b);
C_EXPORT QThreadH QObject_thread(QObjectH handle);
C_EXPORT void QObject_moveToThread(QObjectH handle, QThreadH thread);
C_EXPORT int QObject_startTimer(QObjectH handle, int interval);
C_EXPORT void QObject_killTimer(QObjectH handle, int id);
C_EXPORT void QObject_children(QObjectH handle, PPtrIntArray retval);
C_EXPORT void QObject_setParent(QObjectH handle, QObjectH p1);
C_EXPORT void QObject_installEventFilter(QObjectH handle, QObjectH p1);
C_EXPORT void QObject_removeEventFilter(QObjectH handle, QObjectH p1);
C_EXPORT bool QObject_connect(const QObjectH sender, const char* signal, const QObjectH receiver, const char* member, Qt::ConnectionType p5);
C_EXPORT bool QObject_connect2(QObjectH handle, const QObjectH sender, const char* signal, const char* member, Qt::ConnectionType type);
C_EXPORT bool QObject_disconnect(const QObjectH sender, const char* signal, const QObjectH receiver, const char* member);
C_EXPORT bool QObject_disconnect3(QObjectH handle, const QObjectH receiver, const char* member);
C_EXPORT void QObject_dumpObjectTree(QObjectH handle);
C_EXPORT void QObject_dumpObjectInfo(QObjectH handle);
C_EXPORT bool QObject_setProperty(QObjectH handle, const char* name, const QVariantH value);
C_EXPORT void QObject_property(QObjectH handle, QVariantH retval, const char* name);
C_EXPORT uint QObject_registerUserData();
C_EXPORT QObjectH QObject_parent(QObjectH handle);
C_EXPORT bool QObject_inherits(QObjectH handle, const char* classname);
C_EXPORT void QObject_deleteLater(QObjectH handle);

#endif
