#include <phidgets/quadservo.h>
#include <stdio.h>

#include <math.h>
#include <signal.h>

static bool running = true;

void stop(int x)
{
  running = false;
}

int main(void)
{
  phidget_set_debug_stream(stderr);
  phidget_set_debug(PHIDGET_DEBUG_ALL);
  hid_set_debug_stream(stderr);
  hid_set_debug(HID_DEBUG_NONE);
  hid_set_usb_debug(0);

  phidget_return ret = phidget_init();

  PhidgetQuadServo* qsc1 = phidget_new_PhidgetQuadServo();
  PhidgetQuadServo* qsc2 = phidget_new_PhidgetQuadServo();
  PhidgetQuadServo* qsc3 = phidget_new_PhidgetQuadServo();

  ret = phidget_quadservo_open(qsc1, 1483, 3);
  ret = phidget_quadservo_open(qsc2, 1529, 3);
  ret = phidget_quadservo_open(qsc3, 1518, 3);

  phidget_quadservo_set_servo_parameters(qsc1, PHIDGET_QUADSERVO_MOTOR0, 650, 2370, 10.6);
  phidget_quadservo_set_servo_parameters(qsc1, PHIDGET_QUADSERVO_MOTOR1, 1460, 1950, 10.6);
  phidget_quadservo_set_servo_parameters(qsc1, PHIDGET_QUADSERVO_MOTOR2, 990, 2320, 10.6);
  phidget_quadservo_set_servo_parameters(qsc1, PHIDGET_QUADSERVO_MOTOR3, 1370, 2120, 10.6);
  phidget_quadservo_set_servo_parameters(qsc2, PHIDGET_QUADSERVO_MOTOR0, 1010, 1980, 10.6);
  phidget_quadservo_set_servo_parameters(qsc2, PHIDGET_QUADSERVO_MOTOR1, 1400, 1810, 10.6);
  phidget_quadservo_set_servo_parameters(qsc2, PHIDGET_QUADSERVO_MOTOR2, 790, 1900, 10.6);
  phidget_quadservo_set_servo_parameters(qsc2, PHIDGET_QUADSERVO_MOTOR3, 1460, 1950, 10.6);
  phidget_quadservo_set_servo_parameters(qsc3, PHIDGET_QUADSERVO_MOTOR0, 790, 2090, 10.6);
  phidget_quadservo_set_servo_parameters(qsc3, PHIDGET_QUADSERVO_MOTOR1, 1290, 2560, 10.6);
  phidget_quadservo_set_servo_parameters(qsc3, PHIDGET_QUADSERVO_MOTOR2, 1340, 2250, 10.6);

  signal(2, stop);

  char ch = 0;
  double i;
  while (running)
  {
    unsigned int pos = 0x0;
    phidget_quadservo_set_all_positions(qsc1, pos, pos, pos, pos);
    phidget_quadservo_set_all_positions(qsc2, pos, pos, pos, pos);
    getchar();
    pos = 0xffffffff;
    phidget_quadservo_set_all_positions(qsc1, pos, pos, pos, pos);
    phidget_quadservo_set_all_positions(qsc2, pos, pos, pos, pos);
    getchar();
  }

  ret = phidget_quadservo_close(qsc1);
  ret = phidget_quadservo_close(qsc2);
  ret = phidget_quadservo_close(qsc3);

  phidget_delete_PhidgetQuadServo(&qsc1);
  phidget_delete_PhidgetQuadServo(&qsc2);
  phidget_delete_PhidgetQuadServo(&qsc3);

  ret = phidget_cleanup();

  return 0;
}

/* COPYRIGHT --
 *
 * This file is part of libphidgets, a user-space library for phidgets.
 * libphidgets is (c) 2003-2005 Martin F. Krafft <krafft@ailab.ch>
 * and distributed under the terms of the Artistic Licence.
 * See the ./COPYING file in the source tree root for more information.
 *
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES
 * OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
